//
// RTC_LCD_Clock : Draw a Clock & draw clock pointer every RTC tick
//
// EVB : NuMaker Uni
// MCU : Nano100NE3BN
// LCD : I2C OLED 128x64

// JP2 connection
// PA9/I2C0-SCL to LCD's SCL
// PA8/I2C0-SDA to LCD's SDA

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "Nano100Series.h"
#include "MCU_init.h"
#include "SYS_init.h"
#include "I2C_SSD1306Z.h"
#include "PowerDown.h"
#include "Draw2D.h"

#define PI 3.1415926
#define X0 64
#define Y0 32
#define R  20

volatile S_RTC_TIME_DATA_T sCurTime;
volatile uint8_t old_x, old_y, new_x, new_y;

unsigned char bmp_Clock[64*8]= 
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0x60,0x20,0x30,0xD0,0x98,0x08,0x8C,0x04,0x06,0x06,0x02,0x02,0x02,0x03,0x03,0xF1,0x01,0x13,0x93,0x51,0x31,0x03,0x03,0x02,0x02,0x02,0x06,0x06,0x04,0x0C,0x88,0x18,0x10,0x70,0x20,0x60,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xC0,0x60,0x38,0x0C,0x06,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x03,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1D,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x06,0x0C,0x30,0x60,0xC0,0x00,0x00,0x00,0x00,0x00,
	0x00,0xC0,0xF0,0x1E,0x03,0x01,0x02,0x3F,0x00,0x24,0x22,0x21,0x11,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0x3B,0x29,0x27,0x00,0x02,0x01,0x07,0x1C,0xF0,0xC0,0x00,
	0xF8,0x9F,0x00,0x00,0x80,0x60,0x20,0xA0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x60,0x20,0xA0,0x60,0x00,0x00,0xBF,0xF8,
	0x1F,0xF9,0x00,0x00,0x01,0x05,0x05,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x05,0x05,0x03,0x00,0x00,0xFD,0x1F,
	0x00,0x03,0x0F,0x78,0xC0,0x80,0x40,0x40,0xB8,0x94,0x94,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x28,0x2C,0xFC,0x00,0x40,0x80,0xE0,0x38,0x0F,0x03,0x00,
	0x00,0x00,0x00,0x00,0x00,0x03,0x06,0x1C,0x30,0x60,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x10,0x08,0xC8,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x50,0x48,0x68,0xC8,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0x60,0x30,0x1C,0x06,0x03,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x03,0x06,0x04,0x0C,0x1A,0x11,0x10,0x30,0x20,0x60,0x60,0x40,0x40,0x40,0xC0,0xC0,0x80,0x8F,0xD2,0xCA,0x8E,0x80,0xC0,0xC0,0x40,0x40,0x40,0x60,0x60,0x21,0x31,0x11,0x19,0x0A,0x0C,0x04,0x06,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

uint8_t RTC_Flag;
uint16_t theta;	

void RTC_IRQHandler(void)
{  

    Leave_PowerDown();

    RTC_GetDateAndTime((S_RTC_TIME_DATA_T*)&sCurTime);	// get current time
    theta = sCurTime.u32Second *6;

    //------------drawing clock pointer---------------
    if (theta>=360) theta=0;
	
    new_x = X0 - (R-2) * cos(theta * PI/180);
    new_y = Y0 - (R-2) * sin(theta * PI/180);
	
    draw_Line(old_x,old_y,X0,Y0,BG_COLOR, BG_COLOR);
    draw_Line(new_x,new_y,X0,Y0,FG_COLOR, BG_COLOR);
	
    old_x = new_x;
    old_y = new_y;	
    //------------------------------------------------

    RTC_CLEAR_TICK_INT_FLAG();	
}

void Init_RTC(void)
{
    S_RTC_TIME_DATA_T sInitTime;

    // Time Setting
    sInitTime.u32Year       = 2015;
    sInitTime.u32Month      = 9;
    sInitTime.u32Day        = 26;
    sInitTime.u32Hour       = 16;
    sInitTime.u32Minute     = 10;
    sInitTime.u32Second     = 0;
    sInitTime.u32DayOfWeek  = RTC_SATURDAY;
    sInitTime.u32TimeScale  = RTC_CLOCK_24;

    RTC_Open(&sInitTime);
    RTC_SetTickPeriod(RTC_TICK_1_SEC);    
    RTC_EnableInt(RTC_RIER_TIER_Msk);
    NVIC_EnableIRQ(RTC_IRQn);	
    RTC_ENABLE_TICK_WAKEUP(); // Enable RTC wakeup
}

int32_t main()
{
    SYS_Init();
    I2C_Open(I2C0, I2C0_CLOCK_FREQUENCY); // set I2C0 running at 400KHz
    init_LCD();
    clear_LCD();
    Init_RTC();	
	
    draw_Bmp64x64(32, 0, FG_COLOR, BG_COLOR, bmp_Clock);
	
    old_x = X0 - (R-2) * cos(59*6 * PI/180);
    old_y = Y0 - (R-2) * sin(59*6 * PI/180);
	
    while(1) {				
       Enter_PowerDown();
    }
}
