import sys
import requests
import json
import subprocess

class Douban:

    def __init__(self, _email, _passwd):

        self.login_url = 'https://www.douban.com/j/app/login'
        self.channel_url = 'https://www.douban.com/j/app/radio/channels'
        self.people_url = 'http://www.douban.com/j/app/radio/people'

        # self.app_name = 'radio_desktop_win'
        self.app_name = 'radio_android'
        self.version = '100'

        self.email = _email 
        self.passwd = _passwd

        self.user_id = ''
        self.user_name = ''
        self.token = '' 
        self.expire = '' 
        self.cookies = {} 
        self.is_logged = False
       
        # rock
        self.channel_id = 7

        #'new': 'n',
        #'playing': 'p',
        #'rate': 'r',
        #'unrate': 'u',
        #'end': 'e',
        #'bye': 'b',
        #'skip': 's',

    def login(self):
        if not self.is_logged:
            payload = {'app_name': self.app_name,
                       'version': self.version,
                       'email': self.email,
                       'password': self.passwd,
                      }
            
            r = requests.post(self.login_url, 
                              params=payload, 
                              headers={'Content-Type': 'application/x-www-form-urlencoded'}
                             )
            json_r = r.json()
            if json_r['r'] == 0:
                print '[info] Login successful. Return msg is ' + json_r['err']
                self.cookies = r.cookies.get_dict()
                self.user_id = json_r['user_id']
                self.user_name = json_r['user_name']
                self.token = json_r['token']
                self.expire = json_r['expire']
                self.is_logged = True
                return self.is_logged
            else:
                print 'Login failed. Return msg is ' + json_r['err']
                return self.is_logged
        else:
            print 'Already login.'
            return self.is_logged


    def get_channels(self):
        r = requests.get(self.channel_url) 
        json_r = r.json()
    
    def get_songs(self):
        payload = {'app_name': self.app_name,
                   'version': self.version,
                   'user_id': self.user_id,
                   'expire': self.expire,
                   'token': self.token,
                   'channel': self.channel_id,
                   'type': 'n',
                  }
        print "\033[92m >>> Get songs --->\033[0m"
        r = requests.get(self.people_url, params=payload)
        json_r = r.json()
        if json_r['r'] == 0:
            print "[info] Get songs successful."
            for song in json_r['song']:
                song_url = song['url']
                return song_url, (song['title'], song['artist'])
        return None
        pass 

print "\033[92m >>> Douban player starts -->\033[0m"
email = sys.argv[1]
passwd = sys.argv[2]
douban = Douban(email, passwd)

print "\033[92m >>> Login Douban server -->\033[0m"
douban.login()
# douban.get_channels()

while True:
    try:
        url, song = douban.get_songs()
        if url:
            print "\033[93m >>> Start to playing :", song[0], "->", song[1], "\033[0m"
            subprocess.check_output('/mnt/mmcblk0p1/mplayer -novideo -really-quiet ' + url + ' > /dev/null 2>&1',
                                    stderr=subprocess.STDOUT,
                                    shell=True,
                                    )
            print "End....."
    except KeyboardInterrupt:
        sys.exit()
    except:
        print "\033[91m Woo.., something wrong, try again!!\033[0m"        
