/*
 * adc.c
 *
 * Copyright (c) 2016 Nuvoton technology corporation.
 *
 * This code is based on RPi.GPIO of Ben Croston
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;version 2 of the License.
 *
 */


#include <pthread.h>
#include <sys/epoll.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <sys/time.h>

/************* /sys/class/pwm functions ************/
int adc_get(unsigned int adc)
{
    int fd, len;
    char filename[51];
    char val_s[5] = {0};
    int val;
      
    snprintf(filename, sizeof(filename), "/sys/bus/iio/devices/iio:device0/in_voltage%d_raw", adc);

    if ((fd = open(filename, O_RDONLY)) < 0)
        return -1;

    read(fd, val_s, 4);
    close(fd);
    
    val = atoi(val_s);
    
    return val;
}

