/*
 * py_adc.c
 *
 * Copyright (c) 2016 Nuvoton technology corporation.
 *
 * This code is based on RPi.GPIO of Ben Croston
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;version 2 of the License.
 *
 */


#include "Python.h"

// python method ADC.get(self, dutycycle)
static PyObject *ADC_get(PyObject *self, PyObject *args)
{
   int channel, val; 
   PyObject *value;
   
   if (!PyArg_ParseTuple(args, "i", &channel))
        return NULL;
    
   val = adc_get(channel); 
   value = Py_BuildValue("i", val);
   
   return value;
}


static const char moduledocstring[] = "ADC functionality of a Tomato using Python";

static PyMethodDef
nvt_adc_methods[] = {
   { "get", (PyCFunction)ADC_get, METH_VARARGS, "Get data from ADC channel" },  
   { NULL }
};

#if PY_MAJOR_VERSION >= 3
static struct PyModuleDef nvtadcmodule = {
   PyModuleDef_HEAD_INIT,
   "adc",      // name of module
   moduledocstring,  // module documentation, may be NULL
   -1,               // size of per-interpreter state of the module, or -1 if the module keeps state in global variables.
   nvt_adc_methods
};
#endif

#if PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC PyInit__ADC(void)
#else
PyMODINIT_FUNC initadc(void)
#endif
{
   int i;
   PyObject *module = NULL;

#if PY_MAJOR_VERSION >= 3
   if ((module = PyModule_Create(&nvtadcmodule)) == NULL)
      return NULL;
#else
   if ((module = Py_InitModule3("adc", nvt_adc_methods, moduledocstring)) == NULL)
      return;
#endif 
   
#if PY_MAJOR_VERSION >= 3
   return module;
#else
   return;
#endif
}
