/*
 * common.c
 *
 * Copyright (c) 2016 Nuvoton technology corporation.
 *
 * This code is based on RPi.GPIO of Ben Croston
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;version 2 of the License.
 *
 */


#include "Python.h"
#include "common.h"

int gpio_mode = MODE_UNKNOWN;
const int pin_to_gpio_beta[61] =  {-1, -1, -1, -1, -1, -1, -1, -1, -1, 11,              // 0-9
                                    10, 9, 8, 35, 34, 259, 260, -1, -1, -1,             //10-19
                                    -1, -1, -1, -1, -1, -1, -1, 0, 1, 2,                //20-29
                                    3, 4, 5, 6, 7, 103, -1, 198, 199, 200,              //30-39
                                    201, 263, 264, 265, 266, 267, 268, 269, 270, 271,   //40-49
                                    -1, 288, 289, 290, 291, 292, -1, 128, 129, -1,      //50-59
                                    -1 };                                               //60

const int pin_to_gpio_v1[61] =    {-1, 11, 10, 9, 8, 35, 34, 259, 260, 170,             //0-9
                                    103, 0, 1, 2, 3, 4, 5, 6, 7, 198,                   //10-19
                                    199, 200, 201, 263, 264, 265, 266, 267, 268, 269,   //20-29
                                    270, 271, 288, 289, 290, 291, 292, -1, -1, 225,     //30-39
                                    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,             //40-49
                                    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,             //50-59
                                    -1};                                                //60
int setup_error = 0;
int module_setup = 0;

int check_gpio_priv(void)
{
    // check module has been imported cleanly
    if (setup_error)
    {
        PyErr_SetString(PyExc_RuntimeError, "Module not imported correctly!");
        return 1;
    }
    
    return 0;
}

int get_gpio_number(int channel, unsigned int *gpio)
{
    // check setmode() has been run
    if ((gpio_mode != TOMATO_BOARD) && (gpio_mode != TOMATOV1_BOARD))
    {
        PyErr_SetString(PyExc_RuntimeError, "Please set pin numbering mode using GPIO.setmode(GPIO.BOARD)");
        return 3;
    }

    // check channel number is in range
    if ( (gpio_mode == TOMATO_BOARD && (channel < 1 || channel > 60) ) )
    {
        PyErr_SetString(PyExc_ValueError, "The channel sent is invalid on a Tomato");
        return 4;
    }
    
    // check channel number is in range
    if ( (gpio_mode == TOMATOV1_BOARD && (channel < 1 || channel > 39) ) )
    {
        PyErr_SetString(PyExc_ValueError, "The channel sent is invalid on a Tomato");
        return 4;
    }

    // convert channel to gpio
    if ((gpio_mode == TOMATO_BOARD) || (gpio_mode == TOMATOV1_BOARD))
    {
        if (*(*pin_to_gpio+channel) == -1)
        {
            PyErr_SetString(PyExc_ValueError, "The channel sent is invalid on Tomato");
            return 5;
        } else {
            *gpio = *(*pin_to_gpio+channel);
        }
    }
    else 
    {
        //*gpio = channel;
         PyErr_SetString(PyExc_ValueError, "Not support this mode");
    }

    return 0;
}
