/*
 * constants.c
 *
 * Copyright (c) 2016 Nuvoton technology corporation.
 *
 * This code is based on RPi.GPIO of Ben Croston
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;version 2 of the License.
 *
 */


#include "Python.h"
#include "constants.h"
#include "common.h"
#include "event_gpio.h"

void define_constants(PyObject *module)
{
   high = Py_BuildValue("i", HIGH);
   PyModule_AddObject(module, "HIGH", high);

   low = Py_BuildValue("i", LOW);
   PyModule_AddObject(module, "LOW", low);

   output = Py_BuildValue("i", OUTPUT);
   PyModule_AddObject(module, "OUT", output);

   input = Py_BuildValue("i", INPUT);
   PyModule_AddObject(module, "IN", input);

   board = Py_BuildValue("i", TOMATO_BOARD);
   PyModule_AddObject(module, "TOMATO_BOARD", board);
   
   board_v1 = Py_BuildValue("i", TOMATOV1_BOARD);
   PyModule_AddObject(module, "TOMATOV1_BOARD", board_v1);
}
