/*
 * event_gpio.c
 *
 * Copyright (c) 2016 Nuvoton technology corporation.
 *
 * This code is based on RPi.GPIO of Ben Croston
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;version 2 of the License.
 *
 */


#include <pthread.h>
#include <sys/epoll.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <sys/time.h>
#include "event_gpio.h"

const char *stredge[4] = {"none", "rising", "falling", "both"};

/************* /sys/class/gpio functions ************/
int gpio_export(unsigned int gpio)
{
    int fd, len;
    char str_gpio[4];

    if ((fd = open("/sys/class/gpio/export", O_WRONLY)) < 0)
       return -1;

    len = snprintf(str_gpio, sizeof(str_gpio), "%d", gpio);
    write(fd, str_gpio, len);
    close(fd);

    return 0;
}

int gpio_unexport(unsigned int gpio)
{
    int fd, len;
    char str_gpio[4];

    if ((fd = open("/sys/class/gpio/unexport", O_WRONLY)) < 0)
        return -1;

    len = snprintf(str_gpio, sizeof(str_gpio), "%d", gpio);
    write(fd, str_gpio, len);
    close(fd);

    return 0;
}

int gpio_set_direction(unsigned int gpio, unsigned int in_flag)
{
    int retry;
    struct timespec delay;
    int fd;
    char filename[34];

    snprintf(filename, sizeof(filename), "/sys/class/gpio/gpio%d/direction", gpio);

    if ((fd = open(filename, O_WRONLY)) < 0)
        return -1;

    if (in_flag)
        write(fd, "in", 3);
    else
        write(fd, "out", 4);

    close(fd);
    return 0;
}

int gpio_get_direction(unsigned int gpio)
{
    int fd, ret_val=2;
    char filename[34];
    char flag[4];

    snprintf(filename, sizeof(filename), "/sys/class/gpio/gpio%d/direction", gpio);
    
    if ((fd = open(filename, O_RDONLY)) < 0)
        return -1;

    read(fd, flag, 4);

    if(strncmp("out", flag, 3) == 0)
        ret_val = 1;
    
    if(strncmp("in", flag, 2) == 0)
        ret_val = 0;
    
    close(fd);
    return ret_val;
}

int gpio_set_edge(unsigned int gpio, unsigned int edge)
{
    int fd;
    char filename[29];

    snprintf(filename, sizeof(filename), "/sys/class/gpio/gpio%d/edge", gpio);

    if ((fd = open(filename, O_WRONLY)) < 0)
        return -1;

    write(fd, stredge[edge], strlen(stredge[edge]) + 1);
    close(fd);
    return 0;
}

int gpio_get_value(unsigned int gpio)
{
    int fd;
    char filename[30];
    char val[2]={0};

    // create file descriptor of value file
    snprintf(filename, sizeof(filename), "/sys/class/gpio/gpio%d/value", gpio);
    if ((fd = open(filename, O_RDONLY | O_NONBLOCK)) < 0)
        return -1;
    
    read(fd, &val, 2);
    val[1] = 0;
    val[0] = atoi(val);
    close(fd);
    
    return val[0];
}

int gpio_set_value(unsigned int gpio, unsigned char value)
{
    int fd;
    char filename[30];
    char val;

    // create file descriptor of value file
    snprintf(filename, sizeof(filename), "/sys/class/gpio/gpio%d/value", gpio);
    if ((fd = open(filename, O_WRONLY)) < 0)
        return -1;

    if(value)
        write(fd, "1", 2);
    else
        write(fd, "0", 2);
    
    close(fd);
    
    return 0;
}
