/*
 * pwm.c
 *
 * Copyright (c) 2016 Nuvoton technology corporation.
 *
 * This code is based on RPi.GPIO of Ben Croston
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;version 2 of the License.
 *
 */


#include <pthread.h>
#include <sys/epoll.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <sys/time.h>

int g_duty_ratio[4] = {-1, -1, -1, -1};
int g_pwm[4] = {-1, -1, -1, -1};

/************* /sys/class/pwm functions ************/
int pwm_export(unsigned int pwm)
{
    int fd, len;
    char str_pwm[4];
    char filename[31];
    
    if(g_pwm[pwm] != -1)
        return 0;
    
    snprintf(filename, sizeof(filename), "/sys/class/pwm/pwmchip%d/export", pwm);

    if ((fd = open(filename, O_WRONLY)) < 0)
        return -1;

    write(fd, "0", 1);
    close(fd);
    
    g_pwm[pwm] = 1;
    
    return 0;
}

int pwm_unexport(unsigned int pwm)
{
    int fd, len;
    char str_pwm[4];
    char filename[33];
    
    snprintf(filename, sizeof(filename), "/sys/class/pwm/pwmchip%d/unexport", pwm);
 
    if ((fd = open(filename, O_WRONLY)) < 0)
        return -1;

    write(fd, "0", 1);
    close(fd);
    
    g_duty_ratio[pwm] = -1;
    g_pwm[pwm] = -1;
    
    return 0;
}

int pwm_set_frequency(unsigned int pwm, unsigned int frequency)
{
    int fd;
    char filename[38];
    unsigned long cycle;
    char str_pwm[16]={0};
     
    if(g_pwm[pwm] == -1)
        return 0;
    
    snprintf(filename, sizeof(filename), "/sys/class/pwm/pwmchip%d/pwm0/period", pwm);

    if ((fd = open(filename, O_WRONLY)) < 0)
        return -1;
    
    // frequency to period
    cycle = 1000000000UL/frequency;

    sprintf(str_pwm, "%d", cycle);

    write(fd, str_pwm, strlen(str_pwm) + 1);
    close(fd);
    
    if(g_duty_ratio[pwm] != -1) //if set ratio before
        pwm_set_duty_cycle(pwm, g_duty_ratio[pwm]);
    
    return 0;
}

int pwm_get_period(unsigned int pwm)
{
    int fd;
    char filename[38];
    unsigned long cycle, period;;
    char str_pwm[16];
     
    snprintf(filename, sizeof(filename), "/sys/class/pwm/pwmchip%d/pwm0/period", pwm);

    if ((fd = open(filename, O_RDONLY)) < 0)
        return -1;
    
    read(fd, str_pwm, 16);
    period = atoi(str_pwm);
 
    close(fd);
    
    return period;
}

int pwm_set_duty_cycle(unsigned int pwm, unsigned int duty_ratio)
{
    int fd;
    char filename[40];
    unsigned long duty, period;
    char str_pwm[16];
    
    if(g_pwm[pwm] == -1)
        return 0;
    
    snprintf(filename, sizeof(filename), "/sys/class/pwm/pwmchip%d/pwm0/duty_cycle", pwm);

    if ((fd = open(filename, O_WRONLY)) < 0)
        return -1;
    
    if(!(period = pwm_get_period(pwm)) && g_duty_ratio[pwm] == -1) {
        g_duty_ratio[pwm] = duty_ratio;          // just remember it
        close(fd);
        return 0;
    }    
    
    duty = period * duty_ratio / 100;
    
    sprintf(str_pwm, "%d", duty);
 
    write(fd, str_pwm, strlen(str_pwm) + 1);

    close(fd);
    g_duty_ratio[pwm] = duty_ratio;
    
    return 0;
}

int pwm_start(unsigned int pwm)
{
    int fd;
    char filename[36];
    
    snprintf(filename, sizeof(filename), "/sys/class/pwm/pwmchip%d/pwm0/enable", pwm);

    if ((fd = open(filename, O_WRONLY)) < 0)
        return -1;
    
    write(fd, "1", 1);
    close(fd);
    
    return 0;
}

int pwm_stop(unsigned int pwm)
{
    int fd;
    char filename[36];
    
    snprintf(filename, sizeof(filename), "/sys/class/pwm/pwmchip%d/pwm0/enable", pwm);

    if ((fd = open(filename, O_WRONLY)) < 0)
        return -1;
    
    write(fd, "0", 1);
    close(fd);
    
    return 0;
}
