/*
 * py_pwm.c
 *
 * Copyright (c) 2016 Nuvoton technology corporation.
 *
 * This code is based on RPi.GPIO of Ben Croston
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;version 2 of the License.
 *
 */

#include "Python.h"
#include "py_pwm.h"

// python method PWM.start(self, dutycycle)
static PyObject *PWM_start(PyObject *self, PyObject *args)
{
    int dutycycle;
    int channel;
    int frequency;

    if (!PyArg_ParseTuple(args, "iii", &channel, &dutycycle, &frequency))
        return NULL;

    if (dutycycle < 0.0 || dutycycle > 100.0)
    {
        PyErr_SetString(PyExc_ValueError, "dutycycle must have a value from 0 to 100");
        return NULL;
    }
printf("[%d]start->%d,%d\n", channel, dutycycle, frequency);
    pwm_export(channel);
    pwm_start(channel);
    pwm_set_frequency(channel, frequency); 
    pwm_set_duty_cycle(channel, dutycycle);
        
    Py_RETURN_NONE;
}

// python method PWM.ChangeDutyCycle(self, dutycycle)
static PyObject *PWM_ChangeDutyCycle(PyObject *self, PyObject *args)
{
    int dutycycle;
    int channel;
    
    if (!PyArg_ParseTuple(args, "ii", &channel, &dutycycle))
        return NULL;

    if (dutycycle < 0 || dutycycle > 100)
    {
        PyErr_SetString(PyExc_ValueError, "dutycycle must have a value from 0 to 100");
        return NULL;
    }

    pwm_set_duty_cycle(channel, dutycycle);
    
    Py_RETURN_NONE;
}

// python method PWM. ChangeFrequency(self, frequency)
static PyObject *PWM_ChangeFrequency(PyObject *self, PyObject *args)
{
    int frequency;
    int channel;
    
    if (!PyArg_ParseTuple(args, "ii", &channel, &frequency))
        return NULL;

    if (frequency <= 0.0)
    {
        PyErr_SetString(PyExc_ValueError, "frequency must be greater than 0");
        return NULL;
    }

    pwm_set_frequency(channel, frequency);
    Py_RETURN_NONE;
}

// python function PWM.stop(self)
static PyObject *PWM_stop(PyObject *self, PyObject *args)
{
    int channel;
    
    if (!PyArg_ParseTuple(args, "i", &channel))
        return NULL;
    
    pwm_stop(channel);
    
    Py_RETURN_NONE;
}

static const char moduledocstring[] = "PWM functionality of a Tomato using Python";

static PyMethodDef
nvt_pwm_methods[] = {
   { "start", (PyCFunction)PWM_start, METH_VARARGS, "Start PWM\ndutycycle - the duty cycle (0 to 100 percent)\nfrequency in Hz" },
   { "ChangeDutyCycle", (PyCFunction)PWM_ChangeDutyCycle, METH_VARARGS, "Change the duty cycle\ndutycycle - between 0 and 100 percentage" },
   { "ChangeFrequency", (PyCFunction)PWM_ChangeFrequency, METH_VARARGS, "Change the frequency\nfrequency - frequency in Hz (freq > 1)" },
   { "stop", (PyCFunction)PWM_stop, METH_VARARGS, "Stop PWM" },
   { NULL }
};

#if PY_MAJOR_VERSION >= 3
static struct PyModuleDef nvtpwmmodule = {
   PyModuleDef_HEAD_INIT,
   "pwm",      // name of module
   moduledocstring,  // module documentation, may be NULL
   -1,               // size of per-interpreter state of the module, or -1 if the module keeps state in global variables.
   nvt_pwm_methods
};
#endif

#if PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC PyInit__PWM(void)
#else
PyMODINIT_FUNC initpwm(void)
#endif
{
   int i;
   PyObject *module = NULL;

#if PY_MAJOR_VERSION >= 3
   if ((module = PyModule_Create(&nvtpwmmodule)) == NULL)
      return NULL;
#else
   if ((module = Py_InitModule3("pwm", nvt_pwm_methods, moduledocstring)) == NULL)
      return;
#endif 
   
#if PY_MAJOR_VERSION >= 3
   return module;
#else
   return;
#endif
}
