/*=============================================================*
 *  _  _             ___              _              _         *
 * | \| |   _  _    | _ )     _ _    (_)     __     | |__      *
 * | .` |  | +| |   | _ \    | '_|   | |    / _|    | / /      *
 * |_|\_|   \_,_|   |___/   _|_|_   _|_|_   \__|_   |_\_\      *
 *_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|     *
 *"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'     *
 *                                                             *
 * NuBrick IoT applications firmware                           *
 *                                                             *
 * Written by MB40 for Nuvoton Technology.                     *
 * tlshen@nuvoton.com/tzulan611126@gmail.com                   *
 *                                                             *
 *=============================================================*
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <Wire.h>
#include "timer0.h"
#include "i2c0.h"
#include "tid.h"
#include "led.h"

#define SERIAL_BAUD 100000



void setup() 
{  
    // put your setup code here, to run once:
    Serial.begin(9600);           // start serial for output
    //Serial.print(I2CDataEndBit);
    I2C_init();
    Led_Init();
    SlvDevInit(&LedDev);
    SlvDataStore();
}

void loop() 
{
        //update TID data
        TID_SlvRxUpdate();
        
        /* LED code */
        if(LedDev.Output.data2.value==0)
        {
            if(LedDev.Output.data1.value == 1)                                                                          //Period, Duty
            {
                Led_Blink_Start();
                LedDev.Output.data1.value=0;
            }
        }
        else
        {
            Led_Stop();
        }
        Led_Blink_Check();
        
        SlvDataStore();
}


