/*=============================================================*
 *  _  _             ___              _              _         *
 * | \| |   _  _    | _ )     _ _    (_)     __     | |__      *
 * | .` |  | +| |   | _ \    | '_|   | |    / _|    | / /      *
 * |_|\_|   \_,_|   |___/   _|_|_   _|_|_   \__|_   |_\_\      *
 *_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|     *
 *"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'     *
 *                                                             *
 * NuBrick IoT applications firmware                           *
 *                                                             *
 * Written by MB40 for Nuvoton Technology.                     *
 * tlshen@nuvoton.com/tzulan611126@gmail.com                   *
 * HCHSIEH@nuvoton.com                                         *
 *=============================================================*
 */

#include "led.h"

unsigned char LedStartFlag;                                //single buzzer cycle execute flag
unsigned char LedSingleExecuteFlag;                       //single buzzer cycle execute flag
unsigned char LedSingleCounter;                            //buzzer single buzzer cycle counter
unsigned char LedBlinkSize;                           //buzzer single buzzer cycle counter
unsigned short LedBri_G;                                    //buzzer Brightness
unsigned short LedBri_R;                                  //buzzer Brightness
unsigned short LedBri_B;                                  //buzzer Brightness
unsigned short LedBlink;                                      //buzzer song
unsigned short LedToneStartTime;                                            //buzzer period
unsigned short LedToneStopTime;                                       //buzzer duty
unsigned long LedSingleTimeCnt;                            //single buzzer cycle Time out flag
unsigned long LedLatency;                                    //single buzzer cycle Time out flag

unsigned short MusicScale[32] = {                            //buzzer song scale
    G4, E4, E4, E4, F4, D4, D4, D4, C4, D4, E4, F4, G4, G4, G4, G4,
    G4, E4, E4, E4, F4, D4, D4, D4, C4, E6, G4, G4, C4, C4, C4, C4};

unsigned short MusicTime[32] = {                          //buzzer song scale Time
    250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
    250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250};

unsigned short MusicLevel[32] = {                              //buzzer song scale Level
    20, 20, 20,  0, 20, 20, 20,  0, 20, 20, 20, 20, 20, 20, 20, 0,
    20, 20, 20,  0, 20, 20, 20,  0, 20, 20, 20, 20, 20, 20, 20, 0};
    
void Led_Init()
{
    /* Initialize led output */
    pinMode(LEDPIN_R, OUTPUT);
    pinMode(LEDPIN_G, OUTPUT);
    pinMode(LEDPIN_B, OUTPUT);
    analogWrite(LEDPIN_R, 255);
    analogWrite(LEDPIN_G, 255);
    analogWrite(LEDPIN_B, 255);

    /* Initialize parameter */
    LedSingleExecuteFlag=0;
    LedStartFlag=0;

    LedDev.DevDesc.DevDesc_leng = 26;                       //Report descriptor
    LedDev.DevDesc.RptDesc_leng = 74;                       //Report descriptor
    LedDev.DevDesc.InRptLeng = 3;                               //Input report
    LedDev.DevDesc.OutRptLeng = 4;                          //Output report
    LedDev.DevDesc.GetFeatLeng = 12;                            //Get feature
    LedDev.DevDesc.SetFeatLeng = 12;                            //Set feature
    LedDev.DevDesc.CID = 0;                                         //manufacturers ID
    LedDev.DevDesc.DID = 0;                                         //Product ID
    LedDev.DevDesc.PID = 0;                                         //Device firmware revision
    LedDev.DevDesc.UID = 0;                                         //Device Class type
    LedDev.DevDesc.UCID = 0;                                        //reserve
    /* Feature */
    LedDev.Feature.data1.minimum = 0;                       //SleepPrd
    LedDev.Feature.data1.maximum = 2048;
    LedDev.Feature.data1.value = 100;
    LedDev.Feature.data2.minimum = 0;                       //Brightness
    LedDev.Feature.data2.maximum = 100;
    LedDev.Feature.data2.value = 30;
    LedDev.Feature.data3.minimum = 0;                       //Color
    LedDev.Feature.data3.maximum = 4095;
    LedDev.Feature.data3.value = 4095;
    LedDev.Feature.data4.minimum = 0;                       //Blink
    LedDev.Feature.data4.maximum = 2;
    LedDev.Feature.data4.value = 0;
    LedDev.Feature.data5.minimum = 0;                       //Period
    LedDev.Feature.data5.maximum = 2048;
    LedDev.Feature.data5.value = 500;
    LedDev.Feature.data6.minimum = 0;                       //Duty
    LedDev.Feature.data6.maximum = 100;
    LedDev.Feature.data6.value = 30;
    LedDev.Feature.data7.minimum = 0;                       //Latency
    LedDev.Feature.data7.maximum = 60;
    LedDev.Feature.data7.value = 5;
    LedDev.Feature.arg[0] = 1;
    LedDev.Feature.arg[1] = 2;
    LedDev.Feature.arg[2] = 3;
    LedDev.Feature.arg[3] = 4;
    LedDev.Feature.arg[4] = 5;
    LedDev.Feature.arg[5] = 6;
    LedDev.Feature.arg[6] = 7;
    LedDev.Feature.datalen[0] = 2;
    LedDev.Feature.datalen[1] = 1;
    LedDev.Feature.datalen[2] = 2;
    LedDev.Feature.datalen[3] = 1;
    LedDev.Feature.datalen[4] = 2;
    LedDev.Feature.datalen[5] = 1;
    LedDev.Feature.datalen[6] = 1;
    LedDev.Feature.dataNum = 7;
    /* Input */
    LedDev.Input.data1.minimum = 0;                             //Execute Flag
    LedDev.Input.data1.maximum = 1;
    LedDev.Input.data1.value = 0;
    LedDev.Input.arg[0] = 1;
    LedDev.Input.datalen[0] = 1;
    LedDev.Input.dataNum = 1;
    /* Output */
    LedDev.Output.data1.minimum = 0;                            //Start flag
    LedDev.Output.data1.maximum = 1;
    LedDev.Output.data1.value = 0;
    LedDev.Output.data2.minimum = 0;                            //Stop flag
    LedDev.Output.data2.maximum = 1;
    LedDev.Output.data2.value = 0;
    LedDev.Output.arg[0] = 1;
    LedDev.Output.arg[1] = 2;
    LedDev.Output.datalen[0] = 1;
    LedDev.Output.datalen[1] = 1;
    LedDev.Output.dataNum = 2;
}

// ----------------------------------------------------------------------------------------
//  Single PWM Output
// ----------------------------------------------------------------------------------------
void Led_Alerm(unsigned short freq, unsigned short duration, unsigned char G_level, unsigned char R_level, unsigned char B_level)
{
    LedSingleExecuteFlag=1;
    /* set output time(ms) */
    LedSingleTimeCnt = millis() + duration;
    Serial.println(LedSingleTimeCnt);
    Serial.println(duration);
    Serial.println(millis());
    /* Enable PWM Output */
    analogWrite(LEDPIN_R, R_level);
    analogWrite(LEDPIN_G, G_level);
    analogWrite(LEDPIN_B, B_level);
}

void Led_SingleCheck(unsigned short freq, unsigned short duration, unsigned char G_level, unsigned char R_level, unsigned char B_level)
{
    if(LedSingleExecuteFlag==0)
    {
        /* check if Led time out */
        if(millis() > LedSingleTimeCnt)
        {
            /* Enable PWM Output path for PWMB channel 0 */
            Led_Alerm(freq, duration, G_level, R_level, B_level);
            
            /* check if buzzer single counter reach limit */
            if(LedSingleCounter==(LedBlinkSize-1))
            {
                LedSingleCounter=0;
                LedSingleExecuteFlag=0;
            }
        }
    }
    else if (LedSingleExecuteFlag==1)
    {
        LedSingleExecuteFlag=0;
        LedSingleCounter++;
    }
}

// ----------------------------------------------------------------------------------------
//  check PWM state
// ----------------------------------------------------------------------------------------
void Led_Stop()
{
    analogWrite(LEDPIN_R, 255);
    analogWrite(LEDPIN_G, 255);
    analogWrite(LEDPIN_B, 255);
    LedStartFlag=0;
    LedSingleCounter = 0;
    LedSingleExecuteFlag=0;
    LedDev.Input.data1.value = 0;
}

void Led_Check()
{
    uint32_t currentTimeCnt;
    
    /* check if buzzer time out */
    currentTimeCnt = millis()/1000;               //current time(s)
    if(currentTimeCnt > LedLatency)
    {
        /* Diable PWM Output path for PWMB channel 0 */
        Led_Stop();
    }
}
// ----------------------------------------------------------------------------------------
//  Led start Blink
// ----------------------------------------------------------------------------------------
void Led_Blink_Start()
{
    LedLatency = millis()/1000+LedDev.Feature.data7.value;                            //Led operation time(s)
    LedBlink = LedDev.Feature.data4.value;
    LedStartFlag=1;
    LedDev.Input.data1.value = 1;
    switch (LedBlink)
    {
        case 0:
        {
            LedBri_B = LedDev.Feature.data3.value%16;
            LedBri_B = LedBri_B*(LedDev.Feature.data2.value)/15;
            LedBri_B = 100-LedBri_B;
            LedBri_G = (LedDev.Feature.data3.value>>4)%16;
            LedBri_G = LedBri_G*(LedDev.Feature.data2.value)/15;
            LedBri_G = 100-LedBri_G;
            LedBri_R = (LedDev.Feature.data3.value>>8)%16;
            LedBri_R = LedBri_R*(LedDev.Feature.data2.value)/15;
            LedBri_R = 100-LedBri_R;
            LedToneStartTime = LedDev.Feature.data5.value*LedDev.Feature.data6.value/100;
            LedToneStopTime = LedDev.Feature.data5.value-(LedDev.Feature.data5.value*LedDev.Feature.data6.value/100);
            Serial.println(LedToneStartTime);
            Serial.println(LedToneStopTime);
            LedBlinkSize = 2;
            LedSingleCounter = 0;
            Led_Alerm(G7, LedToneStartTime, LedBri_G, LedBri_R, LedBri_B);
            break;
        }
        case 1:
        {
            LedBlinkSize = sizeof(MusicScale)/2;
            LedSingleCounter = 0;
            Led_Alerm(MusicScale[LedSingleCounter], MusicTime[LedSingleCounter], MusicLevel[LedSingleCounter], MusicLevel[LedSingleCounter], MusicLevel[LedSingleCounter]);
            break;
        }
    }
}
// ----------------------------------------------------------------------------------------
//  Led singing
// ----------------------------------------------------------------------------------------
void Led_Blink_Check()
{
    if(LedStartFlag==1)
    {
        switch (LedBlink)
        {
            case 0:
            {
                if(LedSingleCounter == 0)   Led_SingleCheck(G7, LedToneStartTime, LedBri_G, LedBri_R, LedBri_B);
                else if(LedSingleCounter == 1)  Led_SingleCheck(G7, LedToneStopTime, 255, 255, 255);                //close LED
                break;
            }
            case 1:
            {
                Led_SingleCheck(MusicScale[LedSingleCounter], MusicTime[LedSingleCounter], MusicLevel[LedSingleCounter], MusicLevel[LedSingleCounter], MusicLevel[LedSingleCounter]);
                break;
            }
            case 2:
            {
                break;
            }
        }
        
        /* Check Time Out */
        Led_Check();
    }
}

