/*=============================================================*
 *  _  _             ___              _              _         *
 * | \| |   _  _    | _ )     _ _    (_)     __     | |__      *
 * | .` |  | +| |   | _ \    | '_|   | |    / _|    | / /      *
 * |_|\_|   \_,_|   |___/   _|_|_   _|_|_   \__|_   |_\_\      *
 *_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|     *
 *"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'     *
 *                                                             *
 * NuBrick IoT applications firmware                           *
 *                                                             *
 * Written by MB40 for Nuvoton Technology.                     *
 * tlshen@nuvoton.com/tzulan611126@gmail.com                   *
 * HCHSIEH@nuvoton.com                                         *
 *=============================================================*
 */
 
#ifndef TID_H_
#define TID_H_

#include <stdio.h>

//==============================================================
//==============================================================
//                      Device descriptor
//==============================================================
//==============================================================
struct DEVICE_DESCRIPTOR
{
    unsigned short DevDesc_leng;              //Report descriptor length  
    unsigned short RptDesc_leng;              //Report descriptor length
    unsigned short InRptLeng;                 //input report length
    unsigned short OutRptLeng;                    //output report length
    unsigned short GetFeatLeng;               //get feature length
    unsigned short SetFeatLeng;               //set feature length
    unsigned short CID;                               //Company ID
    unsigned short DID;                               //Device ID
    unsigned short PID;                               //product ID
    unsigned short UID;                               //product ID
    unsigned short UCID;                          //product ID
    unsigned short reserve1;                  //reserved
    unsigned short reserve2;                  //reserved
};

struct TID_DATA
{
    unsigned short value;
    unsigned short minimum;
    unsigned short maximum;
};

struct DEVICE_TO_DEVICE
{
    unsigned char dZERO;          //battery
    unsigned char dONE;           //Buzzer
    unsigned char dTWO;           //Led
    unsigned char dTHR;           //AHRS
    unsigned char dFOUR;          //SONAR
    unsigned char dFIVE;          //Temperature
    unsigned char dSIX;           //Gas
    unsigned char dSEV;           //IR
    unsigned char dEIG;           //KEY
    unsigned char dNINE;          //Reserved device 9
    unsigned char dX;         //Reserved device 10
    unsigned char dXI;            //Reserved device 11
    unsigned char dXII;           //Reserved device 12
    unsigned char dXIII;          //Reserved device 13
    unsigned char dXIV;           //Reserved device 14
};

//==============================================================
//==============================================================
//                                          TID Parameter
//==============================================================
//==============================================================
// ************************************************************
//                      TID Class subject
// ************************************************************
struct TID_FEATURE
{
    struct TID_DATA data1;                                 //Class data 1
    struct TID_DATA data2;                                 //Class data 2
    struct TID_DATA data3;                                 //Class data 3
    struct TID_DATA data4;                                 //Class data 4
    struct TID_DATA data5;                                 //Class data 5
    struct TID_DATA data6;                                 //Class data 1
    struct TID_DATA data7;                                 //Class data 2
    struct TID_DATA data8;                                 //Class data 3
    struct TID_DATA data9;                                 //Class data 4
    struct TID_DATA data10;                                    //Class data 5
    unsigned char arg[10];                                    //arrangement of data
    unsigned char datalen[10];
    unsigned char dataNum;
};

struct TID_INPUT
{
    struct TID_DATA data1;                                 //Class data 1
    struct TID_DATA data2;                                 //Class data 2
    struct TID_DATA data3;                                 //Class data 3
    struct TID_DATA data4;                                 //Class data 4
    struct TID_DATA data5;                                 //Class data 5
    unsigned char arg[5];                                 //arrangement of data
    unsigned char datalen[5];
    unsigned char dataNum;
};

struct TID_OUTPUT
{
    struct TID_DATA data1;                                 //Class data 1
    struct TID_DATA data2;                                 //Class data 2
    struct TID_DATA data3;                                 //Class data 3
    struct TID_DATA data4;                                 //Class data 4
    struct TID_DATA data5;                                 //Class data 5
    unsigned char arg[5];                             //arrangement of data
    unsigned char datalen[5];
    unsigned char dataNum;
};

// ************************************************************
//                                      TID Device
// ************************************************************
struct TID_Device
{
    struct DEVICE_DESCRIPTOR DevDesc;
    struct TID_FEATURE Feature;
    struct TID_INPUT Input;
    struct TID_OUTPUT Output;
    struct DEVICE_TO_DEVICE dTod;
};

extern struct TID_Device LedDev;

#endif //TID

