/*=============================================================*
 *  _  _             ___              _              _         *
 * | \| |   _  _    | _ )     _ _    (_)     __     | |__      *
 * | .` |  | +| |   | _ \    | '_|   | |    / _|    | / /      *
 * |_|\_|   \_,_|   |___/   _|_|_   _|_|_   \__|_   |_\_\      *
 *_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|     *
 *"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'     *
 *                                                             *
 * NuBrick IoT applications firmware                           *
 *                                                             *
 * Written by MB40 for Nuvoton Technology.                     *
 * tlshen@nuvoton.com/tzulan611126@gmail.com                   *
 * HCHSIEH@nuvoton.com                                         *
 *=============================================================*
 */

#include "tid.h"

struct TID_Device LedDev;
/*
 *    Led:
 *
 *          Feature:    Sleep period,                       2 bits
 *                      Brightness,                             1 bit
 *                      color,                              2 bit
 *                      Blink,                              1 bit 
 *                      Period,                             2 bit
 *                      Duty,                               1 bit
 *                      Latency,                            1 bit
 *
 *          Input:      Execute Flag,                       2 bits
 *
 *          Output:     Start flag,                         1 bit
 *                      Stop flag,                          1 bit
 *
 */

volatile unsigned int devNum;
unsigned short TID_loadFromFlash;                            //Load from Flash flag
unsigned char TID_HandSingDataFlag;                       //Handle TID single Data is finished
unsigned char TID_RpDescType;                                 //Handle TID single Data is finished
unsigned short TID_RpDescFeatBase;                        //Handle TID single Data is finished
unsigned short TID_RpDescInBase;                          //Handle TID single Data is finished
unsigned short TID_RpDescOutBase;                         //Handle TID single Data is finished
unsigned short* TID_RpFeatReg;                                //Handle TID single Data is finished
unsigned short* TID_RpInReg;                                  //Handle TID single Data is finished
unsigned short* TID_RpOutReg;                                 //Handle TID single Data is finished

// =============================================================================================
// =============================================================================================
// =============================================================================================
//
//                             Slave deal with received Data
//
// =============================================================================================
// =============================================================================================
// =============================================================================================

// =========================================================================
// =========================================================================
//                  Slave handle descript data will send to master
// =========================================================================
// =========================================================================
void slvTxRpDes(TID_DATA devData, unsigned char datalen, int* i, short tidReg)
{
    I2CMS_SlvTxRPDesData[(*i)++] = tidReg;
    I2CMS_SlvTxRPDesData[(*i)++] = (unsigned char)datalen;
    if(datalen==1)
    {
        I2CMS_SlvTxRPDesData[(*i)++] = (char)(TID_REG_MIN + datalen);
        I2CMS_SlvTxRPDesData[(*i)++] = (char)devData.minimum;
        I2CMS_SlvTxRPDesData[(*i)++] = (char)(TID_REG_MAX + datalen);
        I2CMS_SlvTxRPDesData[(*i)++] = (char)devData.maximum; 
    }
    else if(datalen==2)
    {
        I2CMS_SlvTxRPDesData[(*i)++] = (char)(TID_REG_MIN + datalen);
        I2CMS_SlvTxRPDesData[(*i)++] = (char)devData.minimum;
        I2CMS_SlvTxRPDesData[(*i)++] = (char)(devData.minimum>>8);
        I2CMS_SlvTxRPDesData[(*i)++] = (char)(TID_REG_MAX + datalen);
        I2CMS_SlvTxRPDesData[(*i)++] = (char)devData.maximum;
        I2CMS_SlvTxRPDesData[(*i)++] = (char)(devData.maximum>>8);
    }
}
void SlvDevInit(TID_Device* devPointer)
{    
    int i,j,k;                  //i:total number, j:data number in class, k:class number
    
    I2CMS_SlvTxDevDesData[0] = devPointer->DevDesc.DevDesc_leng;                //((devPointer)->DevDesc.DevDesc_leng)
    I2CMS_SlvTxDevDesData[1] = (devPointer->DevDesc.DevDesc_leng)>>8;
    I2CMS_SlvTxDevDesData[2] = devPointer->DevDesc.RptDesc_leng;                            //Report descriptor
    I2CMS_SlvTxDevDesData[3] = (devPointer->DevDesc.RptDesc_leng)>>8;
    I2CMS_SlvTxDevDesData[4] = devPointer->DevDesc.InRptLeng;                               //Input report
    I2CMS_SlvTxDevDesData[5] = (devPointer->DevDesc.InRptLeng)>>8;
    I2CMS_SlvTxDevDesData[6] = devPointer->DevDesc.OutRptLeng;                              //Output report
    I2CMS_SlvTxDevDesData[7] = (devPointer->DevDesc.OutRptLeng)>>8;
    I2CMS_SlvTxDevDesData[8] = devPointer->DevDesc.GetFeatLeng;                         //Get feature
    I2CMS_SlvTxDevDesData[9] = (devPointer->DevDesc.GetFeatLeng)>>8;
    I2CMS_SlvTxDevDesData[10] = devPointer->DevDesc.SetFeatLeng;                            //Set feature
    I2CMS_SlvTxDevDesData[11] = (devPointer->DevDesc.SetFeatLeng)>>8;
    I2CMS_SlvTxDevDesData[12] = devPointer->DevDesc.CID;                            //manufacturers ID
    I2CMS_SlvTxDevDesData[13] = (devPointer->DevDesc.CID)>>8;
    I2CMS_SlvTxDevDesData[14] = devPointer->DevDesc.DID;                            //Product ID
    I2CMS_SlvTxDevDesData[15] = (devPointer->DevDesc.DID)>>8;
    I2CMS_SlvTxDevDesData[16] = devPointer->DevDesc.PID;                            //Device firmware revision
    I2CMS_SlvTxDevDesData[17] = (devPointer->DevDesc.PID)>>8;
    I2CMS_SlvTxDevDesData[18] = devPointer->DevDesc.UID;                            //Device Class type
    I2CMS_SlvTxDevDesData[19] = (devPointer->DevDesc.UID)>>8;
    I2CMS_SlvTxDevDesData[20] = devPointer->DevDesc.UCID;                           //UCID
    I2CMS_SlvTxDevDesData[21] = (devPointer->DevDesc.UCID)>>8;
    I2CMS_SlvTxDevDesData[22] = devPointer->DevDesc.reserve1;                           //reserve
    I2CMS_SlvTxDevDesData[23] = (devPointer->DevDesc.reserve1)>>8;
    I2CMS_SlvTxDevDesData[24] = devPointer->DevDesc.reserve2;                           //reserve
    I2CMS_SlvTxDevDesData[25] = (devPointer->DevDesc.reserve2)>>8;

    /* Reprot Descriptor Data */
    /*I2CMS_SlvTxRPDesData*/
    I2CMS_SlvTxRPDesData[0] = (char)devPointer->DevDesc.RptDesc_leng;
    I2CMS_SlvTxRPDesData[1] = (char)(devPointer->DevDesc.RptDesc_leng)>>8;
    i=2;
    for(k=1; k<=3; k++)
    {
        if(k==1)                                                                                                                                            //Feature type
        {
            if(devPointer->Feature.dataNum != 0)
            {
                I2CMS_SlvTxRPDesData[i++] = TID_CHANGE_STATE_FLAG;                                              //Change type sign
                I2CMS_SlvTxRPDesData[i++] = TID_FEATURE_FLAG;
                for(j=0; j< (devPointer->Feature.dataNum); j++)                                                                             //import data form
                {
                    if(j==0)
                    {
                        slvTxRpDes((devPointer->Feature.data1), (devPointer->Feature.datalen[0]), &i, tidReg[0]);
                    }
                    else if(j==1)
                    {
                        slvTxRpDes((devPointer->Feature.data2), (devPointer->Feature.datalen[1]), &i, tidReg[1]);
                    }
                    else if(j==2)
                    {
                        slvTxRpDes((devPointer->Feature.data3), (devPointer->Feature.datalen[2]), &i, tidReg[2]);
                    }
                    else if(j==3)
                    {
                        slvTxRpDes((devPointer->Feature.data4), (devPointer->Feature.datalen[3]), &i, tidReg[3]);
                    }
                    else if(j==4)
                    {
                        slvTxRpDes((devPointer->Feature.data5), (devPointer->Feature.datalen[4]), &i, tidReg[4]);
                    }
                    else if(j==5)
                    {
                        slvTxRpDes((devPointer->Feature.data6), (devPointer->Feature.datalen[5]), &i, tidReg[5]);
                    }
                    else if(j==6)
                    {
                        slvTxRpDes((devPointer->Feature.data7), (devPointer->Feature.datalen[6]), &i, tidReg[6]);
                    }
                    else if(j==7)
                    {
                        slvTxRpDes((devPointer->Feature.data8), (devPointer->Feature.datalen[7]), &i, tidReg[7]);
                    }
                    else if(j==8)
                    {
                        slvTxRpDes((devPointer->Feature.data9), (devPointer->Feature.datalen[8]), &i, tidReg[8]);
                    }
                    else if(j==9)
                    {
                        slvTxRpDes((devPointer->Feature.data10), (devPointer->Feature.datalen[9]), &i, tidReg[9]);
                    }
                }
            }
        }
        else if(k==2)                                                                                                                                   //Input type
        {
            if(devPointer->Input.dataNum != 0)
            {
                I2CMS_SlvTxRPDesData[i++] = TID_CHANGE_STATE_FLAG;                                              //Change type sign
                I2CMS_SlvTxRPDesData[i++] = TID_INPUT_FLAG;
                for(j=0; j < devPointer->Input.dataNum; j++)                                                                                //import data form
                {
                    if(j==0)
                    {
                        slvTxRpDes((devPointer->Input.data1), (devPointer->Input.datalen[0]), &i, tidReg[0]);
                    }
                    else if(j==1)
                    {
                        slvTxRpDes((devPointer->Input.data2), (devPointer->Input.datalen[1]), &i, tidReg[1]);
                    }
                    else if(j==2)
                    {
                        slvTxRpDes((devPointer->Input.data3), (devPointer->Input.datalen[2]), &i, tidReg[2]);
                    }
                    else if(j==3)
                    {
                        slvTxRpDes((devPointer->Input.data4), (devPointer->Input.datalen[3]), &i, tidReg[3]);
                    }
                    else if(j==4)
                    {
                        slvTxRpDes((devPointer->Input.data5), (devPointer->Input.datalen[4]), &i, tidReg[4]);
                    }
                }
            }
        }
        else if(k==3)                                                                                                                                   //Output type
        {
            if(devPointer->Output.dataNum != 0)
            {
                I2CMS_SlvTxRPDesData[i++] = TID_CHANGE_STATE_FLAG;                                              //Change type sign
                I2CMS_SlvTxRPDesData[i++] = TID_OUTPUT_FLAG;
                for(j=0; j<devPointer->Output.dataNum; j++)                                                                             //import data form
                {
                    if(j==0)
                    {
                        slvTxRpDes((devPointer->Output.data1), (devPointer->Output.datalen[0]), &i, tidReg[0]);
                    }
                    else if(j==1)
                    {
                        slvTxRpDes((devPointer->Output.data2), (devPointer->Output.datalen[1]), &i, tidReg[1]);
                    }
                    else if(j==2)
                    {
                        slvTxRpDes((devPointer->Output.data3), (devPointer->Output.datalen[2]), &i, tidReg[2]);
                    }
                    else if(j==3)
                    {
                        slvTxRpDes((devPointer->Output.data4), (devPointer->Output.datalen[3]), &i, tidReg[3]);
                    }
                    else if(j==4)
                    {
                        slvTxRpDes((devPointer->Output.data5), (devPointer->Output.datalen[4]), &i, tidReg[4]);
                    }
                }
            }
        }
    }
    I2CSlv_InitFlag = 1;
}

// **************************************************************
//           Slvae Store data to TID REG like input
// **************************************************************
void StoreTIDTxData(unsigned char* storeData, unsigned short RxData, unsigned char DataLen, unsigned char* position)
{
    switch(DataLen)
    {
        case 1:
        {
            *storeData = (unsigned char)RxData;
            (*position)+=1;
            break;
        }
        case 2:
        {
            *storeData = (unsigned char)RxData;
            *(storeData+1) = (unsigned char)(RxData>>8);
            (*position)+=2;
            break;
        }
    }
}

void SlvDevDataStore(TID_Device* devPointer)
{
    unsigned char i=0, j=0;
    /* Output */
    if(devPointer->Feature.dataNum != 0)                                                                                                                //Feature
    {
        i=0;
        I2CMS_SlvTxGetFTData[i++] = (unsigned char)devPointer->DevDesc.GetFeatLeng;
        I2CMS_SlvTxGetFTData[i++] = (unsigned char)(devPointer->DevDesc.GetFeatLeng>>8);
        for(j=0; j < devPointer->Feature.dataNum; j++)                                                                                          //import data
        {
            if(j==0)
            {
                StoreTIDTxData(&I2CMS_SlvTxGetFTData[i], devPointer->Feature.data1.value, devPointer->Feature.datalen[0],&i);
            }
            if(j==1)
            {
                StoreTIDTxData(&I2CMS_SlvTxGetFTData[i], devPointer->Feature.data2.value, devPointer->Feature.datalen[1],&i);
            }
            if(j==2)
            {
                StoreTIDTxData(&I2CMS_SlvTxGetFTData[i], devPointer->Feature.data3.value, devPointer->Feature.datalen[2],&i);
            }
            if(j==3)
            {
                StoreTIDTxData(&I2CMS_SlvTxGetFTData[i], devPointer->Feature.data4.value, devPointer->Feature.datalen[3],&i);
            }
            if(j==4)
            {
                StoreTIDTxData(&I2CMS_SlvTxGetFTData[i], devPointer->Feature.data5.value, devPointer->Feature.datalen[4],&i);
            }
            if(j==5)
            {
                StoreTIDTxData(&I2CMS_SlvTxGetFTData[i], devPointer->Feature.data6.value, devPointer->Feature.datalen[5],&i);
            }
            if(j==6)
            {
                StoreTIDTxData(&I2CMS_SlvTxGetFTData[i], devPointer->Feature.data7.value, devPointer->Feature.datalen[6],&i);
            }
            if(j==7)
            {
                StoreTIDTxData(&I2CMS_SlvTxGetFTData[i], devPointer->Feature.data8.value, devPointer->Feature.datalen[7],&i);
            }
            if(j==8)
            {
                StoreTIDTxData(&I2CMS_SlvTxGetFTData[i], devPointer->Feature.data9.value, devPointer->Feature.datalen[8],&i);
            }
            if(j==9)
            {
                StoreTIDTxData(&I2CMS_SlvTxGetFTData[i], devPointer->Feature.data10.value, devPointer->Feature.datalen[9],&i);
            }
        }
    }
    /* Input */
    if(devPointer->Input.dataNum != 0)
    {
        i=0;
        I2CMS_SlvTxInRPData[i++] = (unsigned char)devPointer->DevDesc.InRptLeng;
        I2CMS_SlvTxInRPData[i++] = (unsigned char)(devPointer->DevDesc.InRptLeng>>8);
        for(j=0; j<devPointer->Input.dataNum; j++)                                                                                          //import data
        {
            if(j==0)
            {
                StoreTIDTxData(&I2CMS_SlvTxInRPData[i], devPointer->Input.data1.value, devPointer->Input.datalen[0],&i);
            }
            if(j==1)
            {
                StoreTIDTxData(&I2CMS_SlvTxInRPData[i], devPointer->Input.data2.value, devPointer->Input.datalen[1],&i);
            }
            if(j==2)
            {
                StoreTIDTxData(&I2CMS_SlvTxInRPData[i], devPointer->Input.data3.value, devPointer->Input.datalen[2],&i);
            }
            if(j==3)
            {
                StoreTIDTxData(&I2CMS_SlvTxInRPData[i], devPointer->Input.data4.value, devPointer->Input.datalen[3],&i);
            }
            if(j==4)
            {
                StoreTIDTxData(&I2CMS_SlvTxInRPData[i], devPointer->Input.data5.value, devPointer->Input.datalen[4],&i);
            }
        }       
    }
}

void SlvDataStore()
{
    SlvDevDataStore(&LedDev);
}

// =============================================================================================
// =============================================================================================
// =============================================================================================
//
//                             Slave deal with received Data
//
// =============================================================================================
// =============================================================================================
// =============================================================================================

void HandTIDRxData(unsigned short* storeData, unsigned char RxData, unsigned char RxData_1, unsigned char DataLen, unsigned char* position)
{
    switch(DataLen)
    {
        case 1:
        {
            *storeData = RxData;
            (*position)+=1;
            break;
        }
        case 2:
        {
            *storeData = (RxData_1<<8) + RxData;
            (*position)+=2;
            break;
        }
    }
}
// =========================================================================
// =========================================================================
//                  Handle Set Feature
// =========================================================================
// =========================================================================
void HandSetFeat_sub(TID_Device* devPointer)
{
    unsigned char i=0,k=4;

    for(i=0;i<10;i++)
    {
        switch(devPointer->Feature.arg[i])
        {
            case 1:
            {
                HandTIDRxData(&devPointer->Feature.data1.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Feature.datalen[i],&k);
                break;
            }
            case 2:
            {
                HandTIDRxData(&devPointer->Feature.data2.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Feature.datalen[i],&k);
                break;
            }
            case 3:
            {
                HandTIDRxData(&devPointer->Feature.data3.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Feature.datalen[i],&k);
                break;
            }
            case 4:
            {
                HandTIDRxData(&devPointer->Feature.data4.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Feature.datalen[i],&k);
                break;
            }
            case 5:
            {
                HandTIDRxData(&devPointer->Feature.data5.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Feature.datalen[i],&k);
                break;
            }
            case 6:
            {
                HandTIDRxData(&devPointer->Feature.data6.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Feature.datalen[i],&k);
                break;
            }
            case 7:
            {
                HandTIDRxData(&devPointer->Feature.data7.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Feature.datalen[i],&k);
                break;
            }
            case 8:
            {
                HandTIDRxData(&devPointer->Feature.data8.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Feature.datalen[i],&k);
                break;
            }
            case 9:
            {
                HandTIDRxData(&devPointer->Feature.data9.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Feature.datalen[i],&k);
                break;
            }
            case 10:
            {
                HandTIDRxData(&devPointer->Feature.data10.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Feature.datalen[i],&k);
                break;
            }
        }
    }
    for(i=0;i<64;i++)
    {
        I2CMS_SlvRxData[i]=0;
    }
}

void HandSetFeat()
{
    HandSetFeat_sub(&LedDev);
}
// =========================================================================
// =========================================================================
//                  Handle Output Report
// =========================================================================
// =========================================================================
void HandOutRpt_sub(TID_Device* devPointer)
{
    unsigned char i=0,k=4;

    for(i=0;i<5;i++)
    {
        switch(devPointer->Output.arg[i])
        {
            case 1:                         //Sleep period
            {
                HandTIDRxData(&devPointer->Output.data1.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Output.datalen[i],&k);
                break;
            }
            case 2:                         //Vibration Level
            {
                HandTIDRxData(&devPointer->Output.data2.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Output.datalen[i],&k);
                break;
            }
            case 3:                         //Alerm time
            {
                HandTIDRxData(&devPointer->Output.data3.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Output.datalen[i],&k);
                break;
            }
            case 4:                         //Alerm time
            {
                HandTIDRxData(&devPointer->Output.data4.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Output.datalen[i],&k);
                break;
            }
            case 5:                         //Alerm time
            {
                HandTIDRxData(&devPointer->Output.data5.value,I2CMS_SlvRxData[k],I2CMS_SlvRxData[k+1],devPointer->Output.datalen[i],&k);
                break;
            }
        }
    }
    for(i=0;i<64;i++)
    {
        I2CMS_SlvRxData[i]=0;
    }
}

void HandOutRpt()
{
    HandOutRpt_sub(&LedDev);
}

// =========================================================================
// =========================================================================
//                              Slave deal with received Data
// =========================================================================
// =========================================================================
void TID_SlvRxUpdate()
{
    switch(I2CMS_SlvRxData[0])
    {
    case 4:                                                                         //handle input report 
    {
        Serial.print(LedDev.Output.data1.value);
        Serial.print(I2CMS_SlvRxData[0]);
        Serial.print(I2CMS_SlvRxData[1]);
        Serial.print(I2CMS_SlvRxData[2]);
        Serial.print(I2CMS_SlvRxData[3]);
        Serial.print(I2CMS_SlvRxData[4]);
        Serial.print(I2CMS_SlvRxData[5]);
        HandOutRpt();
        I2CSlvCmd = 0;
        break;
    }
    case 6:                                                                         //handle Get Feature
    {
        HandSetFeat();
        I2CSlvCmd = 0;
        break;
    }
    }
}
