package com.nuvoton.slidetab;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.widget.ProgressBar;

/**
 * Created by SLMeng on 2016/1/5.
 */
public class MyProgressBar extends ProgressBar {
    String text;
    Paint mPaint;
    int textSize;

    public MyProgressBar(Context context) {
        super(context);
        // TODO Auto-generated constructor stub
        System.out.println("1");
        initText();


    }

    public MyProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        // TODO Auto-generated constructor stub
        System.out.println("2");
        initText();
        //getAttrs(context,attrs);

    }


    public MyProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        // TODO Auto-generated constructor stub
        System.out.println("3");
        initText();
        //getAttrs(context, attrs);

    }

    @Override
    public synchronized void setProgress(int progress) {
        // TODO Auto-generated method stub
        setText(progress);
        super.setProgress(progress);
        invalidate();

    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        // TODO Auto-generated method stub
        super.onDraw(canvas);
        //this.setText();
        Rect rect = new Rect();
        this.mPaint.setTextSize(getHeight());
        this.mPaint.getTextBounds(this.text, 0, this.text.length(), rect);


        int x = (getWidth() / 2) - rect.centerX();
        int y = (getHeight() / 2) - rect.centerY();
        canvas.drawText(this.text, x, y, this.mPaint);
    }

    private void initText(){
        this.mPaint = new Paint();
        this.mPaint.setColor(Color.WHITE);

    }

    private void setText(){
        setText(this.getProgress());
    }

    private void setText(int progress){
        //int i = (progress * 100)/this.getMax();
        //this.text = String.valueOf(i) + "%";
        this.text = String.valueOf(progress);
    }

    private void getAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.myProgressAttr);
        textSize = ta.getDimensionPixelSize(R.styleable.myProgressAttr_textSize, getHeight());
        //Log.d("MYPROCESSBAR","size��"+String.valueOf(textSize));
        textSize = dip2px(context, textSize);
        ta.recycle();
    }
    public static int dip2px(Context context,float dipValue){
        final float scale=context.getResources().getDisplayMetrics().density;
        return (int)(dipValue*scale+0.5f);
    }
}
