package com.nuvoton.slidetab;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import android.app.Activity;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.hardware.Camera;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.support.v4.view.ViewPager;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.widget.Toolbar;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.CheckBox;
import android.widget.ListView;
import android.widget.SeekBar;
import android.widget.SimpleAdapter;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;

public class NubrickActivity extends ActionBarActivity {
    private CustomViewPager mPager;
    private SlidingTabLayout mSlidingTabLayout;
    private List<View> listViews;
    private List<String> titleList;
    private List<Integer> titleLightList;
    private List<Integer> titleDarkList;
    private int currIndex;//��ǰҳ�����

    // Intent request codes
    private static final int REQUEST_CONNECT_DEVICE = 1;
    private static final int REQUEST_ENABLE_BT = 2;
    private static final int REQUEST_SETTINGS = 3;
    //private BluetoothAdapter  mBluetoothAdapter=null;
    private Context context = null;
    private BluetoothAdapter mBluetoothAdapter = null;

    private BluetoothService mbtService = null;
    public static final int MESSAGE_STATE_CHANGE = 1;
    public static final int MESSAGE_READ = 2;
    public static final int MESSAGE_WRITE = 3;
    public static final int MESSAGE_DEVICE_NAME = 4;
    public static final int MESSAGE_TOAST = 5;
    public static final String DEVICE_NAME = "device_name";
    public static final String TOAST = "toast";
    private boolean isConnected = false;
    private ImageButton button_connect;
    private ImageButton button_devlink;
    private ImageButton button_settings;
    private ImageButton button_index;
    private ImageButton button_drawer;
    //private BluetoothDevice device;
    //tab0
    private ImageView image00, image01, image02, image03, image04, image05, image06, image07, image08;
    private MyProgressBar p00, p01, p02, p03, p04, p05, p06, p07, p08, p09, p010, p011, p012, p013, p014, p015;
    //tab1
    private ImageView image10, image11, image12, image13, image14, image15, image16, image17, image18;
    private Button button10, button11;
    private CheckBox cbox10, cbox11, cbox12, cbox13, cbox14, cbox15,
            cbox16, cbox17, cbox18, cbox19, cbox1a, cbox1b, cbox1c, cbox1d;
    private int buzzerlinkstate;
    private int ledlinkstate;
    //tab2 battery
    private MyProgressBar p20;
    private ImageView i20;
    private SeekBar s20, s21;
    private EditText e20, e21;
    private Button button20, button21;
    //tab3 buzzer
    //private MyProgressBar p30;
    private ImageView i30;
    private SeekBar s30, s31, s32, s33, s34, s35, s36;
    private EditText e30, e31, e32, e33, e34, e35, e36;
    private ToggleButton tb30, tb31;
    private Button button30, button31;
    //tab4 led
    //private MyProgressBar p40;
    private ImageView i40;
    private SeekBar s40, s41, s42, s43, s44, s45, s46;
    private EditText e40, e41, e42, e43, e44, e45, e46;
    private ToggleButton tb40, tb41;
    private Button button40, button41;
    //tab5 ahrs
    private MyProgressBar p50;
    private ImageView i50;
    private SeekBar s50, s51;
    private EditText e50, e51;
    private Button button50, button51;
    //tab6
    private MyProgressBar p60;
    private ImageView i60;
    private SeekBar s60, s61;
    private EditText e60, e61;
    private Button button60, button61;
    //tab7 temperature
    private MyProgressBar p70, p72;
    private ImageView i70, i71;
    private SeekBar s70, s71, s72;
    private EditText e70, e71, e72;
    private Button button70, button71;
    //tab8
    private MyProgressBar p80;
    private ImageView i80;
    private SeekBar s80, s81;
    private EditText e80, e81;
    private Button button80, button81;
    //tab9 ir
    private MyProgressBar p90;
    private SeekBar s90, s91, s92, s93, s94;
    private EditText e90, e91, e92, e93, e94;
    private ToggleButton tb90, tb91;
    private Button button90, button91;
    //tab10 key
    private MyProgressBar pa0;
    private SeekBar sa0;
    private EditText ea0;
    private Button buttona0, buttona1;

    //tab11 settings
    private Switch sw_fl,sw_sms,sw_pm,sw_batt,sw_dis,sw_gas,sw_temp,sw_vib;
    private TextView tv_custom,tv_about;
    private EditText edit_sms;

    //tab12 about
    private WebView webview;


    private com.zhy.android.percent.support.PercentDrawerLayout mDrawerLayout;
    private ActionBarDrawerToggle mDrawerToggle;
    private Toolbar mToolbar;
    private com.zhy.android.percent.support.PercentLinearLayout mDrawer;

    private ListView mDrawerList;
    private String[] mPlanetTitles;
    private int[] mImageTitles;
    private ArrayList<HashMap<String, Object>> listItem;
    private SimpleAdapter mSimpleAdapter;
    private List<Integer> LightList;
    private List<Integer> DarkList;
    private List<Integer> DisableList;
    private int[] Itemenableflag;

    private ImageView title_image;
    private TextView title_text;

    private boolean fl_alarm=false;
    private boolean pm_alarm=false;
    private boolean sms_alarm = false;

    private ProgressDialog m_pDialog;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        int flag = WindowManager.LayoutParams.FLAG_FULLSCREEN;
        //获得当前窗体对象
        Window window = this.getWindow();
        //设置当前窗体为全屏显示
        window.setFlags(flag, flag);
        setContentView(R.layout.activity_nubrick);
        //requestWindowFeature(Window.FEATURE_NO_TITLE); //设置无标题
        //等待对话框
        m_pDialog = new ProgressDialog(this);
        m_pDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
        m_pDialog.setMessage("Loading...");
        m_pDialog.setIndeterminate(false);
        m_pDialog.setCancelable(false);

        button_connect = (ImageButton) findViewById(R.id.button_connect);
        button_connect.setOnClickListener(new OnConnectListener());
        mbtService = new BluetoothService(this, mHandler);
        context = getBaseContext();

        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (mBluetoothAdapter == null) {
            Toast.makeText(this, "Bluetooth is not available", Toast.LENGTH_LONG).show();
            finish();
            return;
        } else {
            if (!mBluetoothAdapter.isEnabled()) {
                Intent enableIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
                startActivityForResult(enableIntent, REQUEST_ENABLE_BT);
            } else {
                Intent serverIntent = new Intent(context, DeviceListActivity.class);
                startActivityForResult(serverIntent, REQUEST_CONNECT_DEVICE);
            }
        }
        //button_devlink = (ImageButton) findViewById(R.id.button_devlink);
        //button_devlink.setOnClickListener(new OnDevlinkListener());
        button_settings = (ImageButton) findViewById(R.id.button_settings);
        button_settings.setOnClickListener(new OnSettingsListener());

        button_index = (ImageButton) findViewById(R.id.button_index);
        button_index.setOnClickListener(new OnIndexListener());
        // button_drawer = (ImageButton)findViewById(R.id.drawer_toggle);//use other way
        // button_drawer.setOnClickListener(new OnDrawerbuttonListener());//
        title_image = (ImageView) findViewById(R.id.title_image);
        title_text = (TextView) findViewById(R.id.title_text);

        InitViewPager();

        mToolbar = (Toolbar) findViewById(R.id.tl_custom);
        setSupportActionBar(mToolbar);
        //getSupportActionBar().setDisplayHomeAsUpEnabled(true);


        mDrawerLayout = (com.zhy.android.percent.support.PercentDrawerLayout) findViewById(R.id.drawer);
        mDrawerToggle = new ActionBarDrawerToggle(this, mDrawerLayout, mToolbar, R.string.drawer_open,
                R.string.drawer_close);
        mDrawerToggle.syncState();
        mDrawerLayout.setDrawerListener(mDrawerToggle);
        mDrawerLayout.setDrawerListener(new DrawerLayoutStateListener());
        mDrawer = (com.zhy.android.percent.support.PercentLinearLayout) findViewById(R.id.drawer_view);

        mPlanetTitles = getResources().getStringArray(R.array.planets_array);
        //mImageTitles = getResources().getIntArray(R.array.titleimage_arry);
        TypedArray ar = context.getResources().obtainTypedArray(R.array.titleimage_arry);
        int len = ar.length();
        mImageTitles = new int[len];
        for (int i = 0; i < len; i++)
            mImageTitles[i] = ar.getResourceId(i, 0);
        ar.recycle();

        Itemenableflag = new int[9];
        mDrawerList = (ListView) findViewById(R.id.drawer_list);
        // mDrawerList.setAdapter(new ArrayAdapter<String>(this,
        //        R.layout.drawer_list_item, mPlanetTitles));
        mDrawerList.setOnItemClickListener(new DrawerItemClickListener());
        DisableList = new ArrayList<>();
        DisableList.add(R.mipmap.battery02);
        DisableList.add(R.mipmap.buzzer02);
        DisableList.add(R.mipmap.led02);
        DisableList.add(R.mipmap.ahrs02);
        DisableList.add(R.mipmap.sonar02);
        DisableList.add(R.mipmap.temperature02);
        DisableList.add(R.mipmap.gas02);
        DisableList.add(R.mipmap.ir02);
        DisableList.add(R.mipmap.key02);

        LightList = new ArrayList<>();
        LightList.add(R.mipmap.battery01);
        LightList.add(R.mipmap.buzzer01);
        LightList.add(R.mipmap.led01);
        LightList.add(R.mipmap.ahrs01);
        LightList.add(R.mipmap.sonar01);
        LightList.add(R.mipmap.temperature01);
        LightList.add(R.mipmap.gas01);
        LightList.add(R.mipmap.ir01);
        LightList.add(R.mipmap.key01);

        DarkList = new ArrayList<>();
        DarkList.add(R.mipmap.battery);
        DarkList.add(R.mipmap.buzzer);
        DarkList.add(R.mipmap.led);
        DarkList.add(R.mipmap.ahrs);
        DarkList.add(R.mipmap.sonar);
        DarkList.add(R.mipmap.temperature);
        DarkList.add(R.mipmap.gas);
        DarkList.add(R.mipmap.ir);
        DarkList.add(R.mipmap.key);
        listItem = new ArrayList<HashMap<String, Object>>();/*在数组中存放数据*/
        HashMap<String, Object> map;
        /*
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.index1);//加入图片
        map.put("ItemTitle", "index");
        listItem.add(map);
        */
        for (int i = 0; i < 9; i++) {
            map = new HashMap<String, Object>();
            map.put("ItemImage", DisableList.get(i));//加入图片
            //map.put("ItemTitle", "devlink");
            listItem.add(map);
        }
        /*
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.link_light);//加入图片
        //map.put("ItemTitle", "devlink");
        listItem.add(map);
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.battery);//加入图片
       // map.put("ItemTitle", "battery");
        listItem.add(map);
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.buzzer);//加入图片
        //map.put("ItemTitle", "buzzer");
        listItem.add(map);
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.led);//加入图片
       // map.put("ItemTitle", "led");
        listItem.add(map);
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.ahrs);//加入图片
       // map.put("ItemTitle", "ahrs");
        listItem.add(map);
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.sonar);//加入图片
        //map.put("ItemTitle", "sonar");
        listItem.add(map);
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.temperature);//加入图片
        //map.put("ItemTitle", "Temp.");
        listItem.add(map);
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.gas);//加入图片
        //map.put("ItemTitle", "gas");
        listItem.add(map);
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.ir);//加入图片
       //map.put("ItemTitle", "ir");
        listItem.add(map);
        map = new HashMap<String, Object>();
        map.put("ItemImage", R.mipmap.key);//加入图片
       // map.put("ItemTitle", "key");
        listItem.add(map);
        */

        mSimpleAdapter = new SimpleAdapter(this, listItem,//需要绑定的数据
                R.layout.drawer_list_item,//每一行的布局//动态数组中的数据源的键对应到定义布局的View中
                new String[]{"ItemImage"},
                new int[]{R.id.ItemImage}
        );

        mDrawerList.setAdapter(mSimpleAdapter);
        mDrawerList.setOnItemClickListener(new DrawerItemClickListener());


        InitAlarmAudio();
    }


    /* The click listner for ListView in the navigation drawer */
    private class DrawerItemClickListener implements ListView.OnItemClickListener {
        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
            selectItem(position);
        }
    }

    private void selectItem(int position) {
        // update the main content by replacing fragments
        /*
        Fragment fragment = new PlanetFragment();
        Bundle args = new Bundle();
        args.putInt(PlanetFragment.ARG_PLANET_NUMBER, position);
        fragment.setArguments(args);
        FragmentManager fragmentManager = getFragmentManager();
        fragmentManager.beginTransaction().replace(R.id.content_frame, fragment).commit();
        */
        // update selected item and title, then close the drawer
        for (int i = 0; i < 9; i++) {
            HashMap<String, Object> map = listItem.get(i);
            if (Itemenableflag[i] == 1) {
                if(position==i){
                    map.put("ItemImage", LightList.get(i));
                    mPager.setCurrentItem(position + 2);
                }else {
                    map.put("ItemImage", DarkList.get(i));
                }
            } else {
                map.put("ItemImage", DisableList.get(i));
            }
            listItem.set(i, map);
            mSimpleAdapter.notifyDataSetChanged();
        }


        if (Itemenableflag[position] == 1) {
            //HashMap<String, Object> map = listItem.get(position);
           // map.put("ItemImage", LightList.get(position));
            //listItem.set(position, map);
           // mSimpleAdapter.notifyDataSetChanged();
            //mDrawerList.setItemChecked(position, true);
            for (int i = 0; i < 9; i++) {
                HashMap<String, Object> map = listItem.get(i);
                if (Itemenableflag[i] == 1) {
                    if(position==i){
                        map.put("ItemImage", LightList.get(i));
                    }else {
                        map.put("ItemImage", DarkList.get(i));
                    }
                } else {
                    map.put("ItemImage", DisableList.get(i));
                }
                listItem.set(i, map);
                mSimpleAdapter.notifyDataSetChanged();
            }

            mPager.setCurrentItem(position + 2);
            Log.d("###0", String.valueOf(position));
            //setTitle(mPlanetTitles[position+1]);
            setTitle1(position + 2);
            mDrawerLayout.closeDrawer(mDrawer);
        } else {
            return;
        }
    }

    public void setTitle1(int i) {
        title_image.setBackgroundResource(mImageTitles[i]);
        title_text.setText(mPlanetTitles[i]);
    }

    @Override
    public void setTitle(CharSequence title) {
        //mTitle = title;
        //getActionBar().setTitle(mTitle);
        Log.d("###0", String.valueOf(title));
        //getActionBar().setTitle(title);
        mToolbar.setTitle(title);
    }

    private class DrawerLayoutStateListener extends
            DrawerLayout.SimpleDrawerListener {
        @Override
        public void onDrawerOpened(View drawerView) {
            super.onDrawerOpened(drawerView);
            /*
            if (currIndex >= 2) {
                mDrawerList.setItemChecked(currIndex - 2, true);
                if (Itemenableflag[currIndex - 2] == 1) {
                    HashMap<String, Object> map = listItem.get(currIndex - 2);
                    map.put("ItemImage", LightList.get(currIndex - 2));
                    listItem.set(currIndex - 2, map);
                    mSimpleAdapter.notifyDataSetChanged();
                }
            }*/

            //Log.d("###1", String.valueOf(currIndex));
        }

        @Override
        public void onDrawerClosed(View drawerView) {
            super.onDrawerClosed(drawerView);
            /*
            for (int i = 0; i < 9; i++) {
                HashMap<String, Object> map = listItem.get(i);
                if (Itemenableflag[i] == 1) {
                    map.put("ItemImage", DarkList.get(i));
                } else {
                    map.put("ItemImage", DisableList.get(i));
                }
                listItem.set(i, map);
                mSimpleAdapter.notifyDataSetChanged();
            }*/
        }
    }

    class OnConnectListener implements View.OnClickListener {

        @Override
        public void onClick(View v) {
            if (mBluetoothAdapter == null) {
                Toast.makeText(context, "Bluetooth is not available", Toast.LENGTH_LONG).show();
                finish();
                return;
            } else {
                if (!mBluetoothAdapter.isEnabled()) {
                    Intent enableIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
                    startActivityForResult(enableIntent, REQUEST_ENABLE_BT);
                }
            }
            Intent serverIntent = new Intent(context, DeviceListActivity.class);
            startActivityForResult(serverIntent, REQUEST_CONNECT_DEVICE);
        }
    }

    class OnDevlinkListener implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            mPager.setCurrentItem(1);
            mToolbar.setTitle("Device Link");
            for (int i = 0; i < 9; i++) {
                HashMap<String, Object> map = listItem.get(i);
                if (Itemenableflag[i] == 1) {
                    map.put("ItemImage", DarkList.get(i));
                } else {
                    map.put("ItemImage", DisableList.get(i));
                }
                listItem.set(i, map);
                mSimpleAdapter.notifyDataSetChanged();
            }
        }
    }
    class OnSettingsListener implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            mPager.setCurrentItem(11);
            mToolbar.setTitle("Settings");
            for (int i = 0; i < 9; i++) {
                HashMap<String, Object> map = listItem.get(i);
                if (Itemenableflag[i] == 1) {
                    map.put("ItemImage", DarkList.get(i));
                } else {
                    map.put("ItemImage", DisableList.get(i));
                }
                listItem.set(i, map);
                mSimpleAdapter.notifyDataSetChanged();
            }
        }
    }
    class  MyOnAboutClicked implements View.OnClickListener{

        @Override
        public void onClick(View v) {
            mPager.setCurrentItem(12);
            mToolbar.setTitle("About");
        }
    }


    class OnIndexListener implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            mPager.setCurrentItem(0);
            //mToolbar.setTitle("Index");
            setTitle1(0);
            mDrawerLayout.closeDrawer(mDrawer);
        }
    }

    class OnDrawerbuttonListener implements View.OnClickListener {

        @Override
        public void onClick(View v) {
            mDrawerLayout.openDrawer(Gravity.LEFT);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        //InitImageView();
        //InitProcessBar();
    }

    public void onDestroy() {
        super.onDestroy();
        if (isConnected) {
            if (mbtService != null) mbtService.stop();
        }
        //Log.d("###","ondistroy");
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        //if(D) Log.d(TAG, "onActivityResult " + resultCode);
        switch (requestCode) {
            case REQUEST_CONNECT_DEVICE:
                // When DeviceListActivity returns with a device to connect
                if (resultCode == Activity.RESULT_OK) {
                    // Get the device MAC address
                    String address = data.getExtras()
                            .getString(DeviceListActivity.EXTRA_DEVICE_ADDRESS);
                    // Get the BLuetoothDevice object
                    BluetoothDevice device = mBluetoothAdapter.getRemoteDevice(address);
                    // Attempt to connect to the device
                    mbtService.connect(device);
                }
                break;
            case REQUEST_ENABLE_BT:
                // When the request to enable Bluetooth returns
                if (resultCode == Activity.RESULT_OK) {
                    // Bluetooth is now enabled, so set up a chat session
                    // setupChat();
                    Intent serverIntent = new Intent(context, DeviceListActivity.class);
                    startActivityForResult(serverIntent, REQUEST_CONNECT_DEVICE);
                } else {
                    // User did not enable Bluetooth or an error occured
                    //Log.d(TAG, "BT not enabled");
                    Toast.makeText(this, R.string.bt_not_enabled_leaving, Toast.LENGTH_SHORT).show();
                    finish();
                }
                break;
        }
    }

    /*
     * ��ʼ����ǩ��
     */
    public void InitImageView0(View v) {
        image00 = (ImageView) v.findViewById(R.id.image_battery);
        image01 = (ImageView) v.findViewById(R.id.image_buzzer);
        image02 = (ImageView) v.findViewById(R.id.image_led);
        image03 = (ImageView) v.findViewById(R.id.image_ahrs);
        image04 = (ImageView) v.findViewById(R.id.image_sonar);
        image05 = (ImageView) v.findViewById(R.id.image_temp);
        image06 = (ImageView) v.findViewById(R.id.image_gas);
        image07 = (ImageView) v.findViewById(R.id.image_dir);
        image08 = (ImageView) v.findViewById(R.id.image_key);

        //image00.setBackgroundColor(Color.parseColor("#ff747674"));
    }

    public void InitProcessBar0(View v) {
        p00 = (MyProgressBar) v.findViewById(R.id.progressBar01);
        p01 = (MyProgressBar) v.findViewById(R.id.progressBar02);
        p02 = (MyProgressBar) v.findViewById(R.id.progressBar03);
        p03 = (MyProgressBar) v.findViewById(R.id.progressBar04);
        p04 = (MyProgressBar) v.findViewById(R.id.progressBar05);
        p05 = (MyProgressBar) v.findViewById(R.id.progressBar06);
        p06 = (MyProgressBar) v.findViewById(R.id.progressBar07);
        p07 = (MyProgressBar) v.findViewById(R.id.progressBar08);
        p08 = (MyProgressBar) v.findViewById(R.id.progressBar09);
        p09 = (MyProgressBar) v.findViewById(R.id.progressBar10);
        p010 = (MyProgressBar) v.findViewById(R.id.progressBar11);
        p011 = (MyProgressBar) v.findViewById(R.id.progressBar12);
        p012 = (MyProgressBar) v.findViewById(R.id.progressBar13);
        p013 = (MyProgressBar) v.findViewById(R.id.progressBar14);
        p014 = (MyProgressBar) v.findViewById(R.id.progressBar15);
        p015 = (MyProgressBar) v.findViewById(R.id.progressBar16);
        //p00.setProgress(20);
    }

    public void InitImageView1(View v) {
        image10 = (ImageView) v.findViewById(R.id.image_battery);
        image11 = (ImageView) v.findViewById(R.id.image_ahrs);
        image12 = (ImageView) v.findViewById(R.id.image_sonar);
        image13 = (ImageView) v.findViewById(R.id.image_temp);
        image14 = (ImageView) v.findViewById(R.id.image_gas);
        image15 = (ImageView) v.findViewById(R.id.image_buzzer);
        image16 = (ImageView) v.findViewById(R.id.image_led);
        image17 = (ImageView) v.findViewById(R.id.image_ir);
        image18 = (ImageView) v.findViewById(R.id.image_key);
        //image00.setBackgroundColor(Color.parseColor("#ff747674"));
    }

    public void InitButton1(View v) {
        cbox10 = (CheckBox) v.findViewById(R.id.checkBox01);
        cbox11 = (CheckBox) v.findViewById(R.id.checkBox02);
        cbox12 = (CheckBox) v.findViewById(R.id.checkBox03);
        cbox13 = (CheckBox) v.findViewById(R.id.checkBox04);
        cbox14 = (CheckBox) v.findViewById(R.id.checkBox05);
        cbox15 = (CheckBox) v.findViewById(R.id.checkBox11);
        cbox16 = (CheckBox) v.findViewById(R.id.checkBox12);
        cbox17 = (CheckBox) v.findViewById(R.id.checkBox13);
        cbox18 = (CheckBox) v.findViewById(R.id.checkBox14);
        cbox19 = (CheckBox) v.findViewById(R.id.checkBox15);
        cbox1a = (CheckBox) v.findViewById(R.id.checkBox06);
        cbox1b = (CheckBox) v.findViewById(R.id.checkBox07);
        cbox1c = (CheckBox) v.findViewById(R.id.checkBox16);
        cbox1d = (CheckBox) v.findViewById(R.id.checkBox17);

        button10 = (Button) v.findViewById(R.id.button_set);
        button11 = (Button) v.findViewById(R.id.button_reload);

        button10.setOnClickListener(new MyOnSetButtonClicked());
        button11.setOnClickListener(new MyOnReloadButtonClicked());

    }

    public void InitView2(View v) {
        p20 = (MyProgressBar) v.findViewById(R.id.progressBar01);
        //p21 = (MyProgressBar)v.findViewById(R.id.progressBar02);
        i20 = (ImageView) v.findViewById(R.id.image01);
        s20 = (SeekBar) v.findViewById(R.id.seekBar01);
        s21 = (SeekBar) v.findViewById(R.id.seekBar02);
        e20 = (EditText) v.findViewById(R.id.edittext01);
        e21 = (EditText) v.findViewById(R.id.edittext02);
        button20 = (Button) v.findViewById(R.id.button_set);
        button21 = (Button) v.findViewById(R.id.button_reload);

        e20.addTextChangedListener(new MyTextWatcher(e20, 1024));
        e21.addTextChangedListener(new MyTextWatcher(e21, 100));
        s20.setOnSeekBarChangeListener(new MyProcessListener(e20));
        s21.setOnSeekBarChangeListener(new MyProcessListener(e21));

        button20.setOnClickListener(new MyOnSetButtonClicked());
        button21.setOnClickListener(new MyOnReloadButtonClicked());
    }

    private void InitView3(View v)//buzzer
    {
        // p30 = (MyProgressBar)v.findViewById(R.id.progressBar01);
        i30 = (ImageView) v.findViewById(R.id.image01);
        s30 = (SeekBar) v.findViewById(R.id.seekBar01);
        s31 = (SeekBar) v.findViewById(R.id.seekBar02);
        s32 = (SeekBar) v.findViewById(R.id.seekBar03);
        s33 = (SeekBar) v.findViewById(R.id.seekBar04);
        s34 = (SeekBar) v.findViewById(R.id.seekBar05);
        s35 = (SeekBar) v.findViewById(R.id.seekBar06);
        s36 = (SeekBar) v.findViewById(R.id.seekBar07);
        e30 = (EditText) v.findViewById(R.id.edittext01);
        e31 = (EditText) v.findViewById(R.id.edittext02);
        e32 = (EditText) v.findViewById(R.id.edittext03);
        e33 = (EditText) v.findViewById(R.id.edittext04);
        e34 = (EditText) v.findViewById(R.id.edittext05);
        e35 = (EditText) v.findViewById(R.id.edittext06);
        e36 = (EditText) v.findViewById(R.id.edittext07);
        tb30 = (ToggleButton) v.findViewById(R.id.togglebutton01);
        tb31 = (ToggleButton) v.findViewById(R.id.togglebutton02);
        button30 = (Button) v.findViewById(R.id.button_set);
        button31 = (Button) v.findViewById(R.id.button_reload);

        s30.setOnSeekBarChangeListener(new MyProcessListener(e30));
        s31.setOnSeekBarChangeListener(new MyProcessListener(e31));
        s32.setOnSeekBarChangeListener(new MyProcessListener(e32));
        s33.setOnSeekBarChangeListener(new MyProcessListener(e33));
        s34.setOnSeekBarChangeListener(new MyProcessListener(e34));
        s35.setOnSeekBarChangeListener(new MyProcessListener(e35));
        s36.setOnSeekBarChangeListener(new MyProcessListener(e36));

        e30.addTextChangedListener(new MyTextWatcher(e30, 2048));
        e31.addTextChangedListener(new MyTextWatcher(e31, 100));
        e32.addTextChangedListener(new MyTextWatcher(e32, 5000));
        e33.addTextChangedListener(new MyTextWatcher(e33, 2));
        e34.addTextChangedListener(new MyTextWatcher(e34, 2048));
        e35.addTextChangedListener(new MyTextWatcher(e35, 100));
        e36.addTextChangedListener(new MyTextWatcher(e36, 60));

        button30.setOnClickListener(new MyOnSetButtonClicked());
        button31.setOnClickListener(new MyOnReloadButtonClicked());
    }

    private void InitView4(View v)//led
    {
        //p40 = (MyProgressBar)v.findViewById(R.id.progressBar01);
        i40 = (ImageView) v.findViewById(R.id.image01);
        s40 = (SeekBar) v.findViewById(R.id.seekBar01);
        s41 = (SeekBar) v.findViewById(R.id.seekBar02);
        s42 = (SeekBar) v.findViewById(R.id.seekBar03);
        s43 = (SeekBar) v.findViewById(R.id.seekBar04);
        s44 = (SeekBar) v.findViewById(R.id.seekBar05);
        s45 = (SeekBar) v.findViewById(R.id.seekBar06);
        s46 = (SeekBar) v.findViewById(R.id.seekBar07);
        e40 = (EditText) v.findViewById(R.id.edittext01);
        e41 = (EditText) v.findViewById(R.id.edittext02);
        e42 = (EditText) v.findViewById(R.id.edittext03);
        e43 = (EditText) v.findViewById(R.id.edittext04);
        e44 = (EditText) v.findViewById(R.id.edittext05);
        e45 = (EditText) v.findViewById(R.id.edittext06);
        e46 = (EditText) v.findViewById(R.id.edittext07);
        tb40 = (ToggleButton) v.findViewById(R.id.togglebutton01);
        tb41 = (ToggleButton) v.findViewById(R.id.togglebutton02);
        button40 = (Button) v.findViewById(R.id.button_set);
        button41 = (Button) v.findViewById(R.id.button_reload);

        s40.setOnSeekBarChangeListener(new MyProcessListener(e40));
        s41.setOnSeekBarChangeListener(new MyProcessListener(e41));
        s42.setOnSeekBarChangeListener(new MyProcessListener(e42));
        s43.setOnSeekBarChangeListener(new MyProcessListener(e43));
        s44.setOnSeekBarChangeListener(new MyProcessListener(e44));
        s45.setOnSeekBarChangeListener(new MyProcessListener(e45));
        s46.setOnSeekBarChangeListener(new MyProcessListener(e46));

        e40.addTextChangedListener(new MyTextWatcher(e40, 2048));
        e41.addTextChangedListener(new MyTextWatcher(e41, 100));
        e42.addTextChangedListener(new MyTextWatcher(e42, 2048));
        e43.addTextChangedListener(new MyTextWatcher(e43, 2));
        e44.addTextChangedListener(new MyTextWatcher(e44, 2048));
        e45.addTextChangedListener(new MyTextWatcher(e45, 100));
        e46.addTextChangedListener(new MyTextWatcher(e46, 60));

        button40.setOnClickListener(new MyOnSetButtonClicked());
        button41.setOnClickListener(new MyOnReloadButtonClicked());
    }

    private void InitView5(View v)//ahrs
    {
        p50 = (MyProgressBar) v.findViewById(R.id.progressBar01);
        //p51 = (MyProgressBar)v.findViewById(R.id.progressBar02);
        i50 = (ImageView) v.findViewById(R.id.image01);
        s50 = (SeekBar) v.findViewById(R.id.seekBar01);
        s51 = (SeekBar) v.findViewById(R.id.seekBar02);
        e50 = (EditText) v.findViewById(R.id.edittext01);
        e51 = (EditText) v.findViewById(R.id.edittext02);
        button50 = (Button) v.findViewById(R.id.button_set);
        button51 = (Button) v.findViewById(R.id.button_reload);

        s50.setOnSeekBarChangeListener(new MyProcessListener(e50));
        s51.setOnSeekBarChangeListener(new MyProcessListener(e51));

        e50.addTextChangedListener(new MyTextWatcher(e50, 1024));
        e51.addTextChangedListener(new MyTextWatcher(e51, 10));

        button50.setOnClickListener(new MyOnSetButtonClicked());
        button51.setOnClickListener(new MyOnReloadButtonClicked());
    }

    private void InitView6(View v)//sonar
    {
        p60 = (MyProgressBar) v.findViewById(R.id.progressBar01);
        //p61 = (MyProgressBar)v.findViewById(R.id.progressBar02);
        i60 = (ImageView) v.findViewById(R.id.image01);
        s60 = (SeekBar) v.findViewById(R.id.seekBar01);
        s61 = (SeekBar) v.findViewById(R.id.seekBar02);
        e60 = (EditText) v.findViewById(R.id.edittext01);
        e61 = (EditText) v.findViewById(R.id.edittext02);
        button60 = (Button) v.findViewById(R.id.button_set);
        button61 = (Button) v.findViewById(R.id.button_reload);

        s60.setOnSeekBarChangeListener(new MyProcessListener(e60));
        s61.setOnSeekBarChangeListener(new MyProcessListener(e61));

        e60.addTextChangedListener(new MyTextWatcher(e60, 1024));
        e61.addTextChangedListener(new MyTextWatcher(e61, 200));

        button60.setOnClickListener(new MyOnSetButtonClicked());
        button61.setOnClickListener(new MyOnReloadButtonClicked());
    }


    private void InitView7(View v)//temperature
    {
        p70 = (MyProgressBar) v.findViewById(R.id.progressBar01);
        //p71 = (MyProgressBar)v.findViewById(R.id.progressBar02);
        p72 = (MyProgressBar) v.findViewById(R.id.progressBar03);
        //p73 = (MyProgressBar)v.findViewById(R.id.progressBar04);
        i70 = (ImageView) v.findViewById(R.id.image01);
        i71 = (ImageView) v.findViewById(R.id.image02);
        s70 = (SeekBar) v.findViewById(R.id.seekBar01);
        s71 = (SeekBar) v.findViewById(R.id.seekBar02);
        s72 = (SeekBar) v.findViewById(R.id.seekBar03);
        e70 = (EditText) v.findViewById(R.id.edittext01);
        e71 = (EditText) v.findViewById(R.id.edittext02);
        e72 = (EditText) v.findViewById(R.id.edittext03);
        button70 = (Button) v.findViewById(R.id.button_set);
        button71 = (Button) v.findViewById(R.id.button_reload);

        s70.setOnSeekBarChangeListener(new MyProcessListener(e70));
        s71.setOnSeekBarChangeListener(new MyProcessListener(e71));
        s72.setOnSeekBarChangeListener(new MyProcessListener(e72));

        e70.addTextChangedListener(new MyTextWatcher(e70, 1024));
        e71.addTextChangedListener(new MyTextWatcher(e71, 100));
        e72.addTextChangedListener(new MyTextWatcher(e72, 100));

        button70.setOnClickListener(new MyOnSetButtonClicked());
        button71.setOnClickListener(new MyOnReloadButtonClicked());
    }

    private void InitView8(View v) {
        p80 = (MyProgressBar) v.findViewById(R.id.progressBar01);
        //p81 = (MyProgressBar)v.findViewById(R.id.progressBar02);
        i80 = (ImageView) v.findViewById(R.id.image01);
        s80 = (SeekBar) v.findViewById(R.id.seekBar01);
        s81 = (SeekBar) v.findViewById(R.id.seekBar02);
        e80 = (EditText) v.findViewById(R.id.edittext01);
        e81 = (EditText) v.findViewById(R.id.edittext02);
        button80 = (Button) v.findViewById(R.id.button_set);
        button81 = (Button) v.findViewById(R.id.button_reload);

        s80.setOnSeekBarChangeListener(new MyProcessListener(e80));
        s81.setOnSeekBarChangeListener(new MyProcessListener(e81));

        e80.addTextChangedListener(new MyTextWatcher(e80, 1024));
        e81.addTextChangedListener(new MyTextWatcher(e81, 100));

        button80.setOnClickListener(new MyOnSetButtonClicked());
        button81.setOnClickListener(new MyOnReloadButtonClicked());
    }

    private void InitView9(View v)//temperature
    {
        p90 = (MyProgressBar) v.findViewById(R.id.progressBar01);
        //p81 = (MyProgressBar)v.findViewById(R.id.progressBar02);
        s90 = (SeekBar) v.findViewById(R.id.seekBar01);
        s91 = (SeekBar) v.findViewById(R.id.seekBar02);
        s92 = (SeekBar) v.findViewById(R.id.seekBar03);
        s93 = (SeekBar) v.findViewById(R.id.seekBar04);
        s94 = (SeekBar) v.findViewById(R.id.seekBar05);

        e90 = (EditText) v.findViewById(R.id.edittext01);
        e91 = (EditText) v.findViewById(R.id.edittext02);
        e92 = (EditText) v.findViewById(R.id.edittext03);
        e93 = (EditText) v.findViewById(R.id.edittext04);
        e94 = (EditText) v.findViewById(R.id.edittext05);

        tb90 = (ToggleButton) v.findViewById(R.id.togglebutton01);
        tb91 = (ToggleButton) v.findViewById(R.id.togglebutton02);

        button90 = (Button) v.findViewById(R.id.button_set);
        button91 = (Button) v.findViewById(R.id.button_reload);

        s90.setOnSeekBarChangeListener(new MyProcessListener(e90));
        s91.setOnSeekBarChangeListener(new MyProcessListener(e91));
        s92.setOnSeekBarChangeListener(new MyProcessListener(e92));
        s93.setOnSeekBarChangeListener(new MyProcessListener(e93));
        s94.setOnSeekBarChangeListener(new MyProcessListener(e94));

        e90.addTextChangedListener(new MyTextWatcher(e90, 2048));
        e91.addTextChangedListener(new MyTextWatcher(e91, 6));
        e92.addTextChangedListener(new MyTextWatcher(e92, 1));
        e93.addTextChangedListener(new MyTextWatcher(e93, 1));
        e94.addTextChangedListener(new MyTextWatcher(e94, 6));

        button90.setOnClickListener(new MyOnSetButtonClicked());
        button91.setOnClickListener(new MyOnReloadButtonClicked());
    }

    private void InitViewa(View v) {
        pa0 = (MyProgressBar) v.findViewById(R.id.progressBar01);
        sa0 = (SeekBar) v.findViewById(R.id.seekBar01);
        ea0 = (EditText) v.findViewById(R.id.edittext01);

        buttona0 = (Button) v.findViewById(R.id.button_set);
        buttona1 = (Button) v.findViewById(R.id.button_reload);

        sa0.setOnSeekBarChangeListener(new MyProcessListener(ea0));

        ea0.addTextChangedListener(new MyTextWatcher(ea0, 1024));

        buttona0.setOnClickListener(new MyOnSetButtonClicked());
        buttona1.setOnClickListener(new MyOnReloadButtonClicked());
    }


    //
    private final static String KEY_SMS = "mykey";
    private final static String FILE_NAME = "myFile";
    SharedPreferences sPrefs;
    private SharedPreferences.Editor mSettinsEd=null;//使用SharedPreferences.Editor来存储数据

    private void InitViewb(View v){
        sw_fl = (Switch)v.findViewById(R.id.switch_fl);
        sw_sms = (Switch)v.findViewById(R.id.switch_sms);
        sw_pm = (Switch)v.findViewById(R.id.switch_pm);
        sw_batt = (Switch)v.findViewById(R.id.switch_batt);
        sw_dis = (Switch)v.findViewById(R.id.switch_dis);
        sw_gas = (Switch)v.findViewById(R.id.switch_gas);
        sw_temp = (Switch)v.findViewById(R.id.switch_temp);
        sw_vib = (Switch)v.findViewById(R.id.switch_vib);

        tv_custom = (TextView)v.findViewById(R.id.text_custom);
        tv_custom.setOnClickListener(new OnDevlinkListener());

        tv_about = (TextView)v.findViewById(R.id.text_about);
        tv_about.setOnClickListener(new MyOnAboutClicked());

        edit_sms = (EditText)v.findViewById(R.id.edit_number);

        //SharedPreferences sPrefs = getSharedPreferences(FILE_NAME, Context.MODE_APPEND);
        sPrefs = getPreferences(Activity.MODE_PRIVATE);
        mSettinsEd = sPrefs.edit();
        //SharedPreferences sPrefs =PreferenceManager.getDefaultSharedPreferences(context);
        String s_sms = sPrefs.getString(KEY_SMS,"9999");
        Log.d("sharedpreference","read s_sms="+s_sms);
        edit_sms.setText(s_sms);
        //sPrefs.edit().putInt(SCREEN_COUNT, count).commit();
    }

    private void  InitViewc(View v){
        webview = (WebView)v.findViewById(R.id.wv_about);
    }
    public class MyTextWatcher implements TextWatcher {
        private EditText mEdit;
        private int mMax;
        int value;

        public MyTextWatcher(EditText mEdit, int max) {
            this.mEdit = mEdit;
            mMax = max;
        }

        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {

        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {

        }

        @Override
        public void afterTextChanged(Editable s) {
            if (mEdit.getText().toString().equals("")) {
                value = 0;
            } else {
                value = Integer.parseInt(mEdit.getText().toString());
            }
            if (value > mMax) {
                value = mMax;
            }

        }
    }

    public class MyProcessListener implements SeekBar.OnSeekBarChangeListener {

        private EditText mEdit;

        public MyProcessListener(EditText e) {
            mEdit = e;
        }

        @Override
        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            mEdit.setText(String.valueOf(progress));
        }

        @Override
        public void onStartTrackingTouch(SeekBar seekBar) {

        }

        @Override
        public void onStopTrackingTouch(SeekBar seekBar) {

        }
    }

    public class MyOnSetButtonClicked implements View.OnClickListener {

        @Override
        public void onClick(View v) {

            int tmpvalue;
            byte[] senddat;
            String sends;
            switch (currIndex) {
                case 0:
                    break;
                case 1:
                    Log.d("####", "SET1");
                    senddat = new byte[7];
                    senddat[0] = '@';
                    senddat[1] = 'm';
                    senddat[2] = 'z';
                    senddat[3] = '4';
                    senddat[4] = '0';
                    senddat[5] = (byte) (cbox10.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '3';
                    senddat[5] = (byte) (cbox11.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '4';
                    senddat[5] = (byte) (cbox12.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '5';
                    senddat[5] = (byte) (cbox13.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '6';
                    senddat[5] = (byte) (cbox14.isChecked() ? '1' : '0');//gas
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '7';
                    senddat[5] = (byte) (cbox1a.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '8';
                    senddat[5] = (byte) (cbox1b.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);

                    senddat[2] = 'l';
                    senddat[3] = '4';
                    senddat[4] = '0';
                    senddat[5] = (byte) (cbox15.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '3';
                    senddat[5] = (byte) (cbox16.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '4';
                    senddat[5] = (byte) (cbox17.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '5';
                    senddat[5] = (byte) (cbox18.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '6';//gas
                    senddat[5] = (byte) (cbox19.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);;
                    senddat[4] = '7';
                    senddat[5] = (byte) (cbox1c.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);
                    senddat[4] = '8';
                    senddat[5] = (byte) (cbox1d.isChecked() ? '1' : '0');
                    senddat[6] = '\r';
                    mbtService.write(senddat);

                    break;
                case 2:
                    Log.d("####", "SET2");

                    if (e21.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e21.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e21.getText().toString());
                    }
                    //Log.d("####",e21.getText().toString());
                    s21.setProgress(tmpvalue);
                    sends = "@mb11";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e20.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e20.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e20.getText().toString());
                    }
                    s20.setProgress(tmpvalue);
                    sends = "@mb12";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    break;
                case 3:
                    Log.d("####", "SET3");

                    if (e30.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e30.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e30.getText().toString());
                    }
                    //Log.d("####",e21.getText().toString());
                    s30.setProgress(tmpvalue);
                    sends = "@mz11";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    //senddat[4] = '2';
                    sends = "@mz12";
                    if (e31.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e31.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e31.getText().toString());
                    }
                    s31.setProgress(tmpvalue);
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    sends = "@mz13";
                    if (e32.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e32.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e32.getText().toString());
                    }
                    s32.setProgress(tmpvalue);
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    //senddat[4] = '4';
                    if (e33.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e33.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e33.getText().toString());
                    }
                    s33.setProgress(tmpvalue);
                    sends = "@mz14";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    //senddat[4] = '5';
                    if (e34.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e34.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e34.getText().toString());
                    }
                    s34.setProgress(tmpvalue);
                    sends = "@mz15";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    //senddat[4] = '6';
                    if (e35.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e35.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e35.getText().toString());
                    }
                    s35.setProgress(tmpvalue);
                    sends = "@mz16";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    //senddat[4] = '7';
                    if (e36.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e36.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e36.getText().toString());
                    }
                    s36.setProgress(tmpvalue);
                    sends = "@mz17";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    tmpvalue = Integer.parseInt(tb30.getText().toString());

                    //sends = "@mz31";//slmeng
                    sends = "@mz31";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);
                    Log.d("###", sends);
                    tmpvalue = Integer.parseInt(tb31.getText().toString());
                    sends = "@mz32";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);
                    Log.d("###", sends);

                    break;
                case 4://led
                    if (e40.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e40.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e40.getText().toString());
                    }
                    //Log.d("####",e21.getText().toString());
                    s40.setProgress(tmpvalue);
                    sends = "@ml11";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e41.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e41.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e41.getText().toString());
                    }
                    s41.setProgress(tmpvalue);
                    sends = "@ml12";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e42.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e42.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e42.getText().toString());
                    }
                    s42.setProgress(tmpvalue);
                    sends = "@ml13";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e43.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e43.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e43.getText().toString());
                    }
                    s43.setProgress(tmpvalue);
                    sends = "@ml14";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    //senddat[4] = '5';
                    if (e44.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e44.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e44.getText().toString());
                    }
                    s44.setProgress(tmpvalue);
                    sends = "@ml15";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    //senddat[4] = '6';
                    if (e45.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e45.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e45.getText().toString());
                    }
                    s45.setProgress(tmpvalue);
                    sends = "@ml16";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    //senddat[4] = '7';
                    if (e46.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e46.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e46.getText().toString());
                    }
                    s46.setProgress(tmpvalue);
                    sends = "@ml17";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    tmpvalue = Integer.parseInt(tb40.getText().toString());
                    sends = "@ml31";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    tmpvalue = Integer.parseInt(tb41.getText().toString());
                    sends = "@ml32";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);
                    break;
                case 5://ahrs
                    Log.d("####", "SET5");

                    if (e50.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e50.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e50.getText().toString());
                    }
                    //Log.d("####",e21.getText().toString());
                    s50.setProgress(tmpvalue);
                    sends = "@ma11";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e51.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e51.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e51.getText().toString());
                    }
                    s51.setProgress(tmpvalue);
                    sends = "@ma12";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);
                    break;
                case 6://sonar
                    Log.d("####", "SET6");

                    if (e60.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e60.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e60.getText().toString());
                    }
                    //Log.d("####",e21.getText().toString());
                    s60.setProgress(tmpvalue);
                    sends = "@ms11";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e61.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e61.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e61.getText().toString());
                    }
                    s61.setProgress(tmpvalue);
                    sends = "@ms12";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);
                    break;
                case 7://temp.
                    Log.d("####", "SET7");

                    if (e70.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e70.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e70.getText().toString());
                    }
                    //Log.d("####",e21.getText().toString());
                    s70.setProgress(tmpvalue);
                    sends = "@mt11";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e71.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e71.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e71.getText().toString());
                    }
                    s71.setProgress(tmpvalue);
                    sends = "@mt12";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e72.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e72.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e72.getText().toString());
                    }
                    s72.setProgress(tmpvalue);
                    sends = "@mt13";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);
                    break;
                case 8://gas
                    Log.d("####", "SET8");

                    if (e80.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e80.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e80.getText().toString());
                    }
                    //Log.d("####",e21.getText().toString());
                    s80.setProgress(tmpvalue);
                    sends = "@mg11";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e81.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e81.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e81.getText().toString());
                    }
                    s81.setProgress(tmpvalue);
                    sends = "@mg12";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);
                    break;
                case 9://ir
                    Log.d("####", "SET9");

                    if (e90.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e90.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e90.getText().toString());
                    }
                    //Log.d("####",e21.getText().toString());
                    s90.setProgress(tmpvalue);
                    sends = "@mi11";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e91.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e91.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e91.getText().toString());
                    }
                    s91.setProgress(tmpvalue);
                    sends = "@mi12";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e92.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e92.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e92.getText().toString());
                    }
                    s92.setProgress(tmpvalue);
                    sends = "@mi13";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e93.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e93.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e93.getText().toString());
                    }
                    s93.setProgress(tmpvalue);
                    sends = "@mi14";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    if (e94.getText().toString().equals("")) {
                        tmpvalue = 0;
                        e94.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(e94.getText().toString());
                    }
                    s94.setProgress(tmpvalue);
                    sends = "@mi15";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    tmpvalue = Integer.parseInt(tb90.getText().toString());
                    sends = "@mi31";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    tmpvalue = Integer.parseInt(tb91.getText().toString());
                    sends = "@mi32";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);
                    break;
                case 10://key
                    Log.d("####", "SET10");

                    if (ea0.getText().toString().equals("")) {
                        tmpvalue = 0;
                        ea0.setText(String.valueOf(tmpvalue));
                    } else {
                        tmpvalue = Integer.parseInt(ea0.getText().toString());
                    }
                    //Log.d("####",e21.getText().toString());
                    sa0.setProgress(tmpvalue);
                    sends = "@mk11";
                    sends += String.valueOf(tmpvalue);
                    sends += '\r';
                    senddat = sends.getBytes();
                    mbtService.write(senddat);

                    break;

            }
        }
    }

    /*
        public class MyOnSetButtonClicked implements View.OnClickListener{

            @Override
            public void onClick(View v) {

                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        int tmpvalue;
                        byte[] senddat;
                        switch (currIndex){
                            case 0:
                                break;
                            case 1:
                                break;
                            case 2:
                                Log.d("####","SET2");
                                senddat = new byte[8];
                                senddat[0] = '@';
                                senddat[1] = 'm';
                                senddat[2] = 'b';
                                senddat[3] = '1';
                                senddat[4] = '1';
                                if(e21.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e21.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e21.getText().toString());
                                }
                                //Log.d("####",e21.getText().toString());
                                s21.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xf);
                                senddat[6] = (byte)((tmpvalue>>4)&0xf);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                senddat[4] = '2';
                                if(e20.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e20.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e20.getText().toString());
                                }
                                s20.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xf);
                                senddat[6] = (byte)((tmpvalue>>4)&0xf);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                break;
                            case 3:
                                Log.d("####","SET3");
                                senddat = new byte[8];
                                senddat[0] = '@';
                                senddat[1] = 'm';
                                senddat[2] = 'z';
                                senddat[3] = '1';
                                senddat[4] = '1';
                                if(e30.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e30.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e30.getText().toString());
                                }
                                //Log.d("####",e21.getText().toString());
                                s30.setProgress(tmpvalue);

                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                Log.d("###","senddata:"+Integer.toHexString(senddat[5])+":"+Integer.toHexString(senddat[6]) + ":" + Integer.toHexString(senddat[7]));
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }

                                senddat[4] = '2';
                                if(e31.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e31.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e31.getText().toString());
                                }
                                s31.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }

                                senddat[4] = '3';
                                if(e32.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e32.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e32.getText().toString());
                                }
                                s32.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }

                                senddat[4] = '4';
                                if(e33.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e33.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e33.getText().toString());
                                }
                                s33.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }

                                senddat[4] = '5';
                                if(e34.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e34.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e34.getText().toString());
                                }
                                s34.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }

                                senddat[4] = '6';
                                if(e35.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e35.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e35.getText().toString());
                                }
                                s35.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }

                                senddat[4] = '7';
                                if(e36.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e36.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e36.getText().toString());
                                }
                                s36.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }

                                senddat[3] = '3';
                                senddat[4] = '1';
                                tmpvalue = Integer.parseInt(tb30.getText().toString());
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                senddat[4] = '2';
                                tmpvalue = Integer.parseInt(tb31.getText().toString());
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                try {
                                    Thread.sleep(100);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }

                                break;
                            case 4:
                                senddat = new byte[8];
                                senddat[0] = '@';
                                senddat[1] = 'm';
                                senddat[2] = 'z';
                                senddat[3] = '1';
                                senddat[4] = '1';
                                if(e40.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e40.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e40.getText().toString());
                                }
                                //Log.d("####",e21.getText().toString());
                                s40.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);

                                senddat[4] = '2';
                                if(e41.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e41.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e31.getText().toString());
                                }
                                s41.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);

                                senddat[4] = '3';
                                if(e42.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e42.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e42.getText().toString());
                                }
                                s42.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);

                                senddat[4] = '4';
                                if(e43.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e43.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e43.getText().toString());
                                }
                                s43.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);

                                senddat[4] = '5';
                                if(e44.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e44.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e44.getText().toString());
                                }
                                s44.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);

                                senddat[4] = '6';
                                if(e45.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e45.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e45.getText().toString());
                                }
                                s45.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);

                                senddat[4] = '7';
                                if(e46.getText().toString().equals("")){
                                    tmpvalue = 0;
                                    e46.setText(tmpvalue);
                                }else {
                                    tmpvalue = Integer.parseInt(e46.getText().toString());
                                }
                                s46.setProgress(tmpvalue);
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);

                                senddat[3] = '3';
                                senddat[4] = '1';
                                tmpvalue = Integer.parseInt(tb40.getText().toString());
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                senddat[4] = '2';
                                tmpvalue = Integer.parseInt(tb41.getText().toString());
                                senddat[5] = (byte)(tmpvalue&0xff);
                                senddat[6] = (byte)((tmpvalue>>8)&0xff);
                                senddat[7] = '\r';
                                mbtService.write(senddat);
                                break;

                        }
                    }
                }).start();

            }
        }
        */
    public class MyOnReloadButtonClicked implements View.OnClickListener {

        @Override
        public void onClick(View v) {
            byte[] dat;
            Log.d("####", "RELOAD");
            dat = new byte[3];
            dat[0] = '@';
            dat[1] = 's';
            dat[2] = 'p';
            mbtService.write(dat);
            mbtService.clear();
            mbtService.setReceiveType(currIndex);
            updataflag = true;
            updatecount = 2;

            switch (currIndex) {
                case 0:
                    break;
                case 1:
                    //Log.d("####", "RELOAD1");
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 'd';
                    mbtService.write(dat);
                    mbtService.clear();
                    break;
                case 2:
                    //mbtService.setReceiveType(2);
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 'b';
                    mbtService.write(dat);
                    mbtService.clear();
                    break;
                case 3:
                    //mbtService.setReceiveType(3);
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 'z';
                    mbtService.write(dat);
                    mbtService.clear();
                    break;
                case 4:
                    //mbtService.setReceiveType(4);
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 'l';
                    mbtService.write(dat);
                    mbtService.clear();
                    break;
                case 5:
                    //mbtService.setReceiveType(5);
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 'a';
                    mbtService.write(dat);
                    mbtService.clear();
                    break;
                case 6:
                    //mbtService.setReceiveType(3);
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 's';
                    mbtService.write(dat);
                    mbtService.clear();
                    break;
                case 7:
                    //mbtService.setReceiveType(3);
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 't';
                    mbtService.write(dat);
                    mbtService.clear();
                    break;
                case 8:
                    //mbtService.setReceiveType(3);
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 'g';
                    mbtService.write(dat);
                    mbtService.clear();
                    break;
                case 9:
                    //mbtService.setReceiveType(3);
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 'i';
                    mbtService.write(dat);
                    mbtService.clear();
                    break;
                case 10:
                    //mbtService.setReceiveType(3);
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 'k';
                    mbtService.write(dat);
                    mbtService.clear();
                    break;

            }
            dat[0] = '@';
            dat[1] = 's';
            dat[2] = 's';
            mbtService.write(dat);
        }
    }
    /*
     * ��ʼ��ViewPager
     */

    public void InitViewPager(){
        mPager = (CustomViewPager)findViewById(R.id.viewpager);

        listViews = new ArrayList<View>();
        LayoutInflater mInflater = getLayoutInflater();
        View tab0 = mInflater.inflate(R.layout.f1, null);
        listViews.add(tab0);
        InitImageView0(tab0);
        InitProcessBar0(tab0);
        View tab1 = mInflater.inflate(R.layout.f2, null);
        listViews.add(tab1);
        InitImageView1(tab1);
        InitButton1(tab1);
        View tab2 = mInflater.inflate(R.layout.battery, null);
        listViews.add(tab2);
        InitView2(tab2);

        View tab3 = mInflater.inflate(R.layout.buzzer, null);
        listViews.add(tab3);
        InitView3(tab3);

        View tab4 = mInflater.inflate(R.layout.led, null);
        listViews.add(tab4);
        InitView4(tab4);

        View tab5 = mInflater.inflate(R.layout.ahrs, null);
        listViews.add(tab5);
        InitView5(tab5);

        View tab6 = mInflater.inflate(R.layout.sonar, null);
        listViews.add(tab6);
        InitView6(tab6);

        View tab7 = mInflater.inflate(R.layout.temperature, null);
        listViews.add(tab7);
        InitView7(tab7);

        View tab8 = mInflater.inflate(R.layout.gas, null);
        listViews.add(tab8);
        InitView8(tab8);

        View tab9 = mInflater.inflate(R.layout.ir, null);
        listViews.add(tab9);
        InitView9(tab9);

        View taba = mInflater.inflate(R.layout.key, null);
        listViews.add(taba);
        InitViewa(taba);

        //settings
        View tabb = mInflater.inflate(R.layout.settings, null);
        listViews.add(tabb);
        InitViewb(tabb);

        //about
        View tabc = mInflater.inflate(R.layout.about, null);
        listViews.add(tabc);
        InitViewc(tabc);

        titleList = new ArrayList<String>();// ÿ��ҳ���Title����
        titleList.add("INDEX");
        titleList.add("DEVLINK");
        titleList.add("BATTERY");
        titleList.add("BUZZER");
        titleList.add("LED");
        titleList.add("AHRS");
        titleList.add("SONAR");
        titleList.add("TEMP.");
        titleList.add("GAS");
        titleList.add("IR");
        titleList.add("KEY");
        titleList.add("Settings");

        titleLightList = new ArrayList<>();
        /*
        titleLightList.add(R.mipmap.index1);
        titleLightList.add(R.mipmap.devicelink1);
        titleLightList.add(R.mipmap.battery1);
        titleLightList.add(R.mipmap.buzzer1);
        titleLightList.add(R.mipmap.led1);
        titleLightList.add(R.mipmap.ahrs1);
        titleLightList.add(R.mipmap.sonar1);
        titleLightList.add(R.mipmap.temperature1);
        titleLightList.add(R.mipmap.gas1);
        titleLightList.add(R.mipmap.ir1);
        titleLightList.add(R.mipmap.key1);
        */
        titleDarkList = new ArrayList<>();
        /*
        titleDarkList.add(R.mipmap.index0);
        titleDarkList.add(R.mipmap.devicelink0);
        titleDarkList.add(R.mipmap.battery0);
        titleDarkList.add(R.mipmap.buzzer0);
        titleDarkList.add(R.mipmap.led0);
        titleDarkList.add(R.mipmap.ahrs0);
        titleDarkList.add(R.mipmap.sonar0);
        titleDarkList.add(R.mipmap.temperature0);
        titleDarkList.add(R.mipmap.gas0);
        titleDarkList.add(R.mipmap.ir0);
        titleDarkList.add(R.mipmap.key0);
        */

        mPager.setScanScroll(false);
        mPager.setAdapter(new MyPagerAdapter(listViews, titleList,titleLightList, titleDarkList));
        mPager.setCurrentItem(0);
        mPager.setOnPageChangeListener(new MyOnPageChangeListener());

        //mSlidingTabLayout = (SlidingTabLayout) findViewById(R.id.sliding_tabs);
        //mSlidingTabLayout.setCustomTabView(R.layout.titletextview,R.id.tabtitle);
       // mSlidingTabLayout.setViewPager(mPager);
       // mSlidingTabLayout.setOnPageChangeListener(new MyOnPageChangeListener());

    }

    private int  lastIndex=0;
    public class MyOnPageChangeListener implements ViewPager.OnPageChangeListener {


        @Override
        public void onPageScrolled(int position, float positionOffset,
                                   int positionOffsetPixels) {
            // TODO Auto-generated method stub
            //Log.d("#####", "postion:" + String.valueOf(position) + "offset:" + String.valueOf(positionOffset));
        }

        @Override
        public void onPageScrollStateChanged(int arg0) {
            // TODO Auto-generated method stub

        }

        @Override
        public void onPageSelected(int arg0) {
            // TODO Auto-generated method stub
            //byte[] recv=new byte[256];
            byte[] dat= new byte[3];

            currIndex = arg0;
            setTitle1(currIndex);
            dat[0]='@';
            dat[1]='s';
            dat[2]='p';
            mbtService.write(dat);
            mbtService.clear();
            updataflag=true;
            updatecount=0;
            switch ( currIndex){
                case 0:
                    //mbtService.stop();
                    //mbtService.connect(device);
                    //byte[] dat= new byte[3];
                    mbtService.setReceiveType(0);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='x';
                    mbtService.write(dat);
                    mbtService.clear();

                    break;
                case 1://devlink
                    showwaitdialog(true);
                    mbtService.setReceiveType(1);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='d';
                    mbtService.write(dat);
                    mbtService.clear();
                    /*
                    Uri notification = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
                    Ringtone r = RingtoneManager.getRingtone(getApplicationContext(), notification);
                    Vibrator vibrator = (Vibrator)getSystemService(Context.VIBRATOR_SERVICE);

                    //vibrator.vibrate(new long[]{300, 500}, 0);
                    vibrator.vibrate(1000);
                    r.play();
                    */
                    break;
                case 2:
                    mbtService.setReceiveType(2);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='b';
                    mbtService.write(dat);
                    break;
                case 3:
                    mbtService.setReceiveType(3);
                    dat[0] = '@';
                    dat[1] = 't';
                    dat[2] = 'z';
                    mbtService.write(dat);
                    break;
                case 4:
                    mbtService.setReceiveType(4);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='l';
                    mbtService.write(dat);
                    break;
                case 5:
                    mbtService.setReceiveType(5);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='a';
                    mbtService.write(dat);
                    break;
                case 6://sonar
                    mbtService.setReceiveType(6);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='s';
                    mbtService.write(dat);
                    break;
                case 7://temp.
                    mbtService.setReceiveType(7);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='t';
                    mbtService.write(dat);
                    break;
                case 8://gas
                    mbtService.setReceiveType(8);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='g';
                    mbtService.write(dat);
                    break;
                case 9:
                    mbtService.setReceiveType(9);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='i';
                    mbtService.write(dat);
                    break;
                case 10:
                    mbtService.setReceiveType(10);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='k';
                    mbtService.write(dat);
                    break;
                case 11://settings
                    showwaitdialog(true);
                    mbtService.setReceiveType(1);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='d';
                    mbtService.write(dat);
                    mbtService.clear();
            }
            dat[0]='@';
            dat[1]='s';
            dat[2]='s';
            mbtService.write(dat);

            if(lastIndex==11&&currIndex!=11){//change page from settingpage to others
                fl_alarm = sw_fl.isChecked();
                pm_alarm = sw_pm.isChecked();
                sms_alarm = sw_sms.isChecked();

                boolean b = sw_batt.isChecked();
                boolean d = sw_dis.isChecked();
                boolean g = sw_gas.isChecked();
                boolean t = sw_temp.isChecked();
                boolean v = sw_vib.isChecked();


                byte[] senddat;
                senddat = new byte[7];

                senddat[0] = '@';
                senddat[1] = 'm';
                //buzzer
                senddat[2] = 'z';
                senddat[3] = '4';
                senddat[4] = '0';
                senddat[5] = (byte) (b ? '1' : '0');
                senddat[6] = '\r';
                mbtService.write(senddat);

                senddat[4] = '4';
                senddat[5] = (byte) (d ? '1' : '0');
                senddat[6] = '\r';
                mbtService.write(senddat);

                senddat[4] = '6';
                senddat[5] = (byte) (g ? '1' : '0');//gas
                senddat[6] = '\r';
                mbtService.write(senddat);

                senddat[4] = '5';
                senddat[5] = (byte) (t ? '1' : '0');//tempreture&humidity
                senddat[6] = '\r';
                mbtService.write(senddat);

                senddat[4] = '3';
                senddat[5] = (byte) (v ? '1' : '0');//vibration
                senddat[6] = '\r';
                mbtService.write(senddat);
                //led
                senddat[2] = 'l';
                senddat[3] = '4';
                senddat[4] = '0';
                senddat[5] = (byte) (b ? '1' : '0');
                senddat[6] = '\r';
                mbtService.write(senddat);
                senddat[4] = '4';
                senddat[5] = (byte) (d ? '1' : '0');
                senddat[6] = '\r';
                mbtService.write(senddat);
                senddat[4] = '6';
                senddat[5] = (byte) (g ? '1' : '0');//gas
                senddat[6] = '\r';
                mbtService.write(senddat);
                senddat[4] = '5';
                senddat[5] = (byte) (t ? '1' : '0');//tempreture&humidity
                senddat[6] = '\r';
                mbtService.write(senddat);
                senddat[4] = '3';
                senddat[5] = (byte) (v ? '1' : '0');//vibration
                senddat[6] = '\r';
                mbtService.write(senddat);

                //SharedPreferences sPrefs = getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
                sPrefs = getPreferences(Activity.MODE_PRIVATE);
                //SharedPreferences sPrefs =PreferenceManager.getDefaultSharedPreferences(context);
                String s_sms = edit_sms.getText().toString();
                Log.d("sharedpreference","s_sms="+s_sms);
                mSettinsEd.putString(KEY_SMS,s_sms);
                //sPrefs.edit().apply();
                mSettinsEd.commit();

            }else if(currIndex==11){

            }
            if(currIndex==12){
                //webview.loadUrl("file:///android_asset/about.html");
                webview.loadUrl("file:///android_asset/about.html");
            }
            lastIndex = currIndex;
        }

    }
    private class INDEX_REPORT {
        int indRepLen;                  //Index report length
        int devNum;                     //device prepared to ne used
        int devSta;                     //device connected state
        int indDatLen;                  //Index received data length
    };
    INDEX_REPORT indexRep = new INDEX_REPORT();

    public class DEVLINK_REPORT {
        int repLen;                  //Index report length
        int devNum;                     //device prepared to ne used
        int devSta;                     //device connected state
        int datLen;                  //Index received data length
    };
    DEVLINK_REPORT devLinkRep = new DEVLINK_REPORT();

    private boolean phonealarmflag=false;
    private boolean updataflag = true;
    private int updatecount=0;
    private void showdata(byte[] databuf,int numOFBytesReceived)
    {
        Log.d("###","Len:"+String.valueOf(numOFBytesReceived));
        //Log.d("###","databuf:"+String.valueOf(databuf[0] | databuf[1] << 8));
        int count=0;
        byte[] dat= new byte[3];
        switch( currIndex){
            case 0:
                    if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                    {
                        //mbtService.setReceiveType(0);

                        dat[0]='@';
                        dat[1]='t';
                        dat[2]='x';
                        mbtService.write(dat);
                        dat[0]='@';
                        dat[1]='s';
                        dat[2]='s';
                        mbtService.write(dat);
                        return;

                    }
                    if(numOFBytesReceived==8) {
                        indexRep.indRepLen = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        indexRep.devNum = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        indexRep.devSta = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        indexRep.indDatLen = ((databuf[count++]&0xff)|(databuf[count]&0xff)<<8);
                        Log.d("READ", "indexRep.indRepLen" + String.valueOf(indexRep.indRepLen));
                        Log.d("READ", "indexRep.indDatLen" + String.valueOf(indexRep.indDatLen));
                        if ((indexRep.devSta & 0x1) != 0) {
                            image00.setBackgroundResource(R.mipmap.batteryf1);
                            Itemenableflag[0]=1;
                        } else {
                            image00.setBackgroundResource(R.mipmap.batteryf0);
                            Itemenableflag[0]=0;
                        }
                        if ((indexRep.devSta >> 1 & 0x1) != 0) {
                            Itemenableflag[1]=1;
                            image01.setBackgroundResource(R.mipmap.buzzerf1);
                        } else {
                            image01.setBackgroundResource(R.mipmap.buzzerf0);
                            Itemenableflag[1]=0;
                        }
                        if ((indexRep.devSta >> 2 & 0x1) != 0) {
                            image02.setBackgroundResource(R.mipmap.ledf1);
                            Itemenableflag[2]=1;
                        } else {
                            image02.setBackgroundResource(R.mipmap.ledf0);
                            Itemenableflag[2]=0;
                        }
                        if ((indexRep.devSta >> 3 & 0x1) != 0) {
                            image03.setBackgroundResource(R.mipmap.ahrsf1);
                            Itemenableflag[3]=1;
                        } else {
                            image03.setBackgroundResource(R.mipmap.ahrsf0);
                            Itemenableflag[3]=0;
                        }
                        if ((indexRep.devSta >> 4 & 0x1) != 0) {
                            image04.setBackgroundResource(R.mipmap.sonarf1);
                            Itemenableflag[4]=1;
                        } else {
                            image04.setBackgroundResource(R.mipmap.sonarf0);
                            Itemenableflag[4]=0;
                        }
                        if ((indexRep.devSta >> 5 & 0x1) != 0) {
                            image05.setBackgroundResource(R.mipmap.temperaturef1);
                            Itemenableflag[5]=1;
                        } else {
                            image05.setBackgroundResource(R.mipmap.temperaturef0);
                            Itemenableflag[5]=0;
                        }
                        if ((indexRep.devSta >> 6 & 0x1) != 0) {
                            image06.setBackgroundResource(R.mipmap.gasf1);
                            Itemenableflag[6]=1;
                        } else {
                            image06.setBackgroundResource(R.mipmap.gasf0);
                            Itemenableflag[6]=0;
                        }
                        if ((indexRep.devSta >> 7 & 0x1) != 0) {
                            image07.setBackgroundResource(R.mipmap.irf1);
                            Itemenableflag[7]=1;
                        } else {
                            image07.setBackgroundResource(R.mipmap.irf0);
                            Itemenableflag[7]=0;
                        }
                        if ((indexRep.devSta >> 8 & 0x1) != 0) {
                            image08.setBackgroundResource(R.mipmap.keyf1);
                            Itemenableflag[8]=1;
                        } else {
                            image08.setBackgroundResource(R.mipmap.keyf0);
                            Itemenableflag[8]=0;
                        }
                        for(int i=0;i<9;i++) {
                            HashMap<String, Object>map=listItem.get(i);
                            if( Itemenableflag[i]==1) {
                                map.put("ItemImage", DarkList.get(i));
                            }else{
                                map.put("ItemImage", DisableList.get(i));
                            }
                            listItem.set(i, map);
                            mSimpleAdapter.notifyDataSetChanged();

                        }
                    }else if(indexRep.indDatLen>0&&numOFBytesReceived==indexRep.indDatLen&&
                            ((databuf[0]&0xff)|(databuf[1]&0xff)<<8)==indexRep.indDatLen) {
                        count += 2;
                        //Log.d("READ", "p00" + String.valueOf((databuf[count+1]&0xff)|(databuf[count+2]&0xff)<<8));
                        int batt = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        int batta = (((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8));
                        int buzzer = (((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8));
                        int led = (((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8));
                        int vib =(((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8));
                        int viba =(((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8));
                        int dist =(((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8));
                        int dista =(((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8));
                        int temp = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        int humi = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        int tempa = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        int humia = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        int gas = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        int gasa = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        int ir = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        int  key = ((databuf[count++]&0xff)|(databuf[count]&0xff)<<8);

                        /*
                        String phoneNumber="13585896240";
                        String message = "Temp voer flag!";
                        oe.sendSMS(phoneNumber, message);
                        */
                        if(phonealarmflag==false&&(batta==1||viba==1||dista==1||tempa==1||humia==1||gasa==1)){
                            phonealarmflag=true;
                            if(fl_alarm){
                                openflash();
                            }
                            if(pm_alarm){
                                playmusic();
                            }
                            if(sms_alarm){
                                String message="Alarms battery :"+String.valueOf(batta)
                                                +" vibration :"+ String.valueOf(viba)
                                                +" distance :"+String.valueOf(dista)
                                                +" temprature :"+String.valueOf(tempa)
                                                +" humidity :"+String.valueOf(humia)
                                                +" gas :"+ String.valueOf(gasa);


                                int ret = sendSMS(edit_sms.getText().toString(),message);
                            }
                            new Thread(new Runnable(){
                                     public void run(){
                                         try {
                                             Thread.sleep(10000);
                                         } catch (InterruptedException e) {
                                             e.printStackTrace();
                                         }
                                         phonealarmflag=false;
                                     }
                                 }).start();
                        }


                        p00.setProgress(batt);
                        p03.setProgress(batta);
                        p012.setProgress(buzzer);
                        p013.setProgress(led);
                        p01.setProgress(vib);
                        p04.setProgress(viba);
                        p08.setProgress(dist);
                        p011.setProgress(dista);
                        p02.setProgress(temp);
                        p07.setProgress(humi);
                        p05.setProgress(tempa);
                        p010.setProgress(humia);
                        p06.setProgress(gas);
                        p09.setProgress(gasa);
                        p014.setProgress(ir);
                        p015.setProgress(key);

                    }else{
                            mbtService.clear();
                            mbtService.setReceiveType(0);

                            dat[0]='@';
                            dat[1]='t';
                            dat[2]='x';
                            mbtService.write(dat);
                            dat[0]='@';
                            dat[1]='s';
                            dat[2]='s';
                            mbtService.write(dat);


                    }
                break;
            case 1:
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='p';

                    mbtService.write(dat);
					mbtService.clear();
                    //mbtService.setReceiveType(1);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='d';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;

                }
                if(numOFBytesReceived==8){
                    devLinkRep.repLen = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    devLinkRep.devNum = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    devLinkRep.devSta = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    devLinkRep.datLen = ((databuf[count++]&0xff)|(databuf[count]&0xff)<<8);
                    if (( devLinkRep.devSta & 0x1) != 0) {
                        image10.setBackgroundResource(R.mipmap.batteryf1);
                    } else {
                        image10.setBackgroundResource(R.mipmap.batteryf0);
                    }

                    if (( devLinkRep.devSta >> 1 & 0x1) != 0) {
                        image15.setBackgroundResource(R.mipmap.buzzerf1);
                    } else {
                        image15.setBackgroundResource(R.mipmap.buzzerf0);
                    }
                    if (( devLinkRep.devSta >> 2 & 0x1) != 0) {
                        image16.setBackgroundResource(R.mipmap.ledf1);
                    } else {
                        image16.setBackgroundResource(R.mipmap.ledf0);
                    }
                    if (( devLinkRep.devSta >> 3 & 0x1) != 0) {
                        image11.setBackgroundResource(R.mipmap.ahrsf1);
                    } else {
                        image11.setBackgroundResource(R.mipmap.ahrsf0);
                    }
                    if (( devLinkRep.devSta >> 4 & 0x1) != 0) {
                        image12.setBackgroundResource(R.mipmap.sonarf1);
                    } else {
                        image12.setBackgroundResource(R.mipmap.sonarf0);
                    }
                    if (( devLinkRep.devSta >> 5 & 0x1) != 0) {
                        image13.setBackgroundResource(R.mipmap.temperaturef1);
                    } else {
                        image13.setBackgroundResource(R.mipmap.temperaturef0);
                    }
                    if (( devLinkRep.devSta >> 6 & 0x1) != 0) {
                        image14.setBackgroundResource(R.mipmap.gasf1);
                    } else {
                        image14.setBackgroundResource(R.mipmap.gasf0);;
                    }
                    if (( devLinkRep.devSta >> 7 & 0x1) != 0) {
                        image17.setBackgroundResource(R.mipmap.irf1);
                    } else {
                        image17.setBackgroundResource(R.mipmap.irf0);
                    }
                    if (( devLinkRep.devSta >> 8 & 0x1) != 0) {
                        image18.setBackgroundResource(R.mipmap.keyf1);
                    } else {
                        image18.setBackgroundResource(R.mipmap.keyf0);
                    }
                }else if(devLinkRep.datLen>0&&numOFBytesReceived==devLinkRep.datLen&&
                        ((databuf[0]&0xff)|(databuf[1]&0xff)<<8)==devLinkRep.datLen){
                    count+=2;
                    buzzerlinkstate = (((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8));
                    ledlinkstate =(((databuf[count++]&0xff)|(databuf[count]&0xff)<<8));
                    cbox10.setChecked((buzzerlinkstate & 0x1) != 0);
                    cbox11.setChecked((buzzerlinkstate >> 3 & 0x1) != 0);
                    cbox12.setChecked((buzzerlinkstate >> 4 & 0x1) != 0);
                    cbox13.setChecked((buzzerlinkstate >> 5 & 0x1) != 0);
                    cbox14.setChecked((buzzerlinkstate >> 6 & 0x1) != 0);//gas
                    cbox1a.setChecked((buzzerlinkstate >> 7 & 0x1) != 0);
                    cbox1b.setChecked((buzzerlinkstate >> 8 & 0x1) != 0);


                    cbox15.setChecked((ledlinkstate & 0x1) != 0);
                    cbox16.setChecked((ledlinkstate >> 3 & 0x1) != 0);
                    cbox17.setChecked((ledlinkstate >> 4 & 0x1) != 0);
                    cbox18.setChecked((ledlinkstate >> 5 & 0x1) != 0);
                    cbox19.setChecked((ledlinkstate >> 6 & 0x1) != 0);//gas
                    cbox1c.setChecked((ledlinkstate >> 7 & 0x1) != 0);
                    cbox1d.setChecked((ledlinkstate >> 8 & 0x1) != 0);
                    showwaitdialog(false);
                }else{
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='p';
                    mbtService.write(dat);
					mbtService.clear();
                    mbtService.setReceiveType(1);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='d';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                    break;
            case 2:
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='p';
                    mbtService.write(dat);
                    //mbtService.setReceiveType(2);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='b';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;

                }
                if(numOFBytesReceived==26) {

                }else if(numOFBytesReceived==36){

                }else if(numOFBytesReceived==9&&(databuf[0]&0xff | databuf[1]&0xff << 8)==11){
                    //Log.d("READ BATTERY", "recvlen:" + String.valueOf((databuf[count++] | databuf[count++] << 8)));
                    count+=2;
                    if(updataflag) {
                        int overvalue = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        Log.d("READ BATTERY", "overvalue:" + String.valueOf(overvalue));
                        s21.setProgress(overvalue);
                        e21.setText(String.valueOf(overvalue));
                        int alarmvalue = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                        s20.setProgress(alarmvalue);
                        Log.d("READ BATTERY", "alarmvalue" + String.valueOf(alarmvalue));
                        e20.setText(String.valueOf(alarmvalue));
                        updataflag = false;
                    }else{
                        count+=4;
                    }
                    p20.setProgress(((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8));
                    //p21.setProgress(databuf[count]);
                    if(databuf[count]==1){
                        i20.setBackgroundResource(R.mipmap.overflag01);
                    }else{
                        i20.setBackgroundResource(R.mipmap.overflag00);
                    }
                }else{
                    Log.d("READ BATTERY", "recvlen:" + String.valueOf((databuf[0] | databuf[1] << 8)));
                    //Log.d("READ BATTERY", "recv1:" + String.valueOf((databuf[2] | databuf[3] << 8)));
                    //Log.d("READ BATTERY", "recv2:" + String.valueOf((databuf[4] | databuf[5] << 8)));
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='p';
                    mbtService.setReceiveType(2);
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='b';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                break;
            case 3:
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                    mbtService.clear();
                   // mbtService.setReceiveType(3);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='z';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;

                }
                if(numOFBytesReceived==26) {

                }else if(numOFBytesReceived==74){

                }else if(numOFBytesReceived==15&&(databuf[0] | databuf[1] << 8)==19){
                    count+=2;
                    int sleep = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int volume = (databuf[count++]);
                    int tone = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int song = (databuf[count++]);
                    int period = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int duty = (databuf[count++]);
                    int latency = (databuf[count++]);
                    int eflag = (databuf[count++]);
                    int stflag = (databuf[count++]);
                    int spflag = (databuf[count]);

                    //Log.d("READ BUZZER", "sleep:" + String.valueOf(sleep));
                   // Log.d("READ BUZZER", "volume:" + String.valueOf(volume));
                    //Log.d("READ BUZZER", "tone:" + String.valueOf(tone));
                   // Log.d("READ BUZZER", "start flag:" + String.valueOf(stflag));
                    //Log.d("READ BUZZER", "stop flag:" + String.valueOf(spflag));
                    if(updataflag) {
                        s30.setProgress(sleep);
                        e30.setText(String.valueOf(sleep));
                        s31.setProgress(volume);
                        e31.setText(String.valueOf(volume));
                        s32.setProgress(tone);
                        e32.setText(String.valueOf(tone));
                        s33.setProgress(song);
                        e33.setText(String.valueOf(song));
                        s34.setProgress(period);
                        e34.setText(String.valueOf(period));
                        s35.setProgress(duty);
                        e35.setText(String.valueOf(duty));
                        s36.setProgress(latency);
                        e36.setText(String.valueOf(latency));
                        tb30.setChecked(stflag == 1);
                        tb31.setChecked(spflag == 1);
                        if(updatecount++>2) {
                            updataflag = false;
                            updatecount=0;
                        }
                    }
                    //int lasteflag = p30.getProgress();
                    //p30.setProgress(eflag);
                    if(eflag==1){
                        i30.setBackgroundResource(R.mipmap.overflag01);
                    }else{
                        i30.setBackgroundResource(R.mipmap.overflag00);
                    }
                    /*vibrate del 20160418 */
                    /*
                    if(eflag!=0&lasteflag == 0) {
                        Uri notification = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
                        Ringtone r = RingtoneManager.getRingtone(getApplicationContext(), notification);
                        Vibrator vibrator = (Vibrator)getSystemService(Context.VIBRATOR_SERVICE);

                        vibrator.vibrate(new long[]{300,500},0);
                        r.play();
                    }
                    */

                }else{
                    mbtService.setReceiveType(3);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='z';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                break;
            case 4:
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                   // mbtService.setReceiveType(4);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='l';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;

                }
                if(numOFBytesReceived==26) {

                }else if(numOFBytesReceived==74){

                }else if(numOFBytesReceived==15&&(databuf[0] | databuf[1] << 8)==19){
                    count+=2;
                    int sleep = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int brightness = (databuf[count++]);
                    int color = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int blink= (databuf[count++]);
                    int period = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int duty = (databuf[count++]);
                    int latency = (databuf[count++]);
                    int eflag = (databuf[count++]);
                    int stflag = (databuf[count++]);
                    int spflag = (databuf[count]);

                   // Log.d("READ LED", "sleep:" + String.valueOf(sleep));
                   // Log.d("READ LED", "brightness:" + String.valueOf(brightness));
                   // Log.d("READ LED", "color:" + String.valueOf(color));
                   // Log.d("READ LED", "period:" + String.valueOf(period));
                    if(updataflag) {
                        s40.setProgress(sleep);
                        e40.setText(String.valueOf(sleep));
                        s41.setProgress(brightness);
                        e41.setText(String.valueOf(brightness));
                        s42.setProgress(color);
                        e42.setText(String.valueOf(color));
                        s43.setProgress(blink);
                        e43.setText(String.valueOf(blink));
                        s44.setProgress(period);
                        e44.setText(String.valueOf(period));
                        s45.setProgress(duty);
                        e45.setText(String.valueOf(duty));
                        s46.setProgress(latency);
                        e46.setText(String.valueOf(latency));
                        tb40.setChecked(stflag == 1);
                        tb41.setChecked(spflag == 1);
                        if(updatecount++>2) {
                            updataflag = false;
                            updatecount=0;
                        }
                        //updataflag=false;
                    }
                    //p40.setProgress(eflag);
                    if(eflag==1){
                        i40.setBackgroundResource(R.mipmap.overflag01);
                    }else{
                        i40.setBackgroundResource(R.mipmap.overflag00);
                    }
                }else{
                    mbtService.setReceiveType(4);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='l';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                break;
            case 5://AHRS
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                   // mbtService.setReceiveType(5);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='a';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;

                }
                if(numOFBytesReceived==26) {

                }else if(numOFBytesReceived==34){

                }else if(numOFBytesReceived==8&&(databuf[0] | databuf[1] << 8)==10){
                    //&&(databuf[count++]|databuf[count++]<<8)==9){
                    //Log.d("READ BATTERY", "recvlen:" + String.valueOf((databuf[count++] | databuf[count++] << 8)));
                    count+=2;
                    int speriod = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int vlevel = databuf[count++];
                    int vvalue = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int overfalg = databuf[count];
                    //Log.d("READ BATTERY", "overvalue:" + String.valueOf(speriod));
                    Log.d("READ AHRS", "alarmvalue" + String.valueOf(vlevel));
                    if(updataflag) {
                        s50.setProgress(speriod);
                        e50.setText(String.valueOf(speriod));
                        s51.setProgress(vlevel);
                        e51.setText(String.valueOf(vlevel));
                        updataflag=false;
                    }
                    p50.setProgress(vvalue);
                    //p51.setProgress(overfalg);
                    if(overfalg==1){
                        i50.setBackgroundResource(R.mipmap.overflag01);
                    }else{
                        i50.setBackgroundResource(R.mipmap.overflag00);
                    }
                }else{
                    mbtService.setReceiveType(5);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='a';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                break;
            case 6://SONAR
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                   // mbtService.setReceiveType(6);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='s';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;
                }
                if(numOFBytesReceived==26) {

                }else if(numOFBytesReceived==36){

                }else if(numOFBytesReceived==9&&(databuf[0] | databuf[1] << 8)==11){
                    //&&(databuf[count++]|databuf[count++]<<8)==9){
                    //Log.d("READ BATTERY", "recvlen:" + String.valueOf((databuf[count++] | databuf[count++] << 8)));
                    count+=2;
                    int speriod = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int adistance = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int svalue = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int overfalg = databuf[count];
                    //Log.d("READ BATTERY", "overvalue:" + String.valueOf(speriod));
                    Log.d("READ BATTERY", "adistance" + String.valueOf(adistance));
                    if(updataflag) {
                        s60.setProgress(speriod);
                        e60.setText(String.valueOf(speriod));
                        s61.setProgress(adistance);
                        e61.setText(String.valueOf(adistance));
                        updataflag=false;
                    }
                    p60.setProgress(svalue);
                    //p61.setProgress(overfalg);
                    if(overfalg==1){
                        i60.setBackgroundResource(R.mipmap.overflag01);
                    }else{
                        i60.setBackgroundResource(R.mipmap.overflag00);
                    }
                }else{
                    mbtService.setReceiveType(6);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='s';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                break;
            case 7://tempreture
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                   // mbtService.setReceiveType(7);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='t';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;
                }
                if(numOFBytesReceived==26) {

                }else if(numOFBytesReceived==58){

                }else if(numOFBytesReceived==14&&((databuf[0]&0xff)|(databuf[1]&0xff)<<8)==16){
                    //&&(databuf[count++]|databuf[count++]<<8)==9){
                    //Log.d("READ BATTERY", "recvlen:" + String.valueOf((databuf[count++] | databuf[count++] << 8)));
                    count+=2;
                    int speriod = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int tempalarm = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int humialarm = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int temp = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int humi = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int tempflag = (databuf[count++]);
                    int humiflag = (databuf[count]);
                    //Log.d("READ BATTERY", "overvalue:" + String.valueOf(speriod));
                    Log.d("READ BATTERY", "tempalarm" + String.valueOf(tempalarm));
                    Log.d("READ BATTERY", "humialarm" + String.valueOf(humialarm));
                    if(updataflag) {
                        s70.setProgress(speriod);
                        e70.setText(String.valueOf(speriod));
                        s71.setProgress(tempalarm);
                        e71.setText(String.valueOf(tempalarm));
                        s72.setProgress(humialarm);
                        e72.setText(String.valueOf(humialarm));
                        updataflag=false;
                    }
                    p70.setProgress(temp);
                    //p71.setProgress(tempflag);
                    if(tempflag==1){
                        i70.setBackgroundResource(R.mipmap.overflag01);
                    }else{
                        i70.setBackgroundResource(R.mipmap.overflag00);
                    }
                    p72.setProgress(humi);
                    //p73.setProgress(humiflag);
                    if(humiflag==1){
                        i71.setBackgroundResource(R.mipmap.overflag01);
                    }else{
                        i71.setBackgroundResource(R.mipmap.overflag00);
                    }
                }else{
                    mbtService.setReceiveType(7);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='t';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                break;
            case 8://gas
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                   // mbtService.setReceiveType(8);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='g';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;
                }
                if(numOFBytesReceived==26) {

                }else if(numOFBytesReceived==36){

                }else if(numOFBytesReceived==9&&(databuf[0] | databuf[1] << 8)==11){
                    //&&(databuf[count++]|databuf[count++]<<8)==9){
                    //Log.d("READ BATTERY", "recvlen:" + String.valueOf((databuf[count++] | databuf[count++] << 8)));
                    count+=2;
                    int speriod = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int gasalarm = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int gas = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int overflag = (databuf[count]);
                    //Log.d("READ BATTERY", "overvalue:" + String.valueOf(speriod));
                    if(updataflag) {
                        s80.setProgress(speriod);
                        e80.setText(String.valueOf(speriod));
                        s81.setProgress(gasalarm);
                        Log.d("READ BATTERY", "gasalarm" + String.valueOf(gasalarm));
                        e81.setText(String.valueOf(gasalarm));
                        updataflag=false;
                    }
                    p80.setProgress(gas);
                    //p81.setProgress(overflag);
                    if(overflag==1){
                        i80.setBackgroundResource(R.mipmap.overflag01);
                    }else{
                        i80.setBackgroundResource(R.mipmap.overflag00);
                    }

                }else{
                    mbtService.setReceiveType(8);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='g';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                break;
            case 9://ir
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                   // mbtService.setReceiveType(9);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='i';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;
                }
                if(numOFBytesReceived==26) {

                }else if(numOFBytesReceived==58){

                }else if(numOFBytesReceived==11&&(databuf[0] | databuf[1] << 8)==15){
                    //&&(databuf[count++]|databuf[count++]<<8)==9){
                    //Log.d("READ BATTERY", "recvlen:" + String.valueOf((databuf[count++] | databuf[count++] << 8)));
                    count+=2;
                    int speriod = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    int ldata = (databuf[count++]);
                    int udatatype= (databuf[count++]);
                    int odatanumber= (databuf[count++]);
                    int ldatanumber= (databuf[count++]);
                    int receive= (databuf[count++]);
                    int sflag= (databuf[count++]);
                    int lflag = (databuf[count]);
                    //Log.d("READ BATTERY", "overvalue:" + String.valueOf(speriod));
                    if(updataflag) {
                        s90.setProgress(speriod);
                        e90.setText(String.valueOf(speriod));
                        s91.setProgress(ldata);
                        Log.d("READ BATTERY", "learned data" + String.valueOf(ldata));
                        e91.setText(String.valueOf(ldata));
                        s92.setProgress(udatatype);
                        e92.setText(String.valueOf(udatatype));
                        s93.setProgress(odatanumber);
                        e93.setText(String.valueOf(odatanumber));
                        s94.setProgress(ldatanumber);
                        e94.setText(String.valueOf(ldatanumber));
                        tb90.setChecked(sflag == 1);
                        tb91.setChecked(lflag == 1);
                        updataflag=false;
                    }
                    p90.setProgress(receive);


                }else{
                    mbtService.setReceiveType(9);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='i';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                break;
            case 10:
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                   // mbtService.setReceiveType(10);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='k';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;
                }
                if(numOFBytesReceived==26) {

                }else if(numOFBytesReceived==22){

                }else if(numOFBytesReceived==6&&(databuf[0] | databuf[1] << 8)==7){
                    //&&(databuf[count++]|databuf[count++]<<8)==9){
                    //Log.d("READ BATTERY", "recvlen:" + String.valueOf((databuf[count++] | databuf[count++] << 8)));
                    count+=2;
                    int speriod = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);;
                    int keystate = ((databuf[count++]&0xff)|(databuf[count]&0xff)<<8);;
                    //Log.d("READ BATTERY", "overvalue:" + String.valueOf(speriod));
                    if(updataflag) {
                        sa0.setProgress(speriod);
                        ea0.setText(String.valueOf(speriod));
                        updataflag=false;
                    }
                    pa0.setProgress(keystate);
                }else{
                    mbtService.setReceiveType(10);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='k';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                break;
            case 11://settings
                if(numOFBytesReceived==2&&databuf[0]=='e'&&databuf[1]=='1')
                {
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='p';

                    mbtService.write(dat);
                    mbtService.clear();
                    //mbtService.setReceiveType(1);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='d';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                    return;

                }
                if(numOFBytesReceived==8){
                    devLinkRep.repLen = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    devLinkRep.devNum = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    devLinkRep.devSta = ((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8);
                    devLinkRep.datLen = ((databuf[count++]&0xff)|(databuf[count]&0xff)<<8);
                }else if(devLinkRep.datLen>0&&numOFBytesReceived==devLinkRep.datLen&&
                        ((databuf[0]&0xff)|(databuf[1]&0xff)<<8)==devLinkRep.datLen){
                    count+=2;
                    buzzerlinkstate = (((databuf[count++]&0xff)|(databuf[count++]&0xff)<<8));
                    ledlinkstate =(((databuf[count++]&0xff)|(databuf[count]&0xff)<<8));

                    Log.d("settings","buzzerlinkstate="+String.valueOf(buzzerlinkstate)+" "+"ledlinkstate="+String.valueOf(ledlinkstate));
                    sw_batt.setChecked((buzzerlinkstate & 0x1)!=0&&(ledlinkstate & 0x1)!=0);//batt
                    sw_dis.setChecked((buzzerlinkstate >> 4  & 0x1)!=0&&(ledlinkstate >> 4  & 0x1)!=0);//distance
                    sw_gas.setChecked((buzzerlinkstate >> 6  & 0x1)!=0&&(ledlinkstate >> 6  & 0x1)!=0);//gas
                    sw_temp.setChecked((buzzerlinkstate >> 5 & 0x1)!=0&&(ledlinkstate >> 5 & 0x1)!=0);//temp&humi
                    sw_vib.setChecked((buzzerlinkstate >>3  & 0x1)!=0&&(ledlinkstate >>3  & 0x1)!=0);//vib
                    showwaitdialog(false);
/*
                    cbox10.setChecked((buzzerlinkstate & 0x1) != 0);
                    cbox11.setChecked((buzzerlinkstate >> 3 & 0x1) != 0);
                    cbox12.setChecked((buzzerlinkstate >> 4 & 0x1) != 0);
                    cbox13.setChecked((buzzerlinkstate >> 5 & 0x1) != 0);
                    cbox14.setChecked((buzzerlinkstate >> 6 & 0x1) != 0);//gas
                    cbox1a.setChecked((buzzerlinkstate >> 7 & 0x1) != 0);
                    cbox1b.setChecked((buzzerlinkstate >> 8 & 0x1) != 0);


                    cbox15.setChecked((ledlinkstate & 0x1) != 0);
                    cbox16.setChecked((ledlinkstate >> 3 & 0x1) != 0);
                    cbox17.setChecked((ledlinkstate >> 4 & 0x1) != 0);
                    cbox18.setChecked((ledlinkstate >> 5 & 0x1) != 0);
                    cbox19.setChecked((ledlinkstate >> 6 & 0x1) != 0);//gas
                    cbox1c.setChecked((ledlinkstate >> 7 & 0x1) != 0);
                    cbox1d.setChecked((ledlinkstate >> 8 & 0x1) != 0);
*/

                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='p';
                    mbtService.write(dat);

                }else{
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='p';
                    mbtService.write(dat);
                    mbtService.clear();
                    mbtService.setReceiveType(1);
                    dat[0]='@';
                    dat[1]='t';
                    dat[2]='d';
                    mbtService.write(dat);
                    dat[0]='@';
                    dat[1]='s';
                    dat[2]='s';
                    mbtService.write(dat);
                }
                break;
        }
    }
    // The Handler that gets information back from the BluetoothService
    private final Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MESSAGE_STATE_CHANGE:
                    //if(D) Log.i(TAG, "MESSAGE_STATE_CHANGE: " + msg.arg1);
                    switch (msg.arg1) {
                        case BluetoothService.STATE_CONNECTED:
                            mbtService.clear();
                            byte[] dat= new byte[4];
                            dat[0]='@';
                            dat[1]='h';
                            dat[2]='0';
                            dat[3]='0';
                            mbtService.write(dat);
                            /*
                            byte[] recv = new byte[64];
                            Log.d("READ", "recv[0]:" + new String(recv, 0, 7));
                            mbtService.read(recv,7);
                            */
                            dat[0]='@';
                            dat[1]='s';
                            dat[2]='p';
                            mbtService.write(dat);
                            mbtService.clear();
                            dat= new byte[3];
                            dat[0]='@';
                            dat[1]='f';
                            dat[2]='b';
                            mbtService.write(dat);

                            //mbtService.clear();
                            // dat= new byte[3];
                            mbtService.setReceiveType(0);//0forINDEX
                            dat[0]='@';
                            dat[1]='t';
                            dat[2]='x';
                            mbtService.write(dat);
                            dat[0]='@';
                            dat[1]='s';
                            dat[2]='s';
                            mbtService.write(dat);
                            /*
                            mbtService.read(recv, 10);
                            Log.d("READ", "recv:" + String.valueOf(recv[0]));
                            //mbtService.read(recv, 16);
                            indexRep.indRepLen=recv[3]<<8|recv[2];
                            indexRep.devNum=recv[5]<<8|recv[4];
                            indexRep.devSta=recv[7]<<8|recv[6];
                            indexRep.indDatLen=recv[9]<<8|recv[8];
                            Log.d("READ", "indexRep.indRepLen" + String.valueOf(indexRep.indRepLen));
                            Log.d("READ", "indexRep.indDatLen" + String.valueOf(indexRep.indDatLen));
                            */
                            isConnected = true;
                            //button_connect.setBackgroundColor(Color.GREEN);
                            button_connect.setBackgroundResource(R.mipmap.bluetooth_light);
                            break;
                        case BluetoothService.STATE_CONNECTING:

                            break;
                        case BluetoothService.STATE_LISTEN:
                        case BluetoothService.STATE_NONE:
                            Log.d("ConnectState", "STATE_NONE");
                            isConnected = false;
                            //button_connect.setBackgroundColor(Color.RED);
                            button_connect.setBackgroundResource(R.mipmap.bluetooth_dark);
                            break;
                    }
                    break;
                case MESSAGE_WRITE:
                    // byte[] writeBuf = (byte[]) msg.obj;
                    // construct a string from the buffer
                    //String writeMessage = new String(writeBuf);

                    break;
                case MESSAGE_READ:
                    byte[] readBuf = (byte[]) msg.obj;
                    int len=msg.arg1;
                    // construct a string from the valid bytes in the buffer
                    //String readMessage = new String(readBuf, 0, msg.arg1);
                    //testdata(readBuf,len);
                    showdata(readBuf,len);
                    break;
                case MESSAGE_DEVICE_NAME:
                    // save the connected device's name

                    break;
                case MESSAGE_TOAST:
                    Toast.makeText(getApplicationContext(), msg.getData().getString(TOAST),
                            Toast.LENGTH_SHORT).show();
                    break;
            }
        }
    };

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }
    @Override
    public void onBackPressed() {
        if(currIndex!=0&&currIndex!=1&&currIndex!=12){
            mPager.setCurrentItem(0);
            //mToolbar.setTitle("Index");
            setTitle1(0);
        }else if(currIndex==1){
            mPager.setCurrentItem(11);
            mToolbar.setTitle("Settings");
            for (int i = 0; i < 9; i++) {
                HashMap<String, Object> map = listItem.get(i);
                if (Itemenableflag[i] == 1) {
                    map.put("ItemImage", DarkList.get(i));
                } else {
                    map.put("ItemImage", DisableList.get(i));
                }
                listItem.set(i, map);
                mSimpleAdapter.notifyDataSetChanged();
            }
        }else if(currIndex==12){
            mPager.setCurrentItem(11);
            mToolbar.setTitle("Settings");
        } else if(currIndex==0){
            super.onBackPressed();
        }
        //super.onBackPressed();
    }

    private Camera camera;
    /**
     * 打开闪光灯
     *
     * @return
     */
    private void lightopen() {
        try {
            camera = Camera.open();
            camera.startPreview();
            Camera.Parameters parameters = camera.getParameters();
            parameters.setFlashMode(Camera.Parameters.FLASH_MODE_TORCH);
            camera.setParameters(parameters);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 关闭闪光灯
     *
     * @return
     */
    private void lightclose() {
        try {
            Camera.Parameters parameters = camera.getParameters();
            parameters.setFlashMode(Camera.Parameters.FLASH_MODE_OFF);
            camera.setParameters(parameters);
            camera.release();
            camera = null;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openflash() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                int i=5;
                while ( i-- >0) {
                    lightopen();
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    lightclose();
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }
    private SoundPool soundPool;
    private int sound1,sound2;
    public void InitAlarmAudio(){
        soundPool=new SoundPool(2, AudioManager.STREAM_MUSIC, 0);
        sound1=soundPool.load(this, R.raw.beep, 1);
    }
    public void playmusic(){

        soundPool.play(sound1, 1.0f, 1.0f, 0, 0, 1);
    }

    public int sendSMS(String phoneNumber, String message)
    {
        Log.d("###","send mesage");
        boolean result = true;
        TelephonyManager telMgr = (TelephonyManager) getSystemService(Context.TELEPHONY_SERVICE);
        int simState = telMgr.getSimState();
        switch (simState) {
            case TelephonyManager.SIM_STATE_ABSENT:
                result = false;
                // do something
                break;
            case TelephonyManager.SIM_STATE_NETWORK_LOCKED:
                // do something
                break;
            case TelephonyManager.SIM_STATE_PIN_REQUIRED:
                // do something
                break;
            case TelephonyManager.SIM_STATE_PUK_REQUIRED:
                // do something
                break;
            case TelephonyManager.SIM_STATE_READY:
                // do something
                break;
            case TelephonyManager.SIM_STATE_UNKNOWN:
                result = false;
                // do something
                break;
        }

        if(result) {
            SmsManager sms = SmsManager.getDefault();
            sms.sendTextMessage(phoneNumber, null, message, null, null);
        }else{
            Toast.makeText(getApplicationContext(), "no sim card",
                    Toast.LENGTH_SHORT).show();
        }
        return 0;
    }
    private void showwaitdialog(boolean s)
    {
        if(s)
            m_pDialog.show();
        else
            m_pDialog.hide();
    }
}