/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.editors;

import java.util.Arrays;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;

public class TmfTraceColumnManager {
    private static final String ROOT_SECTION_NAME = (String)NonNullUtils.checkNotNull((Object)TmfTraceColumnManager.class.getSimpleName());
    private static final String COLUMN_ORDER_SECTION_NAME = "column.order";

    public static int[] loadColumnOrder(String traceTypeId) {
        if (traceTypeId == null) {
            return null;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(ROOT_SECTION_NAME);
        if (section == null) {
            return null;
        }
        IDialogSettings columnOrderSection = section.getSection(COLUMN_ORDER_SECTION_NAME);
        if (columnOrderSection == null) {
            return null;
        }
        String string = columnOrderSection.get(traceTypeId);
        if (string == null || string.length() < 3) {
            return null;
        }
        if (string.charAt(0) != '[' || string.charAt(string.length() - 1) != ']') {
            return null;
        }
        String[] array = string.substring(1, string.length() - 1).split(", ");
        int[] columnOrder = new int[array.length];
        try {
            int i = 0;
            while (i < array.length) {
                columnOrder[i] = Integer.valueOf(array[i]);
                ++i;
            }
            return columnOrder;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static void saveColumnOrder(String traceTypeId, int[] columnOrder) {
        IDialogSettings columnOrderSection;
        if (traceTypeId == null) {
            return;
        }
        if (columnOrder == null) {
            TmfTraceColumnManager.clearColumnOrder(traceTypeId);
            return;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(ROOT_SECTION_NAME);
        if (section == null) {
            section = settings.addNewSection(ROOT_SECTION_NAME);
        }
        if ((columnOrderSection = section.getSection(COLUMN_ORDER_SECTION_NAME)) == null) {
            columnOrderSection = section.addNewSection(COLUMN_ORDER_SECTION_NAME);
        }
        columnOrderSection.put(traceTypeId, Arrays.toString(columnOrder));
    }

    public static void clearColumnOrder(String traceTypeId) {
        if (traceTypeId == null) {
            return;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(ROOT_SECTION_NAME);
        if (section == null) {
            return;
        }
        IDialogSettings columnOrderSection = section.getSection(COLUMN_ORDER_SECTION_NAME);
        if (columnOrderSection == null) {
            return;
        }
        columnOrderSection.put(traceTypeId, null);
    }
}

