/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.swtchart.IAxis;

public class TmfMouseWheelZoomProvider
extends TmfBaseProvider
implements MouseWheelListener {
    private static final double ZOOM_FACTOR = 0.8;
    private static final long MIN_WINDOW_SIZE = 1L;

    public TmfMouseWheelZoomProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.getChart().getPlotArea().addMouseWheelListener((MouseWheelListener)this);
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseWheelListener((MouseWheelListener)this);
        }
    }

    @Override
    public void refresh() {
    }

    public synchronized void mouseScrolled(MouseEvent event) {
        ITmfChartTimeProvider viewer = this.getChartViewer();
        long oldDuration = viewer.getWindowDuration();
        if (oldDuration == 0L) {
            return;
        }
        long newDuration = oldDuration;
        double ratio = 1.0;
        if (event.count > 0) {
            ratio = 0.8;
            newDuration = Math.round(0.8 * (double)oldDuration);
        } else {
            ratio = 1.25;
            newDuration = (long)Math.ceil((double)oldDuration * ratio);
        }
        newDuration = Math.max(1L, newDuration);
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        long timeAtXPos = this.limitXDataCoordinate(xAxis.getDataCoordinate(event.x)) + viewer.getTimeOffset();
        long newWindowStartTime = timeAtXPos - Math.round(ratio * (double)(timeAtXPos - viewer.getWindowStartTime()));
        long newWindowEndTime = this.validateWindowEndTime(newWindowStartTime, newWindowStartTime + newDuration);
        newWindowStartTime = this.validateWindowStartTime(newWindowStartTime);
        viewer.updateWindow(newWindowStartTime, newWindowEndTime);
    }

    private long validateWindowStartTime(long start) {
        ITmfChartTimeProvider viewer = this.getChartViewer();
        long realStart = start;
        long startTime = viewer.getStartTime();
        long endTime = viewer.getEndTime();
        if (realStart < startTime) {
            realStart = startTime;
        }
        if (realStart > endTime) {
            realStart = endTime;
        }
        return realStart;
    }

    private long validateWindowEndTime(long start, long end) {
        long realEnd = end;
        ITmfChartTimeProvider viewer = this.getChartViewer();
        long endTime = viewer.getEndTime();
        if (realEnd > endTime) {
            realEnd = endTime;
        }
        if (realEnd < start + 1L) {
            realEnd = start + 1L;
        }
        return realEnd;
    }
}

