/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.core;

import java.util.Comparator;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.AsyncMessageReturn;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.preferences.SDViewPref;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.SortAsyncForBackward;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.SortAsyncMessageComparator;

public class AsyncMessage
extends BaseMessage
implements ITimeRange {
    public static final String ASYNC_MESS_TAG = "AsyncMessage";
    private boolean fHasTime = false;
    private ITmfTimestamp fEndTime = new TmfTimestamp();
    private ITmfTimestamp fStartTime = new TmfTimestamp();
    protected AsyncMessageReturn fMessageReturn = null;

    public AsyncMessage() {
        this.setColorPrefId("PREF_ASYNC_MESS");
    }

    @Override
    public int getX() {
        int x = super.getX(true);
        int activationWidth = 4;
        if (this.getStartLifeline() != null && this.getEndLifeline() != null && this.getStartLifeline().getX() > this.getEndLifeline().getX()) {
            activationWidth = -activationWidth;
        }
        if (this.isMessageStartInActivation(this.getStartOccurrence())) {
            x += activationWidth;
        }
        return x;
    }

    @Override
    public int getY() {
        if (this.getStartLifeline() != null && this.getEndLifeline() != null) {
            return this.getEndLifeline().getY() + this.getEndLifeline().getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.getStartOccurrence();
        }
        return super.getY();
    }

    @Override
    public int getWidth() {
        int width = super.getWidth(true);
        int activationWidth = 4;
        if (this.getStartLifeline() != null && this.getEndLifeline() != null && this.getStartLifeline().getX() > this.getEndLifeline().getX()) {
            activationWidth = -activationWidth;
        }
        if (this.isMessageStartInActivation(this.getStartOccurrence())) {
            width -= activationWidth;
        }
        if (this.isMessageEndInActivation(this.getEndOccurrence())) {
            width -= activationWidth;
        }
        return width;
    }

    @Override
    public int getHeight() {
        if (this.getStartLifeline() != null && this.getEndLifeline() != null) {
            return this.getEndLifeline().getY() + this.getEndLifeline().getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.getEndOccurrence() - this.getY();
        }
        return super.getHeight();
    }

    protected void setMessageReturn(AsyncMessageReturn message) {
        this.fMessageReturn = message;
    }

    @Override
    public void setEndOccurrence(int occurrence) {
        super.setEndOccurrence(occurrence);
        if (this.getStartLifeline() == null) {
            this.setStartOccurrence(occurrence);
        }
        this.informFrame(this.getEndLifeline(), occurrence);
    }

    protected void informFrame(Lifeline lifeLine, int occurrence) {
        if (lifeLine != null && lifeLine.getFrame() != null && lifeLine.getFrame().getMaxEventOccurrence() < occurrence) {
            lifeLine.getFrame().setMaxEventOccurrence(occurrence);
        }
    }

    @Override
    public void setStartOccurrence(int occurrence) {
        super.setStartOccurrence(occurrence);
        if (this.getEndLifeline() == null) {
            this.setEndOccurrence(this.getStartOccurrence());
        }
        this.informFrame(this.getStartLifeline(), occurrence);
    }

    public void autoSetStartLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setStartLifeline(lifeline);
    }

    public void autoSetEndLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setEndLifeline(lifeline);
    }

    @Override
    public void setStartLifeline(Lifeline lifeline) {
        super.setStartLifeline(lifeline);
        this.setStartOccurrence(this.getStartLifeline().getEventOccurrence());
        if (this.getEndLifeline() == null) {
            this.setEndOccurrence(this.getStartOccurrence());
        }
    }

    @Override
    public void setEndLifeline(Lifeline lifeline) {
        super.setEndLifeline(lifeline);
        this.setEventOccurrence(this.getEndLifeline().getEventOccurrence());
    }

    protected boolean isNearSegment(int xA, int yA, int xB, int yB, int xC, int yC) {
        if (xA > xB && xC > xA) {
            return false;
        }
        if (xA < xB && xC > xB) {
            return false;
        }
        if (xA < xB && xC < xA) {
            return false;
        }
        if (xA > xB && xC < xB) {
            return false;
        }
        double distAB = Math.sqrt((xB - xA) * (xB - xA) + (yB - yA) * (yB - yA));
        double scalar = (double)((xB - xA) * (xC - xA) + (yB - yA) * (yC - yA)) / distAB;
        double distAC = Math.sqrt((xC - xA) * (xC - xA) + (yC - yA) * (yC - yA));
        double distToSegment = Math.sqrt(Math.abs(distAC * distAC - scalar * scalar));
        return distToSegment <= 30.0;
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.getStartLifeline() == this.getEndLifeline()) {
            return super.contains(x, y);
        }
        if (this.isNearSegment(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), x, y)) {
            return true;
        }
        int messageMaxWidth = Metrics.swimmingLaneWidth() - 8;
        int nameWidth = this.getName().length() * Metrics.getAverageCharWidth();
        return this.getName().length() * Metrics.getAverageCharWidth() > messageMaxWidth ? GraphNode.contains(this.getX(), this.getY() - 10 - Metrics.getMessageFontHeigth(), messageMaxWidth, Metrics.getMessageFontHeigth(), x, y) : GraphNode.contains(this.getX() + (messageMaxWidth - nameWidth) / 2, this.getY() + this.getHeight() / 2 - 10 - Metrics.getMessageFontHeigth(), nameWidth, Metrics.getMessageFontHeigth(), x, y);
    }

    protected void drawAsyncMessage(IGC context) {
        if (this.getStartLifeline() != null && this.getEndLifeline() != null && this.getStartLifeline() == this.getEndLifeline() && this.getStartOccurrence() != this.getEndOccurrence()) {
            int x = this.getX();
            int y = this.getY();
            int height = this.getHeight();
            int tempx = 0;
            boolean startInActivation = this.isMessageStartInActivation(this.getStartOccurrence());
            boolean endInActivation = this.isMessageEndInActivation(this.getEndOccurrence());
            if (endInActivation && !startInActivation) {
                tempx = 4;
            }
            if (startInActivation && !endInActivation) {
                tempx = -4;
            }
            int tempy = 10;
            if (this.getHeight() <= 20) {
                tempy = this.getHeight() / 2;
            }
            context.drawLine(x, y, x + 10, y);
            context.drawLine(x + 20, y + tempy, x + 20, y + height - tempy);
            context.drawLine(x + tempx, y + height, x + 10, y + height);
            Double xt = Math.cos(0.75) * 7.0;
            Double yt = Math.sin(0.75) * 7.0;
            context.drawLine(x + xt.intValue() + tempx, y + height + yt.intValue(), x + tempx, y + height);
            context.drawArc(x, y, 20, 2 * tempy, 0, 90);
            context.drawArc(x, y + height, 20, -2 * tempy, 0, -90);
            context.drawLine(x + xt.intValue() + tempx, y + height - yt.intValue(), x + tempx, y + height);
            context.drawTextTruncated(this.getName(), x + 20 + 10, y, Metrics.swimmingLaneWidth() - 8 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
        } else {
            super.draw(context);
        }
    }

    @Override
    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        SDViewPref pref = SDViewPref.getInstance();
        if (this.isSelected() && this.getStartLifeline() != null && this.getEndLifeline() != null && this.getStartLifeline() == this.getEndLifeline() && this.getStartOccurrence() != this.getEndOccurrence()) {
            context.setForeground(pref.getBackGroundColorSelection());
            context.setLineWidth(5);
            this.drawAsyncMessage(context);
            context.setBackground(pref.getBackGroundColorSelection());
            context.setForeground(pref.getForeGroundColorSelection());
        } else {
            context.setBackground(pref.getBackGroundColor(this.getColorPrefId()));
            context.setForeground(pref.getForeGroundColor(this.getColorPrefId()));
        }
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(true);
        }
        context.setLineWidth(1);
        this.drawAsyncMessage(context);
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(false);
        }
    }

    public void setEndTime(ITmfTimestamp time) {
        this.fEndTime = time;
        this.fHasTime = true;
        if (this.getStartLifeline() != null && this.getStartLifeline().getFrame() != null) {
            this.getStartLifeline().getFrame().setHasTimeInfo(true);
        } else if (this.getEndLifeline() != null && this.getEndLifeline().getFrame() != null) {
            this.getEndLifeline().getFrame().setHasTimeInfo(true);
        }
    }

    public void setStartTime(ITmfTimestamp time) {
        this.fStartTime = time;
        this.fHasTime = true;
        if (this.getStartLifeline() != null && this.getStartLifeline().getFrame() != null) {
            this.getStartLifeline().getFrame().setHasTimeInfo(true);
        } else if (this.getEndLifeline() != null && this.getEndLifeline().getFrame() != null) {
            this.getEndLifeline().getFrame().setHasTimeInfo(true);
        }
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    @Override
    public boolean hasTimeInfo() {
        return this.fHasTime;
    }

    public AsyncMessageReturn getMessageReturn() {
        return this.fMessageReturn;
    }

    @Override
    public boolean isVisible(int x, int y, int width, int height) {
        int toDrawY = this.getY();
        int toDrawHeight = this.getHeight();
        if (toDrawY > y + height + 10 + Metrics.getMessageFontHeigth() && toDrawY + toDrawHeight > y + height + 10 + Metrics.getMessageFontHeigth()) {
            return false;
        }
        if (toDrawY < y && toDrawY + toDrawHeight < y) {
            return false;
        }
        return super.isVisible(x, y, width, height);
    }

    @Override
    public Comparator<GraphNode> getComparator() {
        return new SortAsyncMessageComparator();
    }

    @Override
    public String getArrayId() {
        return ASYNC_MESS_TAG;
    }

    @Override
    public Comparator<GraphNode> getBackComparator() {
        return new SortAsyncForBackward();
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        int mY = this.getY();
        int mH = this.getHeight();
        return mY > y || mY + mH > y;
    }
}

