/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import java.util.EnumSet;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class DeclSpecWriter
extends NodeWriter {
    public DeclSpecWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
    }

    protected void writeDelcSpec(IASTDeclSpecifier declSpec) {
        this.writeDeclSpec(declSpec);
        if (declSpec instanceof ICPPASTDeclSpecifier) {
            this.writeCPPDeclSpec((ICPPASTDeclSpecifier)declSpec);
        } else if (declSpec instanceof ICASTDeclSpecifier) {
            this.writeCDeclSpec((ICASTDeclSpecifier)declSpec);
        }
    }

    private String getCPPSimpleDecSpecifier(ICPPASTSimpleDeclSpecifier simpDeclSpec) {
        return this.getASTSimpleDecSpecifier(simpDeclSpec.getType(), true);
    }

    private String getCSimpleDecSpecifier(ICASTSimpleDeclSpecifier simpDeclSpec) {
        return this.getASTSimpleDecSpecifier(simpDeclSpec.getType(), false);
    }

    private String getASTSimpleDecSpecifier(int type, boolean isCpp) {
        switch (type) {
            case 0: {
                return "";
            }
            case 1: {
                return "void";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "int";
            }
            case 13: {
                return "__int128";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "double";
            }
            case 14: {
                return "__float128";
            }
            case 15: {
                return "_Decimal32";
            }
            case 16: {
                return "_Decimal64";
            }
            case 17: {
                return "_Decimal128";
            }
            case 6: {
                return isCpp ? "bool" : "_Bool";
            }
            case 7: {
                if (!isCpp) break;
                return "wchar_t";
            }
            case 11: {
                if (!isCpp) break;
                return "char16_t";
            }
            case 12: {
                if (!isCpp) break;
                return "char32_t";
            }
            case 10: {
                if (!isCpp) break;
                return "auto";
            }
            case 8: {
                if (!isCpp) break;
                return "typeof";
            }
            case 9: {
                if (!isCpp) break;
                return "decltype";
            }
        }
        throw new IllegalArgumentException("Unknown specifier type: " + type);
    }

    private void writeCDeclSpec(ICASTDeclSpecifier cDeclSpec) {
        if (cDeclSpec.isRestrict()) {
            this.scribe.printStringSpace("restrict");
        }
        if (cDeclSpec instanceof ICASTCompositeTypeSpecifier) {
            this.writeCompositeTypeSpecifier((ICASTCompositeTypeSpecifier)cDeclSpec);
        } else if (cDeclSpec instanceof ICASTEnumerationSpecifier) {
            this.writeEnumSpec((ICASTEnumerationSpecifier)cDeclSpec);
        } else if (cDeclSpec instanceof ICASTElaboratedTypeSpecifier) {
            this.writeElaboratedTypeSec((ICASTElaboratedTypeSpecifier)cDeclSpec);
        } else if (cDeclSpec instanceof ICASTSimpleDeclSpecifier) {
            this.writeCSimpleDeclSpec((ICASTSimpleDeclSpecifier)cDeclSpec);
        } else if (cDeclSpec instanceof ICASTTypedefNameSpecifier) {
            this.writeNamedTypeSpecifier((ICASTTypedefNameSpecifier)cDeclSpec);
        }
    }

    private void writeNamedTypeSpecifier(ICPPASTNamedTypeSpecifier namedSpc) {
        if (namedSpc.isTypename()) {
            this.scribe.printStringSpace("typename");
        }
        namedSpc.getName().accept(this.visitor);
    }

    private void writeNamedTypeSpecifier(IASTNamedTypeSpecifier namedSpc) {
        namedSpc.getName().accept(this.visitor);
    }

    private void writeElaboratedTypeSec(IASTElaboratedTypeSpecifier elabType) {
        this.scribe.printStringSpace(this.getElabTypeString(elabType.getKind()));
        if (elabType instanceof IASTAttributeOwner) {
            this.writeAttributes((IASTAttributeOwner)((Object)elabType), EnumSet.of(NodeWriter.SpaceLocation.AFTER));
        }
        elabType.getName().accept(this.visitor);
    }

    private String getElabTypeString(int kind) {
        switch (kind) {
            case 0: {
                return "enum";
            }
            case 1: {
                return "struct";
            }
            case 2: {
                return "union";
            }
            case 3: {
                return "class";
            }
        }
        throw new IllegalArgumentException("Unknown elaborated type: " + kind);
    }

    private void writeCPPDeclSpec(ICPPASTDeclSpecifier cppDelcSpec) {
        if (cppDelcSpec.isVirtual()) {
            this.scribe.printStringSpace("virtual");
        }
        if (cppDelcSpec.isConstexpr()) {
            this.scribe.printStringSpace("constexpr");
        }
        if (cppDelcSpec.isExplicit()) {
            this.scribe.printStringSpace("explicit");
        }
        if (cppDelcSpec.isFriend()) {
            this.scribe.printStringSpace("friend");
        }
        if (cppDelcSpec.isThreadLocal()) {
            this.scribe.printStringSpace("thread_local");
        }
        if (cppDelcSpec.getStorageClass() == 6) {
            this.scribe.printStringSpace("mutable");
        }
        if (cppDelcSpec instanceof ICPPASTCompositeTypeSpecifier) {
            this.writeCompositeTypeSpecifier((ICPPASTCompositeTypeSpecifier)cppDelcSpec);
        } else if (cppDelcSpec instanceof IASTEnumerationSpecifier) {
            this.writeEnumSpec((IASTEnumerationSpecifier)((Object)cppDelcSpec));
        } else if (cppDelcSpec instanceof ICPPASTElaboratedTypeSpecifier) {
            this.writeElaboratedTypeSec((ICPPASTElaboratedTypeSpecifier)cppDelcSpec);
        } else if (cppDelcSpec instanceof ICPPASTSimpleDeclSpecifier) {
            this.writeCPPSimpleDeclSpec((ICPPASTSimpleDeclSpecifier)cppDelcSpec);
        } else if (cppDelcSpec instanceof ICPPASTNamedTypeSpecifier) {
            this.writeNamedTypeSpecifier((ICPPASTNamedTypeSpecifier)cppDelcSpec);
        }
    }

    private void writeEnumSpec(IASTEnumerationSpecifier enumSpec) {
        this.scribe.printStringSpace("enum");
        if (enumSpec instanceof IASTAttributeOwner) {
            this.writeAttributes((IASTAttributeOwner)((Object)enumSpec), EnumSet.of(NodeWriter.SpaceLocation.AFTER));
        }
        enumSpec.getName().accept(this.visitor);
        this.scribe.print('{');
        this.scribe.printSpace();
        IASTEnumerationSpecifier.IASTEnumerator[] enums = enumSpec.getEnumerators();
        int i = 0;
        while (i < enums.length) {
            this.writeEnumerator(enums[i]);
            if (i + 1 < enums.length) {
                this.scribe.print(", ");
            }
            ++i;
        }
        this.scribe.print('}');
    }

    private void writeEnumerator(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        enumerator.getName().accept(this.visitor);
        IASTExpression value = enumerator.getValue();
        if (value != null) {
            this.scribe.print(" = ");
            value.accept(this.visitor);
        }
    }

    private void writeCompositeTypeSpecifier(IASTCompositeTypeSpecifier compDeclSpec) {
        boolean hasTrailingComments = this.hasTrailingComments(compDeclSpec.getName());
        this.scribe.printStringSpace(this.getCPPCompositeTypeString(compDeclSpec.getKey()));
        if (compDeclSpec instanceof IASTAttributeOwner) {
            this.writeAttributes((IASTAttributeOwner)((Object)compDeclSpec), EnumSet.of(NodeWriter.SpaceLocation.AFTER));
        }
        compDeclSpec.getName().accept(this.visitor);
        if (compDeclSpec instanceof ICPPASTCompositeTypeSpecifier) {
            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] baseSpecifiers;
            ICPPASTCompositeTypeSpecifier cppComp = (ICPPASTCompositeTypeSpecifier)compDeclSpec;
            if (cppComp.isFinal()) {
                this.scribe.printSpace();
                this.scribe.print(Keywords.cFINAL);
            }
            if ((baseSpecifiers = cppComp.getBaseSpecifiers()).length > 0) {
                this.scribe.print(" : ");
                int i = 0;
                while (i < baseSpecifiers.length) {
                    this.writeBaseSpecifiers(baseSpecifiers[i]);
                    if (i + 1 < baseSpecifiers.length) {
                        this.scribe.print(", ");
                    }
                    ++i;
                }
                hasTrailingComments = this.hasTrailingComments(baseSpecifiers[baseSpecifiers.length - 1].getNameSpecifier());
            }
        }
        if (!hasTrailingComments) {
            this.scribe.newLine();
        }
        this.scribe.print('{');
        this.scribe.newLine();
        this.scribe.incrementIndentationLevel();
        this.visitor.setSuppressLeadingBlankLine(true);
        IASTDeclaration[] decls = this.getMembers(compDeclSpec);
        if (decls.length > 0) {
            IASTDeclaration[] iASTDeclarationArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration declaration = iASTDeclarationArray[n2];
                declaration.accept(this.visitor);
                ++n2;
            }
        }
        if (this.hasFreestandingComments(compDeclSpec)) {
            this.writeFreestandingComments(compDeclSpec);
        }
        this.scribe.decrementIndentationLevel();
        this.scribe.print('}');
        if (this.hasTrailingComments(compDeclSpec)) {
            this.writeTrailingComments(compDeclSpec);
        }
    }

    protected IASTDeclaration[] getMembers(IASTCompositeTypeSpecifier compDeclSpec) {
        return compDeclSpec.getMembers();
    }

    public void writeBaseSpecifiers(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier specifier) {
        switch (specifier.getVisibility()) {
            case 1: {
                this.scribe.printStringSpace("public");
                break;
            }
            case 2: {
                this.scribe.printStringSpace("protected");
                break;
            }
            case 3: {
                this.scribe.printStringSpace("private");
            }
        }
        if (specifier.isVirtual()) {
            this.scribe.printStringSpace("virtual");
        }
        specifier.getNameSpecifier().accept(this.visitor);
    }

    private String getCPPCompositeTypeString(int key) {
        if (key <= 2) {
            return this.getCompositeTypeString(key);
        }
        switch (key) {
            case 3: {
                return "class";
            }
        }
        throw new IllegalArgumentException("Unknown type specifier: " + key);
    }

    private String getCompositeTypeString(int key) {
        switch (key) {
            case 1: {
                return "struct";
            }
            case 2: {
                return "union";
            }
        }
        throw new IllegalArgumentException("Unknown type specifier: " + key);
    }

    private void writeDeclSpec(IASTDeclSpecifier declSpec) {
        if (declSpec.isInline()) {
            this.scribe.printStringSpace("inline");
        }
        switch (declSpec.getStorageClass()) {
            case 1: {
                this.scribe.printStringSpace("typedef");
                break;
            }
            case 2: {
                this.scribe.printStringSpace("extern");
                break;
            }
            case 3: {
                this.scribe.printStringSpace("static");
                break;
            }
            case 4: {
                this.scribe.printStringSpace("auto");
                break;
            }
            case 5: {
                this.scribe.printStringSpace("register");
            }
        }
        if (declSpec.isConst()) {
            this.scribe.printStringSpace("const");
        }
        if (declSpec.isVolatile()) {
            this.scribe.printStringSpace("volatile");
        }
    }

    private void writeCPPSimpleDeclSpec(ICPPASTSimpleDeclSpecifier simpDeclSpec) {
        this.printQualifiers(simpDeclSpec);
        this.scribe.print(this.getCPPSimpleDecSpecifier(simpDeclSpec));
        this.writeAttributes(simpDeclSpec, EnumSet.of(NodeWriter.SpaceLocation.BEFORE));
        if (simpDeclSpec.getType() == 8) {
            this.scribe.printSpace();
            this.visitNodeIfNotNull(simpDeclSpec.getDeclTypeExpression());
        } else if (simpDeclSpec.getType() == 9) {
            this.scribe.print('(');
            this.visitNodeIfNotNull(simpDeclSpec.getDeclTypeExpression());
            this.scribe.print(')');
        }
    }

    private void printQualifiers(IASTSimpleDeclSpecifier simpDeclSpec) {
        ICASTSimpleDeclSpecifier cSimpDeclSpec;
        if (simpDeclSpec.isSigned()) {
            this.scribe.printStringSpace("signed");
        } else if (simpDeclSpec.isUnsigned()) {
            this.scribe.printStringSpace("unsigned");
        }
        if (simpDeclSpec.isShort()) {
            this.scribe.printStringSpace("short");
        } else if (simpDeclSpec.isLong()) {
            this.scribe.printStringSpace("long");
        } else if (simpDeclSpec.isLongLong()) {
            this.scribe.printStringSpace("long");
            this.scribe.printStringSpace("long");
        }
        if (simpDeclSpec instanceof ICASTSimpleDeclSpecifier && (cSimpDeclSpec = (ICASTSimpleDeclSpecifier)simpDeclSpec).isComplex()) {
            this.scribe.printStringSpace("_Complex");
        }
    }

    private void writeCSimpleDeclSpec(ICASTSimpleDeclSpecifier simpDeclSpec) {
        this.printQualifiers(simpDeclSpec);
        this.scribe.print(this.getCSimpleDecSpecifier(simpDeclSpec));
    }
}

