/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class CygPath {
    boolean useOldCygPath = false;
    private final Process cygpath;
    private final BufferedReader stdout;
    private final BufferedWriter stdin;
    private boolean fSpaceIsSeparator = false;

    public CygPath(String command) throws IOException {
        if (!Platform.getOS().equals("win32")) {
            throw new IOException("Not Windows");
        }
        String[] args = new String[]{command, "--windows", "--file", "-"};
        this.cygpath = Runtime.getRuntime().exec(args);
        this.stdin = new BufferedWriter(new OutputStreamWriter(this.cygpath.getOutputStream()));
        this.stdout = new BufferedReader(new InputStreamReader(this.cygpath.getInputStream()));
        try {
            String test = this.getFileName("a b");
            if ("a".equals(test)) {
                this.fSpaceIsSeparator = true;
                this.stdout.readLine();
            }
        }
        catch (IOException e) {
            this.dispose();
            this.useOldCygPath = true;
        }
    }

    public CygPath() throws IOException {
        this("cygpath");
    }

    /*
     * Unable to fully structure code
     */
    public String getFileName(String name) throws IOException {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (this.useOldCygPath) {
            return this.internalgetFileName(name);
        }
        if (!this.fSpaceIsSeparator || name.indexOf(32) == -1) ** GOTO lbl9
        return this.internalgetFileName(name);
lbl-1000:
        // 1 sources

        {
            this.stdout.read();
lbl9:
            // 2 sources

            ** while (this.stdout.ready())
        }
lbl10:
        // 1 sources

        this.stdin.write(String.valueOf(name) + "\n");
        this.stdin.flush();
        str = this.stdout.readLine();
        if (str != null) {
            return str.trim();
        }
        throw new IOException();
    }

    public void dispose() {
        if (!this.useOldCygPath) {
            try {
                this.stdout.close();
                this.stdin.close();
                this.cygpath.getErrorStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cygpath.destroy();
        }
    }

    private String internalgetFileName(String path) throws IOException {
        Process cygPath = null;
        BufferedReader reader = null;
        try {
            cygPath = Runtime.getRuntime().exec(new String[]{"cygpath", "-w", path});
            reader = new BufferedReader(new InputStreamReader(cygPath.getInputStream()));
            String newPath = reader.readLine();
            Path ipath = path != null && !path.equals("") ? new Path(newPath) : new Path(path);
            if (ipath.isAbsolute() && !ipath.toFile().exists() && ipath.segment(0).length() == 1) {
                StringBuffer drive = new StringBuffer(ipath.segment(0));
                drive.append(':');
                ipath = ipath.removeFirstSegments(1);
                ipath = ipath.makeAbsolute();
                ipath = ipath.setDevice(drive.toString());
            }
            String string = ipath.toOSString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (cygPath != null) {
                cygPath.destroy();
            }
        }
    }
}

