/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.ui.handlers;

import ilg.gnuarmeclipse.core.StringUtils;
import ilg.gnuarmeclipse.packs.cmsis.Index;
import ilg.gnuarmeclipse.packs.cmsis.PdscParserForContent;
import ilg.gnuarmeclipse.packs.core.ConsoleStream;
import ilg.gnuarmeclipse.packs.core.Utils;
import ilg.gnuarmeclipse.packs.core.data.PacksStorage;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.data.DataManager;
import ilg.gnuarmeclipse.packs.data.Repos;
import ilg.gnuarmeclipse.packs.ui.Activator;
import ilg.gnuarmeclipse.packs.xcdl.ContentSerialiser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.xml.sax.SAXParseException;

public class UpdatePacksHandler
extends AbstractHandler {
    private MessageConsoleStream fOut;
    private boolean fRunning;
    private Repos fRepos;
    private DataManager fDataManager;
    private IProgressMonitor fMonitor;
    private IWorkbenchWindow window;

    public UpdatePacksHandler() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("UpdatePacksHandler()");
        }
        this.fRunning = false;
        this.fOut = ConsoleStream.getConsoleOut();
        this.fRepos = Repos.getInstance();
        this.fDataManager = DataManager.getInstance();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IProgressService context = this.window.getWorkbench().getProgressService();
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    UpdatePacksHandler.this.myRun(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log((Throwable)e);
        }
        catch (InterruptedException e) {
            Activator.log((Throwable)e);
        }
        return null;
    }

    private IStatus myRun(IProgressMonitor monitor) {
        IStatus status;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("UpdatePacksHandler.myRun()");
        }
        if (this.fRunning) {
            return Status.CANCEL_STATUS;
        }
        this.fRunning = true;
        this.fMonitor = monitor;
        long beginTime = System.currentTimeMillis();
        this.fOut.println();
        this.fOut.println(Utils.getCurrentDateTime());
        this.fOut.println("Update packs job started.");
        int workUnits = 0;
        try {
            String type;
            List reposList = this.fRepos.getList();
            for (Map repo : reposList) {
                if (monitor.isCanceled()) break;
                type = (String)repo.get("type");
                String indexUrl = (String)repo.get("url");
                if ("CMSIS Pack".equals(type)) {
                    LinkedList<String[]> list = new LinkedList<String[]>();
                    this.readCmsisIndex(indexUrl, list);
                    repo.put("list", list);
                    workUnits += list.size();
                    continue;
                }
                if ("XCDL/CMSIS Pack".equals(type)) {
                    ++workUnits;
                    continue;
                }
                if ("Unused".equals(type)) {
                    this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportWarning((String)("Repo \"" + indexUrl + "\" ignored.")));
                    continue;
                }
                this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportWarning((String)("Repo type \"" + type + "\" not supported.")));
            }
            monitor.beginTask("Refresh all packs from all repositories.", ++workUnits);
            for (Map repo : reposList) {
                if (monitor.isCanceled()) break;
                type = (String)repo.get("type");
                if ("CMSIS Pack".equals(type)) {
                    if (!repo.containsKey("list")) continue;
                    this.aggregateCmsis(repo);
                    continue;
                }
                if (!"XCDL/CMSIS Pack".equals(type)) continue;
                this.cacheXcdlContent(repo);
            }
            monitor.worked(1);
        }
        catch (Exception e) {
            Activator.log((Throwable)e);
            this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportError((String)e.toString()));
        }
        if (monitor.isCanceled()) {
            this.fOut.println("Job cancelled.");
            status = Status.CANCEL_STATUS;
        } else {
            this.fDataManager.notifyNewInput();
            long endTime = System.currentTimeMillis();
            long duration = endTime - beginTime;
            if (duration == 0L) {
                duration = 1L;
            }
            this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportInfo((String)("Update packs completed in " + (duration + 500L) / 1000L + "s.")));
            status = Status.OK_STATUS;
        }
        this.fRunning = false;
        return status;
    }

    private void readCmsisIndex(String indexUrl, List<String[]> pdscList) {
        this.fOut.println("Parsing \"" + indexUrl + "\"...");
        try {
            int count = Index.readIndex((String)indexUrl, pdscList);
            if (count == 0) {
                this.fOut.println("Malformed index, no packs contributed.");
            } else {
                this.fOut.println("Contributed " + count + " pack(s).");
            }
            return;
        }
        catch (FileNotFoundException e) {
            this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportError((String)("File not found: " + e.getMessage())));
        }
        catch (Exception e) {
            this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportError((String)e.toString()));
        }
    }

    private void aggregateCmsis(Map<String, Object> repo) {
        List list = (List)repo.get("list");
        String repoUrl = (String)repo.get("url");
        Node contentRoot = new Node("repository");
        String domainName = Repos.getDomaninNameFromUrl((String)repoUrl);
        domainName = StringUtils.capitalizeFirst((String)domainName);
        contentRoot.setName(domainName);
        contentRoot.setDescription(String.valueOf(domainName) + " CMSIS packs repository");
        contentRoot.putProperty("type", "cmsis.repo");
        contentRoot.putProperty("repo.url", repoUrl);
        contentRoot.putProperty("generator", "GNU ARM Eclipse Plug-ins");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar cal = Calendar.getInstance();
        contentRoot.putProperty("date", dateFormat.format(cal.getTime()));
        PdscParserForContent parser = new PdscParserForContent();
        for (String[] pdsc : list) {
            if (this.fMonitor.isCanceled()) break;
            String pdscUrl = StringUtils.cosmetiseUrl((String)pdsc[0]);
            String pdscName = pdsc[1];
            String pdscVersion = pdsc[2];
            this.fMonitor.subTask(pdscName);
            try {
                URL sourceUrl = new URL(String.valueOf(pdscUrl) + pdscName);
                String cachedFileName = PacksStorage.makeCachedPdscName((String)pdscName, (String)pdscVersion);
                File cachedFile = PacksStorage.getCachedFileObject((String)cachedFileName);
                if (!cachedFile.exists()) {
                    if (ilg.gnuarmeclipse.packs.data.Utils.copyFileWithShell((URL)sourceUrl, (File)cachedFile, (MessageConsoleStream)this.fOut, null, (Shell)this.window.getShell())) {
                        ilg.gnuarmeclipse.packs.data.Utils.reportInfo((String)("File " + pdscName + " version " + pdscVersion + " cached locally."));
                    } else {
                        this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportWarning((String)("Missing \"" + cachedFile + "\", ignored by user request.")));
                        continue;
                    }
                }
                if (cachedFile.exists()) {
                    parser.parseXml(cachedFile);
                    parser.parse(pdscName, pdscVersion, contentRoot);
                } else {
                    this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportWarning((String)("Missing \"" + cachedFile + "\", ignored.")));
                }
            }
            catch (SAXParseException e) {
                String xmsg = "line=" + e.getLineNumber() + ", column=" + e.getColumnNumber() + ", \"" + e.getMessage() + "\"";
                this.fOut.println(String.valueOf(xmsg) + ",  ignored.");
                ilg.gnuarmeclipse.packs.data.Utils.reportWarning((String)("File " + pdscName + " version " + pdscVersion + " parse error (" + xmsg + "), ignored"));
            }
            catch (Exception e) {
                this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportWarning((String)("\"" + e.getMessage() + "\", ignored.")));
                ilg.gnuarmeclipse.packs.data.Utils.reportWarning((String)("File " + pdscName + " version " + pdscVersion + "  error (" + e.getMessage() + "), ignored"));
            }
            this.fMonitor.worked(1);
        }
        if (!this.fMonitor.isCanceled()) {
            try {
                String fileName = this.fRepos.getRepoContentXmlFromUrl(repoUrl);
                ContentSerialiser serialiser = new ContentSerialiser();
                serialiser.serialise(contentRoot, PacksStorage.getFileObject((String)fileName));
                File file = PacksStorage.getFileObject((String)fileName);
                this.fOut.println("File \"" + file.getPath() + "\" written.");
                this.fOut.println();
            }
            catch (IOException e) {
                this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportError((String)e.toString()));
            }
        }
    }

    private void cacheXcdlContent(Map<String, Object> repo) {
        try {
            String contentUrl = (String)repo.get("url");
            String fileName = this.fRepos.getRepoContentXmlFromUrl(contentUrl);
            File cachedFile = PacksStorage.getFileObject((String)fileName);
            ilg.gnuarmeclipse.packs.data.Utils.copyFile((URL)new URL(contentUrl), (File)cachedFile, (MessageConsoleStream)this.fOut, null);
            this.fMonitor.worked(1);
        }
        catch (MalformedURLException e) {
            this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportError((String)e.toString()));
        }
        catch (FileNotFoundException e) {
            this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportError((String)("File not found: " + e.getMessage())));
        }
        catch (IOException e) {
            this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportError((String)e.toString()));
        }
    }
}

