/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.ui.views;

import ilg.gnuarmeclipse.packs.core.ConsoleStream;
import ilg.gnuarmeclipse.packs.core.data.DurationMonitor;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.core.tree.NodeViewContentProvider;
import ilg.gnuarmeclipse.packs.data.DataManager;
import ilg.gnuarmeclipse.packs.data.DataManagerEvent;
import ilg.gnuarmeclipse.packs.data.IDataManagerListener;
import ilg.gnuarmeclipse.packs.ui.Activator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.part.ViewPart;

public class BoardsView
extends ViewPart
implements IDataManagerListener {
    public static final String ID = "ilg.gnuarmeclipse.packs.ui.views.BoardsView";
    private TreeViewer fViewer;
    private Action fRemoveFilters;
    private Action fExpandAll;
    private Action fCollapseAll;
    private ViewContentProvider fContentProvider;
    private DataManager fDataManager;
    private MessageConsoleStream fOut = ConsoleStream.getConsoleOut();

    public BoardsView() {
        this.fDataManager = DataManager.getInstance();
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent, 66306);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fViewer);
        this.fContentProvider = new ViewContentProvider();
        this.fDataManager.addListener((IDataManagerListener)this);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.fViewer.setSorter((ViewerSorter)new NameSorter());
        this.fViewer.setInput((Object)this.getBoardsTree());
        this.addProviders();
        this.addListners();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void dispose() {
        super.dispose();
        this.fDataManager.removeListener((IDataManagerListener)this);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("BoardsView.dispose()");
        }
    }

    private void addProviders() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void addListners() {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BoardsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fExpandAll);
        manager.add((IAction)this.fCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fRemoveFilters);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fRemoveFilters);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fExpandAll);
        manager.add((IAction)this.fCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fRemoveFilters);
    }

    private void makeActions() {
        this.fRemoveFilters = new Action(){

            public void run() {
                BoardsView.this.fViewer.setSelection(null);
            }
        };
        this.fRemoveFilters.setText("Remove filters");
        this.fRemoveFilters.setToolTipText("Remove all filters based on selections");
        this.fRemoveFilters.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"ilg.gnuarmeclipse.packs.ui", (String)"icons/removeall.png"));
        this.fExpandAll = new Action(){

            public void run() {
                BoardsView.this.fViewer.expandAll();
            }
        };
        this.fExpandAll.setText("Expand all");
        this.fExpandAll.setToolTipText("Expand all children nodes");
        this.fExpandAll.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"ilg.gnuarmeclipse.packs.ui", (String)"icons/expandall.png"));
        this.fCollapseAll = new Action(){

            public void run() {
                BoardsView.this.fViewer.collapseAll();
            }
        };
        this.fCollapseAll.setText("Collapse all");
        this.fCollapseAll.setToolTipText("Collapse all children nodes");
        this.fCollapseAll.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"ilg.gnuarmeclipse.packs.ui", (String)"icons/collapseall.png"));
    }

    private void hookDoubleClickAction() {
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void refresh(Object obj) {
        if (obj instanceof Collection) {
            for (Object node : (Collection)obj) {
                this.fViewer.refresh(node);
            }
        } else {
            this.fViewer.refresh(obj);
        }
        this.fViewer.setSelection(this.fViewer.getSelection());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DevicesView.refresh() " + obj);
        }
    }

    public void update(Object obj) {
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object node : list) {
                this.fViewer.update(node, null);
            }
        } else {
            this.fViewer.update(obj, null);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("BoardsView.updated()");
        }
    }

    public String toString() {
        return "BoardsView";
    }

    public void packsChanged(DataManagerEvent event) {
        String type = event.getType();
        if ("new.input".equals(type)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BoardsView.this.fViewer.setInput((Object)BoardsView.this.getBoardsTree());
                }
            });
        } else if ("update.versions".equals(type)) {
            final HashMap<String, Leaf> updatedMap = new HashMap<String, Leaf>();
            this.updateBoardsTree(updatedMap);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BoardsView.this.refresh(updatedMap.values());
                }
            });
        }
    }

    private Node getBoardsTree() {
        final Node packsTree = this.fDataManager.getRepositoriesTree();
        final Node boardsRoot = new Node("root");
        boardsRoot.setName("Boards");
        if (packsTree.hasChildren()) {
            new DurationMonitor().displayTimeAndRun(new Runnable(){

                @Override
                public void run() {
                    BoardsView.this.fOut.println("Collecting boards...");
                    int count = 0;
                    try {
                        count = BoardsView.this.getBoardsRecursive((Leaf)packsTree, boardsRoot, false);
                    }
                    catch (Exception e) {
                        Activator.log((Throwable)e);
                    }
                    if (boardsRoot.hasChildren()) {
                        BoardsView.this.fOut.println("Found " + count + " board(s), from " + boardsRoot.getChildren().size() + " vendor(s).");
                    } else {
                        BoardsView.this.fOut.println("Found none.");
                    }
                }
            });
        }
        if (!boardsRoot.hasChildren()) {
            Node empty = Node.addNewChild((Node)boardsRoot, (String)"none");
            empty.setName("(none)");
        }
        return boardsRoot;
    }

    private int getBoardsRecursive(Leaf node, Node root, boolean isInstalled) {
        int count;
        block5: {
            count = 0;
            String type = node.getType();
            if (!node.hasChildren()) break block5;
            if ("outline".equals(type) || "external".equals(type)) {
                for (Leaf child : ((Node)node).getChildren()) {
                    String childType = child.getType();
                    if (!"board".equals(childType)) continue;
                    count += this.addBoard(child, root, isInstalled);
                }
            } else {
                boolean isVersionInstalled = isInstalled;
                if ("version".equals(type) && node.isBooleanProperty("installed")) {
                    isVersionInstalled = true;
                }
                for (Leaf child : ((Node)node).getChildren()) {
                    count += this.getBoardsRecursive(child, root, isVersionInstalled);
                }
            }
        }
        return count;
    }

    private int addBoard(Leaf node, Node tree, boolean isInstalled) {
        int count = 0;
        String vendorName = node.getProperty("vendor.name");
        Node vendorNode = Node.addUniqueChild((Node)tree, (String)"vendor", (String)vendorName);
        String boardName = node.getName();
        String description = node.getDescription();
        Leaf boardNode = vendorNode.findChild("board", boardName);
        if (boardNode == null) {
            boardNode = Leaf.addNewChild((Node)vendorNode, (String)"board");
            boardNode.setName(boardName);
            boardNode.setDescription(description);
            boardNode.putProperty("vendor.name", vendorName);
            if (isInstalled) {
                boardNode.setBooleanProperty("enabled", true);
            }
            ++count;
        }
        return count;
    }

    private void updateBoardsTree(Map<String, Leaf> updatedList) {
        Node modelTree = this.fDataManager.getRepositoriesTree();
        Node viewTree = (Node)this.fViewer.getInput();
        if (modelTree.hasChildren() && viewTree != null) {
            if (viewTree.hasChildren()) {
                for (Leaf vendor : viewTree.getChildren()) {
                    if (!vendor.hasChildren()) continue;
                    for (Leaf device : ((Node)vendor).getChildren()) {
                        device.setBooleanProperty("enabled", false);
                    }
                }
            }
            this.updateBoardsRecursive((Leaf)modelTree, viewTree, false, updatedList);
        }
    }

    private void updateBoardsRecursive(Leaf modelNode, Node viewTree, boolean isInstalled, Map<String, Leaf> updatedMap) {
        block5: {
            String type = modelNode.getType();
            if (!modelNode.hasChildren()) break block5;
            if ("outline".equals(type) || "external".equals(type)) {
                for (Leaf child : ((Node)modelNode).getChildren()) {
                    String childType = child.getType();
                    if (!"board".equals(childType)) continue;
                    this.updateBoard(child, viewTree, isInstalled, updatedMap);
                }
            } else {
                boolean isVersionInstalled = isInstalled;
                if ("version".equals(type) && modelNode.isBooleanProperty("installed")) {
                    isVersionInstalled = true;
                }
                for (Leaf child : ((Node)modelNode).getChildren()) {
                    this.updateBoardsRecursive(child, viewTree, isVersionInstalled, updatedMap);
                }
            }
        }
    }

    private void updateBoard(Leaf modelFamilyNode, Node viewTree, boolean isInstalled, Map<String, Leaf> updatedList) {
        Leaf boardNode;
        String boardName = modelFamilyNode.getName();
        String vendorName = modelFamilyNode.getProperty("vendor.name");
        Node vendorNode = (Node)viewTree.findChild("vendor", vendorName);
        if (vendorNode == null || !vendorName.equals(vendorNode.getName())) {
            vendorNode = Node.addNewChild((Node)viewTree, (String)"vendor");
            vendorNode.setName(vendorName);
        }
        if ((boardNode = vendorNode.findChild("board", boardName)) == null) {
            boardNode = Leaf.addNewChild((Node)vendorNode, (String)"board");
            boardNode.setName(boardName);
            String description = modelFamilyNode.getDescription();
            boardNode.setDescription(description);
            boardNode.putProperty("vendor.name", vendorName);
        }
        if (isInstalled) {
            boardNode.setBooleanProperty("enabled", true);
            updatedList.put(vendorName, (Leaf)vendorNode);
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    extends NodeViewContentProvider {
        ViewContentProvider() {
        }
    }

    class ViewLabelProvider
    extends CellLabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return " " + ((Leaf)obj).getName();
        }

        public Image getImage(Object obj) {
            Leaf node = (Leaf)obj;
            String type = node.getType();
            if ("vendor".equals(type)) {
                String imageKey = "IMG_OBJ_FOLDER";
                return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
            }
            if ("board".equals(type)) {
                if (node.isBooleanProperty("enabled")) {
                    return Activator.getInstance().getImage("board");
                }
                return Activator.getInstance().getImage("board_grey");
            }
            return null;
        }

        public String getToolTipText(Object obj) {
            String description;
            Leaf node = (Leaf)obj;
            String type = node.getType();
            if ("vendor".equals(type)) {
                return "Vendor";
            }
            if ("board".equals(type) && (description = node.getDescription()) != null && description.length() > 0) {
                return description;
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }
    }
}

