/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.ui.views;

import ilg.gnuarmeclipse.packs.core.ConsoleStream;
import ilg.gnuarmeclipse.packs.core.data.DurationMonitor;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.core.tree.NodeViewContentProvider;
import ilg.gnuarmeclipse.packs.data.DataManager;
import ilg.gnuarmeclipse.packs.data.DataManagerEvent;
import ilg.gnuarmeclipse.packs.data.IDataManagerListener;
import ilg.gnuarmeclipse.packs.ui.Activator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.part.ViewPart;

public class KeywordsView
extends ViewPart
implements IDataManagerListener {
    public static final String ID = "ilg.gnuarmeclipse.packs.ui.views.KeywordsView";
    private TreeViewer fViewer;
    private Action fRemoveFilters;
    private ViewContentProvider fContentProvider;
    private DataManager fDataManager;
    private MessageConsoleStream fOut = ConsoleStream.getConsoleOut();

    public KeywordsView() {
        this.fDataManager = DataManager.getInstance();
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent, 66306);
        this.fContentProvider = new ViewContentProvider();
        this.fDataManager.addListener((IDataManagerListener)this);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.fViewer.setSorter((ViewerSorter)new NameSorter());
        this.fViewer.setInput((Object)this.getKeywordsTree());
        this.addProviders();
        this.addListners();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void dispose() {
        super.dispose();
        this.fDataManager.removeListener((IDataManagerListener)this);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("KeywordsView.dispose()");
        }
    }

    private void addProviders() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void addListners() {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                KeywordsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fRemoveFilters);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fRemoveFilters);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fRemoveFilters);
    }

    private void makeActions() {
        this.fRemoveFilters = new Action(){

            public void run() {
                KeywordsView.this.fViewer.setSelection(null);
            }
        };
        this.fRemoveFilters.setText("Remove filters");
        this.fRemoveFilters.setToolTipText("Remove all filters based on selections");
        this.fRemoveFilters.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"ilg.gnuarmeclipse.packs.ui", (String)"icons/removeall.png"));
    }

    private void hookDoubleClickAction() {
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void update(Object obj) {
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object node : list) {
                this.fViewer.update(node, null);
            }
        } else {
            this.fViewer.update(obj, null);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("KeywordsView.updated()");
        }
    }

    public String toString() {
        return "KeywordsView";
    }

    public void packsChanged(DataManagerEvent event) {
        String type = event.getType();
        if ("new.input".equals(type)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    KeywordsView.this.fViewer.setInput((Object)KeywordsView.this.getKeywordsTree());
                }
            });
        } else {
            "update.versions".equals(type);
        }
    }

    private Node getKeywordsTree() {
        final Node packsTree = this.fDataManager.getRepositoriesTree();
        final Node keywordsRoot = new Node("root");
        if (packsTree.hasChildren()) {
            new DurationMonitor().displayTimeAndRun(new Runnable(){

                @Override
                public void run() {
                    KeywordsView.this.fOut.println("Collecting keywords...");
                    HashSet set = new HashSet();
                    try {
                        KeywordsView.this.getKeywordsRecursive((Leaf)packsTree, set);
                        for (String keywordName : set) {
                            Leaf keywordNode = Leaf.addNewChild((Node)keywordsRoot, (String)"keyword");
                            keywordNode.setName(keywordName);
                        }
                    }
                    catch (Exception e) {
                        Activator.log((Throwable)e);
                    }
                    if (set.size() > 0) {
                        KeywordsView.this.fOut.println("Found " + set.size() + " keyword(s).");
                    } else {
                        KeywordsView.this.fOut.println("Found none.");
                    }
                }
            });
        }
        if (!keywordsRoot.hasChildren()) {
            Node empty = Node.addNewChild((Node)keywordsRoot, (String)"none");
            empty.setName("(none)");
        }
        return keywordsRoot;
    }

    private void getKeywordsRecursive(Leaf node, Set<String> set) {
        block4: {
            String type;
            block3: {
                type = node.getType();
                if (!"outline".equals(type)) break block3;
                if (!node.hasChildren()) break block4;
                for (Leaf child : ((Node)node).getChildren()) {
                    String childType = child.getType();
                    if (!"keyword".equals(childType)) continue;
                    set.add(child.getName());
                }
                break block4;
            }
            if (!"external".equals(type) && node instanceof Node && node.hasChildren()) {
                for (Leaf child : ((Node)node).getChildren()) {
                    this.getKeywordsRecursive(child, set);
                }
            }
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    extends NodeViewContentProvider {
        ViewContentProvider() {
        }
    }

    class ViewLabelProvider
    extends CellLabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return " " + ((Leaf)obj).getName();
        }

        public Image getImage(Object obj) {
            return null;
        }

        public String getToolTipText(Object obj) {
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
        }
    }
}

