/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherForKeyProtector;
import com.sun.crypto.provider.EncryptedPrivateKeyInfo;
import com.sun.crypto.provider.PBEKey;
import com.sun.crypto.provider.PBEWithMD5AndTripleDESCipher;
import com.sun.crypto.provider.PrivateKeyInfo;
import com.sun.crypto.provider.SealedObjectForKeyProtector;
import com.sun.crypto.provider.SunJCE;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.SealedObject;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

final class KeyProtector {
    private static final String PBE_WITH_MD5_AND_DES3_CBC_OID = "1.3.6.1.4.1.42.2.19.1";
    private static final String KEY_PROTECTOR_OID = "1.3.6.1.4.1.42.2.17.1.1";
    private static final int MAX_ITERATION_COUNT = 5000000;
    private static final int ITERATION_COUNT = 200000;
    private static final int SALT_LEN = 20;
    private static final int DIGEST_LEN = 20;
    private char[] password;

    KeyProtector(char[] password) {
        if (password == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        this.password = password;
    }

    byte[] protect(PrivateKey key) throws Exception {
        byte[] salt = new byte[8];
        SunJCE.getRandom().nextBytes(salt);
        PBEParameterSpec pbeSpec = new PBEParameterSpec(salt, 200000);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(this.password);
        PBEKey sKey = new PBEKey(pbeKeySpec, "PBEWithMD5AndTripleDES");
        pbeKeySpec.clearPassword();
        PBEWithMD5AndTripleDESCipher cipher = new PBEWithMD5AndTripleDESCipher();
        cipher.engineInit(1, (Key)sKey, pbeSpec, null);
        byte[] plain = key.getEncoded();
        byte[] encrKey = cipher.engineDoFinal(plain, 0, plain.length);
        AlgorithmParameters pbeParams = AlgorithmParameters.getInstance("PBE", SunJCE.getInstance());
        pbeParams.init(pbeSpec);
        AlgorithmId encrAlg = new AlgorithmId(new ObjectIdentifier(PBE_WITH_MD5_AND_DES3_CBC_OID), pbeParams);
        return new EncryptedPrivateKeyInfo(encrAlg, encrKey).getEncoded();
    }

    Key recover(EncryptedPrivateKeyInfo encrInfo) throws UnrecoverableKeyException, NoSuchAlgorithmException {
        try {
            byte[] plain;
            String encrAlg = encrInfo.getAlgorithm().getOID().toString();
            if (!encrAlg.equals(PBE_WITH_MD5_AND_DES3_CBC_OID) && !encrAlg.equals(KEY_PROTECTOR_OID)) {
                throw new UnrecoverableKeyException("Unsupported encryption algorithm");
            }
            if (encrAlg.equals(KEY_PROTECTOR_OID)) {
                plain = this.recover(encrInfo.getEncryptedData());
            } else {
                byte[] encodedParams = encrInfo.getAlgorithm().getEncodedParams();
                AlgorithmParameters pbeParams = AlgorithmParameters.getInstance("PBE");
                pbeParams.init(encodedParams);
                PBEParameterSpec pbeSpec = pbeParams.getParameterSpec(PBEParameterSpec.class);
                if (pbeSpec.getIterationCount() > 5000000) {
                    throw new IOException("PBE iteration count too large");
                }
                PBEKeySpec pbeKeySpec = new PBEKeySpec(this.password);
                PBEKey sKey = new PBEKey(pbeKeySpec, "PBEWithMD5AndTripleDES");
                pbeKeySpec.clearPassword();
                PBEWithMD5AndTripleDESCipher cipher = new PBEWithMD5AndTripleDESCipher();
                cipher.engineInit(2, (Key)sKey, pbeSpec, null);
                plain = cipher.engineDoFinal(encrInfo.getEncryptedData(), 0, encrInfo.getEncryptedData().length);
            }
            String oidName = new AlgorithmId(new PrivateKeyInfo(plain).getAlgorithm().getOID()).getName();
            KeyFactory kFac = KeyFactory.getInstance(oidName);
            return kFac.generatePrivate(new PKCS8EncodedKeySpec(plain));
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        catch (IOException ioe) {
            throw new UnrecoverableKeyException(ioe.getMessage());
        }
        catch (GeneralSecurityException gse) {
            throw new UnrecoverableKeyException(gse.getMessage());
        }
    }

    private byte[] recover(byte[] protectedKey) throws UnrecoverableKeyException, NoSuchAlgorithmException {
        int i;
        MessageDigest md = MessageDigest.getInstance("SHA");
        byte[] salt = new byte[20];
        System.arraycopy(protectedKey, 0, salt, 0, 20);
        int encrKeyLen = protectedKey.length - 20 - 20;
        int numRounds = encrKeyLen / 20;
        if (encrKeyLen % 20 != 0) {
            ++numRounds;
        }
        byte[] encrKey = new byte[encrKeyLen];
        System.arraycopy(protectedKey, 20, encrKey, 0, encrKeyLen);
        byte[] xorKey = new byte[encrKey.length];
        byte[] passwdBytes = new byte[this.password.length * 2];
        int j = 0;
        for (i = 0; i < this.password.length; ++i) {
            passwdBytes[j++] = (byte)(this.password[i] >> 8);
            passwdBytes[j++] = (byte)this.password[i];
        }
        i = 0;
        int xorOffset = 0;
        byte[] digest = salt;
        while (i < numRounds) {
            md.update(passwdBytes);
            md.update(digest);
            digest = md.digest();
            md.reset();
            if (i < numRounds - 1) {
                System.arraycopy(digest, 0, xorKey, xorOffset, digest.length);
            } else {
                System.arraycopy(digest, 0, xorKey, xorOffset, xorKey.length - xorOffset);
            }
            ++i;
            xorOffset += 20;
        }
        byte[] plainKey = new byte[encrKey.length];
        for (i = 0; i < plainKey.length; ++i) {
            plainKey[i] = (byte)(encrKey[i] ^ xorKey[i]);
        }
        md.update(passwdBytes);
        Arrays.fill(passwdBytes, (byte)0);
        passwdBytes = null;
        md.update(plainKey);
        digest = md.digest();
        md.reset();
        for (i = 0; i < digest.length; ++i) {
            if (digest[i] == protectedKey[20 + encrKeyLen + i]) continue;
            throw new UnrecoverableKeyException("Cannot recover key");
        }
        return plainKey;
    }

    SealedObject seal(Key key) throws Exception {
        byte[] salt = new byte[8];
        SunJCE.getRandom().nextBytes(salt);
        PBEParameterSpec pbeSpec = new PBEParameterSpec(salt, 200000);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(this.password);
        PBEKey sKey = new PBEKey(pbeKeySpec, "PBEWithMD5AndTripleDES");
        pbeKeySpec.clearPassword();
        PBEWithMD5AndTripleDESCipher cipherSpi = new PBEWithMD5AndTripleDESCipher();
        CipherForKeyProtector cipher = new CipherForKeyProtector(cipherSpi, SunJCE.getInstance(), "PBEWithMD5AndTripleDES");
        cipher.init(1, (Key)sKey, pbeSpec);
        return new SealedObjectForKeyProtector(key, cipher);
    }

    Key unseal(SealedObject so) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            PBEParameterSpec pbeSpec;
            PBEKeySpec pbeKeySpec = new PBEKeySpec(this.password);
            PBEKey skey = new PBEKey(pbeKeySpec, "PBEWithMD5AndTripleDES");
            pbeKeySpec.clearPassword();
            SealedObjectForKeyProtector soForKeyProtector = null;
            soForKeyProtector = !(so instanceof SealedObjectForKeyProtector) ? new SealedObjectForKeyProtector(so) : (SealedObjectForKeyProtector)so;
            AlgorithmParameters params = soForKeyProtector.getParameters();
            if (params == null) {
                throw new UnrecoverableKeyException("Cannot get algorithm parameters");
            }
            try {
                pbeSpec = params.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new IOException("Invalid PBE algorithm parameters");
            }
            if (pbeSpec.getIterationCount() > 5000000) {
                throw new IOException("PBE iteration count too large");
            }
            PBEWithMD5AndTripleDESCipher cipherSpi = new PBEWithMD5AndTripleDESCipher();
            CipherForKeyProtector cipher = new CipherForKeyProtector(cipherSpi, SunJCE.getInstance(), "PBEWithMD5AndTripleDES");
            cipher.init(2, (Key)skey, params);
            return (Key)soForKeyProtector.getObject(cipher);
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        catch (IOException ioe) {
            throw new UnrecoverableKeyException(ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnrecoverableKeyException(cnfe.getMessage());
        }
        catch (GeneralSecurityException gse) {
            throw new UnrecoverableKeyException(gse.getMessage());
        }
    }
}

