/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import java.util.Iterator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.Messages;
import org.eclipse.mylyn.wikitext.ui.viewer.HtmlTextPresenter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class TextHover
extends DefaultTextHover
implements ITextHoverExtension {
    private final ISourceViewer sourceViewer;

    public TextHover(ISourceViewer sourceViewer) {
        super(sourceViewer);
        this.sourceViewer = sourceViewer;
    }

    protected boolean isIncluded(Annotation annotation) {
        return annotation.getType().equals("org.eclipse.mylyn.wikitext.ui.annotation.title") || annotation.getType().equals("org.eclipse.mylyn.wikitext.ui.annotation.anchor");
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
        if (annotationModel != null) {
            int start = Integer.MAX_VALUE;
            int end = -1;
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation next = (Annotation)iterator.next();
                Position position = annotationModel.getPosition(next);
                if (position.getOffset() > offset || position.getLength() + position.getOffset() < offset) continue;
                start = Math.min(start, position.getOffset());
                end = Math.max(end, position.getOffset() + position.getLength());
            }
            if (start <= end && end > -1) {
                return new Region(start, end - start);
            }
        }
        return super.getHoverRegion(textViewer, offset);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                String tooltipAffordanceString = null;
                try {
                    tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
                }
                catch (Exception exception) {}
                return new DefaultInformationControl(parent, 0, new HtmlTextPresenter(), tooltipAffordanceString){

                    public void setLocation(Point location) {
                        Point cursorLocation = Display.getCurrent().getCursorLocation();
                        if (cursorLocation.y + 12 >= location.y) {
                            location.y = cursorLocation.y + 13;
                        }
                        super.setLocation(location);
                    }
                };
            }
        };
    }

    private IAnnotationModel getAnnotationModel(ISourceViewer viewer) {
        if (viewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 extension = (ISourceViewerExtension2)viewer;
            return extension.getVisualAnnotationModel();
        }
        return viewer.getAnnotationModel();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IAnnotationModel model = this.getAnnotationModel(this.sourceViewer);
        if (model == null) {
            return null;
        }
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            String msg;
            Position p;
            Annotation a = (Annotation)e.next();
            if (!this.isIncluded(a) || (p = model.getPosition(a)) == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = a.getText()) == null || msg.trim().length() <= 0) continue;
            if (a.getType().equals("org.eclipse.mylyn.wikitext.ui.annotation.anchor")) {
                if (msg.startsWith("#")) {
                    return null;
                }
                return NLS.bind((String)Messages.TextHover_hyperlinkHover, (Object)msg);
            }
            return msg;
        }
        return null;
    }
}

