/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.managedbuild.cross.ui;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.managedbuild.cross.ui.DefaultPreferences;
import org.eclipse.cdt.core.templateengine.SharedDefaults;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PersistentPreferences {
    public static final String TOOLCHAIN_NAME_KEY = "toolchain.name";
    private static final String TOOLCHAIN_PATH_KEY = "toolchain.path.%d";
    private static final String TOOLCHAIN_SEARCH_PATH_KEY = "toolchain.search.path.%d";
    private static final String TOOLCHAIN_SEARCH_PATH_OS_KEY = "toolchain.search.path.%s.%d";
    public static final String BUILD_TOOLS_PATH_KEY = "buildTools.path";
    public static final String GLOBAL_TOOLCHAIN_PATH_STRICT = "global.toolchain.path.strict";
    public static final String GLOBAL_BUILDTOOLS_PATH_STRICT = "global.buildTools.path.strict";
    public static final String WORKSPACE_TOOLCHAIN_PATH_STRICT = "workspace.toolchain.path.strict";
    public static final String WORKSPACE_BUILDTOOLS_PATH_STRICT = "workspace.buildTools.path.strict";
    public static final String PROJECT_TOOLCHAIN_PATH_STRICT = "project.toolchain.path.strict";
    public static final String PROJECT_BUILDTOOLS_PATH_STRICT = "project.buildTools.path.strict";

    private static String getString(String key, String defaultValue, IProject project) {
        String value = EclipseUtils.getPreferenceValueForId((String)"ilg.gnuarmeclipse.managedbuild.cross", (String)key, null, (IProject)project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        value = (String)SharedDefaults.getInstance().getSharedDefaultsMap().get("ilg.gnuarmeclipse.managedbuild.cross." + key);
        if (value == null) {
            value = "";
        }
        if (!(value = value.trim()).isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    private static String getEclipseString(String key, String defaultValue) {
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode("ilg.gnuarmeclipse.managedbuild.cross");
        String value = preferences.get(key, defaultValue);
        return value;
    }

    private static String getWorkspaceString(String key, String defaultValue) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("ilg.gnuarmeclipse.managedbuild.cross");
        String value = preferences.get(key, defaultValue);
        return value;
    }

    private static void putString(String key, String value) {
        String oldValue = PersistentPreferences.getWorkspaceString(key, null);
        if (oldValue != null) {
            PersistentPreferences.putWorkspaceString(key, value);
        } else {
            PersistentPreferences.putEclipseString(key, value);
        }
    }

    private static void putEclipseString(String key, String value) {
        value = value.trim();
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode("ilg.gnuarmeclipse.managedbuild.cross");
        preferences.put(key, value);
    }

    private static void putWorkspaceString(String key, String value) {
        value = value.trim();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("ilg.gnuarmeclipse.managedbuild.cross");
        preferences.put(key, value);
    }

    public static void flush() {
        try {
            ConfigurationScope.INSTANCE.getNode("ilg.gnuarmeclipse.managedbuild.cross").flush();
            InstanceScope.INSTANCE.getNode("ilg.gnuarmeclipse.managedbuild.cross").flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private static void putProjectString(String key, String value, IProject project) {
        value = value.trim();
        IEclipsePreferences preferences = new ProjectScope(project).getNode("ilg.gnuarmeclipse.managedbuild.cross");
        preferences.put(key, value);
    }

    public static void flush(IProject project) {
        try {
            new ProjectScope(project).getNode("ilg.gnuarmeclipse.managedbuild.cross").flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static String getToolchainName() {
        String toolchainName = PersistentPreferences.getString(TOOLCHAIN_NAME_KEY, null, null);
        if (toolchainName != null && !toolchainName.isEmpty()) {
            return toolchainName;
        }
        toolchainName = DefaultPreferences.getToolchainName();
        return toolchainName;
    }

    public static void putToolchainName(String toolchainName) {
        PersistentPreferences.putString(TOOLCHAIN_NAME_KEY, toolchainName);
    }

    public static String getToolchainKey(String toolchainName) {
        int hash = Math.abs(toolchainName.trim().hashCode());
        String key = String.format(TOOLCHAIN_PATH_KEY, hash);
        return key;
    }

    public static String getToolchainPath(String toolchainName, IProject project) {
        String value = PersistentPreferences.getString(PersistentPreferences.getToolchainKey(toolchainName), null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        value = "";
        value = DefaultPreferences.getToolchainPath(toolchainName);
        return value;
    }

    public static void putToolchainPath(String toolchainName, String path) {
        PersistentPreferences.putString(PersistentPreferences.getToolchainKey(toolchainName), path);
    }

    public static void putToolchainPath(String toolchainName, String path, IProject project) {
        PersistentPreferences.putProjectString(PersistentPreferences.getToolchainKey(toolchainName), path, project);
    }

    public static String getToolchainSearchKey(String toolchainName) {
        int hash = Math.abs(toolchainName.trim().hashCode());
        String key = String.format(TOOLCHAIN_SEARCH_PATH_KEY, hash);
        return key;
    }

    public static String getToolchainSearchOsKey(String toolchainName) {
        int hash = Math.abs(toolchainName.trim().hashCode());
        String os = EclipseUtils.getOsFamily();
        String key = String.format(TOOLCHAIN_SEARCH_PATH_OS_KEY, os, hash);
        return key;
    }

    public static String getBuildToolsPath(IProject project) {
        return PersistentPreferences.getString(BUILD_TOOLS_PATH_KEY, "", project);
    }
}

