/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import sun.awt.AppContext;
import sun.swing.plaf.synth.Paint9Painter;

class ImagePainter
extends SynthPainter {
    private static final StringBuffer CACHE_KEY = new StringBuffer("SynthCacheKey");
    private Image image;
    private Insets sInsets;
    private Insets dInsets;
    private URL path;
    private boolean tiles;
    private boolean paintCenter;
    private Paint9Painter imageCache;
    private boolean center;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Paint9Painter getPaint9Painter() {
        StringBuffer stringBuffer = CACHE_KEY;
        synchronized (stringBuffer) {
            Paint9Painter painter;
            WeakReference<Paint9Painter> cacheRef = (WeakReference<Paint9Painter>)AppContext.getAppContext().get(CACHE_KEY);
            if (cacheRef == null || (painter = (Paint9Painter)cacheRef.get()) == null) {
                painter = new Paint9Painter(30);
                cacheRef = new WeakReference<Paint9Painter>(painter);
                AppContext.getAppContext().put(CACHE_KEY, cacheRef);
            }
            return painter;
        }
    }

    ImagePainter(boolean tiles, boolean paintCenter, Insets sourceInsets, Insets destinationInsets, URL path, boolean center) {
        if (sourceInsets != null) {
            this.sInsets = (Insets)sourceInsets.clone();
        }
        this.dInsets = destinationInsets == null ? this.sInsets : (Insets)destinationInsets.clone();
        this.tiles = tiles;
        this.paintCenter = paintCenter;
        this.imageCache = ImagePainter.getPaint9Painter();
        this.path = path;
        this.center = center;
    }

    public boolean getTiles() {
        return this.tiles;
    }

    public boolean getPaintsCenter() {
        return this.paintCenter;
    }

    public boolean getCenter() {
        return this.center;
    }

    public Insets getInsets(Insets insets) {
        if (insets == null) {
            return (Insets)this.dInsets.clone();
        }
        insets.left = this.dInsets.left;
        insets.right = this.dInsets.right;
        insets.top = this.dInsets.top;
        insets.bottom = this.dInsets.bottom;
        return insets;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = new ImageIcon(this.path, null).getImage();
        }
        return this.image;
    }

    private void paint(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Image image = this.getImage();
        if (Paint9Painter.validImage(image)) {
            Paint9Painter.PaintType type = this.getCenter() ? Paint9Painter.PaintType.CENTER : (!this.getTiles() ? Paint9Painter.PaintType.PAINT9_STRETCH : Paint9Painter.PaintType.PAINT9_TILE);
            int mask = 512;
            if (!this.getCenter() && !this.getPaintsCenter()) {
                mask |= 0x10;
            }
            this.imageCache.paint((Component)context.getComponent(), g, x, y, w, h, image, this.sInsets, this.dInsets, type, mask);
        }
    }

    @Override
    public void paintArrowButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintArrowButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintArrowButtonForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintCheckBoxMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintCheckBoxMenuItemBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintCheckBoxBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintCheckBoxBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintColorChooserBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintColorChooserBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintComboBoxBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintComboBoxBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintDesktopIconBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintDesktopIconBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintDesktopPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintDesktopPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintEditorPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintEditorPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintFileChooserBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintFileChooserBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintFormattedTextFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintFormattedTextFieldBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintInternalFrameTitlePaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintInternalFrameTitlePaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintInternalFrameBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintInternalFrameBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintLabelBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintLabelBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintListBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintListBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintMenuBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintMenuBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintMenuItemBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintMenuBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintMenuBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintOptionPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintOptionPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintPanelBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintPanelBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintPasswordFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintPasswordFieldBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintPopupMenuBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintPopupMenuBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintProgressBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintProgressBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintProgressBarForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintRadioButtonMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintRadioButtonMenuItemBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintRadioButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintRadioButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintRootPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintRootPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarThumbBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarThumbBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSeparatorBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSeparatorBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSeparatorBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSeparatorBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSeparatorForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSliderBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSliderBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSliderBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSliderBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSliderThumbBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSliderThumbBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSliderTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSliderTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSliderTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSliderTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSpinnerBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSpinnerBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSplitPaneDividerBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSplitPaneDividerBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSplitPaneDividerForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSplitPaneDragDivider(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSplitPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintSplitPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabAreaBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabAreaBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneContentBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTableHeaderBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTableHeaderBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTableBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTableBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTextAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTextAreaBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTextPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTextPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTextFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTextFieldBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToggleButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToggleButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarContentBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarContentBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarDragWindowBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarDragWindowBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarDragWindowBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolBarDragWindowBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolTipBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintToolTipBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTreeBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTreeBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTreeCellBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTreeCellBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintTreeCellFocus(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintViewportBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }

    @Override
    public void paintViewportBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paint(context, g, x, y, w, h);
    }
}

