/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class AuthList {
    private final LinkedList<AuthTimeWithHash> entries;
    private final int lifespan;

    public AuthList(int lifespan) {
        this.lifespan = lifespan;
        this.entries = new LinkedList();
    }

    public void put(AuthTimeWithHash t, KerberosTime currentTime) throws KrbApErrException {
        ListIterator<AuthTimeWithHash> it;
        if (this.entries.isEmpty()) {
            this.entries.addFirst(t);
        } else {
            AuthTimeWithHash temp = this.entries.getFirst();
            int cmp = temp.compareTo(t);
            if (cmp < 0) {
                this.entries.addFirst(t);
            } else {
                if (cmp == 0) {
                    throw new KrbApErrException(34);
                }
                it = this.entries.listIterator(1);
                boolean found = false;
                while (it.hasNext()) {
                    temp = it.next();
                    cmp = temp.compareTo(t);
                    if (cmp < 0) {
                        this.entries.add(this.entries.indexOf(temp), t);
                        found = true;
                        break;
                    }
                    if (cmp != 0) continue;
                    throw new KrbApErrException(34);
                }
                if (!found) {
                    this.entries.addLast(t);
                }
            }
        }
        long timeLimit = currentTime.getSeconds() - this.lifespan;
        it = this.entries.listIterator(0);
        AuthTimeWithHash temp = null;
        int index = -1;
        while (it.hasNext()) {
            temp = it.next();
            if ((long)temp.ctime >= timeLimit) continue;
            index = this.entries.indexOf(temp);
            break;
        }
        if (index > -1) {
            do {
                this.entries.removeLast();
            } while (this.entries.size() > index);
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<AuthTimeWithHash> iter = this.entries.descendingIterator();
        int pos = this.entries.size();
        while (iter.hasNext()) {
            AuthTimeWithHash at = iter.next();
            sb.append('#').append(pos--).append(": ").append(at.toString()).append('\n');
        }
        return sb.toString();
    }
}

