/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs10;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Base64;
import sun.security.pkcs10.PKCS10Attributes;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509Key;

public class PKCS10 {
    private X500Name subject;
    private PublicKey subjectPublicKeyInfo;
    private String sigAlg;
    private PKCS10Attributes attributeSet;
    private byte[] encoded;

    public PKCS10(PublicKey publicKey) {
        this.subjectPublicKeyInfo = publicKey;
        this.attributeSet = new PKCS10Attributes();
    }

    public PKCS10(PublicKey publicKey, PKCS10Attributes attributes) {
        this.subjectPublicKeyInfo = publicKey;
        this.attributeSet = attributes;
    }

    public PKCS10(byte[] data) throws IOException, SignatureException, NoSuchAlgorithmException {
        this.encoded = data;
        DerInputStream in = new DerInputStream(data);
        DerValue[] seq = in.getSequence(3);
        if (seq.length != 3) {
            throw new IllegalArgumentException("not a PKCS #10 request");
        }
        data = seq[0].toByteArray();
        AlgorithmId id = AlgorithmId.parse(seq[1]);
        byte[] sigData = seq[2].getBitString();
        BigInteger serial = seq[0].data.getBigInteger();
        if (!serial.equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("not PKCS #10 v1");
        }
        this.subject = new X500Name(seq[0].data);
        this.subjectPublicKeyInfo = X509Key.parse(seq[0].data.getDerValue());
        this.attributeSet = seq[0].data.available() != 0 ? new PKCS10Attributes(seq[0].data) : new PKCS10Attributes();
        if (seq[0].data.available() != 0) {
            throw new IllegalArgumentException("illegal PKCS #10 data");
        }
        try {
            this.sigAlg = id.getName();
            Signature sig = Signature.getInstance(this.sigAlg);
            sig.initVerify(this.subjectPublicKeyInfo);
            sig.update(data);
            if (!sig.verify(sigData)) {
                throw new SignatureException("Invalid PKCS #10 signature");
            }
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("invalid key");
        }
    }

    public void encodeAndSign(X500Name subject, Signature signature) throws CertificateException, IOException, SignatureException {
        if (this.encoded != null) {
            throw new SignatureException("request is already signed");
        }
        this.subject = subject;
        DerOutputStream scratch = new DerOutputStream();
        scratch.putInteger(BigInteger.ZERO);
        subject.encode(scratch);
        scratch.write(this.subjectPublicKeyInfo.getEncoded());
        this.attributeSet.encode(scratch);
        DerOutputStream out = new DerOutputStream();
        out.write((byte)48, scratch);
        byte[] certificateRequestInfo = out.toByteArray();
        scratch = out;
        signature.update(certificateRequestInfo, 0, certificateRequestInfo.length);
        byte[] sig = signature.sign();
        this.sigAlg = signature.getAlgorithm();
        AlgorithmId algId = null;
        try {
            algId = AlgorithmId.get(signature.getAlgorithm());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SignatureException(nsae);
        }
        algId.encode(scratch);
        scratch.putBitString(sig);
        out = new DerOutputStream();
        out.write((byte)48, scratch);
        this.encoded = out.toByteArray();
    }

    public X500Name getSubjectName() {
        return this.subject;
    }

    public PublicKey getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public String getSigAlg() {
        return this.sigAlg;
    }

    public PKCS10Attributes getAttributes() {
        return this.attributeSet;
    }

    public byte[] getEncoded() {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        return null;
    }

    public void print(PrintStream out) throws IOException, SignatureException {
        if (this.encoded == null) {
            throw new SignatureException("Cert request was not signed");
        }
        byte[] CRLF = new byte[]{13, 10};
        out.println("-----BEGIN NEW CERTIFICATE REQUEST-----");
        out.println(Base64.getMimeEncoder(64, CRLF).encodeToString(this.encoded));
        out.println("-----END NEW CERTIFICATE REQUEST-----");
    }

    public String toString() {
        return "[PKCS #10 certificate request:\n" + this.subjectPublicKeyInfo.toString() + " subject: <" + this.subject + ">\n attributes: " + this.attributeSet.toString() + "\n]";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PKCS10)) {
            return false;
        }
        if (this.encoded == null) {
            return false;
        }
        byte[] otherEncoded = ((PKCS10)other).getEncoded();
        if (otherEncoded == null) {
            return false;
        }
        return Arrays.equals(this.encoded, otherEncoded);
    }

    public int hashCode() {
        int retval = 0;
        if (this.encoded != null) {
            for (int i = 1; i < this.encoded.length; ++i) {
                retval += this.encoded[i] * i;
            }
        }
        return retval;
    }
}

