/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners;

import java.text.MessageFormat;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.Messages;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners.ToolTipChartMouseMoveListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Chart;
import org.swtchart.ISeries;

public class ChartWithAxisMouseMoveListener
extends ToolTipChartMouseMoveListener {
    private static final double DIST_TOLERANCE = 20.0;

    public ChartWithAxisMouseMoveListener(Chart chart, Composite hoverArea) {
        super(chart, hoverArea);
    }

    @Override
    public void mouseMove(MouseEvent e) {
        super.mouseMove(e);
        double closestDistance = 20.0;
        int closestIndex = -1;
        ISeries closestSeries = null;
        Point closestPoint = null;
        ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            int i = 0;
            while (i < series.getXSeries().length) {
                double dist;
                Point dataPoint = series.getPixelCoordinates(i);
                if (dataPoint.x >= 0 && dataPoint.y >= 0 && (dist = Math.sqrt(Math.pow(dataPoint.x - e.x, 2.0) + Math.pow(dataPoint.y - e.y, 2.0))) < closestDistance) {
                    closestDistance = dist;
                    closestIndex = i;
                    closestSeries = series;
                    closestPoint = dataPoint;
                }
                ++i;
            }
            ++n2;
        }
        if (closestPoint != null) {
            this.setTextTip(MessageFormat.format(Messages.AbstractChartWithAxisBuilder_ToolTipCoords, closestSeries.getId(), closestSeries.getXSeries()[closestIndex], closestSeries.getYSeries()[closestIndex]));
        } else {
            this.tipShell.setVisible(false);
        }
    }
}

