/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.widgets;

import org.eclipse.linuxtools.systemtap.graphing.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.GraphComposite;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;

public class GraphContinuousYControl
extends Composite {
    private static final int CLICK_INCREMENT = 10;
    private static final double TOLERANCE = 0.01;
    private AbstractChartBuilder builder;
    private Scale zoomScale;
    private Slider scrollBar;

    public GraphContinuousYControl(GraphComposite comp, int style) {
        super((Composite)comp, style);
        this.builder = comp.getCanvas();
        this.setLayout((Layout)new FormLayout());
        Font font = new Font((Device)comp.getDisplay(), "Arial", 10, 1);
        FormData thisData = new FormData();
        thisData.left = new FormAttachment(0, 0);
        thisData.top = new FormAttachment((Control)this.builder, 0, 128);
        thisData.bottom = new FormAttachment((Control)this.builder, 0, 1024);
        this.setLayoutData(thisData);
        Button zoomOutButton = new Button((Composite)this, 0x1000000);
        zoomOutButton.setText(Messages.GraphContinuousControl_ZoomOutLabel);
        zoomOutButton.setToolTipText(Messages.GraphContinuousYControl_ZoomOutTooltip);
        zoomOutButton.setFont(font);
        FormData data = new FormData();
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        zoomOutButton.setLayoutData((Object)data);
        zoomOutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphContinuousYControl.this.zoomScale.setSelection(GraphContinuousYControl.this.zoomScale.getSelection() + 10);
                GraphContinuousYControl.this.updateScaleY();
            }
        });
        Button zoomInButton = new Button((Composite)this, 0x1000000);
        zoomInButton.setText(Messages.GraphContinuousControl_ZoomInLabel);
        zoomInButton.setToolTipText(Messages.GraphContinuousYControl_ZoomInTooltip);
        zoomInButton.setFont(font);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = ((FormData)zoomOutButton.getLayoutData()).left;
        zoomInButton.setLayoutData((Object)data);
        zoomInButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphContinuousYControl.this.zoomScale.setSelection(GraphContinuousYControl.this.zoomScale.getSelection() - 10);
                GraphContinuousYControl.this.updateScaleY();
            }
        });
        this.zoomScale = new Scale((Composite)this, 512);
        this.zoomScale.setMinimum(1);
        this.zoomScale.setMaximum(100);
        this.zoomScale.setIncrement(1);
        this.zoomScale.setPageIncrement(10);
        this.zoomScale.setSelection(100);
        this.zoomScale.setToolTipText(Messages.GraphContinuousYControl_ScaleMessage);
        data = new FormData();
        data.top = new FormAttachment((Control)zoomInButton, 2);
        data.left = ((FormData)zoomInButton.getLayoutData()).left;
        data.bottom = new FormAttachment((Control)zoomOutButton, -2);
        this.zoomScale.setLayoutData((Object)data);
        this.scrollBar = new Slider((Composite)this, 512);
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(101);
        this.scrollBar.setThumb(100);
        this.scrollBar.setIncrement(1);
        this.scrollBar.setPageIncrement(1);
        this.scrollBar.setSelection(0);
        this.scrollBar.setToolTipText(Messages.GraphContinuousYControl_ScrollMessage);
        data = new FormData();
        data.top = new FormAttachment((Control)zoomInButton, 0);
        data.left = new FormAttachment((Control)this.zoomScale, 0);
        data.bottom = new FormAttachment((Control)zoomOutButton, 0);
        this.scrollBar.setLayoutData((Object)data);
        this.zoomScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphContinuousYControl.this.updateScaleY();
            }
        });
        this.scrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphContinuousYControl.this.updateScrollY();
            }
        });
        this.updateScaleY();
        this.updateScrollY();
    }

    private void updateScaleY() {
        double newscale = (double)this.zoomScale.getSelection() / 100.0;
        if (Math.abs(this.builder.getScaleY() - newscale) >= 0.01) {
            this.builder.setScaleY(newscale);
            this.scrollBar.setThumb((int)(newscale * 100.0));
            this.scrollBar.setSelection((int)((1.0 - this.builder.getScrollY()) * (double)(101 - this.scrollBar.getThumb())));
        }
    }

    private void updateScrollY() {
        double newscroll = 1.0 - (double)this.scrollBar.getSelection() / (101.0 - (double)this.scrollBar.getThumb());
        if (Math.abs(this.builder.getScrollY() - newscroll) >= 0.01) {
            this.builder.setScrollY(newscroll);
        }
    }
}

