/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event;

import org.eclipse.tracecompass.common.core.NonNullUtils;

public class CTFCallsite
implements Comparable<CTFCallsite> {
    private static final int INT_BITS = 32;
    private static final long INT_MASK = 0xFFFFFFFFL;
    private final String fEventName;
    private final String fFileName;
    private final long fIp;
    private final String fFunctionName;
    private final long fLineNumber;

    public CTFCallsite(String en, String func, long ip, String fn, long line) {
        this.fEventName = en;
        this.fFileName = fn;
        this.fFunctionName = func;
        this.fIp = ip;
        this.fLineNumber = line;
    }

    public String getEventName() {
        return this.fEventName;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public long getIp() {
        return this.fIp;
    }

    public String getFunctionName() {
        return this.fFunctionName;
    }

    public long getLineNumber() {
        return this.fLineNumber;
    }

    @Override
    public int compareTo(CTFCallsite o) {
        long other = o.fIp;
        long otherHigh = other >> 32 & 0xFFFFFFFFL;
        long otherLow = other & 0xFFFFFFFFL;
        long ownHigh = this.fIp >> 32 & 0xFFFFFFFFL;
        long ownLow = this.fIp & 0xFFFFFFFFL;
        if (ownHigh > otherHigh) {
            return 1;
        }
        if (ownHigh < otherHigh) {
            return -1;
        }
        if (ownLow > otherLow) {
            return 1;
        }
        if (ownLow < otherLow) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fEventName == null ? 0 : this.fEventName.hashCode());
        result = 31 * result + (this.fFileName == null ? 0 : this.fFileName.hashCode());
        result = 31 * result + (this.fFunctionName == null ? 0 : this.fFunctionName.hashCode());
        result = 31 * result + (int)(this.fIp ^ this.fIp >>> 32);
        result = 31 * result + (int)(this.fLineNumber ^ this.fLineNumber >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CTFCallsite other = (CTFCallsite)obj;
        if (!NonNullUtils.equalsNullable((Object)this.fEventName, (Object)other.fEventName)) {
            return false;
        }
        if (!NonNullUtils.equalsNullable((Object)this.fFileName, (Object)other.fFileName)) {
            return false;
        }
        if (!NonNullUtils.equalsNullable((Object)this.fFunctionName, (Object)other.fFunctionName)) {
            return false;
        }
        if (this.fIp != other.fIp) {
            return false;
        }
        return this.fLineNumber == other.fLineNumber;
    }

    public String toString() {
        return String.valueOf(this.fFileName) + "/" + this.fFunctionName + ":" + this.fLineNumber;
    }
}

