/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;

public class CLICatchInfo
extends MIInfo {
    MIBreakpoint[] breakpoints;

    public CLICatchInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    protected void parse() {
        block5: {
            ArrayList aList = new ArrayList();
            try {
                if (!this.isDone()) break block5;
                MIOutput out = this.getMIOutput();
                MIOOBRecord[] oobs = out.getMIOOBRecords();
                int i = 0;
                while (i < oobs.length) {
                    MIStreamRecord cons;
                    String str;
                    if (oobs[i] instanceof MIConsoleStreamOutput && this.parseCatchpoint((str = (cons = (MIStreamRecord)oobs[i]).getString()).trim(), aList)) {
                        break;
                    }
                    ++i;
                }
            }
            finally {
                this.breakpoints = aList.toArray(new MIBreakpoint[aList.size()]);
            }
        }
    }

    private boolean parseCatchpoint(String str, List aList) {
        if (str.length() == 0) {
            return false;
        }
        if (str.startsWith("Catchpoint ")) {
            int bn = 0;
            StringTokenizer tokenizer = new StringTokenizer(str);
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String sub = tokenizer.nextToken();
                switch (i) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bn = Integer.parseInt(sub);
                    }
                }
                ++i;
            }
            MITuple tuple = new MITuple();
            MIBreakpoint m = new MIBreakpoint(tuple);
            m.setNumber(bn);
            aList.add(m);
            return true;
        }
        return false;
    }

    public MIBreakpoint[] getMIBreakpoints() {
        if (this.breakpoints == null) {
            this.parse();
        }
        return this.breakpoints;
    }
}

