/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.SystemTapRegexGenerator;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.SystemTapScriptLaunchConfigurationTab;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IFilteredDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.row.LineParser;
import org.eclipse.linuxtools.systemtap.graphing.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.graphing.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.graphing.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.graphing.ui.wizards.graph.SelectGraphAndSeriesWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SystemTapScriptGraphOptionsTab
extends AbstractLaunchConfigurationTab {
    static final int MAX_NUMBER_OF_REGEXS = 20;
    static final int MAX_REGEX_LENGTH = 200;
    static final String RUN_WITH_CHART = "runWithChart";
    static final String NUMBER_OF_REGEXS = "numberOfRegexs";
    static final String NUMBER_OF_COLUMNS = "numberOfColumns_";
    static final String REGEX_BOX = "regexBox_";
    static final String NUMBER_OF_EXTRAS = "numberOfExtras_";
    static final String EXTRA_BOX = "extraBox_";
    static final String REGULAR_EXPRESSION = "regularExpression_";
    static final String SAMPLE_OUTPUT = "sampleOutput_";
    private static final String NUMBER_OF_GRAPHS = "numberOfGraphs";
    private static final String GRAPH_TITLE = "graphTitle";
    private static final String GRAPH_KEY = "graphKey";
    private static final String GRAPH_X_SERIES = "graphXSeries";
    private static final String GRAPH_ID = "graphID";
    private static final String GRAPH_Y_SERIES_LENGTH = "graphYSeriesLength";
    private static final String GRAPH_Y_SERIES = "graphYSeries";
    protected Pattern pattern;
    protected Matcher matcher;
    private Combo regularExpressionCombo;
    private Button removeRegexButton;
    private Text sampleOutputText;
    private Composite textFieldsComposite;
    private boolean textListenersEnabled = true;
    private Group outputParsingGroup;
    private Button runWithChartCheckButton;
    private Table graphsTable;
    private Button addGraphButton;
    private Button duplicateGraphButton;
    private Button editGraphButton;
    private Button removeGraphButton;
    private TableItem selectedTableItem;
    private Group graphsGroup;
    private int numberOfVisibleColumns = 0;
    private boolean graphingEnabled = true;
    private List<String> regexErrorMessages = new ArrayList<String>();
    private int selectedRegex = -1;
    private List<String> outputList = new ArrayList<String>();
    private Stack<String> cachedNames = new Stack();
    private List<Stack<String>> cachedNamesList = new ArrayList<Stack<String>>();
    private List<List<String>> columnNamesList = new ArrayList<List<String>>();
    private List<GraphData> graphsData = new LinkedList<GraphData>();
    private List<LinkedList<GraphData>> graphsDataList = new ArrayList<LinkedList<GraphData>>();
    private List<GraphData> badGraphs = new LinkedList<GraphData>();
    private ModifyListener regexListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (!SystemTapScriptGraphOptionsTab.this.textListenersEnabled || SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.getSelectionIndex() != -1) {
                return;
            }
            SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.setItem(SystemTapScriptGraphOptionsTab.this.selectedRegex, SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.getText());
            SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.select(SystemTapScriptGraphOptionsTab.this.selectedRegex);
            SystemTapScriptGraphOptionsTab.this.refreshRegexRows();
            SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };
    private ModifyListener sampleOutputListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (!SystemTapScriptGraphOptionsTab.this.textListenersEnabled) {
                return;
            }
            SystemTapScriptGraphOptionsTab.this.outputList.set(SystemTapScriptGraphOptionsTab.this.selectedRegex, SystemTapScriptGraphOptionsTab.this.sampleOutputText.getText());
            SystemTapScriptGraphOptionsTab.this.refreshRegexRows();
            SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };
    private ModifyListener columnNameListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (!SystemTapScriptGraphOptionsTab.this.textListenersEnabled) {
                return;
            }
            ArrayList<String> columnNames = new ArrayList<String>();
            Control[] children = SystemTapScriptGraphOptionsTab.this.textFieldsComposite.getChildren();
            int i = 0;
            while (i < SystemTapScriptGraphOptionsTab.this.numberOfVisibleColumns) {
                columnNames.add(((Text)children[i * 4 + 2]).getText());
                ++i;
            }
            SystemTapScriptGraphOptionsTab.this.columnNamesList.set(SystemTapScriptGraphOptionsTab.this.selectedRegex, columnNames);
            SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };
    private SelectionAdapter regexGenerator = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IPath scriptPath = null;
            ILaunchConfigurationTab[] iLaunchConfigurationTabArray = SystemTapScriptGraphOptionsTab.this.getLaunchConfigurationDialog().getTabs();
            int n = iLaunchConfigurationTabArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
                if (tab instanceof SystemTapScriptLaunchConfigurationTab) {
                    scriptPath = ((SystemTapScriptLaunchConfigurationTab)tab).getScriptPath();
                    break;
                }
                ++n2;
            }
            if (scriptPath == null) {
                MessageDialog dialog = new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsErrorTitle, null, Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsError, 1, new String[]{"OK"}, 0);
                dialog.open();
                return;
            }
            MessageDialog dialog = new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsTitle, null, Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsMessage, 3, new String[]{"Yes", "Cancel"}, 0);
            int result = dialog.open();
            if (result != 0) {
                return;
            }
            List<Map.Entry<String, Integer>> regexs = SystemTapRegexGenerator.generateFromPrintf(scriptPath, 20);
            if (regexs.size() == 0) {
                dialog = new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsErrorTitle, null, Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsEmpty, 1, new String[]{"OK"}, 0);
                dialog.open();
            } else {
                SystemTapScriptGraphOptionsTab.this.textListenersEnabled = false;
                SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.removeAll();
                SystemTapScriptGraphOptionsTab.this.outputList.clear();
                SystemTapScriptGraphOptionsTab.this.regexErrorMessages.clear();
                SystemTapScriptGraphOptionsTab.this.columnNamesList.clear();
                SystemTapScriptGraphOptionsTab.this.cachedNamesList.clear();
                SystemTapScriptGraphOptionsTab.this.graphsTable.removeAll();
                SystemTapScriptGraphOptionsTab.this.graphsDataList.clear();
                SystemTapScriptGraphOptionsTab.this.badGraphs.clear();
                int i = 0;
                int n3 = regexs.size();
                while (i < n3) {
                    ArrayList<String> columnNames = new ArrayList<String>();
                    int c = 0;
                    int numColumns = regexs.get(i).getValue();
                    while (c < numColumns) {
                        columnNames.add(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_defaultColumnTitleBase, c + 1));
                        ++c;
                    }
                    SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.add(regexs.get(i).getKey());
                    SystemTapScriptGraphOptionsTab.this.outputList.add("");
                    SystemTapScriptGraphOptionsTab.this.regexErrorMessages.add(null);
                    SystemTapScriptGraphOptionsTab.this.columnNamesList.add(columnNames);
                    SystemTapScriptGraphOptionsTab.this.cachedNamesList.add(new Stack());
                    SystemTapScriptGraphOptionsTab.this.graphsDataList.add(new LinkedList());
                    ++i;
                }
                if (SystemTapScriptGraphOptionsTab.this.getNumberOfRegexs() < 20) {
                    SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.add(Messages.SystemTapScriptGraphOptionsTab_regexAddNew);
                }
                SystemTapScriptGraphOptionsTab.this.textListenersEnabled = true;
                SystemTapScriptGraphOptionsTab.this.removeRegexButton.setEnabled(SystemTapScriptGraphOptionsTab.this.getNumberOfRegexs() > 1);
                SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.select(0);
                SystemTapScriptGraphOptionsTab.this.updateRegexSelection(0, true);
                SystemTapScriptGraphOptionsTab.this.checkAllOtherErrors();
                SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
            }
        }
    };

    public static List<String> createDatasetNames(ILaunchConfiguration configuration) {
        try {
            int numberOfRegexs = configuration.getAttribute(NUMBER_OF_REGEXS, 0);
            ArrayList<String> names = new ArrayList<String>(numberOfRegexs);
            int r = 0;
            while (r < numberOfRegexs) {
                names.add(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_graphSetTitleBase, r + 1));
                ++r;
            }
            return names;
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_cantInitializeTab, (Exception)((Object)e));
            return null;
        }
    }

    public static List<IDataSetParser> createDatasetParsers(ILaunchConfiguration configuration) {
        try {
            int numberOfRegexs = configuration.getAttribute(NUMBER_OF_REGEXS, 0);
            ArrayList<IDataSetParser> parsers = new ArrayList<IDataSetParser>(numberOfRegexs);
            int r = 0;
            while (r < numberOfRegexs) {
                parsers.add((IDataSetParser)new LineParser("^" + configuration.getAttribute(REGULAR_EXPRESSION + r, "") + "$"));
                ++r;
            }
            return parsers;
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_cantInitializeTab, (Exception)((Object)e));
            return null;
        }
    }

    public static List<IFilteredDataSet> createDataset(ILaunchConfiguration configuration) {
        try {
            int numberOfRegexs = configuration.getAttribute(NUMBER_OF_REGEXS, 0);
            ArrayList<IFilteredDataSet> datasets = new ArrayList<IFilteredDataSet>(numberOfRegexs);
            int r = 0;
            while (r < numberOfRegexs) {
                int numberOfColumns = configuration.getAttribute(NUMBER_OF_COLUMNS + r, 0);
                ArrayList<String> labels = new ArrayList<String>(numberOfColumns);
                int c = 0;
                while (c < numberOfColumns) {
                    labels.add(configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(REGEX_BOX, r, c), ""));
                    ++c;
                }
                datasets.add(DataSetFactory.createFilteredDataSet((String)"org.eclipse.linuxtools.systemtap.graphing.core.datasets.rowdataset", (String[])labels.toArray(new String[0])));
                ++r;
            }
            return datasets;
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_cantInitializeTab, (Exception)((Object)e));
            return null;
        }
    }

    public static List<LinkedList<GraphData>> createGraphsFromConfiguration(ILaunchConfiguration configuration) throws CoreException {
        int numberOfRegexs = Math.max(configuration.getAttribute(NUMBER_OF_REGEXS, 1), 1);
        ArrayList<LinkedList<GraphData>> graphsList = new ArrayList<LinkedList<GraphData>>(numberOfRegexs);
        int r = 0;
        while (r < numberOfRegexs) {
            int numberOfGraphs = configuration.getAttribute(NUMBER_OF_GRAPHS + r, 0);
            LinkedList<GraphData> graphs = new LinkedList<GraphData>();
            int i = 0;
            while (i < numberOfGraphs) {
                GraphData graphData = new GraphData();
                graphData.title = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_TITLE, r, i), null);
                graphData.key = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_KEY, r, i), null);
                graphData.xSeries = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_X_SERIES, r, i), 0);
                graphData.graphID = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_ID, r, i), null);
                int ySeriesLength = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES_LENGTH, r, i), 0);
                if (ySeriesLength == 0) {
                    graphData.ySeries = null;
                } else {
                    int[] ySeries = new int[ySeriesLength];
                    int j = 0;
                    while (j < ySeriesLength) {
                        ySeries[j] = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES, r, String.valueOf(i) + "_" + j), 0);
                        ++j;
                    }
                    graphData.ySeries = ySeries;
                }
                graphs.add(graphData);
                ++i;
            }
            graphsList.add(graphs);
            ++r;
        }
        return graphsList;
    }

    private static String get2DConfigData(String configDataName, int r, int i) {
        return String.valueOf(configDataName) + r + "_" + i;
    }

    private static String get2DConfigData(String configDataName, int r, String s) {
        return String.valueOf(configDataName) + r + "_" + s;
    }

    private int getNumberOfRegexs() {
        return this.outputList.size();
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        this.runWithChartCheckButton = new Button(top, 32);
        this.runWithChartCheckButton.setText(Messages.SystemTapScriptGraphOptionsTab_graphOutputRun);
        this.runWithChartCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SystemTapScriptGraphOptionsTab.this.setGraphingEnabled(SystemTapScriptGraphOptionsTab.this.runWithChartCheckButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SystemTapScriptGraphOptionsTab.this.setGraphingEnabled(SystemTapScriptGraphOptionsTab.this.runWithChartCheckButton.getSelection());
            }
        });
        this.runWithChartCheckButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_graphOutput);
        this.outputParsingGroup = new Group(top, 16);
        this.outputParsingGroup.setText(Messages.SystemTapScriptGraphOptionsTab_outputLabel);
        this.outputParsingGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createColumnSelector((Composite)this.outputParsingGroup);
        this.graphsGroup = new Group(top, 16);
        this.graphsGroup.setText(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_graphSetTitleBase, 1));
        this.graphsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createGraphCreateArea((Composite)this.graphsGroup);
        this.setGraphingEnabled(false);
        this.runWithChartCheckButton.setSelection(false);
    }

    private void createColumnSelector(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        Composite topLayout = new Composite(parent, 0);
        topLayout.setLayout((Layout)new GridLayout(1, false));
        topLayout.setLayoutData((Object)new GridData(4, 4, false, false));
        Button generateExpsButton = new Button(topLayout, 8);
        generateExpsButton.setLayoutData((Object)new GridData(768));
        generateExpsButton.setText(Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsButton);
        generateExpsButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsTooltip);
        generateExpsButton.addSelectionListener((SelectionListener)this.regexGenerator);
        Composite regexButtonLayout = new Composite(parent, 0);
        regexButtonLayout.setLayout((Layout)new GridLayout(3, false));
        regexButtonLayout.setLayoutData((Object)new GridData(4, 4, true, false));
        Label selectedRegexLabel = new Label(regexButtonLayout, 0);
        selectedRegexLabel.setText(Messages.SystemTapScriptGraphOptionsTab_regexLabel);
        selectedRegexLabel.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_regexTooltip);
        this.regularExpressionCombo = new Combo(regexButtonLayout, 4);
        this.regularExpressionCombo.setTextLimit(200);
        this.regularExpressionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.regularExpressionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selected = SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.getSelectionIndex();
                if (selected == SystemTapScriptGraphOptionsTab.this.selectedRegex) {
                    return;
                }
                if (SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.getItem(SystemTapScriptGraphOptionsTab.this.selectedRegex).isEmpty() && ((LinkedList)SystemTapScriptGraphOptionsTab.this.graphsDataList.get(SystemTapScriptGraphOptionsTab.this.selectedRegex)).size() == 0 && ((String)SystemTapScriptGraphOptionsTab.this.outputList.get(SystemTapScriptGraphOptionsTab.this.selectedRegex)).isEmpty()) {
                    if (selected == SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.getItemCount() - 1) {
                        SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.select(SystemTapScriptGraphOptionsTab.this.selectedRegex);
                        return;
                    }
                    SystemTapScriptGraphOptionsTab.this.removeRegex(false);
                    if (selected > SystemTapScriptGraphOptionsTab.this.selectedRegex) {
                        --selected;
                    }
                }
                if (selected == SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.getItemCount() - 1 && SystemTapScriptGraphOptionsTab.this.getNumberOfRegexs() < 20) {
                    SystemTapScriptGraphOptionsTab.this.outputList.add("");
                    SystemTapScriptGraphOptionsTab.this.regexErrorMessages.add(null);
                    SystemTapScriptGraphOptionsTab.this.columnNamesList.add(new ArrayList());
                    SystemTapScriptGraphOptionsTab.this.cachedNamesList.add(new Stack());
                    SystemTapScriptGraphOptionsTab.this.graphsDataList.add(new LinkedList());
                    SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.setItem(selected, "");
                    SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.select(selected);
                    SystemTapScriptGraphOptionsTab.this.updateRegexSelection(selected, false);
                    SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
                    if (SystemTapScriptGraphOptionsTab.this.getNumberOfRegexs() == 2) {
                        SystemTapScriptGraphOptionsTab.this.removeRegexButton.setEnabled(true);
                    }
                    if (SystemTapScriptGraphOptionsTab.this.getNumberOfRegexs() < 20) {
                        SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.add(Messages.SystemTapScriptGraphOptionsTab_regexAddNew);
                    }
                } else {
                    SystemTapScriptGraphOptionsTab.this.updateRegexSelection(selected, false);
                }
            }
        });
        this.regularExpressionCombo.addModifyListener(this.regexListener);
        this.removeRegexButton = new Button(regexButtonLayout, 8);
        this.removeRegexButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.removeRegexButton.setText(Messages.SystemTapScriptGraphOptionsTab_regexRemove);
        this.removeRegexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                MessageDialog dialog = new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), Messages.SystemTapScriptGraphOptionsTab_removeRegexTitle, null, MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_removeRegexAsk, SystemTapScriptGraphOptionsTab.this.regularExpressionCombo.getItem(SystemTapScriptGraphOptionsTab.this.selectedRegex)), 3, new String[]{"Yes", "No"}, 0);
                int result = dialog.open();
                if (result == 0) {
                    SystemTapScriptGraphOptionsTab.this.removeRegex(true);
                }
            }
        });
        GridLayout twoColumns = new GridLayout(2, false);
        Composite regexSummaryComposite = new Composite(parent, 0);
        regexSummaryComposite.setLayout((Layout)twoColumns);
        regexSummaryComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label sampleOutputLabel = new Label(regexSummaryComposite, 0);
        sampleOutputLabel.setText(Messages.SystemTapScriptGraphOptionsTab_sampleOutputLabel);
        sampleOutputLabel.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_sampleOutputTooltip);
        this.sampleOutputText = new Text(regexSummaryComposite, 2048);
        this.sampleOutputText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sampleOutputText.addModifyListener(this.sampleOutputListener);
        this.sampleOutputText.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_sampleOutputTooltip);
        Composite expressionTableLabels = new Composite(parent, 0);
        expressionTableLabels.setLayoutData((Object)new GridData(4, 4, false, false));
        expressionTableLabels.setLayout((Layout)twoColumns);
        Label label = new Label(expressionTableLabels, 0);
        label.setText(Messages.SystemTapScriptGraphOptionsTab_columnTitle);
        label.setAlignment(16384);
        Label label2 = new Label(expressionTableLabels, 0);
        label2.setAlignment(16384);
        label2.setText(Messages.SystemTapScriptGraphOptionsTab_extractedValueLabel);
        ScrolledComposite regexTextScrolledComposite = new ScrolledComposite(parent, 2560);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 200;
        regexTextScrolledComposite.setLayoutData((Object)data);
        this.textFieldsComposite = new Composite((Composite)regexTextScrolledComposite, 0);
        this.textFieldsComposite.setLayout((Layout)new GridLayout(4, false));
        regexTextScrolledComposite.setContent((Control)this.textFieldsComposite);
        regexTextScrolledComposite.setExpandHorizontal(true);
        this.textListenersEnabled = false;
        this.addColumn(null);
        data = new GridData(4, 4, false, false);
        data.horizontalIndent = this.textFieldsComposite.getChildren()[2].getLocation().x;
        data.widthHint = this.textFieldsComposite.getChildren()[2].getSize().x;
        label.setLayoutData((Object)data);
        label2.setLayoutData((Object)new GridData(4, 4, false, false));
        this.removeColumn(false);
        this.textListenersEnabled = true;
    }

    private IDataSet getCurrentDataset() {
        return DataSetFactory.createDataSet((String)"org.eclipse.linuxtools.systemtap.graphing.core.datasets.rowdataset", (String[])this.columnNamesList.get(this.selectedRegex).toArray(new String[0]));
    }

    private void createGraphCreateArea(Composite comp) {
        comp.setLayout((Layout)new GridLayout(2, false));
        this.graphsTable = new Table(comp, 2052);
        GridData layoutData = new GridData(4, 4, true, true);
        this.graphsTable.setLayoutData((Object)layoutData);
        Composite buttonComposite = new Composite(comp, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        buttonComposite.setLayout((Layout)gridLayout);
        this.addGraphButton = new Button(buttonComposite, 8);
        this.addGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_AddGraphButton);
        this.addGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_AddGraphButtonToolTip);
        this.addGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.duplicateGraphButton = new Button(buttonComposite, 8);
        this.duplicateGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_DuplicateGraphButton);
        this.duplicateGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_DuplicateGraphButtonToolTip);
        this.duplicateGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.editGraphButton = new Button(buttonComposite, 8);
        this.editGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_EditGraphButton);
        this.editGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_EditGraphButtonToolTip);
        this.editGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.removeGraphButton = new Button(buttonComposite, 8);
        this.removeGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_RemoveGraphButton);
        this.removeGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_RemoveGraphButtonToolTip);
        this.removeGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.graphsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemTapScriptGraphOptionsTab.this.selectedTableItem = (TableItem)e.item;
                SystemTapScriptGraphOptionsTab.this.setSelectionControlsEnabled(true);
            }
        });
        this.addGraphButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectGraphAndSeriesWizard wizard = new SelectGraphAndSeriesWizard(SystemTapScriptGraphOptionsTab.this.getCurrentDataset(), null);
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                GraphData gd = wizard.getGraphData();
                if (gd != null) {
                    TableItem item = new TableItem(SystemTapScriptGraphOptionsTab.this.graphsTable, 0);
                    SystemTapScriptGraphOptionsTab.this.graphsData.add(gd);
                    SystemTapScriptGraphOptionsTab.this.setUpGraphTableItem(item, gd, false);
                    SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.duplicateGraphButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphData gd = ((GraphData)SystemTapScriptGraphOptionsTab.this.selectedTableItem.getData()).getCopy();
                TableItem item = new TableItem(SystemTapScriptGraphOptionsTab.this.graphsTable, 0);
                SystemTapScriptGraphOptionsTab.this.graphsData.add(gd);
                if (SystemTapScriptGraphOptionsTab.this.badGraphs.contains(SystemTapScriptGraphOptionsTab.this.selectedTableItem.getData())) {
                    SystemTapScriptGraphOptionsTab.this.badGraphs.add(gd);
                    SystemTapScriptGraphOptionsTab.this.setUpGraphTableItem(item, gd, true);
                } else {
                    SystemTapScriptGraphOptionsTab.this.setUpGraphTableItem(item, gd, false);
                }
                SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.editGraphButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectGraphAndSeriesWizard wizard = new SelectGraphAndSeriesWizard(SystemTapScriptGraphOptionsTab.this.getCurrentDataset(), (GraphData)SystemTapScriptGraphOptionsTab.this.selectedTableItem.getData());
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                GraphData gd = wizard.getGraphData();
                if (gd == null) {
                    return;
                }
                GraphData old_gd = (GraphData)SystemTapScriptGraphOptionsTab.this.selectedTableItem.getData();
                if (!gd.isCopyOf(old_gd)) {
                    SystemTapScriptGraphOptionsTab.this.badGraphs.remove(old_gd);
                    SystemTapScriptGraphOptionsTab.this.setUpGraphTableItem(SystemTapScriptGraphOptionsTab.this.selectedTableItem, gd, false);
                    SystemTapScriptGraphOptionsTab.this.graphsData.set(SystemTapScriptGraphOptionsTab.this.graphsTable.indexOf(SystemTapScriptGraphOptionsTab.this.selectedTableItem), gd);
                    SystemTapScriptGraphOptionsTab.this.checkErrors(SystemTapScriptGraphOptionsTab.this.selectedRegex);
                    SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.removeGraphButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphData gd = (GraphData)SystemTapScriptGraphOptionsTab.this.selectedTableItem.getData();
                SystemTapScriptGraphOptionsTab.this.graphsData.remove(gd);
                SystemTapScriptGraphOptionsTab.this.badGraphs.remove(gd);
                SystemTapScriptGraphOptionsTab.this.selectedTableItem.dispose();
                SystemTapScriptGraphOptionsTab.this.setSelectionControlsEnabled(false);
                SystemTapScriptGraphOptionsTab.this.checkErrors(SystemTapScriptGraphOptionsTab.this.selectedRegex);
                SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void removeRegex(boolean autoSelect) {
        int removedRegex = this.selectedRegex;
        if (autoSelect) {
            this.regularExpressionCombo.select(this.selectedRegex != 0 ? this.selectedRegex - 1 : 1);
            this.updateRegexSelection(this.regularExpressionCombo.getSelectionIndex(), false);
        }
        this.regularExpressionCombo.remove(removedRegex);
        this.outputList.remove(removedRegex);
        this.regexErrorMessages.remove(removedRegex);
        this.columnNamesList.remove(removedRegex);
        this.cachedNamesList.remove(removedRegex);
        this.graphsDataList.remove(removedRegex);
        if (autoSelect) {
            this.selectedRegex = this.regularExpressionCombo.getSelectionIndex();
        }
        if (this.getNumberOfRegexs() == 19) {
            this.regularExpressionCombo.add(Messages.SystemTapScriptGraphOptionsTab_regexAddNew);
        }
        if (this.getNumberOfRegexs() == 1) {
            this.removeRegexButton.setEnabled(false);
        }
        this.updateLaunchConfigurationDialog();
    }

    private void updateRegexSelection(int newSelection, boolean force) {
        boolean textListenersDisabled;
        if (newSelection == -1 || !force && this.selectedRegex == newSelection) {
            return;
        }
        this.selectedRegex = newSelection;
        boolean bl = textListenersDisabled = !this.textListenersEnabled;
        if (!textListenersDisabled) {
            this.textListenersEnabled = false;
        }
        this.sampleOutputText.setText(this.outputList.get(this.selectedRegex));
        this.cachedNames = this.cachedNamesList.get(this.selectedRegex);
        List<String> columnNames = this.columnNamesList.get(this.selectedRegex);
        int desiredNumberOfColumns = columnNames.size();
        while (this.numberOfVisibleColumns > 0) {
            this.removeColumn(false);
        }
        while (this.numberOfVisibleColumns < desiredNumberOfColumns) {
            this.addColumn(columnNames.get(this.numberOfVisibleColumns));
        }
        this.refreshRegexRows();
        this.graphsData = this.graphsDataList.get(this.selectedRegex);
        this.graphsTable.removeAll();
        this.selectedTableItem = null;
        this.setSelectionControlsEnabled(false);
        for (GraphData gd : this.graphsData) {
            TableItem item = new TableItem(this.graphsTable, 0);
            this.setUpGraphTableItem(item, gd, this.badGraphs.contains(gd));
        }
        this.graphsGroup.setText(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_graphSetTitleBase, this.selectedRegex + 1));
        if (!textListenersDisabled) {
            this.textListenersEnabled = true;
        }
    }

    private void refreshRegexRows() {
        try {
            this.pattern = Pattern.compile(this.regularExpressionCombo.getText());
            this.matcher = this.pattern.matcher(this.sampleOutputText.getText());
            this.regexErrorMessages.set(this.selectedRegex, null);
        }
        catch (PatternSyntaxException e) {
            this.regexErrorMessages.set(this.selectedRegex, e.getMessage());
            return;
        }
        this.regexErrorMessages.set(this.selectedRegex, SystemTapScriptGraphOptionsTab.checkRegex(this.regularExpressionCombo.getText()));
        if (this.regexErrorMessages.get(this.selectedRegex) != null) {
            return;
        }
        int desiredNumberOfColumns = this.matcher.groupCount();
        while (this.numberOfVisibleColumns < desiredNumberOfColumns) {
            this.addColumn(null);
        }
        while (this.numberOfVisibleColumns > desiredNumberOfColumns) {
            this.removeColumn(true);
        }
        Control[] children = this.textFieldsComposite.getChildren();
        int i = 0;
        while (i < this.numberOfVisibleColumns) {
            String sampleOutputResults = this.matcher.matches() ? this.matcher.group(i + 1) : (this.sampleOutputText.getText().length() == 0 ? Messages.SystemTapScriptGraphOptionsTab_sampleOutputIsEmpty : Messages.SystemTapScriptGraphOptionsTab_sampleOutputNoMatch);
            ((Label)children[i * 4 + 3]).setText(" " + sampleOutputResults);
            ++i;
        }
        this.addGraphButton.setEnabled(this.numberOfVisibleColumns > 0);
        if (this.selectedTableItem != null) {
            this.editGraphButton.setEnabled(this.numberOfVisibleColumns > 0);
        }
        this.regexErrorMessages.set(this.selectedRegex, this.findBadGraphs(this.selectedRegex));
    }

    private static String checkRegex(String regex) {
        if (regex.contains("()")) {
            return Messages.SystemTapScriptGraphOptionsTab_emptyGroup;
        }
        return null;
    }

    private void addColumn(String nameToAdd) {
        if (this.numberOfVisibleColumns > 0) {
            this.textFieldsComposite.getChildren()[(this.numberOfVisibleColumns - 1) * 4].setVisible(true);
            this.textFieldsComposite.getChildren()[(this.numberOfVisibleColumns - 1) * 4 + 1].setVisible(true);
        }
        Button buttonUp = new Button(this.textFieldsComposite, 8);
        buttonUp.setText(Messages.SystemTapScriptGraphOptionsTab_columnShiftUp);
        buttonUp.setVisible(false);
        Button buttonDown = new Button(this.textFieldsComposite, 8);
        buttonDown.setText(Messages.SystemTapScriptGraphOptionsTab_columnShiftDown);
        buttonDown.setVisible(false);
        Text text = new Text(this.textFieldsComposite, 2048);
        GridData data = new GridData(4, 4, false, false);
        data.minimumWidth = 200;
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        ++this.numberOfVisibleColumns;
        text.addModifyListener(this.columnNameListener);
        if (nameToAdd == null) {
            if (this.cachedNames.size() > 0) {
                text.setText(this.cachedNames.pop());
            } else {
                text.setText(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_defaultColumnTitleBase, this.numberOfVisibleColumns));
            }
        } else {
            text.setText(nameToAdd);
        }
        Label label = new Label(this.textFieldsComposite, 2048);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textFieldsComposite.layout();
        this.textFieldsComposite.pack();
        buttonUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control clickedButton = (Control)e.widget;
                Control[] children = SystemTapScriptGraphOptionsTab.this.textFieldsComposite.getChildren();
                int currentColumn = 0;
                while (currentColumn < SystemTapScriptGraphOptionsTab.this.numberOfVisibleColumns - 1) {
                    if (children[currentColumn * 4].equals(clickedButton)) break;
                    ++currentColumn;
                }
                String edgeName = ((Text)children[currentColumn * 4 + 2]).getText();
                int i = currentColumn;
                while (i < SystemTapScriptGraphOptionsTab.this.numberOfVisibleColumns - 1) {
                    ((Text)children[i * 4 + 2]).setText(((Text)children[(i + 1) * 4 + 2]).getText());
                    ++i;
                }
                ((Text)children[(SystemTapScriptGraphOptionsTab.this.numberOfVisibleColumns - 1) * 4 + 2]).setText(edgeName);
            }
        });
        buttonDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control clickedButton = (Control)e.widget;
                Control[] children = SystemTapScriptGraphOptionsTab.this.textFieldsComposite.getChildren();
                int currentColumn = 0;
                while (currentColumn < SystemTapScriptGraphOptionsTab.this.numberOfVisibleColumns - 1) {
                    if (children[currentColumn * 4 + 1].equals(clickedButton)) break;
                    ++currentColumn;
                }
                String edgeName = ((Text)children[(SystemTapScriptGraphOptionsTab.this.numberOfVisibleColumns - 1) * 4 + 2]).getText();
                int i = SystemTapScriptGraphOptionsTab.this.numberOfVisibleColumns - 1;
                while (i > currentColumn) {
                    ((Text)children[i * 4 + 2]).setText(((Text)children[(i - 1) * 4 + 2]).getText());
                    --i;
                }
                ((Text)children[currentColumn * 4 + 2]).setText(edgeName);
            }
        });
    }

    private void removeColumn(boolean saveNames) {
        Control[] children = this.textFieldsComposite.getChildren();
        int i = this.numberOfVisibleColumns * 4 - 1;
        if (saveNames) {
            String name = ((Text)children[i - 1]).getText();
            if (name != null && name != "") {
                this.cachedNames.push(name);
            }
            this.columnNamesList.get(this.selectedRegex).remove(this.numberOfVisibleColumns - 1);
        }
        children[i].dispose();
        children[i - 1].dispose();
        children[i - 2].dispose();
        children[i - 3].dispose();
        if (this.numberOfVisibleColumns > 2) {
            children[i - 6].setVisible(false);
            children[i - 7].setVisible(false);
        }
        --this.numberOfVisibleColumns;
        this.textFieldsComposite.layout();
        this.textFieldsComposite.pack();
    }

    private String findBadGraphs(int regex) {
        boolean foundBadID = false;
        boolean foundRemoved = false;
        int numberOfColumns = this.columnNamesList.get(regex).size();
        for (GraphData gd : this.graphsDataList.get(regex)) {
            boolean singleBadID = false;
            boolean singleRemoved = false;
            if (GraphFactory.getGraphName((String)gd.graphID) == null) {
                singleBadID = true;
            } else {
                if (gd.xSeries >= numberOfColumns) {
                    singleRemoved = true;
                }
                int s = 0;
                while (s < gd.ySeries.length && !singleRemoved) {
                    if (gd.ySeries[s] >= numberOfColumns) {
                        singleRemoved = true;
                    }
                    ++s;
                }
            }
            if (singleRemoved || singleBadID) {
                if (!this.badGraphs.contains(gd)) {
                    this.badGraphs.add(gd);
                    this.setUpGraphTableItem(this.findGraphTableItem(gd), null, true);
                }
            } else if (this.badGraphs.contains(gd)) {
                this.badGraphs.remove(gd);
                this.setUpGraphTableItem(this.findGraphTableItem(gd), null, false);
            }
            foundBadID |= singleBadID;
            foundRemoved |= singleRemoved;
        }
        if (numberOfColumns == 0) {
            return Messages.SystemTapScriptGraphOptionsTab_noGroups;
        }
        if (foundBadID) {
            return Messages.SystemTapScriptGraphOptionsTab_badGraphID;
        }
        if (foundRemoved) {
            return Messages.SystemTapScriptGraphOptionsTab_deletedGraphData;
        }
        return null;
    }

    private TableItem findGraphTableItem(GraphData gd) {
        TableItem[] tableItemArray = this.graphsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData().equals(gd)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void setUpGraphTableItem(TableItem item, GraphData gd, boolean bad) {
        if (item == null) {
            return;
        }
        if (gd != null) {
            item.setData((Object)gd);
        } else {
            gd = (GraphData)item.getData();
        }
        item.setForeground(item.getDisplay().getSystemColor(bad ? 3 : 2));
        String graphName = GraphFactory.getGraphName((String)gd.graphID);
        if (graphName == null) {
            graphName = Messages.SystemTapScriptGraphOptionsTab_invalidGraphID;
        }
        item.setText(String.valueOf(graphName) + ":" + gd.title + (bad ? " " + Messages.SystemTapScriptGraphOptionsTab_invalidGraph : ""));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(RUN_WITH_CHART, false);
        configuration.setAttribute(NUMBER_OF_REGEXS, 1);
        configuration.setAttribute("numberOfColumns_0", 0);
        configuration.setAttribute("numberOfExtras_0", 0);
        configuration.setAttribute("regularExpression_0", "");
        configuration.setAttribute("sampleOutput_0", "");
        configuration.setAttribute("numberOfGraphs0", 0);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            try {
                this.textListenersEnabled = false;
                this.regularExpressionCombo.removeAll();
                this.outputList.clear();
                this.regexErrorMessages.clear();
                this.columnNamesList.clear();
                this.cachedNamesList.clear();
                this.graphsTable.removeAll();
                this.badGraphs.clear();
                int numberOfRegexs = Math.max(configuration.getAttribute(NUMBER_OF_REGEXS, 1), 1);
                this.removeRegexButton.setEnabled(numberOfRegexs > 1);
                int r = 0;
                while (r < numberOfRegexs) {
                    this.regularExpressionCombo.add(configuration.getAttribute(REGULAR_EXPRESSION + r, ""));
                    this.outputList.add(configuration.getAttribute(SAMPLE_OUTPUT + r, ""));
                    int numberOfColumns = configuration.getAttribute(NUMBER_OF_COLUMNS + r, 0);
                    ArrayList<String> namelist = new ArrayList<String>(numberOfColumns);
                    int i = 0;
                    while (i < numberOfColumns) {
                        namelist.add(configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(REGEX_BOX, r, i), null));
                        ++i;
                    }
                    this.columnNamesList.add(namelist);
                    int numberOfExtras = configuration.getAttribute(NUMBER_OF_EXTRAS + r, 0);
                    Stack<String> oldnames = new Stack<String>();
                    int i2 = 0;
                    while (i2 < numberOfExtras) {
                        oldnames.push(configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(EXTRA_BOX, r, i2), null));
                        ++i2;
                    }
                    this.cachedNamesList.add(oldnames);
                    this.regexErrorMessages.add(null);
                    ++r;
                }
                if (this.getNumberOfRegexs() < 20) {
                    this.regularExpressionCombo.add(Messages.SystemTapScriptGraphOptionsTab_regexAddNew);
                }
                int defaultSelectedRegex = this.selectedRegex >= 0 && this.selectedRegex < numberOfRegexs ? this.selectedRegex : 0;
                this.regularExpressionCombo.select(defaultSelectedRegex);
                this.graphsDataList = SystemTapScriptGraphOptionsTab.createGraphsFromConfiguration(configuration);
                this.graphsData = this.graphsDataList.get(defaultSelectedRegex);
                for (GraphData graphData : this.graphsData) {
                    TableItem item = new TableItem(this.graphsTable, 0);
                    this.setUpGraphTableItem(item, graphData, true);
                }
                this.updateRegexSelection(defaultSelectedRegex, true);
                this.checkAllOtherErrors();
                boolean chart = configuration.getAttribute(RUN_WITH_CHART, false);
                this.setGraphingEnabled(chart);
                this.runWithChartCheckButton.setSelection(chart);
            }
            catch (CoreException e) {
                ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_cantInitializeTab, (Exception)((Object)e));
                this.textListenersEnabled = true;
            }
        }
        finally {
            this.textListenersEnabled = true;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(RUN_WITH_CHART, this.runWithChartCheckButton.getSelection());
        int numberOfRegexs = this.getNumberOfRegexs();
        int r = 0;
        while (r < numberOfRegexs) {
            configuration.setAttribute(REGULAR_EXPRESSION + r, this.regularExpressionCombo.getItem(r));
            configuration.setAttribute(SAMPLE_OUTPUT + r, this.outputList.get(r));
            List<String> columnNames = this.columnNamesList.get(r);
            int numberOfColumns = columnNames.size();
            int i = 0;
            while (i < numberOfColumns) {
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(REGEX_BOX, r, i), columnNames.get(i));
                ++i;
            }
            this.cleanUpConfigurationItem(configuration, NUMBER_OF_COLUMNS, REGEX_BOX, r, numberOfColumns);
            configuration.setAttribute(NUMBER_OF_COLUMNS + r, numberOfColumns);
            Stack<String> extranames = this.cachedNamesList.get(r);
            int numberOfExtras = this.findBadGraphs(r) == null ? 0 : extranames.size();
            int i2 = 0;
            while (i2 < numberOfExtras) {
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(EXTRA_BOX, r, i2), (String)extranames.get(i2));
                ++i2;
            }
            this.cleanUpConfigurationItem(configuration, NUMBER_OF_EXTRAS, EXTRA_BOX, r, numberOfExtras);
            configuration.setAttribute(NUMBER_OF_EXTRAS + r, numberOfExtras);
            LinkedList<GraphData> list = this.graphsDataList.get(r);
            int numberOfGraphs = list.size();
            int i3 = 0;
            while (i3 < numberOfGraphs) {
                GraphData graphData = list.get(i3);
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_TITLE, r, i3), graphData.title);
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_KEY, r, i3), graphData.key);
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_X_SERIES, r, i3), graphData.xSeries);
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_ID, r, i3), graphData.graphID);
                int ySeriesLength = graphData.ySeries.length;
                int j = 0;
                while (j < ySeriesLength) {
                    configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES, r, String.valueOf(i3) + "_" + j), graphData.ySeries[j]);
                    ++j;
                }
                this.cleanUpConfigurationGraphYSeries(configuration, r, i3, ySeriesLength);
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES_LENGTH, r, i3), ySeriesLength);
                ++i3;
            }
            this.cleanUpConfigurationGraphs(configuration, r, numberOfGraphs);
            configuration.setAttribute(NUMBER_OF_GRAPHS + r, numberOfGraphs);
            ++r;
        }
        this.cleanUpConfiguration(configuration, numberOfRegexs);
        configuration.setAttribute(NUMBER_OF_REGEXS, numberOfRegexs);
    }

    private void cleanUpConfiguration(ILaunchConfigurationWorkingCopy configuration, int numberOfRegexs) {
        int oldNumberOfRegexs = 0;
        try {
            oldNumberOfRegexs = configuration.getAttribute(NUMBER_OF_REGEXS, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        int r = numberOfRegexs;
        while (r < oldNumberOfRegexs) {
            configuration.removeAttribute(REGULAR_EXPRESSION + r);
            configuration.removeAttribute(SAMPLE_OUTPUT + r);
            this.cleanUpConfigurationItem(configuration, NUMBER_OF_COLUMNS, REGEX_BOX, r, 0);
            configuration.removeAttribute(NUMBER_OF_COLUMNS + r);
            this.cleanUpConfigurationItem(configuration, NUMBER_OF_COLUMNS, EXTRA_BOX, r, 0);
            configuration.removeAttribute(NUMBER_OF_EXTRAS + r);
            this.cleanUpConfigurationGraphs(configuration, r, 0);
            configuration.removeAttribute(NUMBER_OF_GRAPHS + r);
            ++r;
        }
    }

    private void cleanUpConfigurationGraphs(ILaunchConfigurationWorkingCopy configuration, int regex, int newNumberOfGraphs) {
        int oldNumberOfGraphs = 0;
        try {
            oldNumberOfGraphs = configuration.getAttribute(NUMBER_OF_GRAPHS + regex, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        int i = newNumberOfGraphs;
        while (i < oldNumberOfGraphs) {
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_TITLE, regex, i));
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_KEY, regex, i));
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_X_SERIES, regex, i));
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_ID, regex, i));
            this.cleanUpConfigurationGraphYSeries(configuration, regex, i, 0);
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES_LENGTH, regex, i));
            ++i;
        }
    }

    private void cleanUpConfigurationItem(ILaunchConfigurationWorkingCopy configuration, String counter, String property, int regex, int newNumberOfItems) {
        int oldNumberOfItems = 0;
        try {
            oldNumberOfItems = configuration.getAttribute(String.valueOf(counter) + regex, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        int i = newNumberOfItems;
        while (i < oldNumberOfItems) {
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(property, regex, i));
            ++i;
        }
    }

    private void cleanUpConfigurationGraphYSeries(ILaunchConfigurationWorkingCopy configuration, int regex, int graph, int newLength) {
        int oldYSeriesLength = 0;
        try {
            oldYSeriesLength = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES_LENGTH, regex, graph), 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        int i = newLength;
        while (i < oldYSeriesLength) {
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES, regex, String.valueOf(graph) + "_" + i));
            ++i;
        }
    }

    private void checkAllOtherErrors() {
        int i = 0;
        int n = this.getNumberOfRegexs();
        while (i < n) {
            if (i != this.selectedRegex) {
                this.checkErrors(i);
            }
            ++i;
        }
    }

    private void checkErrors(int i) {
        String regex = this.regularExpressionCombo.getItem(i);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            this.regexErrorMessages.set(i, e.getMessage());
            return;
        }
        String error = this.findBadGraphs(i);
        if (error == null) {
            error = SystemTapScriptGraphOptionsTab.checkRegex(regex);
        }
        this.regexErrorMessages.set(i, error);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!this.graphingEnabled) {
            return true;
        }
        int r = 0;
        int n = this.getNumberOfRegexs();
        while (r < n) {
            String regexErrorMessage = this.regexErrorMessages.get(r);
            if (regexErrorMessage != null) {
                this.setErrorMessage(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_regexErrorMsgFormat, this.regularExpressionCombo.getItems()[r], regexErrorMessage));
                return false;
            }
            ++r;
        }
        return true;
    }

    public static boolean isValidLaunch(ILaunchConfiguration launchConfig) throws CoreException {
        if (!launchConfig.getAttribute(RUN_WITH_CHART, false)) {
            return true;
        }
        int r = 0;
        int n = launchConfig.getAttribute(NUMBER_OF_REGEXS, 1);
        while (r < n) {
            String regex = launchConfig.getAttribute(REGULAR_EXPRESSION + r, null);
            if (regex == null || SystemTapScriptGraphOptionsTab.checkRegex(regex) != null) {
                return false;
            }
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                return false;
            }
            int numberOfColumns = launchConfig.getAttribute(NUMBER_OF_COLUMNS + r, 0);
            if (numberOfColumns == 0) {
                return false;
            }
            int i = 0;
            int g = launchConfig.getAttribute(NUMBER_OF_GRAPHS + r, 0);
            while (i < g) {
                if (GraphFactory.getGraphName((String)launchConfig.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_ID, r, i), null)) == null) {
                    return false;
                }
                if (launchConfig.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_X_SERIES, r, i), 0) >= numberOfColumns) {
                    return false;
                }
                int j = 0;
                int y = launchConfig.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES_LENGTH, r, i), 0);
                while (j < y) {
                    if (launchConfig.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES, r, String.valueOf(i) + "_" + j), 0) >= numberOfColumns) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            ++r;
        }
        return true;
    }

    public String getName() {
        return Messages.SystemTapScriptGraphOptionsTab_graphingTitle;
    }

    public Image getImage() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.systemtap.ui.ide", (String)"icons/graphing_tab.gif").createImage();
    }

    private void setGraphingEnabled(boolean enabled) {
        this.graphingEnabled = enabled;
        this.setControlEnabled((Composite)this.outputParsingGroup, enabled);
        this.setControlEnabled((Composite)this.graphsGroup, enabled);
        this.setSelectionControlsEnabled(this.selectedTableItem != null);
        this.addGraphButton.setEnabled(enabled && this.numberOfVisibleColumns > 0);
        this.removeRegexButton.setEnabled(enabled && this.getNumberOfRegexs() > 1);
        this.updateLaunchConfigurationDialog();
    }

    private void setControlEnabled(Composite composite, boolean enabled) {
        composite.setEnabled(enabled);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(enabled);
            if (child instanceof Composite) {
                this.setControlEnabled((Composite)child, enabled);
            }
            ++n2;
        }
    }

    private void setSelectionControlsEnabled(boolean enabled) {
        this.duplicateGraphButton.setEnabled(enabled);
        this.editGraphButton.setEnabled(enabled && this.numberOfVisibleColumns > 0);
        this.removeGraphButton.setEnabled(enabled);
    }
}

