/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.debug.gdbjtag.datamodel;

import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdClusterDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdDerivedFromPath;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdObjectDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdRegisterDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdUtils;
import ilg.gnuarmeclipse.packs.core.tree.AbstractTreePreOrderIterator;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import java.math.BigInteger;
import java.util.LinkedList;

public class SvdPeripheralDMNode
extends SvdDMNode {
    private String fHexAddress = null;
    private BigInteger fBigAbsoluteAddress = null;
    private String fGroupName = null;
    private String fVersion = null;
    private Boolean fIsSystem = null;
    private static final BigInteger fSystemLimit = new BigInteger("E0000000", 16);

    public SvdPeripheralDMNode(Leaf node) {
        super(node);
    }

    @Override
    public void dispose() {
        this.fBigAbsoluteAddress = null;
        this.fHexAddress = null;
        this.fIsSystem = null;
        this.fGroupName = null;
        this.fVersion = null;
        super.dispose();
    }

    @Override
    protected SvdObjectDMNode[] prepareChildren(Leaf node) {
        if (node == null || !node.hasChildren()) {
            return null;
        }
        Leaf group = ((Node)node).findChild("registers");
        if (!group.hasChildren()) {
            return null;
        }
        LinkedList<SvdDMNode> list = new LinkedList<SvdDMNode>();
        for (Leaf child : ((Node)group).getChildren()) {
            if (child.isType("register")) {
                list.add(new SvdRegisterDMNode(child));
                continue;
            }
            if (!child.isType("cluster")) continue;
            list.add(new SvdClusterDMNode(child));
        }
        SvdObjectDMNode[] array = list.toArray(new SvdObjectDMNode[list.size()]);
        return array;
    }

    @Override
    protected Leaf findDerivedFromNode() {
        String derivedFromName = this.getNode().getPropertyOrNull("derivedFrom");
        final SvdDerivedFromPath path = SvdDerivedFromPath.createPeripheralPath(derivedFromName);
        if (path == null) {
            return null;
        }
        Node root = this.getNode().getParent();
        while (!root.isType("device")) {
            root = root.getParent();
        }
        AbstractTreePreOrderIterator peripheralNodes = new AbstractTreePreOrderIterator(){

            public boolean isIterable(Leaf node) {
                if (node.isType("peripherals")) {
                    return true;
                }
                if (node.isType("peripheral")) {
                    return path.peripheralName.equals(node.getProperty("name"));
                }
                return false;
            }

            public boolean isLeaf(Leaf node) {
                return node.isType("peripheral");
            }
        };
        peripheralNodes.setTreeNode((Leaf)root);
        Leaf ret = null;
        for (Leaf node : peripheralNodes) {
            if (!node.isType("peripheral")) continue;
            if (ret == null) {
                ret = node;
                continue;
            }
            Activator.log((String)("Non unique SVD path " + path));
        }
        return ret;
    }

    public String getId() {
        return this.getHexAddress();
    }

    @Override
    public BigInteger getBigSizeBytes() {
        String size = this.getAddressBlockSizeElement(this.getNode());
        if (size == null && this.getDerivedFromNode() != null) {
            size = this.getAddressBlockSizeElement(this.getDerivedFromNode());
        }
        if (size != null) {
            return SvdUtils.parseScaledNonNegativeBigInteger(size);
        }
        return null;
    }

    private String getAddressBlockSizeElement(Leaf node) {
        if (node.hasChildren()) {
            for (Leaf child : ((Node)node).getChildren()) {
                String usage;
                if (!child.isType("addressBlock") || !"registers".equals(usage = child.getProperty("usage", ""))) continue;
                return child.getProperty("size", null);
            }
        }
        return null;
    }

    @Override
    public BigInteger getBigAbsoluteAddress() {
        if (this.fBigAbsoluteAddress == null) {
            this.fBigAbsoluteAddress = SvdUtils.parseScaledNonNegativeBigInteger(this.getBaseAddress());
        }
        return this.fBigAbsoluteAddress;
    }

    public String getHexAddress() {
        if (this.fHexAddress == null) {
            this.fHexAddress = String.format("0x%08X", this.getBigAbsoluteAddress().longValue());
        }
        return this.fHexAddress;
    }

    public String getBaseAddress() {
        return this.getNode().getProperty("baseAddress", "0");
    }

    public boolean isSystem() {
        if (this.fIsSystem == null) {
            BigInteger addr = this.getBigAbsoluteAddress();
            this.fIsSystem = addr.compareTo(fSystemLimit) >= 0 ? new Boolean(true) : new Boolean(false);
        }
        return this.fIsSystem;
    }

    public String getGroupName() {
        if (this.fGroupName == null) {
            this.fGroupName = this.getPropertyWithDerived("groupName");
        }
        return this.fGroupName;
    }

    public String getVersion() {
        if (this.fVersion == null) {
            this.fVersion = this.getPropertyWithDerived("version");
        }
        return this.fVersion;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.getDisplayName() + ", " + this.getBaseAddress() + ", " + this.getBigSizeBytes() + ", " + this.getAccess() + ", \"" + this.getDescription() + "\"]";
    }
}

