/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.debug.gdbjtag.dsf;

import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.DebugUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.services.IGnuArmDebuggerCommandsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GnuArmRestartProcessSequence
extends ReflectionSequence {
    private IGDBControl fCommandControl;
    private CommandFactory fCommandFactory;
    private IGDBProcesses fProcService;
    private IGnuArmDebuggerCommandsService fDebuggerCommands;
    private DsfServicesTracker fTracker;
    private IRunControl.IContainerDMContext fContainerDmc;
    private final Map<String, Object> fAttributes;

    public GnuArmRestartProcessSequence(DsfExecutor executor, IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        super(executor, rm);
        assert (executor != null);
        assert (containerDmc != null);
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
        }
        this.fContainerDmc = containerDmc;
        this.fAttributes = attributes;
    }

    protected IRunControl.IContainerDMContext getContainerContext() {
        return this.fContainerDmc;
    }

    private void queueCommands(List<String> commands, RequestMonitor rm) {
        DebugUtils.queueCommands(commands, rm, this.fCommandControl, this.getExecutor());
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            return new String[]{"stepInitializeBaseSequence", "stepRestartCommands"};
        }
        return null;
    }

    @ReflectionSequence.Execute
    public void stepInitializeBaseSequence(RequestMonitor rm) {
        this.fTracker = new DsfServicesTracker(Activator.getInstance().getBundle().getBundleContext(), this.fContainerDmc.getSessionId());
        this.fCommandControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        this.fCommandFactory = ((IMICommandControl)this.fTracker.getService(IMICommandControl.class)).getCommandFactory();
        this.fProcService = (IGDBProcesses)this.fTracker.getService(IGDBProcesses.class);
        this.fDebuggerCommands = (IGnuArmDebuggerCommandsService)this.fTracker.getService(IGnuArmDebuggerCommandsService.class);
        if (this.fCommandControl == null || this.fCommandFactory == null || this.fProcService == null || this.fDebuggerCommands == null) {
            rm.setStatus((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", 10005, "Cannot obtain service", null));
            rm.done();
            return;
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepRestartCommands(RequestMonitor rm) {
        ArrayList<String> commandsList = new ArrayList<String>();
        IStatus status = this.fDebuggerCommands.addGnuArmRestartCommands(commandsList);
        if (!status.isOK()) {
            rm.setStatus(status);
            rm.done();
            return;
        }
        this.queueCommands(commandsList, rm);
    }
}

