/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.debug.gdbjtag.render.peripherals;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.core.SystemUIJob;
import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.memory.MemoryBlockMonitor;
import ilg.gnuarmeclipse.debug.gdbjtag.memory.PeripheralMemoryBlockExtension;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.progress.UIJob;

public class PeripheralsView
extends VariablesView
implements IMemoryBlockListener,
IDebugEventSetListener {
    public static final String PRESENTATION_CONTEXT_ID = "PeripheralsView";
    private UIJob fRefreshUIjob = new SystemUIJob(String.valueOf(PeripheralsView.class.getSimpleName()) + "#refreshUIjob"){

        public IStatus runInUIThread(IProgressMonitor pm) {
            Viewer viewer = PeripheralsView.this.getViewer();
            if (viewer != null) {
                viewer.refresh();
            }
            return Status.OK_STATUS;
        }
    };
    Set<PeripheralMemoryBlockExtension> fMemoryBlocks;

    public PeripheralsView() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsView()");
        }
        this.fMemoryBlocks = new HashSet<PeripheralMemoryBlockExtension>();
    }

    protected String getPresentationContextId() {
        return PRESENTATION_CONTEXT_ID;
    }

    protected int getViewerStyle() {
        return 268501794;
    }

    private void addDebugEventListener() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    private void removeDebugEventListener() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i;
        if (Activator.getInstance().isDebugging()) {
            System.out.print("PeripheralsView.handleDebugEvents() " + events.length);
            i = 0;
            while (i < events.length) {
                System.out.print(" " + events[i]);
                ++i;
            }
            System.out.println();
        }
        i = 0;
        while (i < events.length) {
            Object object;
            if (events[i].getKind() == 8) {
                EclipseUtils.clearStatusMessage();
            } else if (events[i].getKind() == 32 && (object = events[i].getSource()) instanceof PeripheralMemoryBlockExtension) {
                this.refresh();
            }
            ++i;
        }
    }

    private void addMemoryBlockListener() {
        DebugPlugin.getDefault().getMemoryBlockManager().addListener((IMemoryBlockListener)this);
    }

    private void removeMemoryBlockListener() {
        DebugPlugin.getDefault().getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
    }

    public void memoryBlocksAdded(IMemoryBlock[] memoryBlocks) {
        int i = 0;
        while (i < memoryBlocks.length) {
            if (memoryBlocks[i] instanceof PeripheralMemoryBlockExtension) {
                PeripheralMemoryBlockExtension memoryBlockExtension = (PeripheralMemoryBlockExtension)memoryBlocks[i];
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("PeripheralsView.memoryBlocksAdded() [] " + (Object)((Object)memoryBlockExtension));
                }
                this.fMemoryBlocks.add(memoryBlockExtension);
            }
            ++i;
        }
    }

    public void memoryBlocksRemoved(IMemoryBlock[] memoryBlocks) {
        int i = 0;
        while (i < memoryBlocks.length) {
            if (memoryBlocks[i] instanceof PeripheralMemoryBlockExtension) {
                PeripheralMemoryBlockExtension memoryBlockExtension = (PeripheralMemoryBlockExtension)memoryBlocks[i];
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("PeripheralsView.memoryBlocksRemoved() [] " + (Object)((Object)memoryBlockExtension));
                }
                this.fMemoryBlocks.remove((Object)memoryBlockExtension);
            }
            ++i;
        }
        this.refresh();
    }

    public Viewer createViewer(Composite composite) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsView.createViewer()");
        }
        TreeModelViewer viewer = (TreeModelViewer)super.createViewer(composite);
        this.addMemoryBlockListener();
        this.addDebugEventListener();
        this.initStates(this.getMemento());
        return viewer;
    }

    public void dispose() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsView.dispose()");
        }
        if (!this.fMemoryBlocks.isEmpty()) {
            IMemoryBlock[] memoryBlocks = this.fMemoryBlocks.toArray(new IMemoryBlock[this.fMemoryBlocks.size()]);
            MemoryBlockMonitor.getInstance().savePeripheralNames(memoryBlocks);
            MemoryBlockMonitor.getInstance().removeMemoryBlocks(memoryBlocks);
        }
        assert (this.fMemoryBlocks.isEmpty());
        this.removeDebugEventListener();
        this.removeMemoryBlockListener();
        super.dispose();
    }

    private void refresh() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsView.refresh()");
        }
        this.fRefreshUIjob.schedule();
    }

    public Object getAdapter(Class required) {
        return super.getAdapter(required);
    }

    private void initStates(IMemento memento) {
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public void saveViewerState(IMemento memento) {
        super.saveViewerState(memento);
    }
}

