/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.FileNotFoundException;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.osgi.util.NLS;

public class LocalAttachLaunchDelegate
extends AbstractCLaunchDelegate {
    @Override
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block15: {
            IBinaryParser.IBinaryObject exeFile = null;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(LaunchMessages.LocalAttachLaunchDelegate_Attaching_to_Local_C_Application, 10);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                monitor.worked(1);
                ICProject cproject = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
                IPath exePath = CDebugUtils.getProgramPath((ILaunchConfiguration)config);
                if (exePath != null && !exePath.isEmpty()) {
                    if (!exePath.isAbsolute()) {
                        IFile wsProgramPath = cproject.getProject().getFile(exePath);
                        exePath = wsProgramPath.getLocation();
                    }
                    if (!exePath.toFile().exists()) {
                        this.abort(LaunchMessages.AbstractCLaunchDelegate_Program_file_does_not_exist, new FileNotFoundException(NLS.bind((String)LaunchMessages.AbstractCLaunchDelegate_PROGRAM_PATH_not_found, (Object)exePath.toOSString())), 104);
                    }
                    exeFile = this.verifyBinary(cproject, exePath);
                }
                if (!mode.equals("debug")) break block15;
                ICDebugConfiguration debugConfig = this.getDebugConfig(config);
                ICDISession dsession = null;
                String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                if (!debugMode.equals("attach")) break block15;
                if (config.getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1) == -1) {
                    int pid = this.promptForProcessID(config);
                    if (pid == -1) {
                        this.cancel(LaunchMessages.LocalAttachLaunchDelegate_No_Process_ID_selected, 107);
                    }
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", pid);
                    wc.launch(mode, (IProgressMonitor)new SubProgressMonitor(monitor, 9));
                    wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", null);
                    this.cancel("", -1);
                    break block15;
                }
                dsession = debugConfig.createDebugger().createDebuggerSession(launch, exeFile, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                try {
                    this.setDefaultSourceLocator(launch, config);
                    ICDITarget[] targets = dsession.getTargets();
                    int i = 0;
                    while (i < targets.length) {
                        CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)cproject.getProject(), (ICDITarget)targets[i], (String)this.renderTargetLabel(debugConfig), null, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)true, (boolean)false);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    try {
                        dsession.terminate();
                    }
                    catch (CDIException cDIException) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected int promptForProcessID(ILaunchConfiguration config) throws CoreException {
        Object result;
        Status fPromptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
        Status processPrompt = new Status(1, "org.eclipse.cdt.launch", 100, "", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)fPromptStatus);
        if (prompter != null && (result = prompter.handleStatus((IStatus)processPrompt, (Object)config)) instanceof Integer) {
            return (Integer)result;
        }
        return -1;
    }

    @Override
    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

