/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import org.eclipse.tracecompass.tmf.core.parsers.custom.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class CustomTraceDefinition {
    public static final int ACTION_SET = 0;
    public static final int ACTION_APPEND = 1;
    public static final int ACTION_APPEND_WITH_SEPARATOR = 2;
    public static final String TAG_TIMESTAMP = Messages.CustomTraceDefinition_timestampTag;
    public static final String TAG_MESSAGE = Messages.CustomTraceDefinition_messageTag;
    public static final String TAG_OTHER = Messages.CustomTraceDefinition_otherTag;
    public String categoryName;
    public String definitionName;
    public List<OutputColumn> outputs;
    public String timeStampOutputFormat;

    public String formatTimeStamp(TmfTimestamp timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.timeStampOutputFormat);
        return simpleDateFormat.format(timestamp.getValue());
    }

    public abstract void save();

    public abstract void save(String var1);

    protected static EntityResolver createEmptyEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                String empty = "";
                ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                return new InputSource(bais);
            }
        };
    }

    protected static ErrorHandler createErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException saxparseexception) throws SAXException {
            }

            @Override
            public void warning(SAXParseException saxparseexception) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException saxparseexception) throws SAXException {
                throw saxparseexception;
            }
        };
    }

    public static class OutputColumn {
        public String name;

        public OutputColumn() {
        }

        public OutputColumn(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

