/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.timestamp;

import java.util.TimeZone;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public class TmfTimestampDelta
extends TmfTimestamp {
    public TmfTimestampDelta() {
    }

    public TmfTimestampDelta(long value) {
        super(value);
    }

    public TmfTimestampDelta(long value, int scale) {
        super(value, scale);
    }

    public TmfTimestampDelta(ITmfTimestamp timestamp) {
        super(timestamp);
    }

    @Override
    public ITmfTimestamp normalize(long offset, int scale) {
        ITmfTimestamp nts = super.normalize(offset, scale);
        return new TmfTimestampDelta(nts.getValue(), nts.getScale());
    }

    @Override
    public String toString() {
        return this.toString(TmfTimestampFormat.getDefaulIntervalFormat());
    }

    @Override
    public String toString(TmfTimestampFormat format) {
        if (this.getValue() < 0L) {
            TmfTimestampDelta tmpTs = new TmfTimestampDelta(-this.getValue(), this.getScale());
            return "-" + tmpTs.toString(format);
        }
        TmfTimestampFormat deltaFormat = new TmfTimestampFormat(format.toPattern());
        deltaFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return super.toString(deltaFormat);
    }
}

