/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.RemedyElementCategory;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.Remedy;
import org.eclipse.equinox.p2.operations.RemedyIUDetail;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class ElementUtils {
    public static void updateRepositoryUsingElements(ProvisioningUI ui, MetadataRepositoryElement[] elements) {
        ui.signalRepositoryOperationStart();
        IMetadataRepositoryManager metaManager = ProvUI.getMetadataRepositoryManager(ui.getSession());
        IArtifactRepositoryManager artManager = ProvUI.getArtifactRepositoryManager(ui.getSession());
        try {
            int visibilityFlags = ui.getRepositoryTracker().getMetadataRepositoryFlags();
            URI[] currentlyEnabled = metaManager.getKnownRepositories(visibilityFlags);
            URI[] currentlyDisabled = metaManager.getKnownRepositories(8 | visibilityFlags);
            int i = 0;
            while (i < elements.length) {
                URI location = elements[i].getLocation();
                if (elements[i].isEnabled()) {
                    if (ElementUtils.containsURI(currentlyDisabled, location)) {
                        ElementUtils.setColocatedRepositoryEnablement(ui, location, true);
                    } else if (!ElementUtils.containsURI(currentlyEnabled, location)) {
                        metaManager.addRepository(location);
                        artManager.addRepository(location);
                    }
                } else if (ElementUtils.containsURI(currentlyEnabled, location)) {
                    ElementUtils.setColocatedRepositoryEnablement(ui, location, false);
                } else if (!ElementUtils.containsURI(currentlyDisabled, location)) {
                    metaManager.addRepository(location);
                    artManager.addRepository(location);
                    ElementUtils.setColocatedRepositoryEnablement(ui, location, false);
                }
                String name = elements[i].getName();
                if (name != null && name.length() > 0) {
                    metaManager.setRepositoryProperty(location, "p2.nickname", name);
                    artManager.setRepositoryProperty(location, "p2.nickname", name);
                }
                ++i;
            }
            HashSet<String> nowKnown = new HashSet<String>();
            int i2 = 0;
            while (i2 < elements.length) {
                nowKnown.add(URIUtil.toUnencodedString((URI)elements[i2].getLocation()));
                ++i2;
            }
            i2 = 0;
            while (i2 < currentlyEnabled.length) {
                if (!nowKnown.contains(URIUtil.toUnencodedString((URI)currentlyEnabled[i2]))) {
                    metaManager.removeRepository(currentlyEnabled[i2]);
                    artManager.removeRepository(currentlyEnabled[i2]);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < currentlyDisabled.length) {
                if (!nowKnown.contains(URIUtil.toUnencodedString((URI)currentlyDisabled[i2]))) {
                    metaManager.removeRepository(currentlyDisabled[i2]);
                    artManager.removeRepository(currentlyDisabled[i2]);
                }
                ++i2;
            }
        }
        finally {
            ui.signalRepositoryOperationComplete(null, true);
        }
    }

    private static void setColocatedRepositoryEnablement(ProvisioningUI ui, URI location, boolean enable) {
        ProvUI.getArtifactRepositoryManager(ui.getSession()).setEnabled(location, enable);
        ProvUI.getMetadataRepositoryManager(ui.getSession()).setEnabled(location, enable);
    }

    public static IInstallableUnit getIU(Object element) {
        if (element instanceof IInstallableUnit) {
            return (IInstallableUnit)element;
        }
        if (element instanceof IIUElement) {
            return ((IIUElement)element).getIU();
        }
        return ProvUI.getAdapter(element, IInstallableUnit.class);
    }

    public static List<IInstallableUnit> elementsToIUs(Object[] elements) {
        ArrayList<IInstallableUnit> theIUs = new ArrayList<IInstallableUnit>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IInstallableUnit iu = ProvUI.getAdapter(elements[i], IInstallableUnit.class);
            if (iu != null) {
                theIUs.add(iu);
            }
            ++i;
        }
        return theIUs;
    }

    public static IInstallableUnit elementToIU(Object selectedElement) {
        return ProvUI.getAdapter(selectedElement, IInstallableUnit.class);
    }

    static boolean containsURI(URI[] locations, URI url) {
        int i = 0;
        while (i < locations.length) {
            if (locations[i].equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static AvailableIUElement[] requestToElement(Remedy remedy, boolean installMode) {
        if (remedy == null) {
            return new AvailableIUElement[0];
        }
        ArrayList<AvailableIUElement> temp = new ArrayList<AvailableIUElement>();
        IUElementListRoot root = new IUElementListRoot();
        for (RemedyIUDetail iuDetail : remedy.getIusDetails()) {
            if (iuDetail.getStatus() == 3) continue;
            AvailableIUElement element = new AvailableIUElement(root, iuDetail.getIu(), ProvisioningUI.getDefaultUI().getProfileId(), true);
            if (iuDetail.getBeingInstalledVersion() != null && iuDetail.getRequestedVersion() != null && iuDetail.getBeingInstalledVersion().compareTo((Object)iuDetail.getRequestedVersion()) < 0 && !installMode) {
                element.setImageOverlayId("obj/iu_info.gif");
            } else if (iuDetail.getStatus() == 2) {
                element.setImageId("obj/iu_remove.gif");
            }
            temp.add(element);
        }
        return temp.toArray(new AvailableIUElement[temp.size()]);
    }

    public static RemedyElementCategory[] requestToRemedyElementsCategories(Remedy remedy) {
        ArrayList<RemedyElementCategory> categories = new ArrayList<RemedyElementCategory>();
        RemedyElementCategory categoryAdded = new RemedyElementCategory(ProvUIMessages.RemedyCategoryAdded);
        RemedyElementCategory cateogyRemoved = new RemedyElementCategory(ProvUIMessages.RemedyCategoryRemoved);
        RemedyElementCategory categoryNotAdded = new RemedyElementCategory(ProvUIMessages.RemedyCategoryNotAdded);
        RemedyElementCategory categoryChanged = new RemedyElementCategory(ProvUIMessages.RemedyCategoryChanged);
        for (RemedyIUDetail remedyIUVersions : remedy.getIusDetails()) {
            if (remedyIUVersions.getStatus() == 1) {
                categoryAdded.add(remedyIUVersions);
                continue;
            }
            if (remedyIUVersions.getStatus() == 4) {
                categoryChanged.add(remedyIUVersions);
                continue;
            }
            if (remedyIUVersions.getStatus() == 2) {
                cateogyRemoved.add(remedyIUVersions);
                continue;
            }
            if (remedyIUVersions.getStatus() != 3) continue;
            categoryNotAdded.add(remedyIUVersions);
        }
        if (cateogyRemoved.getElements().size() > 0) {
            categories.add(cateogyRemoved);
        }
        if (categoryChanged.getElements().size() > 0) {
            categories.add(categoryChanged);
        }
        if (categoryNotAdded.getElements().size() > 0) {
            categories.add(categoryNotAdded);
        }
        if (categoryAdded.getElements().size() > 0) {
            categories.add(categoryAdded);
        }
        return categories.toArray(new RemedyElementCategory[categories.size()]);
    }
}

