/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.MakefileContentOutlinePage;
import org.eclipse.cdt.make.ui.dialogs.MakeTargetDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;

public class AddBuildTargetAction
extends Action {
    MakefileContentOutlinePage fOutliner;
    static final ITargetRule[] EMPTY_TARGET_RULES = new ITargetRule[0];

    public AddBuildTargetAction(MakefileContentOutlinePage outliner) {
        super(MakeUIPlugin.getResourceString("AddBuildTargetAction.title"));
        this.setDescription(MakeUIPlugin.getResourceString("AddBuildTargetAction.description"));
        this.setToolTipText(MakeUIPlugin.getResourceString("AddBuildTargetAction.tooltip"));
        this.fOutliner = outliner;
    }

    public void run() {
        IMakeTargetManager manager = MakeCorePlugin.getDefault().getTargetManager();
        IFile file = this.getFile();
        Shell shell = this.fOutliner.getControl().getShell();
        ITargetRule[] rules = this.getTargetRules(this.fOutliner.getSelection());
        if (file != null && rules.length > 0 && shell != null) {
            StringBuffer sbBuildName = new StringBuffer();
            StringBuffer sbMakefileTarget = new StringBuffer();
            ITargetRule[] iTargetRuleArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetRule rule = iTargetRuleArray[n2];
                String name = rule.getTarget().toString().trim();
                if (sbBuildName.length() == 0) {
                    sbBuildName.append(name);
                } else {
                    sbBuildName.append('_').append(name);
                }
                if (sbMakefileTarget.length() == 0) {
                    sbMakefileTarget.append(name);
                } else {
                    sbMakefileTarget.append(' ').append(name);
                }
                ++n2;
            }
            String buildName = this.generateUniqueName(file.getParent(), sbBuildName.toString());
            String makefileTarget = sbMakefileTarget.toString();
            IMakeTarget target = null;
            try {
                String[] ids = manager.getTargetBuilders(file.getProject());
                if (ids.length > 0) {
                    target = manager.createTarget(file.getProject(), buildName, ids[0]);
                    target.setBuildAttribute(IMakeTarget.BUILD_TARGET, makefileTarget);
                    target.setContainer(file.getParent());
                }
            }
            catch (CoreException e) {
                MakeUIPlugin.errorDialog(shell, MakeUIPlugin.getResourceString("AddBuildTargetAction.exception.internal"), e.toString(), e);
                target = null;
            }
            if (target != null) {
                try {
                    MakeTargetDialog dialog = new MakeTargetDialog(shell, target);
                    dialog.open();
                }
                catch (CoreException e) {
                    MakeUIPlugin.errorDialog(shell, MakeUIPlugin.getResourceString("AddBuildTargetAction.exception.internal"), e.toString(), e);
                }
            }
        }
    }

    private String generateUniqueName(IContainer container, String targetString) {
        String newName = targetString;
        int i = 0;
        IMakeTargetManager manager = MakeCorePlugin.getDefault().getTargetManager();
        try {
            while (manager.findTarget(container, newName) != null) {
                newName = String.valueOf(targetString) + " (" + Integer.toString(++i) + ")";
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return newName;
    }

    public boolean canActionBeAdded(ISelection selection) {
        ITargetRule[] rules = this.getTargetRules(selection);
        if (rules.length == 0) {
            return false;
        }
        IFile file = this.getFile();
        if (file == null) {
            return false;
        }
        return MakeCorePlugin.getDefault().getTargetManager().hasTargetBuilder(file.getProject());
    }

    private IFile getFile() {
        Object input = this.fOutliner.getInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    private ITargetRule[] getTargetRules(ISelection sel) {
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() > 0) {
            Object[] elements;
            ArrayList<ITargetRule> targets = new ArrayList<ITargetRule>(list.size());
            Object[] objectArray = elements = list.toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof ITargetRule) {
                    targets.add((ITargetRule)element);
                }
                ++n2;
            }
            return targets.toArray(EMPTY_TARGET_RULES);
        }
        return EMPTY_TARGET_RULES;
    }
}

