/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.cmsis;

import com.github.zafarkhaja.semver.Version;
import ilg.gnuarmeclipse.core.StringUtils;
import ilg.gnuarmeclipse.core.Xml;
import ilg.gnuarmeclipse.packs.cmsis.PdscParser;
import ilg.gnuarmeclipse.packs.cmsis.PdscUtils;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.core.tree.PackNode;
import ilg.gnuarmeclipse.packs.data.Activator;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PdscParserFull
extends PdscParser {
    private boolean fIsBrief = false;

    public void setIsBrief(boolean brief) {
        this.fIsBrief = brief;
    }

    public boolean isBrief() {
        return this.fIsBrief;
    }

    public Node parsePdscFull() throws ParserConfigurationException, SAXException, IOException {
        Node tree = new Node("outline");
        tree.setName("Full Outline");
        tree.putProperty("folder", this.fPath.removeLastSegments(1).toString());
        Element packageElement = this.fDocument.getDocumentElement();
        String firstElementName = packageElement.getNodeName();
        if (!"package".equals(firstElementName)) {
            Activator.log((String)("Missing <packages>, <" + firstElementName + "> encountered"));
            return tree;
        }
        String schemaVersion = packageElement.getAttribute("schemaVersion").trim();
        Version semVer = Version.valueOf((String)schemaVersion);
        if (!PdscUtils.isSchemaValid(semVer)) {
            Activator.log((String)("Unrecognised schema version " + schemaVersion));
            return tree;
        }
        Node packNode = new Node("package");
        tree.addChild((Leaf)packNode);
        packNode.putProperty("schema", schemaVersion);
        String packDescription = "";
        List childElements = Xml.getChildrenElementsList((Element)packageElement);
        for (Element childElement : childElements) {
            String elementName2;
            List childElements2;
            String elementName = childElement.getNodeName();
            if ("vendor".equals(elementName)) {
                String vendorName = Xml.getElementContent((Element)childElement);
                packNode.putProperty("vendor", vendorName);
                continue;
            }
            if ("name".equals(elementName)) {
                String packName = Xml.getElementContent((Element)childElement);
                packNode.setName(packName);
                packNode.putProperty("name", packName);
                packDescription = "Package: " + packName;
                continue;
            }
            if ("description".equals(elementName)) {
                packDescription = this.extendDescription(packDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("url".equals(elementName)) {
                String url = Xml.getElementContent((Element)childElement);
                packNode.putNonEmptyProperty("url", url);
                packDescription = this.extendDescription(packDescription, "url", url);
                continue;
            }
            if ("license".equals(elementName)) {
                String license = Xml.getElementContent((Element)childElement);
                license = this.updatePosixSeparators(license);
                packNode.putNonEmptyProperty("license", license);
                packDescription = this.extendDescription(packDescription, "license", license);
                continue;
            }
            if ("releases".equals(elementName)) {
                List releaseElements = Xml.getChildrenElementsList((Element)childElement, (String)"release");
                for (Element releaseElement : releaseElements) {
                    String releaseVersion = releaseElement.getAttribute("version").trim();
                    String releaseDate = releaseElement.getAttribute("date").trim();
                    String description = "Version: " + releaseVersion;
                    if (releaseDate.length() > 0) {
                        description = String.valueOf(description) + ", from " + releaseDate;
                    }
                    description = this.extendDescription(description, Xml.getElementContent((Element)releaseElement));
                    Node versionNode = new Node("version");
                    versionNode.setName(releaseVersion);
                    versionNode.putProperty("name", releaseVersion);
                    versionNode.putNonEmptyProperty("date", releaseDate);
                    versionNode.setDescription(description);
                    tree.addChild((Leaf)versionNode);
                }
                continue;
            }
            if ("keywords".equals(elementName)) {
                childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    elementName2 = childElement2.getNodeName();
                    if ("keyword".equals(elementName2)) {
                        this.processKeywordElement(childElement2, tree);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            if ("devices".equals(elementName)) {
                childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    elementName2 = childElement2.getNodeName();
                    if ("family".equals(elementName2)) {
                        this.processFamilyElement(childElement2, tree);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            if ("boards".equals(elementName)) {
                childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    elementName2 = childElement2.getNodeName();
                    if ("board".equals(elementName2)) {
                        this.processBoardElement(childElement2, tree);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            if ("conditions".equals(elementName)) {
                childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    elementName2 = childElement2.getNodeName();
                    if ("condition".equals(elementName2)) {
                        this.processConditionElement(childElement2, tree);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            if ("examples".equals(elementName)) {
                childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    elementName2 = childElement2.getNodeName();
                    if ("example".equals(elementName2)) {
                        this.processExampleElement(childElement2, tree, false);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            if ("components".equals(elementName)) {
                childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    elementName2 = childElement2.getNodeName();
                    if ("component".equals(elementName2)) {
                        this.processComponentElement(childElement2, tree, "");
                        continue;
                    }
                    if ("bundle".equals(elementName2)) {
                        this.processBundleElement(childElement2, tree);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            if ("apis".equals(elementName)) {
                childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    elementName2 = childElement2.getNodeName();
                    if ("api".equals(elementName2)) {
                        this.processApiElement(childElement2, tree);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            if ("taxonomy".equals(elementName)) {
                childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    elementName2 = childElement2.getNodeName();
                    if ("description".equals(elementName2)) {
                        this.processTaxonomyDescription(childElement2, tree);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            Activator.log((String)("Not processed <" + elementName + ">"));
        }
        packDescription = this.extendDescription(packDescription, "schema", schemaVersion);
        packNode.setDescription(packDescription);
        return tree;
    }

    public void parseExamples(Node parent) {
        Element packageElement = this.fDocument.getDocumentElement();
        Element examplesElement = Xml.getFirstChildElement((Element)packageElement, (String)"examples");
        if (examplesElement != null) {
            List exampleElements = Xml.getChildrenElementsList((Element)examplesElement, (String)"example");
            for (Element exampleElement : exampleElements) {
                PackNode exampleNode;
                String exampleName = exampleElement.getAttribute("name").trim();
                Element boardElement = Xml.getFirstChildElement((Element)exampleElement, (String)"board");
                String boardName = boardElement.getAttribute("name");
                if (boardName.length() > 0) {
                    exampleName = String.valueOf(exampleName) + " (" + boardName + ")";
                }
                if ((exampleNode = (PackNode)parent.findChild("example", exampleName)) == null) {
                    exampleNode = new PackNode("example");
                    parent.addChild((Leaf)exampleNode);
                    exampleNode.setName(exampleName);
                }
                Element descriptionElement = Xml.getFirstChildElement((Element)exampleElement, (String)"description");
                String description = Xml.getElementContent((Element)descriptionElement);
                exampleNode.setDescription(description);
                Node outlineNode = new Node("outline");
                exampleNode.setOutline(outlineNode);
                this.processExampleElement(exampleElement, outlineNode, true);
            }
        }
    }

    private void processFamilyElement(Element el, Node parent) {
        String familyName = el.getAttribute("Dfamily").trim();
        String familyVendor = el.getAttribute("Dvendor").trim();
        String[] va = familyVendor.split("[:]");
        Node familyNode = new Node("family");
        parent.addChild((Leaf)familyNode);
        familyNode.setName(String.valueOf(familyName) + " (family)");
        familyNode.putProperty("name", familyName);
        familyNode.putProperty("vendor", va[0]);
        familyNode.putProperty("vendorid", va[1]);
        String familyDescription = "Device family: " + familyName;
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if (this.isBrief()) {
                if (!"description".equals(elementName)) continue;
                familyDescription = this.extendDescription(familyDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("description".equals(elementName)) {
                familyDescription = this.extendDescription(familyDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("subFamily".equals(elementName)) {
                this.processSubFamilyElement(childElement, familyNode);
                continue;
            }
            if ("device".equals(elementName)) {
                this.processDeviceElement(childElement, familyNode);
                continue;
            }
            this.processDevicePropertiesGroup(childElement, familyNode);
        }
        familyNode.setDescription(familyDescription);
    }

    private void processProcessorElement(Element el, Node parent) {
        String Dcore = el.getAttribute("Dcore").trim();
        String DcoreVersion = el.getAttribute("DcoreVersion").trim();
        String Dfpu = el.getAttribute("Dfpu").trim();
        String Dmpu = el.getAttribute("Dmpu").trim();
        String Dendian = el.getAttribute("Dendian").trim();
        String Dclock = el.getAttribute("Dclock").trim();
        Node processorNode = new Node("processor");
        parent.addChild((Leaf)processorNode);
        String name = Dcore.length() > 0 ? Dcore : (Dclock.length() > 0 ? Dclock : "Processor");
        processorNode.setName(name);
        processorNode.putNonEmptyProperty("core", Dcore);
        processorNode.putNonEmptyProperty("version", DcoreVersion);
        processorNode.putNonEmptyProperty("fpu", Dfpu);
        processorNode.putNonEmptyProperty("mpu", Dmpu);
        processorNode.putNonEmptyProperty("endian", Dendian);
        processorNode.putNonEmptyProperty("clock", Dclock);
        String description = "Processor";
        description = this.extendDescription(description, "Dcore", Dcore);
        description = this.extendDescription(description, "DcoreVersion", DcoreVersion);
        description = this.extendDescription(description, "Dfpu", Dfpu);
        description = this.extendDescription(description, "Dmpu", Dmpu);
        description = this.extendDescription(description, "Dendian", Dendian);
        description = this.extendDescription(description, "Dclock", Dclock);
        processorNode.setDescription(description);
    }

    private void processFeatureElement(Element el, Node parent) {
        String featureType = el.getAttribute("type").trim();
        String featureN = el.getAttribute("n").trim();
        String featureM = el.getAttribute("m").trim();
        String name = el.getAttribute("name").trim();
        String Pname = el.getAttribute("Pname").trim();
        Node featureNode = new Node("feature");
        parent.addChild((Leaf)featureNode);
        featureNode.setName(featureType);
        featureNode.putNonEmptyProperty("name", name);
        featureNode.putNonEmptyProperty("n", featureN);
        featureNode.putNonEmptyProperty("m", featureM);
        featureNode.putNonEmptyProperty("pname", Pname);
        String description = "Feature";
        if (name.length() > 0) {
            description = String.valueOf(description) + ": " + name;
        }
        description = this.extendDescription(description, "type", featureType);
        description = this.extendDescription(description, "n", featureN);
        description = this.extendDescription(description, "m", featureM);
        description = this.extendDescription(description, "Pname", Pname);
        featureNode.setDescription(description);
    }

    private void processBookElement(Element el, Node parent) {
        String bookName = el.getAttribute("name").trim();
        String bookTitle = el.getAttribute("title").trim();
        String category = el.getAttribute("category").trim();
        Node bookNode = new Node("book");
        parent.addChild((Leaf)bookNode);
        bookNode.setName(bookTitle);
        String description = "Book: " + bookTitle;
        String posixName = this.updatePosixSeparators(bookName);
        if (bookName.startsWith("http://") || bookName.startsWith("https://") || bookName.startsWith("ftp://")) {
            bookNode.putNonEmptyProperty("url", bookName);
            description = this.extendDescription(description, "url", bookName);
        } else {
            bookNode.putNonEmptyProperty("file", posixName);
            description = this.extendDescription(description, "file", posixName);
        }
        bookNode.putNonEmptyProperty("title", bookTitle);
        bookNode.putNonEmptyProperty("category", category);
        description = this.extendDescription(description, "category", category);
        bookNode.setDescription(description);
    }

    private void processSubFamilyElement(Element el, Node parent) {
        String subFamilyName = el.getAttribute("DsubFamily").trim();
        Node subFamilyNode = new Node("subfamily");
        parent.addChild((Leaf)subFamilyNode);
        subFamilyNode.setName(String.valueOf(subFamilyName) + " (subfamily)");
        subFamilyNode.putProperty("name", subFamilyName);
        String description = "Device subfamily: " + subFamilyName;
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("description".equals(elementName)) {
                description = this.extendDescription(description, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("device".equals(elementName)) {
                this.processDeviceElement(childElement, subFamilyNode);
                continue;
            }
            this.processDevicePropertiesGroup(childElement, subFamilyNode);
        }
        subFamilyNode.setDescription(description);
    }

    private void processDeviceElement(Element el, Node parent) {
        String deviceName = el.getAttribute("Dname").trim();
        Node deviceNode = new Node("device");
        parent.addChild((Leaf)deviceNode);
        deviceNode.setName(String.valueOf(deviceName) + " (device)");
        deviceNode.putProperty("name", deviceName);
        String descriptionContent = "";
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("description".equals(elementName)) {
                descriptionContent = Xml.getElementContent((Element)childElement);
                continue;
            }
            if ("variant".equals(elementName)) {
                String variantName = childElement.getAttribute("Dvariant").trim();
                Node variantNode = new Node("variant");
                deviceNode.addChild((Leaf)variantNode);
                variantNode.setName(String.valueOf(variantName) + " (variant)");
                variantNode.putProperty("name", variantName);
                String variantDescriptionContent = "Device variant: " + variantName;
                List childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    String elementName2 = childElement2.getNodeName();
                    if ("description".equals(elementName2)) {
                        variantDescriptionContent = this.extendDescription(variantDescriptionContent, Xml.getElementContent((Element)childElement));
                        continue;
                    }
                    this.processDevicePropertiesGroup(childElement2, variantNode);
                }
                variantNode.setDescription(variantDescriptionContent);
                continue;
            }
            this.processDevicePropertiesGroup(childElement, deviceNode);
        }
        String deviceDescription = "Device: " + deviceName;
        int ramKB = 0;
        int romKB = 0;
        if (deviceNode.hasChildren()) {
            for (Leaf childNode : deviceNode.getChildren()) {
                if (!"memory".equals(childNode.getType())) continue;
                String size = childNode.getProperty("size");
                long sizeKB = StringUtils.convertHexLong((String)size) / 1024L;
                String id = childNode.getProperty("id");
                if (id.contains("ROM")) {
                    romKB = (int)((long)romKB + sizeKB);
                    continue;
                }
                if (!id.contains("RAM")) continue;
                ramKB = (int)((long)ramKB + sizeKB);
            }
        }
        if (ramKB > 0) {
            if (deviceDescription.length() > 0) {
                deviceDescription = String.valueOf(deviceDescription) + ", ";
            }
            deviceDescription = String.valueOf(deviceDescription) + String.valueOf(ramKB) + " kB RAM";
        }
        if (romKB > 0) {
            if (deviceDescription.length() > 0) {
                deviceDescription = String.valueOf(deviceDescription) + ", ";
            }
            deviceDescription = String.valueOf(deviceDescription) + String.valueOf(romKB) + " kB ROM";
        }
        deviceDescription = this.extendDescription(deviceDescription, descriptionContent);
        deviceNode.setDescription(deviceDescription);
    }

    private void processDevicePropertiesGroup(Element el, Node parent) {
        String elementName = el.getNodeName();
        if ("processor".equals(elementName)) {
            this.processProcessorElement(el, parent);
        } else if ("compile".equals(elementName)) {
            String header = el.getAttribute("header").trim();
            String define = el.getAttribute("define").trim();
            String Pname = el.getAttribute("Pname").trim();
            if (Pname.length() > 0) {
                Activator.log((String)("Pname not processed " + Pname));
            }
            Node headerNode = new Node("header");
            parent.addChild((Leaf)headerNode);
            String posixHeader = this.updatePosixSeparators(header);
            String[] va = posixHeader.split("/");
            headerNode.setName(va[va.length - 1]);
            headerNode.setDescription("Header file: " + posixHeader);
            headerNode.putProperty("file", posixHeader);
            headerNode.putNonEmptyProperty("define", define);
            if (define.length() > 0) {
                Node defineNode = new Node("define");
                parent.addChild((Leaf)defineNode);
                defineNode.setName(define);
                defineNode.setDescription("Macro definition");
            }
        } else if ("memory".equals(elementName)) {
            String id = el.getAttribute("id").trim();
            String start = el.getAttribute("start").trim();
            String size = el.getAttribute("size").trim();
            String Pname = el.getAttribute("Pname").trim();
            String startup = el.getAttribute("startup").trim();
            String init = el.getAttribute("init").trim();
            String defa = el.getAttribute("default").trim();
            Node memoryNode = new Node("memory");
            parent.addChild((Leaf)memoryNode);
            memoryNode.setName(id);
            memoryNode.putProperty("id", id);
            memoryNode.putProperty("start", start);
            memoryNode.putProperty("size", size);
            memoryNode.putNonEmptyProperty("pname", Pname);
            memoryNode.putNonEmptyProperty("startup", startup);
            memoryNode.putNonEmptyProperty("init", init);
            memoryNode.putNonEmptyProperty("default", defa);
            String description = id.contains("ROM") ? "ROM area" : (id.contains("RAM") ? "RAM area" : "Memory");
            description = this.extendDescription(description, "id", id);
            description = this.extendDescription(description, "start", start);
            description = this.extendDescription(description, "size", size);
            description = this.extendDescription(description, "startup", startup);
            description = this.extendDescription(description, "init", init);
            description = this.extendDescription(description, "default", defa);
            description = this.extendDescription(description, "Pname", Pname);
            memoryNode.setDescription(description);
        } else if (!"algorithm".equals(elementName)) {
            if ("book".equals(elementName)) {
                this.processBookElement(el, parent);
            } else if ("feature".equals(elementName)) {
                this.processFeatureElement(el, parent);
            } else if ("debug".equals(elementName)) {
                String Pname = el.getAttribute("Pname").trim();
                String dp = el.getAttribute("dp").trim();
                String ap = el.getAttribute("ap").trim();
                String svd = el.getAttribute("svd").trim();
                String posixSvd = this.updatePosixSeparators(svd);
                String[] va = posixSvd.split("/");
                Node debugNode = new Node("debug");
                parent.addChild((Leaf)debugNode);
                debugNode.setName(va[va.length - 1]);
                debugNode.putProperty("file", posixSvd);
                debugNode.putNonEmptyProperty("pname", Pname);
                debugNode.putNonEmptyProperty("dp", dp);
                debugNode.putNonEmptyProperty("ap", ap);
                String description = "Debug";
                description = this.extendDescription(description, "Pname", Pname);
                description = this.extendDescription(description, "dp", dp);
                description = this.extendDescription(description, "ap", ap);
                description = this.extendDescription(description, "svd", posixSvd);
                debugNode.setDescription(description);
            } else {
                Activator.log((String)("Not processed <" + elementName + ">"));
            }
        }
    }

    private void processBoardElement(Element el, Node parent) {
        String boardVendor = el.getAttribute("vendor").trim();
        String boardName = el.getAttribute("name").trim();
        String boardRevision = el.getAttribute("revision").trim();
        String salesContact = el.getAttribute("salesContact").trim();
        String orderForm = el.getAttribute("orderForm").trim();
        Node boardNode = new Node("board");
        parent.addChild((Leaf)boardNode);
        boardNode.setName(boardName);
        boardNode.putProperty("vendor", boardVendor);
        boardNode.putProperty("name", boardName);
        boardNode.putNonEmptyProperty("revision", boardRevision);
        String boardDescription = "Board: " + boardName;
        String descriptionTail = "";
        descriptionTail = this.extendDescription(descriptionTail, "revision", boardRevision);
        descriptionTail = this.extendDescription(descriptionTail, "vendor", boardVendor);
        descriptionTail = this.extendDescription(descriptionTail, "salesContact", salesContact);
        descriptionTail = this.extendDescription(descriptionTail, "orderForm", orderForm);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String deviceDescription;
            String name;
            String[] va;
            Node deviceNode;
            String Dname;
            String DsubFamily;
            String Dfamily;
            String elementName = childElement.getNodeName();
            if (this.isBrief()) {
                if (!"description".equals(elementName)) continue;
                boardDescription = this.extendDescription(boardDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("description".equals(elementName)) {
                boardDescription = this.extendDescription(boardDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("image".equals(elementName)) continue;
            if ("book".equals(elementName)) {
                this.processBookElement(childElement, boardNode);
                continue;
            }
            if ("mountedDevice".equals(elementName)) {
                String Dvendor = childElement.getAttribute("Dvendor").trim();
                String deviceIndex = childElement.getAttribute("deviceIndex").trim();
                Dfamily = childElement.getAttribute("Dfamily").trim();
                DsubFamily = childElement.getAttribute("DsubFamily").trim();
                Dname = childElement.getAttribute("Dname").trim();
                deviceNode = new Node("device");
                boardNode.addChild((Leaf)deviceNode);
                va = Dvendor.split(":");
                deviceNode.putProperty("vendor", va[0]);
                deviceNode.putProperty("vendorid", va[1]);
                deviceNode.putNonEmptyProperty("deviceindex", deviceIndex);
                deviceNode.putNonEmptyProperty("family", Dfamily);
                deviceNode.putNonEmptyProperty("subfamily", DsubFamily);
                deviceNode.putNonEmptyProperty("name", Dname);
                name = "";
                name = this.extendName(name, Dfamily);
                name = this.extendName(name, DsubFamily);
                name = this.extendName(name, Dname);
                deviceNode.setName(name);
                deviceDescription = "Mounted device: " + name;
                deviceDescription = this.extendDescription(deviceDescription, "deviceIndex", deviceIndex);
                deviceDescription = this.extendDescription(deviceDescription, "Dvendor", Dvendor);
                deviceDescription = this.extendDescription(deviceDescription, "Dfamily", Dfamily);
                deviceDescription = this.extendDescription(deviceDescription, "DsubFamily", DsubFamily);
                deviceDescription = this.extendDescription(deviceDescription, "Dname", Dname);
                deviceNode.setDescription(deviceDescription);
                continue;
            }
            if ("compatibleDevice".equals(elementName)) {
                String deviceIndex = childElement.getAttribute("deviceIndex").trim();
                String Dvendor = childElement.getAttribute("Dvendor").trim();
                Dfamily = childElement.getAttribute("Dfamily").trim();
                DsubFamily = childElement.getAttribute("DsubFamily").trim();
                Dname = childElement.getAttribute("Dname").trim();
                deviceNode = new Node("compatibledevice");
                boardNode.addChild((Leaf)deviceNode);
                va = Dvendor.split(":");
                deviceNode.putProperty("vendor", va[0]);
                deviceNode.putProperty("vendorid", va[1]);
                deviceNode.putNonEmptyProperty("deviceindex", deviceIndex);
                deviceNode.putNonEmptyProperty("family", Dfamily);
                deviceNode.putNonEmptyProperty("subfamily", DsubFamily);
                deviceNode.putNonEmptyProperty("name", Dname);
                name = "";
                name = this.extendName(name, Dfamily);
                name = this.extendName(name, DsubFamily);
                name = this.extendName(name, Dname);
                deviceNode.setName(name);
                deviceDescription = "Compatible device: " + name;
                deviceDescription = this.extendDescription(deviceDescription, "deviceIndex", deviceIndex);
                deviceDescription = this.extendDescription(deviceDescription, "Dvendor", Dvendor);
                deviceDescription = this.extendDescription(deviceDescription, "Dfamily", Dfamily);
                deviceDescription = this.extendDescription(deviceDescription, "DsubFamily", DsubFamily);
                deviceDescription = this.extendDescription(deviceDescription, "Dname", Dname);
                deviceNode.setDescription(deviceDescription);
                continue;
            }
            if ("feature".equals(elementName)) {
                this.processFeatureElement(childElement, boardNode);
                continue;
            }
            if ("debugInterface".equals(elementName)) {
                String adapter = childElement.getAttribute("adapter").trim();
                String connector = childElement.getAttribute("connector").trim();
                Node debugNode = new Node("debuginterface");
                boardNode.addChild((Leaf)debugNode);
                debugNode.putProperty("name", adapter);
                debugNode.putProperty("connector", connector);
                debugNode.setName(adapter);
                String description = "Debug interface: " + adapter;
                description = this.extendDescription(description, "connector", connector);
                debugNode.setDescription(description);
                continue;
            }
            Activator.log((String)("Not processed <" + elementName + ">"));
        }
        boardDescription = this.extendDescription(boardDescription, descriptionTail);
        boardNode.setDescription(boardDescription);
    }

    private void processComponentElement(Element el, Node parent, String parentClass) {
        String Cclass = el.getAttribute("Cclass").trim();
        String Cgroup = el.getAttribute("Cgroup").trim();
        String Cversion = el.getAttribute("Cversion").trim();
        String Csub = el.getAttribute("Csub").trim();
        String Cvariant = el.getAttribute("Cvariant").trim();
        String Cvendor = el.getAttribute("Cvendor").trim();
        String apiVersion = el.getAttribute("Capiversion").trim();
        String condition = el.getAttribute("condition").trim();
        String maxInstances = el.getAttribute("maxInstances").trim();
        Node componentNode = new Node("component");
        parent.addChild((Leaf)componentNode);
        if (!this.isBrief()) {
            componentNode.putProperty("class", Cclass);
            componentNode.putProperty("group", Cgroup);
            componentNode.putProperty("version", Cversion);
            componentNode.putNonEmptyProperty("subgroup", Csub);
            componentNode.putNonEmptyProperty("variant", Cvariant);
            componentNode.putNonEmptyProperty("vendor", Cvendor);
            componentNode.putNonEmptyProperty("condition", condition);
            componentNode.putNonEmptyProperty("apiversion", apiVersion);
            componentNode.putNonEmptyProperty("maxinstances", maxInstances);
        }
        String name = "";
        name = this.extendName(name, Cvendor);
        name = this.extendName(name, Cclass.length() > 0 ? Cclass : parentClass);
        name = this.extendName(name, Cgroup);
        name = this.extendName(name, Csub);
        name = this.extendName(name, Cvariant);
        componentNode.setName(name);
        String componentDescription = "Component: " + name;
        String descriptionTail = "";
        descriptionTail = this.extendDescription(descriptionTail, "Cvendor", Cvendor);
        descriptionTail = this.extendDescription(descriptionTail, "Cclass", Cclass);
        descriptionTail = this.extendDescription(descriptionTail, "Cgroup", Cgroup);
        descriptionTail = this.extendDescription(descriptionTail, "Csub", Csub);
        descriptionTail = this.extendDescription(descriptionTail, "Cvariant", Cvariant);
        descriptionTail = this.extendDescription(descriptionTail, "Cversion", Cversion);
        descriptionTail = this.extendDescription(descriptionTail, "condition", condition);
        descriptionTail = this.extendDescription(descriptionTail, "apiVersion", apiVersion);
        descriptionTail = this.extendDescription(descriptionTail, "maxInstances", maxInstances);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if (this.isBrief()) {
                if (!"description".equals(elementName)) continue;
                componentDescription = this.extendDescription(componentDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("description".equals(elementName)) {
                componentDescription = this.extendDescription(componentDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("RTE_Components_h".equals(elementName)) {
                String rte = Xml.getElementContent((Element)childElement);
                componentNode.putNonEmptyProperty("rte", rte);
                continue;
            }
            if ("deprecated".equals(elementName)) {
                String deprecated = Xml.getElementContent((Element)childElement);
                componentNode.putNonEmptyProperty("deprecated", deprecated);
                continue;
            }
            if ("files".equals(elementName)) {
                List childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    String elementName2 = childElement2.getNodeName();
                    if ("file".equals(elementName2)) {
                        this.processFileElement(childElement2, componentNode);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            Activator.log((String)("Not processed <" + elementName + ">"));
        }
        componentDescription = this.extendDescription(componentDescription, descriptionTail);
        componentNode.setDescription(componentDescription);
    }

    private void processFileElement(Element el, Node parent) {
        String description;
        String name = el.getAttribute("name").trim();
        String category = el.getAttribute("category").trim();
        String attr = el.getAttribute("attr").trim();
        String version = el.getAttribute("version").trim();
        String src = el.getAttribute("src").trim();
        String select = el.getAttribute("select").trim();
        String condition = el.getAttribute("condition").trim();
        Node fileNode = new Node("file");
        parent.addChild((Leaf)fileNode);
        String posixPath = this.updatePosixSeparators(name);
        String[] pathArray = posixPath.split("/");
        String baseName = pathArray[pathArray.length - 1];
        String posixSrc = this.updatePosixSeparators(src);
        fileNode.putProperty("file", posixPath);
        fileNode.putProperty("category", category);
        fileNode.putNonEmptyProperty("attr", attr);
        fileNode.putNonEmptyProperty("version", version);
        fileNode.putNonEmptyProperty("src", posixSrc);
        fileNode.putNonEmptyProperty("select", select);
        fileNode.putNonEmptyProperty("condition", condition);
        if ("include".equals(category)) {
            fileNode.setName(posixPath);
            description = "Include: ";
        } else {
            fileNode.setName(baseName);
            description = "File: ";
        }
        description = String.valueOf(description) + posixPath;
        description = this.extendDescription(description, "category", category);
        description = this.extendDescription(description, "attr", attr);
        description = this.extendDescription(description, "version", version);
        description = this.extendDescription(description, "src", posixSrc);
        description = this.extendDescription(description, "select", select);
        description = this.extendDescription(description, "condition", condition);
        fileNode.setDescription(description);
    }

    private void processBundleElement(Element el, Node parent) {
        String Cbundle = el.getAttribute("Cbundle").trim();
        String Cclass = el.getAttribute("Cclass").trim();
        String Cversion = el.getAttribute("Cversion").trim();
        String Cvendor = el.getAttribute("Cvendor").trim();
        Node bundleNode = new Node("bundle");
        parent.addChild((Leaf)bundleNode);
        if (!this.isBrief()) {
            bundleNode.putProperty("bundle", Cbundle);
            bundleNode.putProperty("class", Cclass);
            bundleNode.putProperty("version", Cversion);
            bundleNode.putNonEmptyProperty("vendor", Cvendor);
        }
        String name = "";
        name = this.extendName(name, Cclass);
        name = this.extendName(name, Cbundle);
        bundleNode.setName(name);
        String bundleDescription = "Bundle: " + name;
        String descriptionTail = "";
        descriptionTail = this.extendDescription(descriptionTail, "Cvendor", Cvendor);
        descriptionTail = this.extendDescription(descriptionTail, "Cbundle", Cbundle);
        descriptionTail = this.extendDescription(descriptionTail, "Cclass", Cclass);
        descriptionTail = this.extendDescription(descriptionTail, "Cversion", Cversion);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if (this.isBrief()) {
                if (!"description".equals(elementName)) continue;
                bundleDescription = this.extendDescription(bundleDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("description".equals(elementName)) {
                bundleDescription = this.extendDescription(bundleDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("doc".equals(elementName)) {
                String doc = Xml.getElementContent((Element)childElement);
                String posixDoc = this.updatePosixSeparators(doc);
                descriptionTail = this.extendDescription(descriptionTail, "doc", posixDoc);
                bundleNode.putNonEmptyProperty("url", doc);
                continue;
            }
            if ("component".equals(elementName)) {
                this.processComponentElement(childElement, bundleNode, Cclass);
                continue;
            }
            Activator.log((String)("Not processed <" + elementName + ">"));
        }
        bundleDescription = this.extendDescription(bundleDescription, descriptionTail);
        bundleNode.setDescription(bundleDescription);
    }

    private void processTaxonomyDescription(Element el, Node parent) {
        String Cclass = el.getAttribute("Cclass").trim();
        String Cgroup = el.getAttribute("Cgroup").trim();
        String doc = el.getAttribute("doc").trim();
        String generator = el.getAttribute("generator").trim();
        Node taxonomyNode = new Node("taxonomy");
        parent.addChild((Leaf)taxonomyNode);
        taxonomyNode.putProperty("class", Cclass);
        taxonomyNode.putNonEmptyProperty("group", Cgroup);
        taxonomyNode.putNonEmptyProperty("doc", doc);
        taxonomyNode.putNonEmptyProperty("generator", generator);
        String name = Cclass;
        name = this.extendName(name, Cgroup);
        taxonomyNode.setName(name);
        String posixDoc = this.updatePosixSeparators(doc);
        String description = "Taxonomy: " + name;
        description = this.extendDescription(description, Xml.getElementContent((Element)el));
        description = this.extendDescription(description, "Cclass", Cclass);
        description = this.extendDescription(description, "Cgroup", Cgroup);
        description = this.extendDescription(description, "doc", posixDoc);
        description = this.extendDescription(description, "generator", generator);
        taxonomyNode.setDescription(description);
    }

    private void processConditionElement(Element el, Node parent) {
        String id = el.getAttribute("id").trim();
        Node conditionNode = new Node("condition");
        parent.addChild((Leaf)conditionNode);
        conditionNode.putProperty("id", id);
        conditionNode.setName(id);
        String conditionDescription = "Condition: " + id;
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("description".equals(elementName)) {
                conditionDescription = this.extendDescription(conditionDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("accept".equals(elementName) || "require".equals(elementName) || "deny".equals(elementName)) {
                String conditionName = "";
                String description = "";
                Node node = null;
                if ("accept".equals(elementName)) {
                    node = new Node("accept");
                    description = "Accept";
                } else if ("require".equals(elementName)) {
                    node = new Node("require");
                    description = "Require";
                } else if ("deny".equals(elementName)) {
                    node = new Node("deny");
                    description = "Deny";
                }
                conditionNode.addChild((Leaf)node);
                List attrNames = Xml.getAttributesNames((Element)childElement, (String[])Node.CONDITION_ATTRIBUTES);
                for (String attrName : attrNames) {
                    String value = childElement.getAttribute(attrName).trim();
                    node.putNonEmptyProperty(attrName, value);
                    conditionName = "Dvendor".equals(attrName) ? this.extendName(conditionName, value.split(":")[0]) : this.extendName(conditionName, value);
                    description = this.extendDescription(description, attrName, value);
                }
                node.setName(conditionName);
                node.setDescription(description);
                continue;
            }
            Activator.log((String)("Not processed <" + elementName + ">"));
        }
        conditionNode.setDescription(conditionDescription);
    }

    private void processApiElement(Element el, Node parent) {
        String Cclass = el.getAttribute("Cclass").trim();
        String Cgroup = el.getAttribute("Cgroup").trim();
        String exclusive = el.getAttribute("exclusive").trim();
        String apiVersion = el.getAttribute("Capiversion").trim();
        Node apiNode = new Node("api");
        parent.addChild((Leaf)apiNode);
        apiNode.putProperty("class", Cclass);
        apiNode.putProperty("group", Cgroup);
        apiNode.putNonEmptyProperty("exclusive", exclusive);
        apiNode.putNonEmptyProperty("apiversion", apiVersion);
        String name = "";
        name = this.extendName(name, Cclass);
        name = this.extendName(name, Cgroup);
        apiNode.setName(name);
        String apiDescription = "Api: " + name;
        String descriptionTail = "";
        descriptionTail = this.extendDescription(descriptionTail, "Cclass", Cclass);
        descriptionTail = this.extendDescription(descriptionTail, "Cgroup", Cgroup);
        descriptionTail = this.extendDescription(descriptionTail, "exclusive", exclusive);
        descriptionTail = this.extendDescription(descriptionTail, "CapiVersion", apiVersion);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("description".equals(elementName)) {
                apiDescription = this.extendDescription(apiDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("files".equals(elementName)) {
                List childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    String elementName2 = childElement2.getNodeName();
                    if ("file".equals(elementName2)) {
                        this.processFileElement(childElement2, apiNode);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            Activator.log((String)("Not processed <" + elementName + ">"));
        }
        apiDescription = this.extendDescription(apiDescription, descriptionTail);
        apiNode.setDescription(apiDescription);
    }

    protected void processExampleElement(Element el, Node parent, boolean isFlat) {
        String exampleName = el.getAttribute("name").trim();
        String exampleFolder = el.getAttribute("folder").trim();
        String exampleDoc = el.getAttribute("doc").trim();
        String exampleVendor = el.getAttribute("vendor").trim();
        String exampleVersion = el.getAttribute("version").trim();
        String exampleArchive = el.getAttribute("archive").trim();
        Node exampleNode = new Node("example");
        parent.addChild((Leaf)exampleNode);
        exampleNode.putProperty("name", exampleName);
        String posixDoc = this.updatePosixSeparators(exampleDoc);
        String posixFolder = this.updatePosixSeparators(exampleFolder);
        if (!this.isBrief()) {
            exampleNode.putProperty("folder", posixFolder);
            exampleNode.putProperty("doc", exampleDoc);
            exampleNode.putNonEmptyProperty("vendor", exampleVendor);
            exampleNode.putNonEmptyProperty("version", exampleVersion);
            exampleNode.putNonEmptyProperty("archive", exampleArchive);
        }
        String exampleDescription = "Example: " + exampleName;
        String descriptionTail = "";
        descriptionTail = this.extendDescription(descriptionTail, "folder", posixFolder);
        descriptionTail = this.extendDescription(descriptionTail, "doc", posixDoc);
        descriptionTail = this.extendDescription(descriptionTail, "version", exampleVersion);
        descriptionTail = this.extendDescription(descriptionTail, "archive", exampleArchive);
        Node linkNode = isFlat ? parent : exampleNode;
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName2;
            List childElements2;
            String elementName = childElement.getNodeName();
            if (this.isBrief()) {
                if ("description".equals(elementName)) {
                    exampleDescription = this.extendDescription(exampleDescription, Xml.getElementContent((Element)childElement));
                    continue;
                }
                if (!"board".equals(elementName)) continue;
                this.processBoardRef(childElement, linkNode);
                continue;
            }
            if ("description".equals(elementName)) {
                exampleDescription = this.extendDescription(exampleDescription, Xml.getElementContent((Element)childElement));
                continue;
            }
            if ("board".equals(elementName)) {
                this.processBoardRef(childElement, linkNode);
                continue;
            }
            if ("project".equals(elementName)) {
                childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    elementName2 = childElement2.getNodeName();
                    if ("environment".equals(elementName2)) {
                        String name = childElement2.getAttribute("name").trim();
                        String load = childElement2.getAttribute("load").trim();
                        Node environmentNode = new Node("environment");
                        linkNode.addChild((Leaf)environmentNode);
                        environmentNode.putProperty("name", name);
                        environmentNode.putProperty("load", load);
                        environmentNode.setName(String.valueOf(load) + " (" + name + ")");
                        String description = "Environment";
                        description = this.extendDescription(description, "name", name);
                        description = this.extendDescription(description, "load", load);
                        environmentNode.setDescription(description);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            if ("attributes".equals(elementName)) {
                childElements2 = Xml.getChildrenElementsList((Element)childElement);
                for (Element childElement2 : childElements2) {
                    elementName2 = childElement2.getNodeName();
                    if ("category".equals(elementName2)) {
                        Node categoryNode = new Node("category");
                        linkNode.addChild((Leaf)categoryNode);
                        String category = Xml.getElementContent((Element)childElement2);
                        categoryNode.putProperty("name", category);
                        categoryNode.setName(category);
                        categoryNode.setDescription("Category: " + category);
                        continue;
                    }
                    if ("component".equals(elementName2)) {
                        String Cclass = childElement2.getAttribute("Cclass").trim();
                        String Cgroup = childElement2.getAttribute("Cgroup").trim();
                        String Csub = childElement2.getAttribute("Csub").trim();
                        String Cversion = childElement2.getAttribute("Cversion").trim();
                        String Cvendor = childElement2.getAttribute("Cvendor").trim();
                        Node componentNode = new Node("component");
                        linkNode.addChild((Leaf)componentNode);
                        componentNode.putProperty("class", Cclass);
                        componentNode.putNonEmptyProperty("class", Cclass);
                        componentNode.putNonEmptyProperty("group", Cgroup);
                        componentNode.putNonEmptyProperty("subgroup", Csub);
                        componentNode.putNonEmptyProperty("version", Cversion);
                        componentNode.putNonEmptyProperty("vendor", Cvendor);
                        String name = "";
                        name = this.extendName(name, Cclass);
                        name = this.extendName(name, Cgroup);
                        name = this.extendName(name, Csub);
                        componentNode.setName(name);
                        String description = "Referred component: " + name;
                        description = this.extendDescription(description, "Cvendor", Cvendor);
                        description = this.extendDescription(description, "Cclass", Cclass);
                        description = this.extendDescription(description, "Cgroup", Cgroup);
                        description = this.extendDescription(description, "Csub", Csub);
                        description = this.extendDescription(description, "Cversion", Cversion);
                        componentNode.setDescription(description);
                        continue;
                    }
                    if ("keyword".equals(elementName2)) {
                        this.processKeywordElement(childElement2, linkNode);
                        continue;
                    }
                    Activator.log((String)("Not processed <" + elementName2 + ">"));
                }
                continue;
            }
            Activator.log((String)("Not processed <" + elementName + ">"));
        }
        String boardName = "";
        if (linkNode.hasChildren()) {
            for (Leaf childNode : linkNode.getChildren()) {
                if (!"board".equals(childNode.getType())) continue;
                boardName = childNode.getName();
                break;
            }
        }
        if (boardName.length() > 0) {
            exampleName = String.valueOf(exampleName) + " (" + boardName + ")";
        }
        exampleNode.setName(exampleName);
        if (this.isBrief()) {
            exampleNode.removeChildren();
        }
        exampleDescription = this.extendDescription(exampleDescription, descriptionTail);
        exampleNode.setDescription(exampleDescription);
    }

    protected void processBoardRef(Element el, Node parent) {
        String boardName = el.getAttribute("name").trim();
        String boardVendor = el.getAttribute("vendor").trim();
        Node boardNode = new Node("board");
        parent.addChild((Leaf)boardNode);
        boardNode.putProperty("name", boardName);
        boardNode.putProperty("vendor", boardVendor);
        boardNode.setName(boardName);
        String description = "Board: " + boardName;
        description = this.extendDescription(description, "vendor", boardVendor);
        boardNode.setDescription(description);
    }

    protected void processKeywordElement(Element el, Node parent) {
        Node keywordNode = new Node("keyword");
        String keyword = Xml.getElementContent((Element)el);
        keywordNode.putProperty("name", keyword);
        keywordNode.setName(keyword);
        keywordNode.setDescription("Keyword: " + keyword);
        parent.addChild((Leaf)keywordNode);
    }
}

