/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenInEditorCommand
extends RepositoriesViewCommandHandler<FileNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileNode node = (FileNode)this.getSelectedNodes(event).get(0);
        Path path = new Path(((File)node.getObject()).getAbsolutePath());
        IFile file = ResourceUtil.getFileForLocation((IPath)path);
        if (file == null) {
            IFileStore store = EFS.getLocalFileSystem().getStore((IPath)path);
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)this.getView(event).getSite().getPage(), (IFileStore)store);
            }
            catch (PartInitException e) {
                Activator.handleError(UIText.RepositoriesView_Error_WindowTitle, e, true);
            }
        } else {
            try {
                IDE.openEditor((IWorkbenchPage)this.getView(event).getSite().getPage(), (IFile)file);
            }
            catch (PartInitException e) {
                Activator.handleError(UIText.RepositoriesView_Error_WindowTitle, e, true);
            }
        }
        return null;
    }
}

