/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.ui.indexview.CountNodeAction;
import org.eclipse.cdt.internal.ui.indexview.DiscardExternalDefsAction;
import org.eclipse.cdt.internal.ui.indexview.FindDeclarationsAction;
import org.eclipse.cdt.internal.ui.indexview.FindReferencesAction;
import org.eclipse.cdt.internal.ui.indexview.IndexAction;
import org.eclipse.cdt.internal.ui.indexview.IndexLabelProvider;
import org.eclipse.cdt.internal.ui.indexview.IndexNode;
import org.eclipse.cdt.internal.ui.indexview.OpenDefinitionAction;
import org.eclipse.cdt.internal.ui.indexview.ToggleLinkingAction;
import org.eclipse.cdt.internal.ui.viewsupport.AsyncTreeContentProvider;
import org.eclipse.cdt.internal.ui.viewsupport.ExtendedTreeViewer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class IndexView
extends ViewPart
implements PDOM.IListener,
IElementChangedListener {
    private TreeViewer viewer;
    private ToggleLinkingAction toggleLinkingAction;
    private IndexAction countSymbolsAction;
    private IndexAction discardExternalDefsAction;
    private IndexAction openDefinitionAction;
    private IndexAction findDeclarationsAction;
    private IndexAction findReferencesAction;
    Filter filter = new Filter();
    public boolean isLinking = false;
    private volatile boolean fUpdateRequested = false;
    private Map<String, Long> fTimestampPerProject = new HashMap<String, Long>();
    private IndexContentProvider contentProvider;

    public void toggleExternalDefs() {
        boolean bl = this.filter.showExternalDefs = !this.filter.showExternalDefs;
        if (!this.filter.showExternalDefs) {
            this.viewer.addFilter((ViewerFilter)this.filter);
        } else {
            this.viewer.removeFilter((ViewerFilter)this.filter);
        }
    }

    public void toggleLinking() {
        boolean bl = this.isLinking = !this.isLinking;
        if (this.isLinking) {
            this.openDefinitionAction.run();
        }
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        if (this.isLinking) {
            this.openDefinitionAction.run();
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new ExtendedTreeViewer(parent, 770);
        this.contentProvider = new IndexContentProvider(this.getSite().getShell().getDisplay());
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new IndexLabelProvider());
        this.viewer.setUseHashlookup(true);
        ICModel model = CoreModel.getDefault().getCModel();
        this.viewer.setInput((Object)model);
        this.viewer.addFilter((ViewerFilter)this.filter);
        try {
            ICProject[] projects = model.getCProjects();
            int i = 0;
            while (i < projects.length) {
                IPDOM pdom = CCoreInternals.getPDOMManager().getPDOM(projects[i]);
                pdom.addListener((PDOM.IListener)this);
                ++i;
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            private void hideMenuItems(IMenuManager manager) {
            }

            public void menuAboutToShow(IMenuManager manager) {
                IndexView.this.fillContextMenu(manager);
                this.hideMenuItems(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IndexView.this.handleSelectionChanged(event);
            }
        });
    }

    public void dispose() {
        super.dispose();
        ICModel model = CoreModel.getDefault().getCModel();
        try {
            ICProject[] projects = model.getCProjects();
            int i = 0;
            while (i < projects.length) {
                IPDOM pdom = CCoreInternals.getPDOMManager().getPDOM(projects[i]);
                pdom.removeListener((PDOM.IListener)this);
                ++i;
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
    }

    private void makeActions() {
        this.countSymbolsAction = new CountNodeAction(this, this.viewer);
        this.discardExternalDefsAction = new DiscardExternalDefsAction(this.viewer, this);
        this.toggleLinkingAction = new ToggleLinkingAction(this);
        this.openDefinitionAction = new OpenDefinitionAction(this, this.viewer);
        this.findDeclarationsAction = new FindDeclarationsAction(this, this.viewer);
        this.findReferencesAction = new FindReferencesAction(this, this.viewer);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IndexView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.countSymbolsAction.valid()) {
            manager.add((IAction)this.countSymbolsAction);
        }
        if (this.discardExternalDefsAction.valid()) {
            manager.add((IAction)this.discardExternalDefsAction);
        }
        if (this.openDefinitionAction.valid()) {
            manager.add((IAction)this.openDefinitionAction);
        }
        if (this.findDeclarationsAction.valid()) {
            manager.add((IAction)this.findDeclarationsAction);
        }
        if (this.findReferencesAction.valid()) {
            manager.add((IAction)this.findReferencesAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IndexView.this.openDefinitionAction.run();
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.toggleLinkingAction);
        manager.add((IAction)this.discardExternalDefsAction);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void handleChange(PDOM pdom, PDOM.ChangeEvent e) {
        this.requestUpdate();
    }

    private void requestUpdate() {
        if (!this.fUpdateRequested) {
            this.fUpdateRequested = true;
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IndexView.this.fUpdateRequested = false;
                    if (!IndexView.this.viewer.getControl().isDisposed()) {
                        IndexView.this.contentProvider.recompute();
                    }
                }
            });
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() != 1) {
            return;
        }
        this.processDelta(event.getDelta());
    }

    private void processDelta(ICElementDelta delta) {
        block11: {
            int type = delta.getElement().getElementType();
            switch (type) {
                case 10: {
                    ICElementDelta[] children = delta.getAffectedChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.processDelta(children[i]);
                        ++i;
                    }
                    break;
                }
                case 11: {
                    switch (delta.getKind()) {
                        case 1: {
                            try {
                                IPDOM pdom = CCoreInternals.getPDOMManager().getPDOM((ICProject)delta.getElement());
                                pdom.addListener((PDOM.IListener)this);
                                this.handleChange(null, null);
                            }
                            catch (CoreException coreException) {}
                            break block11;
                        }
                        case 2: {
                            this.handleChange(null, null);
                        }
                    }
                }
            }
        }
    }

    public long getLastWriteAccess(ICProject cproject) {
        Long result = this.fTimestampPerProject.get(cproject.getElementName());
        return result == null ? -1L : result;
    }

    private static class Children
    implements IPDOMVisitor {
        private ArrayList<IPDOMNode> fNodes = new ArrayList();

        public boolean visit(IPDOMNode node) throws CoreException {
            this.fNodes.add(node);
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IPDOMNode[] getNodes() {
            return this.fNodes.toArray(new IPDOMNode[this.fNodes.size()]);
        }
    }

    private static class Filter
    extends ViewerFilter {
        public boolean showExternalDefs = false;

        private Filter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IndexNode) {
                IndexNode node = (IndexNode)element;
                return node.fHasDeclarationInProject;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static boolean hasDeclarationInProject(IPDOMNode element) {
            if (!(element instanceof PDOMBinding)) {
                if (!(element instanceof PDOMLinkage)) return false;
                return true;
            }
            try {
                IIndexFragmentName name;
                PDOMBinding binding = (PDOMBinding)element;
                PDOM pdom = binding.getPDOM();
                IIndexFragmentName[] names = pdom.findNames((IBinding)binding, 1);
                int i = 0;
                while (i < names.length) {
                    name = names[i];
                    if (name.getFile().getLocation().getFullPath() != null) {
                        return true;
                    }
                    ++i;
                }
                names = pdom.findNames((IBinding)binding, 2);
                i = 0;
                while (i < names.length) {
                    name = names[i];
                    if (name.getFile().getLocation().getFullPath() != null) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
                return false;
            }
        }
    }

    private class IndexContentProvider
    extends AsyncTreeContentProvider {
        public IndexContentProvider(Display disp) {
            super(disp);
        }

        @Override
        public Object getParent(Object element) {
            if (element instanceof IndexNode) {
                return ((IndexNode)element).fParent;
            }
            if (element instanceof ICElement) {
                return ((ICElement)element).getParent();
            }
            return null;
        }

        @Override
        protected Object[] syncronouslyComputeChildren(Object parentElement) {
            if (parentElement instanceof ICModel) {
                ICModel element = (ICModel)parentElement;
                try {
                    return element.getCProjects();
                }
                catch (CModelException e) {
                    CUIPlugin.log(e);
                    return new Object[0];
                }
            }
            if (parentElement instanceof IndexNode) {
                PDOMBinding binding;
                IndexNode node = (IndexNode)parentElement;
                if (node.fObject instanceof PDOMBinding && !(binding = (PDOMBinding)node.fObject).mayHaveChildren()) {
                    return new Object[0];
                }
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Object[] asyncronouslyComputeChildren(Object parentElement, IProgressMonitor monitor) {
            try {
                if (parentElement instanceof ICProject) {
                    ICProject cproject = (ICProject)parentElement;
                    if (cproject.getProject().isOpen()) return this.computeChildren(cproject);
                    return new Object[0];
                }
                if (!(parentElement instanceof IndexNode)) return new Object[0];
                IndexNode node = (IndexNode)parentElement;
                ICProject cproject = node.getProject();
                if (cproject == null) return new Object[0];
                if (!cproject.getProject().isOpen()) return new Object[0];
                Long ts = (Long)IndexView.this.fTimestampPerProject.get(cproject.getElementName());
                IPDOM pdom = CCoreInternals.getPDOMManager().getPDOM(cproject);
                pdom.acquireReadLock();
                try {
                    if (ts != null) {
                        if (ts.longValue() != pdom.getLastWriteAccess()) return new Object[0];
                    }
                    Object[] objectArray = this.computeChildren(parentElement, node.fObject);
                    return objectArray;
                }
                finally {
                    pdom.releaseReadLock();
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
                return new Object[0];
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return new Object[0];
        }

        private Object[] computeChildren(ICProject cproject) throws CoreException, InterruptedException {
            IPDOM pdom = CCoreInternals.getPDOMManager().getPDOM(cproject);
            pdom.acquireReadLock();
            try {
                IndexView.this.fTimestampPerProject.put(cproject.getElementName(), new Long(pdom.getLastWriteAccess()));
                PDOMLinkage[] linkages = pdom.getLinkageImpls();
                if (linkages.length == 1) {
                    Object[] objectArray = this.computeChildren(cproject, (IPDOMNode)linkages[0]);
                    return objectArray;
                }
                Object[] objectArray = this.wrap(cproject, (IPDOMNode[])linkages);
                return objectArray;
            }
            finally {
                pdom.releaseReadLock();
            }
        }

        private Object[] computeChildren(Object parent, IPDOMNode node) throws CoreException {
            Children collector = new Children();
            node.accept((IPDOMVisitor)collector);
            return this.wrap(parent, collector.getNodes());
        }

        private Object[] wrap(Object parent, IPDOMNode[] nodes) {
            if (nodes.length == 0) {
                return nodes;
            }
            Object[] result = new IndexNode[nodes.length];
            int i = 0;
            while (i < result.length) {
                result[i] = new IndexNode();
                IndexNode indexNode = result[i];
                IPDOMNode node = nodes[i];
                indexNode.fParent = parent;
                indexNode.fObject = node;
                indexNode.fText = IndexLabelProvider.getText(node);
                indexNode.fImage = IndexLabelProvider.getImage(node);
                indexNode.fHasDeclarationInProject = Filter.hasDeclarationInProject(node);
                if (node instanceof PDOMNode) {
                    indexNode.fBindingKind = ((PDOMNode)node).getNodeType();
                }
                ++i;
            }
            return result;
        }
    }
}

