/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.core.tree;

import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.core.tree.Selector;
import java.util.LinkedList;
import java.util.List;

public class PackNode
extends Node {
    protected List<Selector> fSelectors = null;
    protected Node fOutline = null;

    public PackNode(String type) {
        super(type);
    }

    public PackNode(Leaf node) {
        super(node);
    }

    public static PackNode addUniqueChild(Node parent, String type, String name) {
        PackNode packNode = (PackNode)parent.findChild(type, name);
        if (packNode == null) {
            packNode = new PackNode(type);
            parent.addChild(packNode);
            packNode.setName(name);
        }
        return packNode;
    }

    public static PackNode addNewChild(Node parent, String type) {
        PackNode node = new PackNode(type);
        parent.addChild(node);
        return node;
    }

    public static PackNode addNewChild(Node parent, Leaf from) {
        assert (parent != null);
        PackNode node = new PackNode(from);
        parent.addChild(node);
        return node;
    }

    public boolean hasSelectors() {
        return this.fSelectors != null && !this.fSelectors.isEmpty();
    }

    public List<Selector> getSelectors() {
        return this.fSelectors;
    }

    public List<Selector> getSelectorsByType(String type) {
        LinkedList<Selector> list = new LinkedList<Selector>();
        if (this.fSelectors != null) {
            for (Selector condition : this.fSelectors) {
                if (!condition.getType().equals(type)) continue;
                list.add(condition);
            }
        }
        return list;
    }

    public void addSelector(Selector selector) {
        assert (selector != null);
        if (this.fSelectors == null) {
            this.fSelectors = new LinkedList<Selector>();
        } else {
            for (Selector sel : this.fSelectors) {
                if (!sel.equals(selector)) continue;
                return;
            }
        }
        this.fSelectors.add(selector);
    }

    public List<Selector> copySelectorsRef(PackNode node) {
        this.fSelectors = node.fSelectors;
        return this.fSelectors;
    }

    public boolean hasOutline() {
        return this.fOutline != null;
    }

    public Node getOutline() {
        return this.fOutline;
    }

    public void setOutline(Node node) {
        this.fOutline = node;
    }

    public static /* bridge */ /* synthetic */ Node addNewChild(Node node, Leaf leaf) {
        return PackNode.addNewChild(node, leaf);
    }

    public static /* bridge */ /* synthetic */ Node addNewChild(Node node, String string) {
        return PackNode.addNewChild(node, string);
    }

    public static /* bridge */ /* synthetic */ Node addUniqueChild(Node node, String string, String string2) {
        return PackNode.addUniqueChild(node, string, string2);
    }
}

