/*
 * Decompiled with CFR 0.152.
 */
package com.nuvoton.debug.gdbjtag.nulink;

import com.nuvoton.debug.gdbjtag.nulink.Activator;
import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.core.StringUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.DebugUtils;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;

public class Configuration {
    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String getGdbServerCommand(ILaunchConfiguration configuration) {
        String executable;
        block6: {
            block5: {
                executable = null;
                try {
                    if (configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.doStartGdbServer", true)) break block5;
                    return null;
                }
                catch (CoreException e) {
                    Activator.log((Throwable)e);
                    return null;
                }
            }
            executable = configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerExecutable", "${openocd_nulink_path}/${openocd_nulink_executable}");
            executable = executable.trim();
            if (executable.length() != 0) break block6;
            return null;
        }
        executable = DebugUtils.resolveAll((String)executable, (Map)configuration.getAttributes());
        ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
        if (buildConfig != null) {
            executable = DebugUtils.resolveAll((String)executable, (ICConfigurationDescription)buildConfig);
        }
        return executable;
    }

    public static String getGdbServerCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbServerCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String[] getGdbServerCommandLineArray(ILaunchConfiguration configuration) {
        String commandStr1;
        String executable;
        ArrayList<String> lst;
        block19: {
            block18: {
                lst = new ArrayList<String>();
                try {
                    if (configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.doStartGdbServer", true)) break block18;
                    return null;
                }
                catch (CoreException e) {
                    Activator.log((Throwable)e);
                    return null;
                }
            }
            executable = Configuration.getGdbServerCommand(configuration);
            if (executable != null && executable.length() != 0) break block19;
            return null;
        }
        lst.add(executable);
        lst.add("-c");
        lst.add("gdb_port " + Integer.toString(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerGdbPortNumber", 3333)));
        lst.add("-c");
        lst.add("telnet_port " + Integer.toString(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerTelnetPortNumber", 4444)));
        String other = configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerOther", "-f ../scripts/interface/nulink.cfg -f ../scripts/target/numicroM4.cfg\n").trim();
        other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes());
        if (!other.isEmpty()) {
            lst.addAll(StringUtils.splitCommandLineOptions((String)other));
        }
        if ((commandStr1 = configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.targetChip", "")).toUpperCase().indexOf("0X") == 0) {
            commandStr1 = commandStr1.substring(2);
        }
        if (configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.writeDPMS", false) && (commandStr1.toUpperCase().indexOf("M2354") != -1 || Configuration.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 55)) {
            lst.add("-c");
            if (configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialSecureDebugEnable", false)) {
                lst.add("numicro chip_init 0 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMSPassword0", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMSPassword1", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMSPassword2", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMSPassword3", "0"));
            } else if (configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialSecureDebugDisable", true)) {
                lst.add("numicro chip_init 1 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMSPassword0", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMSPassword1", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMSPassword2", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMSPassword3", "0"));
            } else if (configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialSecureDebugLock", false)) {
                lst.add("numicro chip_init 2");
            }
        }
        if (configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.writeDPMNS", false) && (commandStr1.toUpperCase().indexOf("M2354") != -1 || Configuration.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 55)) {
            lst.add("-c");
            if (configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialNonSecureDebugEnable", false)) {
                lst.add("numicro chip_init 3 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMNSPassword0", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMNSPassword1", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMNSPassword2", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMNSPassword3", "0"));
            } else if (configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialNonSecureDebugDisable", true)) {
                lst.add("numicro chip_init 4 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMNSPassword0", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMNSPassword1", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMNSPassword2", "0") + " 0x" + configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialDPMNSPassword3", "0"));
            } else if (configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialNonSecureDebugLock", false)) {
                lst.add("numicro chip_init 5");
            }
        }
        lst.add("-c");
        lst.add("echo \"Started by GNU ARM Eclipse\"");
        return lst.toArray(new String[0]);
    }

    public static String getGdbServerCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbServerCommand(config);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String getGdbServerOtherConfig(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerOther", "-f ../scripts/interface/nulink.cfg -f ../scripts/target/numicroM4.cfg\n").trim();
    }

    public static String getGdbClientCommand(ILaunchConfiguration configuration) {
        String executable = null;
        try {
            String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
            executable = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            executable = DebugUtils.resolveAll((String)executable, (Map)configuration.getAttributes());
            ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
            if (buildConfig != null) {
                executable = DebugUtils.resolveAll((String)executable, (ICConfigurationDescription)buildConfig);
            }
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return null;
        }
        return executable;
    }

    public static String[] getGdbClientCommandLineArray(ILaunchConfiguration configuration) {
        ArrayList<String> lst = new ArrayList<String>();
        String executable = Configuration.getGdbClientCommand(configuration);
        if (executable == null || executable.length() == 0) {
            return null;
        }
        lst.add(executable);
        lst.add("--interpreter=mi2");
        lst.add("--nx");
        try {
            String other = configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbClientOtherOptions", "").trim();
            other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes());
            if (!other.isEmpty()) {
                lst.addAll(StringUtils.splitCommandLineOptions((String)other));
            }
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbClientCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbClientCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String getGdbClientCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbClientCommand(config);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static boolean getDoStartGdbServer(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("com.nuvoton.debug.gdbjtag.nulink.doStartGdbServer", true);
    }

    public static boolean getDoAddServerConsole(ILaunchConfiguration config) throws CoreException {
        return Configuration.getDoStartGdbServer(config) && config.getAttribute("com.nuvoton.debug.gdbjtag.nulink.doGdbServerAllocateConsole", true);
    }
}

