/*
 * Decompiled with CFR 0.152.
 */
package com.nuvoton.debug.gdbjtag.nulink.dsf;

import com.nuvoton.debug.gdbjtag.nulink.ui.TabStartup;
import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.core.StringUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.DebugUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.dsf.GnuArmDebuggerCommandsService;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.core.Messages;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class DebuggerCommands
extends GnuArmDebuggerCommandsService {
    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public DebuggerCommands(DsfSession session, ILaunchConfiguration lc, String mode) {
        super(session, lc, mode, true);
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    public IStatus addGdbInitCommandsCommands(List<String> commandsList) {
        String otherInits = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.gdbClientOtherCommands", (Object)"set mem inaccessible-by-default off\n")).trim();
        otherInits = DebugUtils.resolveAll((String)otherInits, (Map)this.fAttributes);
        DebugUtils.addMultiLine((String)otherInits, commandsList);
        return Status.OK_STATUS;
    }

    public IStatus addGnuArmResetCommands(List<String> commandsList) {
        IStatus status = this.addFirstResetCommands(commandsList);
        if (!status.isOK()) {
            return status;
        }
        status = this.addLoadSymbolsCommands(commandsList);
        if (!status.isOK()) {
            return status;
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.loadImage", (Object)true)).booleanValue() && !((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doDebugInRam", (Object)false)).booleanValue() && !(status = this.addLoadImageToFlashCommands(commandsList)).isOK()) {
            return status;
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue() && !((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doDebugInRam", (Object)false)).booleanValue() && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus addGnuArmStartCommands(List<String> commandsList) {
        IStatus status = this.addStartRestartCommands(true, commandsList);
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus addFirstResetCommands(List<String> commandsList) {
        String configValue;
        String commandStr;
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doFirstReset", (Object)true)).booleanValue()) {
            String commandStr2 = "monitor reset ";
            String resetType = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.firstResetType", (Object)"init");
            commandsList.add(String.valueOf(commandStr2) + resetType);
            commandStr2 = "monitor halt";
            commandsList.add(commandStr2);
        }
        String otherInits = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.otherInitCommands", (Object)"")).trim();
        otherInits = DebugUtils.resolveAll((String)otherInits, (Map)this.fAttributes);
        if (this.fDoDoubleBackslash && EclipseUtils.isWindows()) {
            otherInits = StringUtils.duplicateBackslashes((String)otherInits);
        }
        DebugUtils.addMultiLine((String)otherInits, commandsList);
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.enableSemihosting", (Object)true)).booleanValue()) {
            commandStr = "monitor arm semihosting enable";
            commandsList.add(commandStr);
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.chipErase", (Object)false)).booleanValue()) {
            String commandStr1 = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.targetChip", (Object)"")).trim();
            if (commandStr1.toUpperCase().indexOf("0X") == 0) {
                commandStr1 = commandStr1.substring(2);
            }
            commandStr = commandStr1.toUpperCase().indexOf("M235") != -1 || DebuggerCommands.isNumeric(commandStr1) && (Integer.parseInt(commandStr1, 16) == 53 || Integer.parseInt(commandStr1, 16) == 55) ? "monitor numicro M2351_erase" : "monitor numicro chip_erase";
            commandsList.add(commandStr);
            commandStr = "monitor sleep 500";
            commandsList.add(commandStr);
            commandStr = "monitor reset ";
            commandsList.add(commandStr);
            commandStr = "monitor halt";
            commandsList.add(commandStr);
            if (commandStr1.toUpperCase().indexOf("M451") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 15) {
                commandStr = "monitor numicro write_isp 0x300000 ";
                configValue = "0xFFFEFFFF";
                commandsList.add(String.valueOf(commandStr) + configValue);
            } else if (commandStr1.toUpperCase().indexOf("M4521") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 22) {
                commandStr = "monitor numicro write_isp 0x300000 ";
                configValue = "0xFFFEFFFF";
                commandsList.add(String.valueOf(commandStr) + configValue);
            } else if (commandStr1.toUpperCase().indexOf("NUC121") != -1 || commandStr1.toUpperCase().indexOf("NUC125") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 20) {
                commandStr = "monitor numicro write_isp 0x300008 ";
                configValue = "0xFFFFFF5A";
                commandsList.add(String.valueOf(commandStr) + configValue);
            } else if (commandStr1.toUpperCase().indexOf("NANO103") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 19) {
                commandStr = "monitor numicro write_isp 0x300008 ";
                configValue = "0xFFFFFF5A";
                commandsList.add(String.valueOf(commandStr) + configValue);
            } else if (commandStr1.toUpperCase().indexOf("MINI58") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 17) {
                commandStr = "monitor numicro write_isp 0x300008 ";
                configValue = "0xFFFFFF5A";
                commandsList.add(String.valueOf(commandStr) + configValue);
            } else if (commandStr1.toUpperCase().indexOf("M031") != -1 || DebuggerCommands.isNumeric(commandStr1) && (Integer.parseInt(commandStr1, 16) == 23 || Integer.parseInt(commandStr1, 16) == 24 || Integer.parseInt(commandStr1, 16) == 25 || Integer.parseInt(commandStr1, 16) == 26 || Integer.parseInt(commandStr1, 16) == 28 || Integer.parseInt(commandStr1, 16) == 29 || Integer.parseInt(commandStr1, 16) == 31 || Integer.parseInt(commandStr1, 16) == 33)) {
                commandStr = "monitor numicro write_isp 0x300008 ";
                configValue = "0xFFFFFF5A";
                commandsList.add(String.valueOf(commandStr) + configValue);
            } else if (commandStr1.toUpperCase().indexOf("M0A21") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 32) {
                commandStr = "monitor numicro write_isp 0x300008 ";
                configValue = "0xFFFFFF5A";
                commandsList.add(String.valueOf(commandStr) + configValue);
            } else if (commandStr1.toUpperCase().indexOf("M251") != -1 || commandStr1.toUpperCase().indexOf("M252") != -1 || commandStr1.toUpperCase().indexOf("M253") != -1 || commandStr1.toUpperCase().indexOf("M258") != -1 || DebuggerCommands.isNumeric(commandStr1) && (Integer.parseInt(commandStr1, 16) == 46 || Integer.parseInt(commandStr1, 16) == 47 || Integer.parseInt(commandStr1, 16) == 48 || Integer.parseInt(commandStr1, 16) == 49 || Integer.parseInt(commandStr1, 16) == 51 || Integer.parseInt(commandStr1, 16) == 57)) {
                commandStr = "monitor numicro write_isp 0x300008 ";
                configValue = "0xFFFFFF5A";
                commandsList.add(String.valueOf(commandStr) + configValue);
            } else if (commandStr1.toUpperCase().indexOf("M471") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 34) {
                commandStr = "monitor numicro write_isp 0x300008 ";
                configValue = "0xFFFFFF5A";
                commandsList.add(String.valueOf(commandStr) + configValue);
            } else if (commandStr1.toUpperCase().indexOf("M479") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 54) {
                commandStr = "monitor numicro write_isp 0x300008 ";
                configValue = "0xFFFF5A5A";
                commandsList.add(String.valueOf(commandStr) + configValue);
            } else if (commandStr1.toUpperCase().indexOf("M480") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 52) {
                commandStr = "monitor numicro write_isp 0x300008 ";
                configValue = "0xFFFF5A5A";
                commandsList.add(String.valueOf(commandStr) + configValue);
            }
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.writeConifg", (Object)false)).booleanValue()) {
            if (!((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.chipErase", (Object)false)).booleanValue()) {
                commandsList.add("monitor numicro erase_isp 0x300000 ");
                commandsList.add("monitor numicro erase_isp 0x300004 ");
                commandsList.add("monitor numicro erase_isp 0x300008 ");
                commandsList.add("monitor numicro erase_isp 0x30000C ");
            }
            commandStr = "monitor numicro write_isp 0x300000 ";
            String configValue2 = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialConfig0", (Object)"FFFFFFFF");
            commandsList.add(String.valueOf(commandStr) + configValue2);
            commandStr = "monitor numicro write_isp 0x300004 ";
            configValue2 = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialConfig1", (Object)"FFFFFFFF");
            commandsList.add(String.valueOf(commandStr) + configValue2);
            commandStr = "monitor numicro write_isp 0x300008 ";
            configValue2 = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialConfig2", (Object)"FFFFFFFF");
            commandsList.add(String.valueOf(commandStr) + configValue2);
            commandStr = "monitor numicro write_isp 0x30000C ";
            configValue2 = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialConfig3", (Object)"FFFFFFFF");
            commandsList.add(String.valueOf(commandStr) + configValue2);
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.writeLock", (Object)false)).booleanValue()) {
            String commandStr3;
            String commandStr1;
            if (!((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.chipErase", (Object)false)).booleanValue()) {
                commandsList.add("monitor numicro erase_isp 0x200800 ");
                commandsList.add("monitor numicro erase_isp 0x210800");
            }
            if ((commandStr1 = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.targetChip", (Object)"")).trim()).toUpperCase().indexOf("0X") == 0) {
                commandStr1 = commandStr1.substring(2);
            }
            if (commandStr1.toUpperCase().indexOf("M2351") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 53) {
                commandStr3 = "monitor numicro write_isp 0x200800 ";
                configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialNSCBA", (Object)"080000");
                commandsList.add(String.valueOf(commandStr3) + configValue);
                commandStr3 = "monitor numicro write_isp 0x200804 ";
                configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialSCRLOCK", (Object)"5A");
                commandsList.add(String.valueOf(commandStr3) + configValue);
            }
            if (commandStr1.toUpperCase().indexOf("M2354") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 55) {
                commandStr3 = "monitor numicro write_isp 0x200800 ";
                configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialNSCBA", (Object)"080000");
                commandsList.add(String.valueOf(commandStr3) + configValue);
                commandStr3 = "monitor numicro write_isp 0x610000 ";
                configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialSCRLOCK", (Object)"5A");
                commandsList.add(String.valueOf(commandStr3) + configValue);
            }
            if (commandStr1.toUpperCase().indexOf("M261") != -1 || DebuggerCommands.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 53) {
                commandStr3 = "monitor numicro write_isp 0x210804 ";
                configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialARLOCK", (Object)"5A");
                commandsList.add(String.valueOf(commandStr3) + configValue);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus addStartRestartCommands(boolean doReset, List<String> commandsList) {
        IStatus status;
        if (doReset && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doSecondReset", (Object)true)).booleanValue()) {
            String commandStr = "monitor reset ";
            String resetType = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.secondResetType", (Object)"init");
            commandsList.add(String.valueOf(commandStr) + resetType);
            commandStr = "monitor halt";
            commandsList.add(commandStr);
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue() && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doDebugInRam", (Object)false)).booleanValue() && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
            return status;
        }
        String userCmd = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.otherRunCommands", (Object)"")).trim();
        userCmd = DebugUtils.resolveAll((String)userCmd, (Map)this.fAttributes);
        if (this.fDoDoubleBackslash && EclipseUtils.isWindows()) {
            userCmd = StringUtils.duplicateBackslashes((String)userCmd);
        }
        DebugUtils.addMultiLine((String)userCmd, commandsList);
        this.addSetPcCommands(commandsList);
        this.addStopAtCommands(commandsList);
        commandsList.add("monitor reg");
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doContinue", (Object)true)).booleanValue()) {
            commandsList.add("continue");
        }
        return Status.OK_STATUS;
    }

    public IStatus addLoadImageToFlashCommands(List<String> commandsList) {
        int lastDot;
        String imageOffset;
        IPath programPath = this.fGdbBackend.getProgramPath();
        String imageFileName = null;
        boolean bUseProjBinaryForImage = false;
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.useProjBinaryForImage", (Object)true)).booleanValue()) {
            if (programPath != null) {
                imageFileName = programPath.toOSString();
            }
            bUseProjBinaryForImage = true;
        } else {
            imageFileName = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.imageFileName", (Object)"");
            imageFileName = !imageFileName.isEmpty() ? DebugUtils.resolveAll((String)imageFileName, (Map)this.fAttributes) : null;
        }
        if (imageFileName == null) {
            return new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", -1, Messages.getString((String)"GDBJtagDebugger.err_no_img_file"), null);
        }
        imageFileName = DebugUtils.resolveAll((String)imageFileName, (Map)this.fAttributes);
        if (EclipseUtils.isWindows()) {
            imageFileName = StringUtils.duplicateBackslashes((String)imageFileName);
        }
        if (!(imageOffset = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.imageOffset", (Object)"")).trim()).isEmpty()) {
            imageOffset = imageFileName.endsWith(".hex") ? "" : "0x" + imageOffset;
        }
        String file = this.escapeSpaces(imageFileName);
        String fileOutputName = TabStartup.getManagedOutputName(file);
        if (bUseProjBinaryForImage && (lastDot = file.lastIndexOf(46)) >= 0) {
            file = String.valueOf(file.substring(0, lastDot + 1)) + fileOutputName;
        }
        file = this.escapeSpaces(file);
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.chipErase", (Object)false)).booleanValue()) {
            commandsList.add("monitor flash write_image " + file + ' ' + imageOffset);
        } else {
            commandsList.add("monitor flash write_image erase " + file + ' ' + imageOffset);
        }
        return Status.OK_STATUS;
    }
}

