/*
 * Decompiled with CFR 0.152.
 */
package com.nuvoton.debug.gdbjtag.nulink.dsf;

import com.nuvoton.debug.gdbjtag.nulink.Activator;
import com.nuvoton.debug.gdbjtag.nulink.Configuration;
import ilg.gnuarmeclipse.core.StringUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.DebugUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.dsf.GnuArmGdbBackend;
import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.parser.util.StringUtil;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GdbBackend
extends GnuArmGdbBackend {
    private final ILaunchConfiguration fLaunchConfiguration;

    public GdbBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GdbBackend() " + (Object)((Object)this));
        }
        this.fLaunchConfiguration = lc;
    }

    public void initialize(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GdbBackend.initialize() " + Thread.currentThread());
        }
        super.initialize(rm);
    }

    public void destroy() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GdbBackend.destroy() " + Thread.currentThread());
        }
        super.destroy();
    }

    public void shutdown(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GdbBackend.shutdown() " + Thread.currentThread());
        }
        super.shutdown(rm);
    }

    protected String[] getGDBCommandLineArray() {
        String[] commandLineArray = Configuration.getGdbClientCommandLineArray(this.fLaunchConfiguration);
        return commandLineArray;
    }

    protected Process launchGDBProcess(String[] commandLine) throws CoreException {
        Process proc = null;
        File dir = null;
        IPath path = this.getGDBWorkingDirectory();
        if (path != null) {
            dir = new File(path.toOSString());
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("exec " + StringUtils.join((String[])commandLine, (String)" "));
            System.out.println("dir " + dir);
        }
        try {
            proc = ProcessFactory.getFactory().exec(commandLine, DebugUtils.getLaunchEnvironment((ILaunchConfiguration)this.fLaunchConfiguration), dir);
        }
        catch (IOException e) {
            String message = "Error while launching command: " + StringUtil.join((String[])commandLine, (String)" ");
            throw new CoreException((IStatus)new Status(4, "com.nuvoton.debug.gdbjtag.nulink", -1, message, (Throwable)e));
        }
        return proc;
    }

    public IPath getGDBWorkingDirectory() throws CoreException {
        IPath path;
        try {
            path = super.getGDBWorkingDirectory();
        }
        catch (CoreException coreException) {
            path = null;
        }
        if (path == null) {
            path = DebugUtils.getProjectOsPath((ILaunchConfiguration)this.fLaunchConfiguration);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("getGDBWorkingDirectory() " + path);
        }
        return path;
    }
}

