/*
 * Decompiled with CFR 0.152.
 */
package com.nuvoton.debug.gdbjtag.nulink.dsf;

import com.nuvoton.debug.gdbjtag.nulink.Activator;
import com.nuvoton.debug.gdbjtag.nulink.Configuration;
import com.nuvoton.debug.gdbjtag.nulink.dsf.GdbServerBackend;
import com.nuvoton.debug.gdbjtag.nulink.dsf.Launch;
import com.nuvoton.debug.gdbjtag.nulink.dsf.ServicesFactory;
import ilg.gnuarmeclipse.debug.gdbjtag.DebugUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.dsf.AbstractGnuArmLaunchConfigurationDelegate;
import ilg.gnuarmeclipse.debug.gdbjtag.dsf.GnuArmServerServicesLaunchSequence;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.launching.ServicesLaunchSequence;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;

public class LaunchConfigurationDelegate
extends AbstractGnuArmLaunchConfigurationDelegate {
    private static final String NON_STOP_FIRST_VERSION = "6.8.50";
    ILaunchConfiguration fConfig = null;
    private boolean fIsNonStopSession = false;
    private boolean fDoStartGdbServer = false;

    protected IDsfDebugServicesFactory newServiceFactory(ILaunchConfiguration config, String version) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("LaunchConfigurationDelegate.newServiceFactory(" + config.getName() + "," + version + ") " + (Object)((Object)this));
        }
        this.fConfig = config;
        return new ServicesFactory(version, "debug");
    }

    protected IDsfDebugServicesFactory newServiceFactory(ILaunchConfiguration config, String version, String mode) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("LaunchConfigurationDelegate.newServiceFactory(" + config.getName() + "," + version + "," + mode + ") " + (Object)((Object)this));
        }
        this.fConfig = config;
        return new ServicesFactory(version, mode);
    }

    protected GdbLaunch createGdbLaunch(ILaunchConfiguration configuration, String mode, ISourceLocator locator) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("LaunchConfigurationDelegate.createGdbLaunch(" + configuration.getName() + "," + mode + ") " + (Object)((Object)this));
        }
        this.fDoStartGdbServer = Configuration.getDoStartGdbServer(configuration);
        DebugUtils.checkLaunchConfigurationStarted((ILaunchConfiguration)configuration);
        return new Launch(configuration, mode, locator);
    }

    protected String getGDBVersion(ILaunchConfiguration config) throws CoreException {
        String gdbClientCommand = Configuration.getGdbClientCommand(config);
        String version = DebugUtils.getGDBVersion((ILaunchConfiguration)config, (String)gdbClientCommand);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("LaunchConfigurationDelegate.getGDBVersion " + version);
        }
        return version;
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("LaunchConfigurationDelegate.launch(" + config.getName() + "," + mode + ") " + (Object)((Object)this));
        }
        LaunchUtils.enableActivity((String)"org.eclipse.cdt.debug.dsfgdbActivity", (boolean)true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("debug") || mode.equals("run")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("LaunchConfigurationDelegate.launchDebugger(" + config.getName() + ") " + (Object)((Object)this));
        }
        int totalWork = 10;
        if (this.fDoStartGdbServer) {
            ++totalWork;
        }
        monitor.beginTask(LaunchMessages.getString((String)"GdbLaunchDelegate.0"), totalWork);
        if (monitor.isCanceled()) {
            this.cleanupLaunchLocal(launch);
            return;
        }
        try {
            this.launchDebugSession(config, launch, monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected void launchDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("LaunchConfigurationDelegate.launchDebugSession(" + config.getName() + ") " + (Object)((Object)this));
        }
        if (monitor.isCanceled()) {
            this.cleanupLaunchLocal(l);
            return;
        }
        SessionType sessionType = org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getSessionType((ILaunchConfiguration)config);
        boolean attach = org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsAttach((ILaunchConfiguration)config);
        final GdbLaunch launch = (GdbLaunch)l;
        if (sessionType == SessionType.REMOTE) {
            monitor.subTask(LaunchMessages.getString((String)"GdbLaunchDelegate.1"));
        } else if (sessionType == SessionType.CORE) {
            monitor.subTask(LaunchMessages.getString((String)"GdbLaunchDelegate.2"));
        } else {
            assert (sessionType == SessionType.LOCAL) : "Unexpected session type: " + sessionType.toString();
            monitor.subTask(LaunchMessages.getString((String)"GdbLaunchDelegate.3"));
        }
        if (!attach) {
            this.checkBinaryDetails(config);
        }
        monitor.worked(1);
        this.fIsNonStopSession = org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsNonStopMode((ILaunchConfiguration)config);
        String gdbVersion = this.getGDBVersion(config);
        if (org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsNonStopMode((ILaunchConfiguration)config) && !this.isNonStopSupportedInGdbVersion(gdbVersion)) {
            this.cleanupLaunchLocal((ILaunch)launch);
            throw new DebugException((IStatus)new Status(4, "com.nuvoton.debug.gdbjtag.nulink", 5012, "Non-stop mode is not supported for GDB " + gdbVersion + ", GDB " + NON_STOP_FIRST_VERSION + " or higher is required.", null));
        }
        if (org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsPostMortemTracing((ILaunchConfiguration)config) && !this.isPostMortemTracingSupportedInGdbVersion(gdbVersion)) {
            this.cleanupLaunchLocal((ILaunch)launch);
            throw new DebugException((IStatus)new Status(4, "com.nuvoton.debug.gdbjtag.nulink", 5012, "Post-mortem tracing is not supported for GDB " + gdbVersion + ", GDB " + NON_STOP_FIRST_VERSION + " or higher is required.", null));
        }
        launch.setServiceFactory(this.newServiceFactory(config, gdbVersion, launch.getLaunchMode()));
        launch.initialize();
        boolean succeed = false;
        SubProgressMonitor subMonServer = new SubProgressMonitor(monitor, 4, 4);
        Sequence serverServicesLaunchSequence = this.getServerServicesSequence(launch.getSession(), (ILaunch)launch, (IProgressMonitor)subMonServer);
        try {
            try {
                launch.getSession().getExecutor().execute((Runnable)serverServicesLaunchSequence);
                serverServicesLaunchSequence.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
            }
            catch (ExecutionException e1) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Error in services launch sequence", e1.getCause()));
            }
            catch (CancellationException cancellationException) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("Launch aborted, so exit cleanly");
                }
                if (!succeed) {
                    this.cleanupLaunchLocal((ILaunch)launch);
                }
                return;
            }
        }
        finally {
            if (!succeed) {
                this.cleanupLaunchLocal((ILaunch)launch);
            }
        }
        if (this.fDoStartGdbServer) {
            ((Launch)launch).initializeServerConsole(monitor);
            try {
                Callable<IStatus> callable = new Callable<IStatus>(){

                    @Override
                    public IStatus call() throws CoreException {
                        DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), launch.getSession().getId());
                        GdbServerBackend backend = (GdbServerBackend)((Object)tracker.getService(GdbServerBackend.class));
                        if (backend != null) {
                            return backend.getServerExitStatus();
                        }
                        throw new CoreException((IStatus)new Status(4, "com.nuvoton.debug.gdbjtag.nulink", "Could not start GDB server."));
                    }
                };
                IStatus serverStatus = null;
                while (serverStatus == null) {
                    if (monitor.isCanceled()) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("LaunchConfigurationDelegate.launchDebugSession() sleep cancelled" + (Object)((Object)this));
                        }
                        this.cleanupLaunchLocal((ILaunch)launch);
                        return;
                    }
                    Thread.sleep(10L);
                    serverStatus = (IStatus)launch.getSession().getExecutor().submit((Callable)callable).get();
                    if (!Activator.getInstance().isDebugging()) continue;
                    System.out.print('!');
                }
                if (serverStatus != Status.OK_STATUS) {
                    if ("TERMINATED".equals(serverStatus.getMessage())) {
                        this.cleanupLaunchLocal((ILaunch)launch);
                        return;
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println(serverStatus);
                    }
                    throw new CoreException(serverStatus);
                }
            }
            catch (InterruptedException e) {
                Activator.log((Throwable)e);
            }
            catch (ExecutionException e) {
                Activator.log((Throwable)e);
            }
            if (Activator.getInstance().isDebugging()) {
                System.out.println("launchDebugSession() * Server start confirmed. *");
            }
        }
        SubProgressMonitor subMon1 = new SubProgressMonitor(monitor, 4, 4);
        Sequence servicesLaunchSequence = this.getServicesSequence(launch.getSession(), (ILaunch)launch, (IProgressMonitor)subMon1);
        launch.getSession().getExecutor().execute((Runnable)servicesLaunchSequence);
        try {
            try {
                servicesLaunchSequence.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, "com.nuvoton.debug.gdbjtag.nulink", 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
            }
            catch (ExecutionException e1) {
                throw new DebugException((IStatus)new Status(4, "com.nuvoton.debug.gdbjtag.nulink", 5012, "Error in services launch sequence", e1.getCause()));
            }
            catch (CancellationException cancellationException) {
                if (!succeed) {
                    this.cleanupLaunchLocal((ILaunch)launch);
                }
                return;
            }
        }
        finally {
            if (!succeed) {
                this.cleanupLaunchLocal((ILaunch)launch);
            }
        }
        if (monitor.isCanceled()) {
            this.cleanupLaunchLocal((ILaunch)launch);
            return;
        }
        launch.initializeControl();
        ((Launch)launch).initializeConsoles(monitor);
        SubProgressMonitor subMon2 = new SubProgressMonitor(monitor, 4, 4);
        Query<Object> completeLaunchQuery = new Query<Object>((IProgressMonitor)subMon2){
            private final /* synthetic */ IProgressMonitor val$subMon2;
            {
                this.val$subMon2 = iProgressMonitor;
            }

            protected void execute(final DataRequestMonitor<Object> rm) {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), launch.getSession().getId());
                IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
                tracker.dispose();
                control.completeInitialization((RequestMonitor)new RequestMonitorWithProgress(ImmediateExecutor.getInstance(), this.val$subMon2){

                    protected void handleCompleted() {
                        if (this.isCanceled()) {
                            rm.cancel();
                        } else {
                            rm.setStatus(this.getStatus());
                        }
                        rm.done();
                    }
                });
            }
        };
        launch.getSession().getExecutor().execute((Runnable)completeLaunchQuery);
        succeed = false;
        try {
            try {
                completeLaunchQuery.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, "com.nuvoton.debug.gdbjtag.nulink", 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
            }
            catch (ExecutionException e1) {
                if (e1.getCause().toString().indexOf("target machine actively refused it") != -1) {
                    throw new DebugException((IStatus)new Status(4, "com.nuvoton.debug.gdbjtag.nulink", 5012, "A problem occurred between OpenOCD and a Nu-Link. To fix it, we must use only one Nu-Link and keep the Nu-Link not occupied by other Nuvoton tools. For more details, please refer to the OpenOCD console.", (Throwable)e1));
                }
                throw new DebugException((IStatus)new Status(4, "com.nuvoton.debug.gdbjtag.nulink", 5012, "Error in final launch sequence", e1.getCause()));
            }
            catch (CancellationException cancellationException) {
                if (!succeed) {
                    this.cleanupLaunchLocal((ILaunch)launch);
                }
                return;
            }
        }
        finally {
            if (!succeed) {
                this.cleanupLaunchLocal((ILaunch)launch);
            }
        }
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        boolean doStartServer = true;
        try {
            Configuration.getDoStartGdbServer(config);
        }
        catch (CoreException coreException) {}
        if (doStartServer) {
            String configOptions = "";
            try {
                configOptions = Configuration.getGdbServerOtherConfig(config);
            }
            catch (CoreException coreException) {}
            if (configOptions.isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "com.nuvoton.debug.gdbjtag.nulink", "Missing mandatory configuration. Fill-in the 'Config options:' field in the Debugger tab."));
            }
        }
        IPath path = super.checkBinaryDetails(config);
        return path;
    }

    protected Sequence getServicesSequence(DsfSession session, ILaunch launch, IProgressMonitor progressMonitor) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("LaunchConfigurationDelegate.getServicesSequence()");
        }
        return new ServicesLaunchSequence(session, (GdbLaunch)launch, progressMonitor);
    }

    protected Sequence getServerServicesSequence(DsfSession session, ILaunch launch, IProgressMonitor progressMonitor) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("LaunchConfigurationDelegate.getServerServicesSequence()");
        }
        return new GnuArmServerServicesLaunchSequence(session, (GdbLaunch)launch, progressMonitor);
    }
}

